/// autogenerated analytical inverse kinematics code from ikfast program part of OpenRAVE
/// \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
/// 
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 0x10000049 generated on 2016-08-23 13:37:00.154880
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared -Wl,-soname,libik.so -o libik.so ik.cpp
#define IKFAST_HAS_LIBRARY
#include "ikfast.h" // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;

// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION==0x10000049);

#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <complex>

#ifndef IKFAST_ASSERT
#include <stdexcept>
#include <sstream>
#include <iostream>

#ifdef _MSC_VER
#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __FUNCDNAME__
#endif
#endif

#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __func__
#endif

#define IKFAST_ASSERT(b) { if( !(b) ) { std::stringstream ss; ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": " <<__PRETTY_FUNCTION__ << ": Assertion '" << #b << "' failed"; throw std::runtime_error(ss.str()); } }

#endif

#if defined(_MSC_VER)
#define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
#define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI  ((IkReal)6.28318530717959)
#define IKPI  ((IkReal)3.14159265358979)
#define IKPI_2  ((IkReal)1.57079632679490)

#ifdef _MSC_VER
#ifndef isnan
#define isnan _isnan
#endif
#ifndef isinf
#define isinf _isinf
#endif
//#ifndef isfinite
//#define isfinite _isfinite
//#endif
#endif // _MSC_VER

// lapack routines
extern "C" {
  void dgetrf_ (const int* m, const int* n, double* a, const int* lda, int* ipiv, int* info);
  void zgetrf_ (const int* m, const int* n, std::complex<double>* a, const int* lda, int* ipiv, int* info);
  void dgetri_(const int* n, const double* a, const int* lda, int* ipiv, double* work, const int* lwork, int* info);
  void dgesv_ (const int* n, const int* nrhs, double* a, const int* lda, int* ipiv, double* b, const int* ldb, int* info);
  void dgetrs_(const char *trans, const int *n, const int *nrhs, double *a, const int *lda, int *ipiv, double *b, const int *ldb, int *info);
  void dgeev_(const char *jobvl, const char *jobvr, const int *n, double *a, const int *lda, double *wr, double *wi,double *vl, const int *ldvl, double *vr, const int *ldvr, double *work, const int *lwork, int *info);
}

using namespace std; // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE {
#endif

inline float IKabs(float f) { return fabsf(f); }
inline double IKabs(double f) { return fabs(f); }

inline float IKsqr(float f) { return f*f; }
inline double IKsqr(double f) { return f*f; }

inline float IKlog(float f) { return logf(f); }
inline double IKlog(double f) { return log(f); }

// allows asin and acos to exceed 1. has to be smaller than thresholds used for branch conds and evaluation
#ifndef IKFAST_SINCOS_THRESH
#define IKFAST_SINCOS_THRESH ((IkReal)1e-7)
#endif

// used to check input to atan2 for degenerate cases. has to be smaller than thresholds used for branch conds and evaluation
#ifndef IKFAST_ATAN2_MAGTHRESH
#define IKFAST_ATAN2_MAGTHRESH ((IkReal)1e-7)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
#define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

// there are checkpoints in ikfast that are evaluated to make sure they are 0. This threshold speicfies by how much they can deviate
#ifndef IKFAST_EVALCOND_THRESH
#define IKFAST_EVALCOND_THRESH ((IkReal)0.00001)
#endif


inline float IKasin(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(-IKPI_2);
else if( f >= 1 ) return float(IKPI_2);
return asinf(f);
}
inline double IKasin(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return -IKPI_2;
else if( f >= 1 ) return IKPI_2;
return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
    while(x < 0) {
        x += y;
    }
    return fmodf(x,y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
    while(x < 0) {
        x += y;
    }
    return fmod(x,y);
}

inline float IKacos(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(IKPI);
else if( f >= 1 ) return float(0);
return acosf(f);
}
inline double IKacos(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return IKPI;
else if( f >= 1 ) return 0;
return acos(f);
}
inline float IKsin(float f) { return sinf(f); }
inline double IKsin(double f) { return sin(f); }
inline float IKcos(float f) { return cosf(f); }
inline double IKcos(double f) { return cos(f); }
inline float IKtan(float f) { return tanf(f); }
inline double IKtan(double f) { return tan(f); }
inline float IKsqrt(float f) { if( f <= 0.0f ) return 0.0f; return sqrtf(f); }
inline double IKsqrt(double f) { if( f <= 0.0 ) return 0.0; return sqrt(f); }
inline float IKatan2Simple(float fy, float fx) {
    return atan2f(fy,fx);
}
inline float IKatan2(float fy, float fx) {
    if( std::isnan(fy) ) {
        IKFAST_ASSERT(!std::isnan(fx)); // if both are nan, probably wrong value will be returned
        return float(IKPI_2);
    }
    else if( std::isnan(fx) ) {
        return 0;
    }
    return atan2f(fy,fx);
}
inline double IKatan2Simple(double fy, double fx) {
    return atan2(fy,fx);
}
inline double IKatan2(double fy, double fx) {
    if( std::isnan(fy) ) {
        IKFAST_ASSERT(!std::isnan(fx)); // if both are nan, probably wrong value will be returned
        return IKPI_2;
    }
    else if( std::isnan(fx) ) {
        return 0;
    }
    return atan2(fy,fx);
}

template <typename T>
struct CheckValue
{
    T value;
    bool valid;
};

template <typename T>
inline CheckValue<T> IKatan2WithCheck(T fy, T fx, T epsilon)
{
    CheckValue<T> ret;
    ret.valid = false;
    ret.value = 0;
    if( !std::isnan(fy) && !std::isnan(fx) ) {
        if( IKabs(fy) >= IKFAST_ATAN2_MAGTHRESH || IKabs(fx) > IKFAST_ATAN2_MAGTHRESH ) {
            ret.value = IKatan2Simple(fy,fx);
            ret.valid = true;
        }
    }
    return ret;
}

inline float IKsign(float f) {
    if( f > 0 ) {
        return float(1);
    }
    else if( f < 0 ) {
        return float(-1);
    }
    return 0;
}

inline double IKsign(double f) {
    if( f > 0 ) {
        return 1.0;
    }
    else if( f < 0 ) {
        return -1.0;
    }
    return 0;
}

template <typename T>
inline CheckValue<T> IKPowWithIntegerCheck(T f, int n)
{
    CheckValue<T> ret;
    ret.valid = true;
    if( n == 0 ) {
        ret.value = 1.0;
        return ret;
    }
    else if( n == 1 )
    {
        ret.value = f;
        return ret;
    }
    else if( n < 0 )
    {
        if( f == 0 )
        {
            ret.valid = false;
            ret.value = (T)1.0e30;
            return ret;
        }
        if( n == -1 ) {
            ret.value = T(1.0)/f;
            return ret;
        }
    }

    int num = n > 0 ? n : -n;
    if( num == 2 ) {
        ret.value = f*f;
    }
    else if( num == 3 ) {
        ret.value = f*f*f;
    }
    else {
        ret.value = 1.0;
        while(num>0) {
            if( num & 1 ) {
                ret.value *= f;
            }
            num >>= 1;
            f *= f;
        }
    }
    
    if( n < 0 ) {
        ret.value = T(1.0)/ret.value;
    }
    return ret;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot) {
IkReal x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21,x22,x23,x24,x25,x26,x27,x28,x29,x30,x31,x32,x33,x34,x35,x36,x37,x38,x39,x40,x41,x42,x43,x44,x45,x46,x47,x48,x49,x50,x51,x52,x53,x54,x55,x56,x57,x58,x59;
x0=IKsin(j[2]);
x1=IKsin(j[5]);
x2=IKsin(j[4]);
x3=IKcos(j[4]);
x4=IKcos(j[2]);
x5=IKcos(j[3]);
x6=IKsin(j[1]);
x7=IKsin(j[3]);
x8=IKcos(j[5]);
x9=IKcos(j[1]);
x10=IKsin(j[0]);
x11=IKcos(j[0]);
x12=IKcos(j[6]);
x13=IKsin(j[6]);
x14=((1.0)*x1);
x15=((1.0)*x13);
x16=((1.0)*x9);
x17=((1.0)*x12);
x18=((0.1385)*x3);
x19=((1.0)*x6);
x20=((1.0)*x3);
x21=((1.0)*x4);
x22=((1.0)*x8);
x23=(x0*x3);
x24=(x5*x9);
x25=(x0*x7);
x26=(x2*x4);
x27=(x0*x2);
x28=(x5*x6);
x29=(x4*x7);
x30=((0.3215)*x25);
x31=(x19*x7);
x32=((0.1385)*x29);
x33=(x19*x29);
x34=((1.0)*x27*x5);
x35=((0.1385)*x25*x8);
x36=(x16*x27);
x37=(x16*x23);
x38=(((x23*x5))+x26);
x39=((((-1.0)*x34))+((x3*x4)));
x40=((((-1.0)*x31))+((x24*x4)));
x41=(x34+(((-1.0)*x20*x4)));
x42=((((-1.0)*x16*x4*x5))+x31);
x43=(((x16*x7))+((x19*x4*x5)));
x44=((-1.0)*x43);
x45=(((x0*x18*x5))+(((0.1385)*x26)));
x46=((((-1.0)*x19*x5))+(((-1.0)*x16*x29)));
x47=(x30+x35);
x48=(x2*x42);
x49=(x2*x43);
x50=(((x14*x25))+(((-1.0)*x22*x38)));
x51=(((x27*x6))+((x3*x44)));
x52=((1.0)*x50);
x53=(x13*x50);
x54=(((x8*(((((-1.0)*x33))+x24))))+((x1*x51)));
x55=(((x8*(((((-1.0)*x36))+((x3*x40))))))+((x1*x46)));
x56=(((x14*(((((-1.0)*x33))+((x16*x5))))))+(((-1.0)*x22*x51)));
x57=((((0.352)*x9))+(((0.3215)*x24))+(((-0.3215)*x29*x6))+((x1*(((((0.1385)*x27*x6))+((x18*x44))))))+((x8*(((((-1.0)*x32*x6))+(((0.1385)*x24)))))));
x58=(((x13*x56))+((x12*((((x23*x6))+x49)))));
x59=(((x12*x56))+((x13*(((((-1.0)*x49))+(((-1.0)*x19*x23)))))));
eerot[0]=(((x11*x54))+((x10*(((((-1.0)*x14*x38))+(((-1.0)*x22*x25)))))));
eerot[1]=(((x10*(((((-1.0)*x17*x39))+(((-1.0)*x15*x50))))))+((x11*x58)));
eerot[2]=(((x11*x59))+((x10*(((((-1.0)*x15*x41))+(((-1.0)*x17*x50)))))));
eetrans[0]=((0.119525)+((x10*(((((-1.0)*x47))+(((-1.0)*x14*x45))))))+((x11*x57))+(((0.117)*x11)));
eerot[3]=(((x11*((((x1*x38))+((x25*x8))))))+((x10*x54)));
eerot[4]=(((x11*((x53+((x12*x39))))))+((x10*x58)));
eerot[5]=(((x11*((((x12*x50))+((x13*x41))))))+((x10*x59)));
eetrans[1]=(((x10*x57))+((x11*((x47+((x1*x45))))))+(((0.117)*x10)));
eerot[6]=(((x1*(((((-1.0)*x20*x40))+x36))))+((x46*x8)));
eerot[7]=(((x13*x55))+((x12*(((((-1.0)*x48))+x37)))));
eerot[8]=(((x12*x55))+((x13*(((((-1.0)*x37))+x48)))));
eetrans[2]=((0.40858)+(((-0.3215)*x29*x9))+(((-0.3215)*x28))+((x1*(((((0.1385)*x27*x9))+(((-1.0)*x18*x40))))))+(((-0.352)*x6))+((x8*(((((-1.0)*x32*x9))+(((-0.1385)*x28)))))));
}

IKFAST_API int GetNumFreeParameters() { return 1; }
IKFAST_API int* GetFreeParameters() { static int freeparams[] = {0}; return freeparams; }
IKFAST_API int GetNumJoints() { return 7; }

IKFAST_API int GetIkRealSize() { return sizeof(IkReal); }

IKFAST_API int GetIkType() { return 0x67000001; }

class IKSolver {
public:
IkReal j7,cj7,sj7,htj7,j7mul,j8,cj8,sj8,htj8,j8mul,j9,cj9,sj9,htj9,j9mul,j10,cj10,sj10,htj10,j10mul,j11,cj11,sj11,htj11,j11mul,j12,cj12,sj12,htj12,j12mul,j6,cj6,sj6,htj6,new_r00,r00,rxp0_0,new_r01,r01,rxp0_1,new_r02,r02,rxp0_2,new_r10,r10,rxp1_0,new_r11,r11,rxp1_1,new_r12,r12,rxp1_2,new_r20,r20,rxp2_0,new_r21,r21,rxp2_1,new_r22,r22,rxp2_2,new_px,px,npx,new_py,py,npy,new_pz,pz,npz,pp;
unsigned char _ij7[2], _nj7,_ij8[2], _nj8,_ij9[2], _nj9,_ij10[2], _nj10,_ij11[2], _nj11,_ij12[2], _nj12,_ij6[2], _nj6;

IkReal j100, cj100, sj100;
unsigned char _ij100[2], _nj100;
bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
j7=numeric_limits<IkReal>::quiet_NaN(); _ij7[0] = -1; _ij7[1] = -1; _nj7 = -1; j8=numeric_limits<IkReal>::quiet_NaN(); _ij8[0] = -1; _ij8[1] = -1; _nj8 = -1; j9=numeric_limits<IkReal>::quiet_NaN(); _ij9[0] = -1; _ij9[1] = -1; _nj9 = -1; j10=numeric_limits<IkReal>::quiet_NaN(); _ij10[0] = -1; _ij10[1] = -1; _nj10 = -1; j11=numeric_limits<IkReal>::quiet_NaN(); _ij11[0] = -1; _ij11[1] = -1; _nj11 = -1; j12=numeric_limits<IkReal>::quiet_NaN(); _ij12[0] = -1; _ij12[1] = -1; _nj12 = -1;  _ij6[0] = -1; _ij6[1] = -1; _nj6 = 0; 
for(int dummyiter = 0; dummyiter < 1; ++dummyiter) {
    solutions.Clear();
j6=pfree[0]; cj6=cos(pfree[0]); sj6=sin(pfree[0]), htj6=tan(pfree[0]*0.5);
r00 = eerot[0*3+0];
r01 = eerot[0*3+1];
r02 = eerot[0*3+2];
r10 = eerot[1*3+0];
r11 = eerot[1*3+1];
r12 = eerot[1*3+2];
r20 = eerot[2*3+0];
r21 = eerot[2*3+1];
r22 = eerot[2*3+2];
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];

new_r00=((((-1.0)*r12*(IKsin(j6))))+(((-1.0)*r02*(IKcos(j6)))));
new_r01=(((r11*(IKsin(j6))))+((r01*(IKcos(j6)))));
new_r02=(((r00*(IKcos(j6))))+((r10*(IKsin(j6)))));
IkReal x60=IKcos(j6);
IkReal x61=IKsin(j6);
new_px=((-0.117)+(((-0.1385)*r10*x61))+(((-0.1385)*r00*x60))+((px*x60))+(((-0.119525)*x60))+((py*x61)));
new_r10=r22;
new_r11=((-1.0)*r21);
new_r12=((-1.0)*r20);
new_py=((0.40858)+(((0.1385)*r20))+(((-1.0)*pz)));
new_r20=((((-1.0)*r12*(IKcos(j6))))+((r02*(IKsin(j6)))));
new_r21=(((r11*(IKcos(j6))))+(((-1.0)*r01*(IKsin(j6)))));
new_r22=(((r10*(IKcos(j6))))+(((-1.0)*r00*(IKsin(j6)))));
IkReal x62=IKsin(j6);
IkReal x63=IKcos(j6);
new_pz=((((-0.1385)*r10*x63))+(((0.119525)*x62))+(((0.1385)*r00*x62))+(((-1.0)*px*x62))+((py*x63)));
r00 = new_r00; r01 = new_r01; r02 = new_r02; r10 = new_r10; r11 = new_r11; r12 = new_r12; r20 = new_r20; r21 = new_r21; r22 = new_r22; px = new_px; py = new_py; pz = new_pz;
IkReal x64=((1.0)*px);
IkReal x65=((1.0)*pz);
IkReal x66=((1.0)*py);
pp=((px*px)+(py*py)+(pz*pz));
npx=(((px*r00))+((py*r10))+((pz*r20)));
npy=(((px*r01))+((py*r11))+((pz*r21)));
npz=(((px*r02))+((py*r12))+((pz*r22)));
rxp0_0=((((-1.0)*r20*x66))+((pz*r10)));
rxp0_1=(((px*r20))+(((-1.0)*r00*x65)));
rxp0_2=((((-1.0)*r10*x64))+((py*r00)));
rxp1_0=((((-1.0)*r21*x66))+((pz*r11)));
rxp1_1=(((px*r21))+(((-1.0)*r01*x65)));
rxp1_2=((((-1.0)*r11*x64))+((py*r01)));
rxp2_0=(((pz*r12))+(((-1.0)*r22*x66)));
rxp2_1=(((px*r22))+(((-1.0)*r02*x65)));
rxp2_2=((((-1.0)*r12*x64))+((py*r02)));
{
IkReal j7eval[2];
j7eval[0]=((px*px)+(py*py));
j7eval[1]=(pp+(((-1.0)*(pz*pz))));
if( IKabs(j7eval[0]) < 0.0000010000000000  || IKabs(j7eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((px*px)+(py*py));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j12eval[1];
IkReal x67=((1.0)*pz);
IkReal x68=((0.3215)*r22);
IkReal x69=(pz*r22);
IkReal x70=((0.643)*x69);
IkReal x71=((0.0410835)+(((-1.0)*x70)));
IkReal x72=(x68+(((-1.0)*x67)));
IkReal x73=((-1.0)*pz);
IkReal x74=((0.0410835)+x70);
IkReal x75=((((-1.0)*x68))+(((-1.0)*x67)));
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=x69;
rxp0_0=(pz*r10);
rxp0_1=(r00*x73);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x73);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=(r02*x73);
rxp2_2=0;
IkReal gconst0=x74;
IkReal gconst1=x71;
IkReal gconst2=x72;
IkReal gconst3=x75;
IkReal gconst4=x74;
IkReal gconst5=x71;
IkReal gconst6=x72;
IkReal gconst7=x75;
IkReal gconst8=x74;
IkReal gconst9=x71;
IkReal gconst10=x72;
IkReal gconst11=x75;
IkReal gconst12=x74;
IkReal gconst13=x71;
IkReal gconst14=x72;
IkReal gconst15=x75;
IkReal x76=r21*r21;
IkReal x77=pz*pz;
IkReal x78=pz*pz*pz*pz;
IkReal x79=r22*r22;
IkReal x80=r20*r20;
IkReal x81=(r20*r21);
IkReal x82=((0.271774911864)*x77);
IkReal x83=((6.615184)*x78);
IkReal x84=(x77*x80);
IkReal x85=(x78*x79);
IkReal x86=(x78*x80);
IkReal x87=(x77*x79);
IkReal x88=(((x81*x83))+((x81*x82))+(((0.00279136614789116)*x81)));
j12eval[0]=((((0.5)*(IKabs(((((3.307592)*x86))+(((-9.922776)*x85))+(((0.00139568307394558)*x80))+(((0.135887455932)*x84))+(((-0.543549823728)*x76*x77))+(((-0.407662367796)*x87))+(((-0.00558273229578232)*x76))+(((-0.00418704922183674)*x79))+(((-13.230368)*x76*x78)))))))+(((0.5)*(IKabs(((((-0.067943727966)*x84))+(((-0.067943727966)*x87))+(((-0.00069784153697279)*x80))+(((-0.00069784153697279)*x79))+(((-1.653796)*x85))+(((-1.653796)*x86)))))))+(IKabs(((((-1.0)*x79*x82))+(((-1.0)*x79*x83))+(((-1.0)*x76*x82))+(((-1.0)*x76*x83))+(((-0.00279136614789116)*x76))+(((-0.00279136614789116)*x79)))))+(((2.0)*(IKabs(x88)))));
if( IKabs(j12eval[0]) < 0.0000000010000000  )
{
continue; // no branches [j7, j11, j12]

} else
{
IkReal op[8+1], zeror[8];
int numroots;
IkReal x89=r20*r20;
IkReal x90=pz*pz;
IkReal x91=r21*r21;
IkReal x92=(r20*r21);
IkReal x93=(gconst0*gconst11);
IkReal x94=(gconst5*gconst6);
IkReal x95=((1.0)*gconst12);
IkReal x96=(gconst13*gconst14);
IkReal x97=(gconst14*gconst5);
IkReal x98=((1.0)*gconst2);
IkReal x99=((0.413449)*gconst12);
IkReal x100=(gconst0*gconst3);
IkReal x101=(gconst11*gconst8);
IkReal x102=(gconst13*gconst6);
IkReal x103=((0.826898)*gconst12);
IkReal x104=((0.413449)*gconst4);
IkReal x105=(gconst4*pz);
IkReal x106=(gconst4*gconst9);
IkReal x107=(gconst1*gconst12);
IkReal x108=((1.653796)*pz);
IkReal x109=(gconst10*gconst7);
IkReal x110=(gconst3*gconst8);
IkReal x111=(gconst1*gconst4);
IkReal x112=(gconst10*gconst15);
IkReal x113=(gconst2*gconst7);
IkReal x114=(gconst12*gconst9);
IkReal x115=((0.826898)*gconst4);
IkReal x116=(gconst15*gconst2);
IkReal x117=(gconst1*x89);
IkReal x118=(gconst6*x108);
IkReal x119=((1.0)*gconst4*gconst7);
IkReal x120=(gconst9*x89);
IkReal x121=((1.0)*gconst1*gconst10);
IkReal x122=(gconst11*x89);
IkReal x123=(gconst14*x90);
IkReal x124=((1.653796)*x91);
IkReal x125=(gconst3*x89);
IkReal x126=((0.826898)*gconst6*pz);
IkReal x127=(gconst6*x90);
IkReal x128=((1.0)*gconst10*gconst9);
IkReal x129=((1.0)*gconst15*gconst4);
IkReal x130=(gconst3*x91);
IkReal x131=(gconst11*x91);
IkReal x132=((0.826898)*gconst14*pz);
IkReal x133=((3.307592)*pz*x91);
IkReal x134=(x120*x99);
IkReal x135=(x117*x99);
IkReal x136=(x104*x120);
IkReal x137=(x104*x117);
IkReal x138=(pz*x103*x122);
IkReal x139=(x120*x132);
IkReal x140=(x120*x126);
IkReal x141=(pz*x103*x125);
IkReal x142=(x117*x132);
IkReal x143=((0.826898)*x105*x122);
IkReal x144=((0.826898)*x105*x125);
IkReal x145=(x117*x126);
IkReal x146=((1.653796)*x122*x123);
IkReal x147=((1.653796)*x122*x127);
IkReal x148=((1.653796)*x123*x125);
IkReal x149=((1.653796)*x125*x127);
IkReal x150=(x144+x145);
IkReal x151=(x139+x138);
IkReal x152=(x146+x134);
IkReal x153=(x149+x137);
IkReal x154=((((-6.615184)*x92*(x90*x90)))+(((-0.271774911864)*x90*x92))+(((-0.00279136614789116)*x92)));
IkReal x155=((((0.271774911864)*x90*x92))+(((6.615184)*x92*(x90*x90)))+(((0.00279136614789116)*x92)));
IkReal x156=(x147+x148+x135+x136);
IkReal x157=(x140+x141+x142+x143);
op[0]=((((-1.0)*x152))+((x112*x114))+(((-1.0)*gconst15*x101*x95))+((x101*x96))+x151+(((-1.0)*x128*x96)));
op[1]=x154;
op[2]=((((-1.0)*x101*x129))+(((-1.0)*x156))+((gconst14*gconst9*x133))+((x106*x112))+((x114*x116))+((x101*x97))+((x103*x120))+(((-1.0)*gconst7*x101*x95))+((x109*x114))+x157+(((-1.0)*gconst15*x110*x95))+(((3.307592)*x122*x123))+(((-1.0)*gconst14*x108*x120))+((x93*x96))+(((-1.0)*gconst12*x108*x122))+(((-1.0)*x114*x124))+(((-1.0)*x121*x96))+(((3.307592)*gconst12*pz*x131))+(((-6.615184)*x123*x131))+(((-1.0)*x102*x128))+((x101*x102))+(((-1.0)*x128*x97))+(((-1.0)*gconst15*x93*x95))+(((-1.0)*gconst9*x96*x98))+((x110*x96))+((x107*x112)));
op[3]=x154;
op[4]=((((-1.0)*x118*x120))+((x107*x109))+(((-1.0)*x152))+(((-1.0)*x153))+(((-1.0)*gconst7*x93*x95))+((x100*x96))+((x106*x109))+((x111*x112))+((gconst6*gconst9*x133))+(((-1.0)*x110*x129))+(((3.307592)*x123*x125))+((x106*x116))+(((-1.0)*x101*x119))+(((-1.0)*gconst15*x100*x95))+(((-1.0)*x106*x124))+((x102*x93))+((x101*x94))+(((-1.0)*gconst1*x96*x98))+((x113*x114))+(((-1.0)*gconst9*x102*x98))+(((3.307592)*x105*x131))+((x102*x110))+((x103*x117))+x151+x150+(((-1.0)*x107*x124))+(((-1.653796)*x105*x122))+(((3.307592)*x122*x127))+((x93*x97))+(((-1.0)*gconst9*x97*x98))+(((0.826898)*x106*x89))+(((-1.0)*gconst7*x110*x95))+(((-1.0)*gconst12*x108*x125))+(((-1.0)*x121*x97))+(((-6.615184)*x127*x131))+(((3.307592)*gconst12*pz*x130))+(((-6.615184)*x123*x130))+((gconst1*gconst14*x133))+(((-1.0)*x102*x121))+(((-1.0)*gconst14*x108*x117))+(((-1.0)*x129*x93))+(((-1.0)*x128*x94))+((x110*x97))+((x107*x116)));
op[5]=x155;
op[6]=((((-1.0)*gconst1*x97*x98))+(((-1.0)*x100*x129))+(((-1.0)*x156))+((x100*x97))+(((3.307592)*x125*x127))+((x111*x116))+(((-1.0)*gconst9*x94*x98))+(((-1.0)*x117*x118))+((x106*x113))+(((-1.0)*x111*x124))+(((3.307592)*x105*x130))+(((-1.0)*x119*x93))+(((0.826898)*x111*x89))+((x109*x111))+(((-1.0)*x110*x119))+x157+((gconst1*gconst6*x133))+(((-1.653796)*x105*x125))+((x93*x94))+(((-1.0)*gconst7*x100*x95))+(((-1.0)*x121*x94))+(((-6.615184)*x127*x130))+(((-1.0)*gconst1*x102*x98))+((x110*x94))+((x107*x113))+((x100*x102)));
op[7]=x155;
op[8]=((((-1.0)*x153))+((x100*x94))+((x111*x113))+(((-1.0)*x100*x119))+(((-1.0)*gconst1*x94*x98))+x150);
polyroots8(op,zeror,numroots);
IkReal j12array[8], cj12array[8], sj12array[8], tempj12array[1];
int numsolutions = 0;
for(int ij12 = 0; ij12 < numroots; ++ij12)
{
IkReal htj12 = zeror[ij12];
tempj12array[0]=((2.0)*(atan(htj12)));
for(int kj12 = 0; kj12 < 1; ++kj12)
{
j12array[numsolutions] = tempj12array[kj12];
if( j12array[numsolutions] > IKPI )
{
    j12array[numsolutions]-=IK2PI;
}
else if( j12array[numsolutions] < -IKPI )
{
    j12array[numsolutions]+=IK2PI;
}
sj12array[numsolutions] = IKsin(j12array[numsolutions]);
cj12array[numsolutions] = IKcos(j12array[numsolutions]);
numsolutions++;
}
}
bool j12valid[8]={true,true,true,true,true,true,true,true};
_nj12 = 8;
for(int ij12 = 0; ij12 < numsolutions; ++ij12)
    {
if( !j12valid[ij12] )
{
    continue;
}
    j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
htj12 = IKtan(j12/2);

_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < numsolutions; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
{
IkReal j11eval[2];
IkReal x158=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x158);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x158);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=(r02*x158);
rxp2_2=0;
IkReal x159=(cj12*r20);
IkReal x160=(r21*sj12);
j11eval[0]=((r22*r22)+(x160*x160)+(x159*x159)+(((-2.0)*x159*x160)));
j11eval[1]=((IKabs(r22))+(((3.1104199066874)*(IKabs(((((-0.3215)*x159))+(((0.3215)*x160))))))));
if( IKabs(j11eval[0]) < 0.0000010000000000  || IKabs(j11eval[1]) < 0.0000010000000000  )
{
{
IkReal j11eval[2];
IkReal x161=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x161);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x161);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=(r02*x161);
rxp2_2=0;
IkReal x162=pz*pz;
IkReal x163=(r21*sj12);
IkReal x164=(cj12*r20);
j11eval[0]=((IKabs((pz*r22)))+(IKabs((((pz*x163))+(((-1.0)*pz*x164))))));
j11eval[1]=(((x162*(x163*x163)))+(((-2.0)*x162*x163*x164))+((x162*(r22*r22)))+((x162*(x164*x164))));
if( IKabs(j11eval[0]) < 0.0000010000000000  || IKabs(j11eval[1]) < 0.0000010000000000  )
{
{
IkReal j7eval[2];
IkReal x165=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x165);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x165);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=(r02*x165);
rxp2_2=0;
IkReal x166=sj12*sj12;
IkReal x167=cj12*cj12;
IkReal x168=(r10*sj12);
IkReal x169=(cj12*r11);
IkReal x170=(cj12*r01);
IkReal x171=(r00*sj12);
j7eval[0]=((((2.0)*x170*x171))+((x166*(r00*r00)))+((x166*(r10*r10)))+((x167*(r11*r11)))+(((2.0)*x168*x169))+((x167*(r01*r01))));
j7eval[1]=((IKabs(((((0.352)*x169))+(((0.352)*x168)))))+(IKabs(((((0.352)*x170))+(((0.352)*x171))))));
if( IKabs(j7eval[0]) < 0.0000010000000000  || IKabs(j7eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(pz);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j11eval[1];
px=0;
py=0;
pp=0;
npx=0;
npy=0;
npz=0;
rxp0_0=0;
rxp0_1=0;
rxp0_2=0;
rxp1_0=0;
rxp1_1=0;
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
pz=0;
j11eval[0]=((((3.1104199066874)*(IKabs(((((-0.3215)*cj12*r20))+(((0.3215)*r21*sj12)))))))+(IKabs(r22)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal j7eval[1];
px=0;
py=0;
pp=0;
npx=0;
npy=0;
npz=0;
rxp0_0=0;
rxp0_1=0;
rxp0_2=0;
rxp1_0=0;
rxp1_1=0;
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
pz=0;
IkReal x172=((0.352)*sj12);
IkReal x173=((0.352)*cj12);
j7eval[0]=((IKabs((((r00*x172))+((r01*x173)))))+(IKabs((((r10*x172))+((r11*x173))))));
if( IKabs(j7eval[0]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j7array[2], cj7array[2], sj7array[2];
bool j7valid[2]={false};
_nj7 = 2;
IkReal x174=((0.352)*cj12);
IkReal x175=((0.352)*sj12);
CheckValue<IkReal> x177 = IKatan2WithCheck(IkReal((((r00*x175))+((r01*x174)))),IkReal((((r10*x175))+((r11*x174)))),IKFAST_ATAN2_MAGTHRESH);
if(!x177.valid){
continue;
}
IkReal x176=x177.value;
j7array[0]=((-1.0)*x176);
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
j7array[1]=((3.14159265358979)+(((-1.0)*x176)));
sj7array[1]=IKsin(j7array[1]);
cj7array[1]=IKcos(j7array[1]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
if( j7array[1] > IKPI )
{
    j7array[1]-=IK2PI;
}
else if( j7array[1] < -IKPI )
{    j7array[1]+=IK2PI;
}
j7valid[1] = true;
for(int ij7 = 0; ij7 < 2; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 2; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];

{
IkReal j11eval[1];
px=0;
py=0;
pp=0;
npx=0;
npy=0;
npz=0;
rxp0_0=0;
rxp0_1=0;
rxp0_2=0;
rxp1_0=0;
rxp1_1=0;
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
pz=0;
j11eval[0]=((((-1.0)*cj12*r20))+((r21*sj12)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal j11eval[1];
px=0;
py=0;
pp=0;
npx=0;
npy=0;
npz=0;
rxp0_0=0;
rxp0_1=0;
rxp0_2=0;
rxp1_0=0;
rxp1_1=0;
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
pz=0;
j11eval[0]=((((-1.0)*cj12*r00))+((r01*sj12)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal j11eval[1];
px=0;
py=0;
pp=0;
npx=0;
npy=0;
npz=0;
rxp0_0=0;
rxp0_1=0;
rxp0_2=0;
rxp1_0=0;
rxp1_1=0;
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
pz=0;
j11eval[0]=(((r11*sj12))+(((-1.0)*cj12*r10)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x178=((44.0)*sj7);
IkReal x179=(cj7*r02);
CheckValue<IkReal> x180=IKPowWithIntegerCheck(((((40.1875)*r11*sj12))+(((-40.1875)*cj12*r10))),-1);
if(!x180.valid){
continue;
}
if( IKabs(((x180.value)*(((((-1.0)*x178))+(((44.0)*r12*x179))+((x178*(r12*r12))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.09486780715397)*x179))+(((-1.09486780715397)*r12*sj7)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x180.value)*(((((-1.0)*x178))+(((44.0)*r12*x179))+((x178*(r12*r12)))))))+IKsqr(((((-1.09486780715397)*x179))+(((-1.09486780715397)*r12*sj7))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x180.value)*(((((-1.0)*x178))+(((44.0)*r12*x179))+((x178*(r12*r12)))))), ((((-1.09486780715397)*x179))+(((-1.09486780715397)*r12*sj7))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[5];
IkReal x181=IKcos(j11);
IkReal x182=IKsin(j11);
IkReal x183=(r01*sj12);
IkReal x184=((0.352)*cj7);
IkReal x185=(cj12*r10);
IkReal x186=(r11*sj12);
IkReal x187=(cj12*r00);
IkReal x188=((0.352)*sj7);
IkReal x189=((0.3215)*x182);
IkReal x190=((0.3215)*x181);
evalcond[0]=(x190+((r12*x188))+((r02*x184)));
evalcond[1]=(((r21*sj12*x189))+(((-1.0)*cj12*r20*x189))+((r22*x190)));
evalcond[2]=((((-1.0)*x187*x189))+x184+((r02*x190))+((x183*x189)));
evalcond[3]=(((x186*x189))+x188+(((-1.0)*x185*x189))+((r12*x190)));
evalcond[4]=((((-1.0)*x186*x188))+(((-1.0)*x189))+((x185*x188))+((x184*x187))+(((-1.0)*x183*x184)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x732=(r12*sj7);
IkReal x733=((44.0)*cj7);
CheckValue<IkReal> x734=IKPowWithIntegerCheck(((((-40.1875)*cj12*r00))+(((40.1875)*r01*sj12))),-1);
if(!x734.valid){
continue;
}
if( IKabs(((x734.value)*(((((-1.0)*x733))+(((44.0)*r02*x732))+((x733*(r02*r02))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.09486780715397)*cj7*r02))+(((-1.09486780715397)*x732)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x734.value)*(((((-1.0)*x733))+(((44.0)*r02*x732))+((x733*(r02*r02)))))))+IKsqr(((((-1.09486780715397)*cj7*r02))+(((-1.09486780715397)*x732))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x734.value)*(((((-1.0)*x733))+(((44.0)*r02*x732))+((x733*(r02*r02)))))), ((((-1.09486780715397)*cj7*r02))+(((-1.09486780715397)*x732))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[5];
IkReal x735=IKcos(j11);
IkReal x736=IKsin(j11);
IkReal x737=(r01*sj12);
IkReal x738=((0.352)*cj7);
IkReal x739=(cj12*r10);
IkReal x740=(r11*sj12);
IkReal x741=(cj12*r00);
IkReal x742=((0.352)*sj7);
IkReal x743=((0.3215)*x736);
IkReal x744=((0.3215)*x735);
evalcond[0]=(((r12*x742))+((r02*x738))+x744);
evalcond[1]=(((r22*x744))+(((-1.0)*cj12*r20*x743))+((r21*sj12*x743)));
evalcond[2]=(((r02*x744))+((x737*x743))+(((-1.0)*x741*x743))+x738);
evalcond[3]=(((x740*x743))+((r12*x744))+x742+(((-1.0)*x739*x743)));
evalcond[4]=(((x738*x741))+((x739*x742))+(((-1.0)*x737*x738))+(((-1.0)*x740*x742))+(((-1.0)*x743)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x745=((0.352)*r22);
IkReal x746=(r12*sj7);
IkReal x747=(cj7*r02);
CheckValue<IkReal> x748=IKPowWithIntegerCheck(((((-0.3215)*cj12*r20))+(((0.3215)*r21*sj12))),-1);
if(!x748.valid){
continue;
}
if( IKabs(((x748.value)*((((x745*x747))+((x745*x746)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.09486780715397)*x747))+(((-1.09486780715397)*x746)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x748.value)*((((x745*x747))+((x745*x746))))))+IKsqr(((((-1.09486780715397)*x747))+(((-1.09486780715397)*x746))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x748.value)*((((x745*x747))+((x745*x746))))), ((((-1.09486780715397)*x747))+(((-1.09486780715397)*x746))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[5];
IkReal x749=IKcos(j11);
IkReal x750=IKsin(j11);
IkReal x751=(r01*sj12);
IkReal x752=((0.352)*cj7);
IkReal x753=(cj12*r10);
IkReal x754=(r11*sj12);
IkReal x755=(cj12*r00);
IkReal x756=((0.352)*sj7);
IkReal x757=((0.3215)*x750);
IkReal x758=((0.3215)*x749);
evalcond[0]=(((r02*x752))+((r12*x756))+x758);
evalcond[1]=(((r22*x758))+((r21*sj12*x757))+(((-1.0)*cj12*r20*x757)));
evalcond[2]=(((r02*x758))+((x751*x757))+(((-1.0)*x755*x757))+x752);
evalcond[3]=((((-1.0)*x753*x757))+((r12*x758))+x756+((x754*x757)));
evalcond[4]=(((x752*x755))+(((-1.0)*x754*x756))+(((-1.0)*x751*x752))+((x753*x756))+(((-1.0)*x757)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}

} else
{
{
IkReal j11array[2], cj11array[2], sj11array[2];
bool j11valid[2]={false};
_nj11 = 2;
CheckValue<IkReal> x760 = IKatan2WithCheck(IkReal(((0.3215)*r22)),IkReal(((((-0.3215)*cj12*r20))+(((0.3215)*r21*sj12)))),IKFAST_ATAN2_MAGTHRESH);
if(!x760.valid){
continue;
}
IkReal x759=x760.value;
j11array[0]=((-1.0)*x759);
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
j11array[1]=((3.14159265358979)+(((-1.0)*x759)));
sj11array[1]=IKsin(j11array[1]);
cj11array[1]=IKcos(j11array[1]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
if( j11array[1] > IKPI )
{
    j11array[1]-=IK2PI;
}
else if( j11array[1] < -IKPI )
{    j11array[1]+=IK2PI;
}
j11valid[1] = true;
for(int ij11 = 0; ij11 < 2; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 2; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];

{
IkReal j7eval[3];
px=0;
py=0;
pp=0;
npx=0;
npy=0;
npz=0;
rxp0_0=0;
rxp0_1=0;
rxp0_2=0;
rxp1_0=0;
rxp1_1=0;
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
pz=0;
IkReal x761=(r21*sj12);
IkReal x762=((1.0)*cj12);
IkReal x763=(cj11*sj12);
j7eval[0]=((((-1.0)*r20*x762))+x761);
j7eval[1]=((IKabs(((((-1.0)*cj11*r11*x762))+(((-1.0)*r10*x763)))))+(IKabs((((cj11*cj12*r01))+((r00*x763))))));
j7eval[2]=IKsign(((((247.808)*x761))+(((-247.808)*cj12*r20))));
if( IKabs(j7eval[0]) < 0.0000010000000000  || IKabs(j7eval[1]) < 0.0000010000000000  || IKabs(j7eval[2]) < 0.0000010000000000  )
{
{
IkReal j7eval[3];
px=0;
py=0;
pp=0;
npx=0;
npy=0;
npz=0;
rxp0_0=0;
rxp0_1=0;
rxp0_2=0;
rxp1_0=0;
rxp1_1=0;
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
pz=0;
IkReal x764=((28292.0)*cj11);
IkReal x765=((28292.0)*sj11);
IkReal x766=(cj12*r21);
IkReal x767=(r20*sj12);
j7eval[0]=(x766+x767);
j7eval[1]=((IKabs((((r02*x765))+(((-1.0)*r01*sj12*x764))+((cj12*r00*x764)))))+(IKabs(((((-1.0)*cj12*r10*x764))+((r11*sj12*x764))+(((-1.0)*r12*x765))))));
j7eval[2]=IKsign(((((30976.0)*x767))+(((30976.0)*x766))));
if( IKabs(j7eval[0]) < 0.0000010000000000  || IKabs(j7eval[1]) < 0.0000010000000000  || IKabs(j7eval[2]) < 0.0000010000000000  )
{
{
IkReal j7eval[1];
px=0;
py=0;
pp=0;
npx=0;
npy=0;
npz=0;
rxp0_0=0;
rxp0_1=0;
rxp0_2=0;
rxp1_0=0;
rxp1_1=0;
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
pz=0;
j7eval[0]=r12;
if( IKabs(j7eval[0]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j7array[1], cj7array[1], sj7array[1];
bool j7valid[1]={false};
_nj7 = 1;
IkReal x768=((643.0)*cj11);
IkReal x769=((643.0)*r02);
IkReal x770=(cj12*r00*sj11);
IkReal x771=(r01*sj11*sj12);
CheckValue<IkReal> x772=IKPowWithIntegerCheck(r12,-1);
if(!x772.valid){
continue;
}
if( IKabs(((0.00142045454545455)*(x772.value)*(((((-1.0)*x768))+((x769*x771))+(((-1.0)*x769*x770))+((x768*(r02*r02))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-0.913352272727273)*cj11*r02))+(((-0.913352272727273)*x771))+(((0.913352272727273)*x770)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00142045454545455)*(x772.value)*(((((-1.0)*x768))+((x769*x771))+(((-1.0)*x769*x770))+((x768*(r02*r02)))))))+IKsqr(((((-0.913352272727273)*cj11*r02))+(((-0.913352272727273)*x771))+(((0.913352272727273)*x770))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j7array[0]=IKatan2(((0.00142045454545455)*(x772.value)*(((((-1.0)*x768))+((x769*x771))+(((-1.0)*x769*x770))+((x768*(r02*r02)))))), ((((-0.913352272727273)*cj11*r02))+(((-0.913352272727273)*x771))+(((0.913352272727273)*x770))));
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
for(int ij7 = 0; ij7 < 1; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 1; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];
{
IkReal evalcond[5];
IkReal x773=IKcos(j7);
IkReal x774=IKsin(j7);
IkReal x775=(r01*sj12);
IkReal x776=((0.3215)*cj11);
IkReal x777=(r11*sj12);
IkReal x778=((0.3215)*sj11);
IkReal x779=(cj12*r10);
IkReal x780=(cj12*r00);
IkReal x781=((0.352)*x774);
IkReal x782=((0.352)*x773);
evalcond[0]=(((r02*x782))+x776+((r12*x781)));
evalcond[1]=(x782+(((-1.0)*x778*x780))+((r02*x776))+((x775*x778)));
evalcond[2]=((((-1.0)*x778*x779))+((x777*x778))+((r12*x776))+x781);
evalcond[3]=(((r10*sj12*x781))+((r00*sj12*x782))+((cj12*r01*x782))+((cj12*r11*x781)));
evalcond[4]=((((-1.0)*x775*x782))+(((-1.0)*x777*x781))+((x779*x781))+((x780*x782))+(((-1.0)*x778)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j7array[1], cj7array[1], sj7array[1];
bool j7valid[1]={false};
_nj7 = 1;
IkReal x783=((28292.0)*cj11);
IkReal x784=((28292.0)*sj11);
CheckValue<IkReal> x785=IKPowWithIntegerCheck(IKsign(((((30976.0)*r20*sj12))+(((30976.0)*cj12*r21)))),-1);
if(!x785.valid){
continue;
}
CheckValue<IkReal> x786 = IKatan2WithCheck(IkReal((((r02*x784))+(((-1.0)*r01*sj12*x783))+((cj12*r00*x783)))),IkReal(((((-1.0)*cj12*r10*x783))+(((-1.0)*r12*x784))+((r11*sj12*x783)))),IKFAST_ATAN2_MAGTHRESH);
if(!x786.valid){
continue;
}
j7array[0]=((-1.5707963267949)+(((1.5707963267949)*(x785.value)))+(x786.value));
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
for(int ij7 = 0; ij7 < 1; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 1; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];
{
IkReal evalcond[5];
IkReal x787=IKcos(j7);
IkReal x788=IKsin(j7);
IkReal x789=(r01*sj12);
IkReal x790=((0.3215)*cj11);
IkReal x791=(r11*sj12);
IkReal x792=((0.3215)*sj11);
IkReal x793=(cj12*r10);
IkReal x794=(cj12*r00);
IkReal x795=((0.352)*x788);
IkReal x796=((0.352)*x787);
evalcond[0]=(((r02*x796))+x790+((r12*x795)));
evalcond[1]=((((-1.0)*x792*x794))+((r02*x790))+x796+((x789*x792)));
evalcond[2]=((((-1.0)*x792*x793))+x795+((r12*x790))+((x791*x792)));
evalcond[3]=(((r10*sj12*x795))+((r00*sj12*x796))+((cj12*r01*x796))+((cj12*r11*x795)));
evalcond[4]=((((-1.0)*x792))+((x793*x795))+(((-1.0)*x791*x795))+(((-1.0)*x789*x796))+((x794*x796)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j7array[1], cj7array[1], sj7array[1];
bool j7valid[1]={false};
_nj7 = 1;
IkReal x797=((226.336)*cj11);
CheckValue<IkReal> x798 = IKatan2WithCheck(IkReal((((r00*sj12*x797))+((cj12*r01*x797)))),IkReal(((((-1.0)*cj12*r11*x797))+(((-1.0)*r10*sj12*x797)))),IKFAST_ATAN2_MAGTHRESH);
if(!x798.valid){
continue;
}
CheckValue<IkReal> x799=IKPowWithIntegerCheck(IKsign(((((-247.808)*cj12*r20))+(((247.808)*r21*sj12)))),-1);
if(!x799.valid){
continue;
}
j7array[0]=((-1.5707963267949)+(x798.value)+(((1.5707963267949)*(x799.value))));
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
for(int ij7 = 0; ij7 < 1; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 1; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];
{
IkReal evalcond[5];
IkReal x800=IKcos(j7);
IkReal x801=IKsin(j7);
IkReal x802=(r01*sj12);
IkReal x803=((0.3215)*cj11);
IkReal x804=(r11*sj12);
IkReal x805=((0.3215)*sj11);
IkReal x806=(cj12*r10);
IkReal x807=(cj12*r00);
IkReal x808=((0.352)*x801);
IkReal x809=((0.352)*x800);
evalcond[0]=(((r12*x808))+((r02*x809))+x803);
evalcond[1]=((((-1.0)*x805*x807))+((r02*x803))+x809+((x802*x805)));
evalcond[2]=(((x804*x805))+(((-1.0)*x805*x806))+((r12*x803))+x808);
evalcond[3]=(((r00*sj12*x809))+((r10*sj12*x808))+((cj12*r01*x809))+((cj12*r11*x808)));
evalcond[4]=((((-1.0)*x804*x808))+((x806*x808))+(((-1.0)*x805))+(((-1.0)*x802*x809))+((x807*x809)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j7, j11]

}
} while(0);
if( bgotonextstatement )
{
}
}
}

} else
{
{
IkReal j7array[2], cj7array[2], sj7array[2];
bool j7valid[2]={false};
_nj7 = 2;
IkReal x810=((0.352)*cj12);
IkReal x811=((0.352)*sj12);
IkReal x812=((1.0)*pz);
IkReal x813=(((r01*x810))+((r00*x811)));
IkReal x814=(((r11*x810))+((r10*x811)));
CheckValue<IkReal> x817 = IKatan2WithCheck(IkReal(x813),IkReal(x814),IKFAST_ATAN2_MAGTHRESH);
if(!x817.valid){
continue;
}
IkReal x815=((1.0)*(x817.value));
if((((x814*x814)+(x813*x813))) < -0.00001)
continue;
CheckValue<IkReal> x818=IKPowWithIntegerCheck(IKabs(IKsqrt(((x814*x814)+(x813*x813)))),-1);
if(!x818.valid){
continue;
}
if( (((-1.0)*(x818.value)*(((((-1.0)*r20*sj12*x812))+(((-1.0)*cj12*r21*x812)))))) < -1-IKFAST_SINCOS_THRESH || (((-1.0)*(x818.value)*(((((-1.0)*r20*sj12*x812))+(((-1.0)*cj12*r21*x812)))))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x816=((-1.0)*(IKasin(((-1.0)*(x818.value)*(((((-1.0)*r20*sj12*x812))+(((-1.0)*cj12*r21*x812))))))));
j7array[0]=((((-1.0)*x816))+(((-1.0)*x815)));
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
j7array[1]=((3.14159265358979)+(((-1.0)*x815))+(((1.0)*x816)));
sj7array[1]=IKsin(j7array[1]);
cj7array[1]=IKcos(j7array[1]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
if( j7array[1] > IKPI )
{
    j7array[1]-=IK2PI;
}
else if( j7array[1] < -IKPI )
{    j7array[1]+=IK2PI;
}
j7valid[1] = true;
for(int ij7 = 0; ij7 < 2; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 2; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];

{
IkReal j11eval[1];
IkReal x819=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x819);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x819);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=(r02*x819);
rxp2_2=0;
j11eval[0]=((((-1.0)*cj12*r20))+((r21*sj12)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal j11eval[1];
IkReal x820=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x820);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x820);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=(r02*x820);
rxp2_2=0;
j11eval[0]=((((-1.0)*cj12*r00))+((r01*sj12)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal j11eval[1];
IkReal x821=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x821);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x821);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=(r02*x821);
rxp2_2=0;
j11eval[0]=(((r11*sj12))+(((-1.0)*cj12*r10)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(r10))+(IKabs(r11)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j11eval[1];
IkReal x822=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=0;
rxp0_0=0;
rxp0_1=(r00*x822);
rxp0_2=0;
rxp1_0=0;
rxp1_1=(r01*x822);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=0;
rxp2_2=0;
r10=0;
r11=0;
r22=0;
r02=0;
j11eval[0]=((((-1.0)*cj12*r20))+((r21*sj12)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal j11eval[1];
IkReal x823=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=0;
rxp0_0=0;
rxp0_1=(r00*x823);
rxp0_2=0;
rxp1_0=0;
rxp1_1=(r01*x823);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=0;
rxp2_2=0;
r10=0;
r11=0;
r22=0;
r02=0;
j11eval[0]=((((-1.0)*cj12*r00))+((r01*sj12)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal j11eval[1];
IkReal x824=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=0;
rxp0_0=0;
rxp0_1=(r00*x824);
rxp0_2=0;
rxp1_0=0;
rxp1_1=(r01*x824);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=0;
rxp2_2=0;
r10=0;
r11=0;
r22=0;
r02=0;
j11eval[0]=(((pz*r21*sj12))+(((-1.0)*cj12*pz*r20)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x825=((1286000.0)*pz);
CheckValue<IkReal> x826=IKPowWithIntegerCheck((((r21*sj12*x825))+(((-1.0)*cj12*r20*x825))),-1);
if(!x826.valid){
continue;
}
if( IKabs(((-82167.0)*(x826.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.09486780715397)*r12*sj7)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-82167.0)*(x826.value)))+IKsqr(((-1.09486780715397)*r12*sj7))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((-82167.0)*(x826.value)), ((-1.09486780715397)*r12*sj7));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x827=IKcos(j11);
IkReal x828=IKsin(j11);
IkReal x829=(cj12*r20);
IkReal x830=(r01*sj12);
IkReal x831=((0.352)*cj7);
IkReal x832=((1.0)*pz);
IkReal x833=(cj12*r00);
IkReal x834=(r21*sj12);
IkReal x835=((0.352)*sj7);
IkReal x836=((0.3215)*x828);
IkReal x837=((0.3215)*x827);
IkReal x838=((0.643)*pz*x828);
evalcond[0]=(((r12*x835))+x837);
evalcond[1]=(((r12*x837))+x835);
evalcond[2]=((((-1.0)*x832))+((x834*x836))+(((-1.0)*x829*x836)));
evalcond[3]=((0.0410835)+((x834*x838))+(((-1.0)*x829*x838)));
evalcond[4]=((((-1.0)*x833*x836))+((x830*x836))+x831);
evalcond[5]=(((x831*x833))+((pz*x834))+(((-1.0)*x830*x831))+(((-1.0)*x836))+(((-1.0)*x829*x832)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
CheckValue<IkReal> x839=IKPowWithIntegerCheck(((((-40.1875)*cj12*r00))+(((40.1875)*r01*sj12))),-1);
if(!x839.valid){
continue;
}
if( IKabs(((-44.0)*cj7*(x839.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.09486780715397)*r12*sj7)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-44.0)*cj7*(x839.value)))+IKsqr(((-1.09486780715397)*r12*sj7))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((-44.0)*cj7*(x839.value)), ((-1.09486780715397)*r12*sj7));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x840=IKcos(j11);
IkReal x841=IKsin(j11);
IkReal x842=(cj12*r20);
IkReal x843=(r01*sj12);
IkReal x844=((0.352)*cj7);
IkReal x845=((1.0)*pz);
IkReal x846=(cj12*r00);
IkReal x847=(r21*sj12);
IkReal x848=((0.352)*sj7);
IkReal x849=((0.3215)*x841);
IkReal x850=((0.3215)*x840);
IkReal x851=((0.643)*pz*x841);
evalcond[0]=(((r12*x848))+x850);
evalcond[1]=(((r12*x850))+x848);
evalcond[2]=((((-1.0)*x842*x849))+(((-1.0)*x845))+((x847*x849)));
evalcond[3]=((0.0410835)+(((-1.0)*x842*x851))+((x847*x851)));
evalcond[4]=(((x843*x849))+(((-1.0)*x846*x849))+x844);
evalcond[5]=((((-1.0)*x842*x845))+((pz*x847))+(((-1.0)*x843*x844))+(((-1.0)*x849))+((x844*x846)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
CheckValue<IkReal> x852=IKPowWithIntegerCheck(((((-0.3215)*cj12*r20))+(((0.3215)*r21*sj12))),-1);
if(!x852.valid){
continue;
}
if( IKabs((pz*(x852.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.09486780715397)*r12*sj7)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((pz*(x852.value)))+IKsqr(((-1.09486780715397)*r12*sj7))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2((pz*(x852.value)), ((-1.09486780715397)*r12*sj7));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x853=IKcos(j11);
IkReal x854=IKsin(j11);
IkReal x855=(cj12*r20);
IkReal x856=(r01*sj12);
IkReal x857=((0.352)*cj7);
IkReal x858=((1.0)*pz);
IkReal x859=(cj12*r00);
IkReal x860=(r21*sj12);
IkReal x861=((0.352)*sj7);
IkReal x862=((0.3215)*x854);
IkReal x863=((0.3215)*x853);
IkReal x864=((0.643)*pz*x854);
evalcond[0]=(((r12*x861))+x863);
evalcond[1]=(((r12*x863))+x861);
evalcond[2]=((((-1.0)*x858))+((x860*x862))+(((-1.0)*x855*x862)));
evalcond[3]=((0.0410835)+((x860*x864))+(((-1.0)*x855*x864)));
evalcond[4]=(((x856*x862))+(((-1.0)*x859*x862))+x857);
evalcond[5]=((((-1.0)*x862))+(((-1.0)*x856*x857))+(((-1.0)*x855*x858))+((pz*x860))+((x857*x859)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(r21))+(IKabs(r20)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j11eval[1];
IkReal x865=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=0;
npy=0;
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x865);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x865);
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
r20=0;
r21=0;
r02=0;
r12=0;
j11eval[0]=((((-1.0)*cj12*r00))+((r01*sj12)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal j11eval[1];
IkReal x866=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=0;
npy=0;
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x866);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x866);
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
r20=0;
r21=0;
r02=0;
r12=0;
j11eval[0]=(((r11*sj12))+(((-1.0)*cj12*r10)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal j11eval[3];
IkReal x867=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=0;
npy=0;
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x867);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x867);
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
r20=0;
r21=0;
r02=0;
r12=0;
j11eval[0]=((((-1.0)*cj12*r00))+((r01*sj12)));
j11eval[1]=pz;
j11eval[2]=r22;
if( IKabs(j11eval[0]) < 0.0000010000000000  || IKabs(j11eval[1]) < 0.0000010000000000  || IKabs(j11eval[2]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
CheckValue<IkReal> x868=IKPowWithIntegerCheck(((((-40.1875)*cj12*r00))+(((40.1875)*r01*sj12))),-1);
if(!x868.valid){
continue;
}
CheckValue<IkReal> x869=IKPowWithIntegerCheck(pz,-1);
if(!x869.valid){
continue;
}
CheckValue<IkReal> x870=IKPowWithIntegerCheck(r22,-1);
if(!x870.valid){
continue;
}
if( IKabs(((-44.0)*cj7*(x868.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.063893468118196)*(x869.value)*(x870.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-44.0)*cj7*(x868.value)))+IKsqr(((-0.063893468118196)*(x869.value)*(x870.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((-44.0)*cj7*(x868.value)), ((-0.063893468118196)*(x869.value)*(x870.value)));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x871=IKcos(j11);
IkReal x872=IKsin(j11);
IkReal x873=((0.352)*sj7);
IkReal x874=(cj12*r10);
IkReal x875=(r01*sj12);
IkReal x876=(r11*sj12);
IkReal x877=((1.0)*pz);
IkReal x878=((0.352)*cj7);
IkReal x879=(cj12*r00);
IkReal x880=((0.3215)*x872);
IkReal x881=(r22*x871);
evalcond[0]=((0.0410835)+(((0.643)*pz*x881)));
evalcond[1]=((((0.3215)*x871))+(((-1.0)*r22*x877)));
evalcond[2]=((((0.3215)*x881))+(((-1.0)*x877)));
evalcond[3]=((((-1.0)*x879*x880))+((x875*x880))+x878);
evalcond[4]=(((x876*x880))+x873+(((-1.0)*x874*x880)));
evalcond[5]=(((x878*x879))+((x873*x874))+(((-1.0)*x873*x876))+(((-1.0)*x880))+(((-1.0)*x875*x878)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
CheckValue<IkReal> x882=IKPowWithIntegerCheck(((((40.1875)*r11*sj12))+(((-40.1875)*cj12*r10))),-1);
if(!x882.valid){
continue;
}
if( IKabs(((-44.0)*sj7*(x882.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((3.1104199066874)*pz*r22)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-44.0)*sj7*(x882.value)))+IKsqr(((3.1104199066874)*pz*r22))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((-44.0)*sj7*(x882.value)), ((3.1104199066874)*pz*r22));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x883=IKcos(j11);
IkReal x884=IKsin(j11);
IkReal x885=((0.352)*sj7);
IkReal x886=(cj12*r10);
IkReal x887=(r01*sj12);
IkReal x888=(r11*sj12);
IkReal x889=((1.0)*pz);
IkReal x890=((0.352)*cj7);
IkReal x891=(cj12*r00);
IkReal x892=((0.3215)*x884);
IkReal x893=(r22*x883);
evalcond[0]=((0.0410835)+(((0.643)*pz*x893)));
evalcond[1]=((((0.3215)*x883))+(((-1.0)*r22*x889)));
evalcond[2]=((((0.3215)*x893))+(((-1.0)*x889)));
evalcond[3]=(x890+(((-1.0)*x891*x892))+((x887*x892)));
evalcond[4]=(x885+((x888*x892))+(((-1.0)*x886*x892)));
evalcond[5]=((((-1.0)*x892))+((x890*x891))+(((-1.0)*x885*x888))+((x885*x886))+(((-1.0)*x887*x890)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
CheckValue<IkReal> x894=IKPowWithIntegerCheck(((((-40.1875)*cj12*r00))+(((40.1875)*r01*sj12))),-1);
if(!x894.valid){
continue;
}
if( IKabs(((-44.0)*cj7*(x894.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((3.1104199066874)*pz*r22)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-44.0)*cj7*(x894.value)))+IKsqr(((3.1104199066874)*pz*r22))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((-44.0)*cj7*(x894.value)), ((3.1104199066874)*pz*r22));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x895=IKcos(j11);
IkReal x896=IKsin(j11);
IkReal x897=((0.352)*sj7);
IkReal x898=(cj12*r10);
IkReal x899=(r01*sj12);
IkReal x900=(r11*sj12);
IkReal x901=((1.0)*pz);
IkReal x902=((0.352)*cj7);
IkReal x903=(cj12*r00);
IkReal x904=((0.3215)*x896);
IkReal x905=(r22*x895);
evalcond[0]=((0.0410835)+(((0.643)*pz*x905)));
evalcond[1]=((((-1.0)*r22*x901))+(((0.3215)*x895)));
evalcond[2]=((((0.3215)*x905))+(((-1.0)*x901)));
evalcond[3]=((((-1.0)*x903*x904))+((x899*x904))+x902);
evalcond[4]=(((x900*x904))+(((-1.0)*x898*x904))+x897);
evalcond[5]=((((-1.0)*x897*x900))+(((-1.0)*x904))+((x902*x903))+((x897*x898))+(((-1.0)*x899*x902)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j11]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x906=((44.0)*sj7);
IkReal x907=(pz*r22);
IkReal x908=(cj7*r02);
CheckValue<IkReal> x909=IKPowWithIntegerCheck(((((40.1875)*r11*sj12))+(((-40.1875)*cj12*r10))),-1);
if(!x909.valid){
continue;
}
if( IKabs(((x909.value)*(((((44.0)*r12*x908))+(((-1.0)*x906))+(((-125.0)*r12*x907))+((x906*(r12*r12))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.09486780715397)*x908))+(((3.1104199066874)*x907))+(((-1.09486780715397)*r12*sj7)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x909.value)*(((((44.0)*r12*x908))+(((-1.0)*x906))+(((-125.0)*r12*x907))+((x906*(r12*r12)))))))+IKsqr(((((-1.09486780715397)*x908))+(((3.1104199066874)*x907))+(((-1.09486780715397)*r12*sj7))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x909.value)*(((((44.0)*r12*x908))+(((-1.0)*x906))+(((-125.0)*r12*x907))+((x906*(r12*r12)))))), ((((-1.09486780715397)*x908))+(((3.1104199066874)*x907))+(((-1.09486780715397)*r12*sj7))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x910=IKcos(j11);
IkReal x911=IKsin(j11);
IkReal x912=((0.643)*pz);
IkReal x913=((0.352)*sj7);
IkReal x914=(cj12*r10);
IkReal x915=((0.352)*cj7);
IkReal x916=(cj12*r00);
IkReal x917=((1.0)*pz);
IkReal x918=(cj12*r20);
IkReal x919=(sj12*x911);
IkReal x920=((0.3215)*x910);
IkReal x921=((0.3215)*x911);
evalcond[0]=((((-1.0)*r22*x917))+((r12*x913))+((r02*x915))+x920);
evalcond[1]=(((r22*x920))+(((-1.0)*x917))+(((-1.0)*x918*x921))+(((0.3215)*r21*x919)));
evalcond[2]=((((0.3215)*r01*x919))+(((-1.0)*x916*x921))+x915+((r02*x920)));
evalcond[3]=((((0.3215)*r11*x919))+(((-1.0)*x914*x921))+((r12*x920))+x913);
evalcond[4]=((0.0410835)+(((-1.0)*x911*x912*x918))+((r22*x910*x912))+((r21*x912*x919)));
evalcond[5]=((((-1.0)*x921))+((pz*r21*sj12))+(((-1.0)*r01*sj12*x915))+((x915*x916))+(((-1.0)*r11*sj12*x913))+((x913*x914))+(((-1.0)*x917*x918)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x922=(pz*r22);
IkReal x923=(r12*sj7);
IkReal x924=((44.0)*cj7);
CheckValue<IkReal> x925=IKPowWithIntegerCheck(((((-40.1875)*cj12*r00))+(((40.1875)*r01*sj12))),-1);
if(!x925.valid){
continue;
}
if( IKabs(((x925.value)*(((((-1.0)*x924))+(((44.0)*r02*x923))+((x924*(r02*r02)))+(((-125.0)*r02*x922)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.09486780715397)*x923))+(((-1.09486780715397)*cj7*r02))+(((3.1104199066874)*x922)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x925.value)*(((((-1.0)*x924))+(((44.0)*r02*x923))+((x924*(r02*r02)))+(((-125.0)*r02*x922))))))+IKsqr(((((-1.09486780715397)*x923))+(((-1.09486780715397)*cj7*r02))+(((3.1104199066874)*x922))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x925.value)*(((((-1.0)*x924))+(((44.0)*r02*x923))+((x924*(r02*r02)))+(((-125.0)*r02*x922))))), ((((-1.09486780715397)*x923))+(((-1.09486780715397)*cj7*r02))+(((3.1104199066874)*x922))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x926=IKcos(j11);
IkReal x927=IKsin(j11);
IkReal x928=((0.643)*pz);
IkReal x929=((0.352)*sj7);
IkReal x930=(cj12*r10);
IkReal x931=((0.352)*cj7);
IkReal x932=(cj12*r00);
IkReal x933=((1.0)*pz);
IkReal x934=(cj12*r20);
IkReal x935=(sj12*x927);
IkReal x936=((0.3215)*x926);
IkReal x937=((0.3215)*x927);
evalcond[0]=((((-1.0)*r22*x933))+((r12*x929))+x936+((r02*x931)));
evalcond[1]=(((r22*x936))+(((0.3215)*r21*x935))+(((-1.0)*x934*x937))+(((-1.0)*x933)));
evalcond[2]=((((-1.0)*x932*x937))+(((0.3215)*r01*x935))+x931+((r02*x936)));
evalcond[3]=((((-1.0)*x930*x937))+((r12*x936))+x929+(((0.3215)*r11*x935)));
evalcond[4]=((0.0410835)+((r21*x928*x935))+((r22*x926*x928))+(((-1.0)*x927*x928*x934)));
evalcond[5]=(((pz*r21*sj12))+(((-1.0)*r11*sj12*x929))+((x931*x932))+(((-1.0)*r01*sj12*x931))+(((-1.0)*x933*x934))+((x929*x930))+(((-1.0)*x937)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x938=((0.352)*r22);
IkReal x939=(r12*sj7);
IkReal x940=(cj7*r02);
CheckValue<IkReal> x941=IKPowWithIntegerCheck(((((-0.3215)*cj12*r20))+(((0.3215)*r21*sj12))),-1);
if(!x941.valid){
continue;
}
if( IKabs(((x941.value)*((((x938*x940))+(((-1.0)*pz*(r22*r22)))+pz+((x938*x939)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.09486780715397)*x940))+(((-1.09486780715397)*x939))+(((3.1104199066874)*pz*r22)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x941.value)*((((x938*x940))+(((-1.0)*pz*(r22*r22)))+pz+((x938*x939))))))+IKsqr(((((-1.09486780715397)*x940))+(((-1.09486780715397)*x939))+(((3.1104199066874)*pz*r22))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x941.value)*((((x938*x940))+(((-1.0)*pz*(r22*r22)))+pz+((x938*x939))))), ((((-1.09486780715397)*x940))+(((-1.09486780715397)*x939))+(((3.1104199066874)*pz*r22))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x942=IKcos(j11);
IkReal x943=IKsin(j11);
IkReal x944=((0.643)*pz);
IkReal x945=((0.352)*sj7);
IkReal x946=(cj12*r10);
IkReal x947=((0.352)*cj7);
IkReal x948=(cj12*r00);
IkReal x949=((1.0)*pz);
IkReal x950=(cj12*r20);
IkReal x951=(sj12*x943);
IkReal x952=((0.3215)*x942);
IkReal x953=((0.3215)*x943);
evalcond[0]=(((r02*x947))+((r12*x945))+(((-1.0)*r22*x949))+x952);
evalcond[1]=((((0.3215)*r21*x951))+((r22*x952))+(((-1.0)*x949))+(((-1.0)*x950*x953)));
evalcond[2]=(((r02*x952))+(((0.3215)*r01*x951))+x947+(((-1.0)*x948*x953)));
evalcond[3]=((((0.3215)*r11*x951))+(((-1.0)*x946*x953))+((r12*x952))+x945);
evalcond[4]=((0.0410835)+(((-1.0)*x943*x944*x950))+((r21*x944*x951))+((r22*x942*x944)));
evalcond[5]=(((pz*r21*sj12))+((x945*x946))+((x947*x948))+(((-1.0)*x949*x950))+(((-1.0)*r01*sj12*x947))+(((-1.0)*x953))+(((-1.0)*r11*sj12*x945)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}

} else
{
{
IkReal j11array[2], cj11array[2], sj11array[2];
bool j11valid[2]={false};
_nj11 = 2;
IkReal x954=((0.643)*pz);
IkReal x955=(((r21*sj12*x954))+(((-1.0)*cj12*r20*x954)));
CheckValue<IkReal> x958 = IKatan2WithCheck(IkReal((r22*x954)),IkReal(x955),IKFAST_ATAN2_MAGTHRESH);
if(!x958.valid){
continue;
}
IkReal x956=((1.0)*(x958.value));
if((((x955*x955)+(((0.413449)*(pz*pz)*(r22*r22))))) < -0.00001)
continue;
CheckValue<IkReal> x959=IKPowWithIntegerCheck(IKabs(IKsqrt(((x955*x955)+(((0.413449)*(pz*pz)*(r22*r22)))))),-1);
if(!x959.valid){
continue;
}
if( (((0.0410835)*(x959.value))) < -1-IKFAST_SINCOS_THRESH || (((0.0410835)*(x959.value))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x957=IKasin(((0.0410835)*(x959.value)));
j11array[0]=((((-1.0)*x957))+(((-1.0)*x956)));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
j11array[1]=((3.14159265358979)+(((-1.0)*x956))+x957);
sj11array[1]=IKsin(j11array[1]);
cj11array[1]=IKcos(j11array[1]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
if( j11array[1] > IKPI )
{
    j11array[1]-=IK2PI;
}
else if( j11array[1] < -IKPI )
{    j11array[1]+=IK2PI;
}
j11valid[1] = true;
for(int ij11 = 0; ij11 < 2; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 2; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[1];
IkReal x960=IKsin(j11);
IkReal x961=((0.3215)*x960);
evalcond[0]=((((-1.0)*pz))+((r21*sj12*x961))+(((-1.0)*cj12*r20*x961))+(((0.3215)*r22*(IKcos(j11)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j7array[1], cj7array[1], sj7array[1];
bool j7valid[1]={false};
_nj7 = 1;
IkReal x962=((0.913352272727273)*cj11);
IkReal x963=((0.913352272727273)*cj12*sj11);
IkReal x964=((0.913352272727273)*sj11*sj12);
if( IKabs(((((-1.0)*r12*x962))+(((-1.0)*r11*x964))+((r10*x963)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*r01*x964))+((r00*x963))+(((-1.0)*r02*x962)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*r12*x962))+(((-1.0)*r11*x964))+((r10*x963))))+IKsqr(((((-1.0)*r01*x964))+((r00*x963))+(((-1.0)*r02*x962))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j7array[0]=IKatan2(((((-1.0)*r12*x962))+(((-1.0)*r11*x964))+((r10*x963))), ((((-1.0)*r01*x964))+((r00*x963))+(((-1.0)*r02*x962))));
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
for(int ij7 = 0; ij7 < 1; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 1; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];
{
IkReal evalcond[5];
IkReal x965=IKcos(j7);
IkReal x966=IKsin(j7);
IkReal x967=(cj12*r00);
IkReal x968=(r11*sj12);
IkReal x969=(r01*sj12);
IkReal x970=(cj12*r10);
IkReal x971=((0.3215)*sj11);
IkReal x972=((0.3215)*cj11);
IkReal x973=((1.0)*pz);
IkReal x974=((0.352)*x965);
IkReal x975=((0.352)*x966);
IkReal x976=(cj12*x973);
evalcond[0]=(((r12*x975))+((r02*x974))+x972+(((-1.0)*r22*x973)));
evalcond[1]=(((x969*x971))+(((-1.0)*x967*x971))+((r02*x972))+x974);
evalcond[2]=(((x968*x971))+(((-1.0)*x970*x971))+((r12*x972))+x975);
evalcond[3]=(((r10*sj12*x975))+((cj12*r01*x974))+((r00*sj12*x974))+(((-1.0)*r20*sj12*x973))+(((-1.0)*r21*x976))+((cj12*r11*x975)));
evalcond[4]=((((-1.0)*r20*x976))+((pz*r21*sj12))+(((-1.0)*x969*x974))+((x967*x974))+((x970*x975))+(((-1.0)*x968*x975))+(((-1.0)*x971)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}
}
}

}

}

} else
{
{
IkReal j11array[2], cj11array[2], sj11array[2];
bool j11valid[2]={false};
_nj11 = 2;
IkReal x977=((((-0.3215)*cj12*r20))+(((0.3215)*r21*sj12)));
CheckValue<IkReal> x980 = IKatan2WithCheck(IkReal(((0.3215)*r22)),IkReal(x977),IKFAST_ATAN2_MAGTHRESH);
if(!x980.valid){
continue;
}
IkReal x978=((1.0)*(x980.value));
if((((((0.10336225)*(r22*r22)))+(x977*x977))) < -0.00001)
continue;
CheckValue<IkReal> x981=IKPowWithIntegerCheck(IKabs(IKsqrt(((((0.10336225)*(r22*r22)))+(x977*x977)))),-1);
if(!x981.valid){
continue;
}
if( ((pz*(x981.value))) < -1-IKFAST_SINCOS_THRESH || ((pz*(x981.value))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x979=IKasin((pz*(x981.value)));
j11array[0]=(x979+(((-1.0)*x978)));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
j11array[1]=((3.14159265358979)+(((-1.0)*x979))+(((-1.0)*x978)));
sj11array[1]=IKsin(j11array[1]);
cj11array[1]=IKcos(j11array[1]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
if( j11array[1] > IKPI )
{
    j11array[1]-=IK2PI;
}
else if( j11array[1] < -IKPI )
{    j11array[1]+=IK2PI;
}
j11valid[1] = true;
for(int ij11 = 0; ij11 < 2; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 2; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[1];
IkReal x982=IKsin(j11);
IkReal x983=((0.643)*pz);
evalcond[0]=((0.0410835)+((r21*sj12*x982*x983))+(((-1.0)*cj12*r20*x982*x983))+((r22*x983*(IKcos(j11)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j7array[1], cj7array[1], sj7array[1];
bool j7valid[1]={false};
_nj7 = 1;
IkReal x984=((0.913352272727273)*cj11);
IkReal x985=((0.913352272727273)*cj12*sj11);
IkReal x986=((0.913352272727273)*sj11*sj12);
if( IKabs((((r10*x985))+(((-1.0)*r12*x984))+(((-1.0)*r11*x986)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*r01*x986))+((r00*x985))+(((-1.0)*r02*x984)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((r10*x985))+(((-1.0)*r12*x984))+(((-1.0)*r11*x986))))+IKsqr(((((-1.0)*r01*x986))+((r00*x985))+(((-1.0)*r02*x984))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j7array[0]=IKatan2((((r10*x985))+(((-1.0)*r12*x984))+(((-1.0)*r11*x986))), ((((-1.0)*r01*x986))+((r00*x985))+(((-1.0)*r02*x984))));
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
for(int ij7 = 0; ij7 < 1; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 1; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];
{
IkReal evalcond[5];
IkReal x987=IKcos(j7);
IkReal x988=IKsin(j7);
IkReal x989=(cj12*r00);
IkReal x990=(r11*sj12);
IkReal x991=(r01*sj12);
IkReal x992=(cj12*r10);
IkReal x993=((0.3215)*sj11);
IkReal x994=((0.3215)*cj11);
IkReal x995=((1.0)*pz);
IkReal x996=((0.352)*x987);
IkReal x997=((0.352)*x988);
IkReal x998=(cj12*x995);
evalcond[0]=((((-1.0)*r22*x995))+((r12*x997))+((r02*x996))+x994);
evalcond[1]=(((x991*x993))+((r02*x994))+(((-1.0)*x989*x993))+x996);
evalcond[2]=(((r12*x994))+(((-1.0)*x992*x993))+((x990*x993))+x997);
evalcond[3]=(((r00*sj12*x996))+(((-1.0)*r20*sj12*x995))+((r10*sj12*x997))+((cj12*r11*x997))+((cj12*r01*x996))+(((-1.0)*r21*x998)));
evalcond[4]=(((x989*x996))+((pz*r21*sj12))+((x992*x997))+(((-1.0)*x991*x996))+(((-1.0)*x990*x997))+(((-1.0)*x993))+(((-1.0)*r20*x998)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}
}
}

}

}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(px))+(IKabs(py)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j12eval[1];
IkReal x999=((1.0)*pz);
IkReal x1000=((0.3215)*r22);
IkReal x1001=(pz*r22);
IkReal x1002=((0.643)*x1001);
IkReal x1003=((0.0410835)+(((-1.0)*x1002)));
IkReal x1004=(x1000+(((-1.0)*x999)));
IkReal x1005=((-1.0)*pz);
IkReal x1006=((0.0410835)+x1002);
IkReal x1007=((((-1.0)*x1000))+(((-1.0)*x999)));
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=x1001;
rxp0_0=(pz*r10);
rxp0_1=(r00*x1005);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x1005);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=(r02*x1005);
rxp2_2=0;
IkReal gconst32=x1006;
IkReal gconst33=x1003;
IkReal gconst34=x1004;
IkReal gconst35=x1007;
IkReal gconst36=x1006;
IkReal gconst37=x1003;
IkReal gconst38=x1004;
IkReal gconst39=x1007;
IkReal gconst40=x1006;
IkReal gconst41=x1003;
IkReal gconst42=x1004;
IkReal gconst43=x1007;
IkReal gconst44=x1006;
IkReal gconst45=x1003;
IkReal gconst46=x1004;
IkReal gconst47=x1007;
IkReal x1008=r21*r21;
IkReal x1009=pz*pz;
IkReal x1010=pz*pz*pz*pz;
IkReal x1011=r22*r22;
IkReal x1012=r20*r20;
IkReal x1013=(r20*r21);
IkReal x1014=((0.271774911864)*x1009);
IkReal x1015=((6.615184)*x1010);
IkReal x1016=(x1009*x1012);
IkReal x1017=(x1010*x1011);
IkReal x1018=(x1010*x1012);
IkReal x1019=(x1009*x1011);
IkReal x1020=(((x1013*x1014))+((x1013*x1015))+(((0.00279136614789116)*x1013)));
j12eval[0]=((IKabs(((((-0.00279136614789116)*x1011))+(((-0.00279136614789116)*x1008))+(((-1.0)*x1011*x1015))+(((-1.0)*x1011*x1014))+(((-1.0)*x1008*x1014))+(((-1.0)*x1008*x1015)))))+(((0.5)*(IKabs(((((-0.543549823728)*x1008*x1009))+(((-0.00418704922183674)*x1011))+(((-9.922776)*x1017))+(((-0.00558273229578232)*x1008))+(((0.135887455932)*x1016))+(((3.307592)*x1018))+(((-13.230368)*x1008*x1010))+(((-0.407662367796)*x1019))+(((0.00139568307394558)*x1012)))))))+(((0.5)*(IKabs(((((-0.00069784153697279)*x1012))+(((-0.00069784153697279)*x1011))+(((-0.067943727966)*x1019))+(((-0.067943727966)*x1016))+(((-1.653796)*x1018))+(((-1.653796)*x1017)))))))+(((2.0)*(IKabs(x1020)))));
if( IKabs(j12eval[0]) < 0.0000000010000000  )
{
continue; // no branches [j7, j11, j12]

} else
{
IkReal op[8+1], zeror[8];
int numroots;
IkReal x1021=r20*r20;
IkReal x1022=pz*pz;
IkReal x1023=r21*r21;
IkReal x1024=(r20*r21);
IkReal x1025=(gconst41*gconst44);
IkReal x1026=(gconst32*gconst36);
IkReal x1027=((3.307592)*gconst43);
IkReal x1028=(gconst34*gconst39);
IkReal x1029=(gconst33*gconst36);
IkReal x1030=(gconst35*gconst40);
IkReal x1031=(gconst45*gconst46);
IkReal x1032=(gconst40*gconst44);
IkReal x1033=(gconst33*gconst46);
IkReal x1034=((1.0)*gconst36);
IkReal x1035=((1.653796)*gconst35);
IkReal x1036=(gconst37*gconst38);
IkReal x1037=(gconst32*gconst43);
IkReal x1038=((0.826898)*gconst41);
IkReal x1039=(gconst35*gconst36);
IkReal x1040=(gconst39*gconst42);
IkReal x1041=((1.0)*gconst42);
IkReal x1042=(gconst37*gconst46);
IkReal x1043=(gconst36*gconst43);
IkReal x1044=((1.0)*gconst34);
IkReal x1045=(gconst38*gconst41);
IkReal x1046=(gconst33*gconst38);
IkReal x1047=(gconst32*gconst35);
IkReal x1048=((1.0)*gconst39);
IkReal x1049=(gconst38*gconst45);
IkReal x1050=(gconst40*gconst43);
IkReal x1051=(gconst33*gconst44);
IkReal x1052=(gconst34*gconst47);
IkReal x1053=((1.0)*gconst47);
IkReal x1054=(gconst36*gconst41);
IkReal x1055=(gconst35*gconst44);
IkReal x1056=((1.653796)*gconst43);
IkReal x1057=(gconst41*gconst46);
IkReal x1058=((3.307592)*gconst35);
IkReal x1059=(gconst42*gconst47);
IkReal x1060=((1.653796)*x1023);
IkReal x1061=(gconst33*x1059);
IkReal x1062=(gconst43*x1048);
IkReal x1063=(pz*x1021);
IkReal x1064=(gconst36*x1021);
IkReal x1065=((0.826898)*x1021);
IkReal x1066=(gconst46*x1022);
IkReal x1067=((6.615184)*x1023);
IkReal x1068=((0.413449)*x1021);
IkReal x1069=(pz*x1023);
IkReal x1070=((3.307592)*x1069);
IkReal x1071=(x1025*x1068);
IkReal x1072=(x1051*x1068);
IkReal x1073=(x1054*x1068);
IkReal x1074=(x1029*x1068);
IkReal x1075=(gconst38*x1021*x1022);
IkReal x1076=(gconst46*x1038*x1063);
IkReal x1077=((0.826898)*gconst43*gconst44*x1063);
IkReal x1078=(gconst38*x1038*x1063);
IkReal x1079=((0.826898)*x1043*x1063);
IkReal x1080=((0.826898)*x1033*x1063);
IkReal x1081=((0.826898)*x1055*x1063);
IkReal x1082=((0.826898)*x1039*x1063);
IkReal x1083=((0.826898)*x1046*x1063);
IkReal x1084=(gconst38*x1022*x1067);
IkReal x1085=(x1021*x1056*x1066);
IkReal x1086=(x1056*x1075);
IkReal x1087=(x1021*x1035*x1066);
IkReal x1088=(x1035*x1075);
IkReal x1089=(x1076+x1077);
IkReal x1090=(x1083+x1082);
IkReal x1091=(x1071+x1085);
IkReal x1092=(x1074+x1088);
IkReal x1093=((((-0.271774911864)*x1022*x1024))+(((-6.615184)*x1024*(x1022*x1022)))+(((-0.00279136614789116)*x1024)));
IkReal x1094=((((0.271774911864)*x1022*x1024))+(((0.00279136614789116)*x1024))+(((6.615184)*x1024*(x1022*x1022))));
IkReal x1095=(x1078+x1079+x1081+x1080);
IkReal x1096=(x1072+x1073+x1087+x1086);
op[0]=(x1089+(((-1.0)*gconst41*x1031*x1041))+((x1025*x1059))+(((-1.0)*x1091))+(((-1.0)*gconst43*x1032*x1053))+((x1031*x1050)));
op[1]=x1093;
op[2]=(((x1031*x1037))+((x1030*x1031))+((x1054*x1059))+x1095+(((-1.653796)*x1057*x1063))+(((-1.0)*gconst45*x1041*x1045))+(((-1.0)*gconst43*x1066*x1067))+((gconst44*x1027*x1069))+((x1042*x1050))+(((-1.0)*gconst33*x1031*x1041))+(((-1.0)*gconst41*x1031*x1044))+((x1025*x1052))+(((-1.0)*gconst44*x1056*x1063))+((x1025*x1040))+(((-1.0)*x1096))+(((-1.0)*x1025*x1060))+((x1025*x1065))+(((-1.0)*gconst44*x1030*x1053))+((x1057*x1070))+((x1051*x1059))+(((-1.0)*gconst47*x1034*x1050))+((x1021*x1027*x1066))+(((-1.0)*gconst41*x1041*x1042))+((x1049*x1050))+(((-1.0)*x1032*x1062))+(((-1.0)*gconst44*x1037*x1053)));
op[3]=x1093;
op[4]=((((-1.0)*gconst44*x1037*x1048))+((x1055*x1070))+((x1033*x1070))+(((-1.0)*gconst43*x1026*x1053))+(((-1.653796)*x1043*x1063))+x1090+x1089+(((-1.0)*gconst47*x1030*x1034))+(((-1.0)*gconst45*x1041*x1046))+((x1021*x1058*x1066))+((x1037*x1042))+((x1037*x1049))+(((-1.0)*gconst44*x1035*x1063))+(((-1.0)*gconst33*x1031*x1044))+((x1038*x1064))+(((-1.0)*gconst39*x1034*x1050))+((x1051*x1065))+((x1040*x1054))+((x1040*x1051))+(((-1.0)*gconst43*x1084))+((gconst36*x1027*x1069))+(((-1.0)*x1091))+(((-1.0)*x1092))+((x1052*x1054))+(((-1.0)*gconst44*x1030*x1048))+(((-1.653796)*x1045*x1063))+(((-1.0)*gconst35*x1066*x1067))+(((-1.0)*gconst41*x1036*x1041))+((x1027*x1075))+((x1031*x1047))+((x1051*x1052))+((x1030*x1042))+((x1030*x1049))+((x1036*x1050))+((x1029*x1059))+(((-1.0)*gconst45*x1044*x1045))+(((-1.0)*gconst44*x1047*x1053))+(((-1.0)*gconst37*x1033*x1041))+((x1025*x1028))+(((-1.0)*x1054*x1060))+((x1045*x1070))+(((-1.0)*x1051*x1060))+(((-1.653796)*x1033*x1063))+(((-1.0)*gconst41*x1042*x1044)));
op[5]=x1094;
op[6]=(((x1036*x1037))+((x1058*x1075))+((x1039*x1070))+((x1030*x1036))+(((-1.653796)*x1046*x1063))+x1095+((x1042*x1047))+(((-1.0)*gconst35*x1026*x1053))+(((-1.0)*x1096))+(((-1.0)*gconst33*x1036*x1041))+(((-1.0)*gconst39*x1030*x1034))+(((-1.0)*gconst35*x1084))+(((-1.0)*gconst41*x1036*x1044))+(((-1.0)*x1029*x1060))+((x1029*x1052))+(((-1.0)*gconst45*x1044*x1046))+((x1046*x1070))+((x1028*x1051))+((x1028*x1054))+(((-1.0)*gconst37*x1033*x1044))+((x1047*x1049))+((x1029*x1040))+(((-1.0)*gconst44*x1047*x1048))+(((-1.0)*gconst36*x1035*x1063))+((x1029*x1065))+(((-1.0)*x1026*x1062)));
op[7]=x1094;
op[8]=(x1090+((x1028*x1029))+(((-1.0)*x1092))+(((-1.0)*gconst33*x1036*x1044))+(((-1.0)*gconst35*x1026*x1048))+((x1036*x1047)));
polyroots8(op,zeror,numroots);
IkReal j12array[8], cj12array[8], sj12array[8], tempj12array[1];
int numsolutions = 0;
for(int ij12 = 0; ij12 < numroots; ++ij12)
{
IkReal htj12 = zeror[ij12];
tempj12array[0]=((2.0)*(atan(htj12)));
for(int kj12 = 0; kj12 < 1; ++kj12)
{
j12array[numsolutions] = tempj12array[kj12];
if( j12array[numsolutions] > IKPI )
{
    j12array[numsolutions]-=IK2PI;
}
else if( j12array[numsolutions] < -IKPI )
{
    j12array[numsolutions]+=IK2PI;
}
sj12array[numsolutions] = IKsin(j12array[numsolutions]);
cj12array[numsolutions] = IKcos(j12array[numsolutions]);
numsolutions++;
}
}
bool j12valid[8]={true,true,true,true,true,true,true,true};
_nj12 = 8;
for(int ij12 = 0; ij12 < numsolutions; ++ij12)
    {
if( !j12valid[ij12] )
{
    continue;
}
    j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
htj12 = IKtan(j12/2);

_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < numsolutions; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
{
IkReal j11eval[2];
IkReal x1097=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x1097);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x1097);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=(r02*x1097);
rxp2_2=0;
IkReal x1098=(cj12*r20);
IkReal x1099=(r21*sj12);
j11eval[0]=((r22*r22)+(x1098*x1098)+(x1099*x1099)+(((-2.0)*x1098*x1099)));
j11eval[1]=((IKabs(r22))+(((3.1104199066874)*(IKabs(((((0.3215)*x1099))+(((-0.3215)*x1098))))))));
if( IKabs(j11eval[0]) < 0.0000010000000000  || IKabs(j11eval[1]) < 0.0000010000000000  )
{
{
IkReal j11eval[2];
IkReal x1100=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x1100);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x1100);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=(r02*x1100);
rxp2_2=0;
IkReal x1101=pz*pz;
IkReal x1102=(r21*sj12);
IkReal x1103=(cj12*r20);
j11eval[0]=((IKabs((pz*r22)))+(IKabs((((pz*x1102))+(((-1.0)*pz*x1103))))));
j11eval[1]=(((x1101*(x1103*x1103)))+((x1101*(x1102*x1102)))+(((-2.0)*x1101*x1102*x1103))+((x1101*(r22*r22))));
if( IKabs(j11eval[0]) < 0.0000010000000000  || IKabs(j11eval[1]) < 0.0000010000000000  )
{
{
IkReal j7eval[2];
IkReal x1104=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x1104);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x1104);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=(r02*x1104);
rxp2_2=0;
IkReal x1105=sj12*sj12;
IkReal x1106=cj12*cj12;
IkReal x1107=(r10*sj12);
IkReal x1108=(cj12*r11);
IkReal x1109=(cj12*r01);
IkReal x1110=(r00*sj12);
j7eval[0]=(((x1106*(r11*r11)))+((x1106*(r01*r01)))+((x1105*(r10*r10)))+(((2.0)*x1109*x1110))+(((2.0)*x1107*x1108))+((x1105*(r00*r00))));
j7eval[1]=((IKabs(((((0.352)*x1108))+(((0.352)*x1107)))))+(IKabs(((((0.352)*x1110))+(((0.352)*x1109))))));
if( IKabs(j7eval[0]) < 0.0000010000000000  || IKabs(j7eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(pz);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j11eval[1];
px=0;
py=0;
pp=0;
npx=0;
npy=0;
npz=0;
rxp0_0=0;
rxp0_1=0;
rxp0_2=0;
rxp1_0=0;
rxp1_1=0;
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
pz=0;
j11eval[0]=((((3.1104199066874)*(IKabs(((((-0.3215)*cj12*r20))+(((0.3215)*r21*sj12)))))))+(IKabs(r22)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal j7eval[1];
px=0;
py=0;
pp=0;
npx=0;
npy=0;
npz=0;
rxp0_0=0;
rxp0_1=0;
rxp0_2=0;
rxp1_0=0;
rxp1_1=0;
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
pz=0;
IkReal x1111=((0.352)*sj12);
IkReal x1112=((0.352)*cj12);
j7eval[0]=((IKabs((((r11*x1112))+((r10*x1111)))))+(IKabs((((r01*x1112))+((r00*x1111))))));
if( IKabs(j7eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j7, j11]

} else
{
{
IkReal j7array[2], cj7array[2], sj7array[2];
bool j7valid[2]={false};
_nj7 = 2;
IkReal x1113=((0.352)*cj12);
IkReal x1114=((0.352)*sj12);
CheckValue<IkReal> x1116 = IKatan2WithCheck(IkReal((((r01*x1113))+((r00*x1114)))),IkReal((((r11*x1113))+((r10*x1114)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1116.valid){
continue;
}
IkReal x1115=x1116.value;
j7array[0]=((-1.0)*x1115);
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
j7array[1]=((3.14159265358979)+(((-1.0)*x1115)));
sj7array[1]=IKsin(j7array[1]);
cj7array[1]=IKcos(j7array[1]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
if( j7array[1] > IKPI )
{
    j7array[1]-=IK2PI;
}
else if( j7array[1] < -IKPI )
{    j7array[1]+=IK2PI;
}
j7valid[1] = true;
for(int ij7 = 0; ij7 < 2; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 2; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];

{
IkReal j11eval[1];
px=0;
py=0;
pp=0;
npx=0;
npy=0;
npz=0;
rxp0_0=0;
rxp0_1=0;
rxp0_2=0;
rxp1_0=0;
rxp1_1=0;
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
pz=0;
j11eval[0]=((((-1.0)*cj12*r20))+((r21*sj12)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal j11eval[1];
px=0;
py=0;
pp=0;
npx=0;
npy=0;
npz=0;
rxp0_0=0;
rxp0_1=0;
rxp0_2=0;
rxp1_0=0;
rxp1_1=0;
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
pz=0;
j11eval[0]=((((-1.0)*cj12*r00))+((r01*sj12)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal j11eval[1];
px=0;
py=0;
pp=0;
npx=0;
npy=0;
npz=0;
rxp0_0=0;
rxp0_1=0;
rxp0_2=0;
rxp1_0=0;
rxp1_1=0;
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
pz=0;
j11eval[0]=(((r11*sj12))+(((-1.0)*cj12*r10)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(r10))+(IKabs(r11)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j11array[2], cj11array[2], sj11array[2];
bool j11valid[2]={false};
_nj11 = 2;
cj11array[0]=((-1.09486780715397)*r12*sj7);
if( cj11array[0] >= -1-IKFAST_SINCOS_THRESH && cj11array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j11valid[0] = j11valid[1] = true;
    j11array[0] = IKacos(cj11array[0]);
    sj11array[0] = IKsin(j11array[0]);
    cj11array[1] = cj11array[0];
    j11array[1] = -j11array[0];
    sj11array[1] = -sj11array[0];
}
else if( std::isnan(cj11array[0]) )
{
    // probably any value will work
    j11valid[0] = true;
    cj11array[0] = 1; sj11array[0] = 0; j11array[0] = 0;
}
for(int ij11 = 0; ij11 < 2; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 2; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[4];
IkReal x1117=IKsin(j11);
IkReal x1118=((0.3215)*x1117);
evalcond[0]=((-0.3215)*x1117);
evalcond[1]=((((0.352)*sj7))+(((0.3215)*r12*(IKcos(j11)))));
evalcond[2]=((((-1.0)*cj12*r20*x1118))+((r21*sj12*x1118)));
evalcond[3]=(((r01*sj12*x1118))+(((-1.0)*cj12*r00*x1118)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(r21))+(IKabs(r20)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j11array[2], cj11array[2], sj11array[2];
bool j11valid[2]={false};
_nj11 = 2;
IkReal x1119=((1.09486780715397)*cj12);
IkReal x1120=((1.09486780715397)*sj12);
sj11array[0]=((((-1.0)*r11*sj7*x1120))+((r10*sj7*x1119))+(((-1.0)*cj7*r01*x1120))+((cj7*r00*x1119)));
if( sj11array[0] >= -1-IKFAST_SINCOS_THRESH && sj11array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j11valid[0] = j11valid[1] = true;
    j11array[0] = IKasin(sj11array[0]);
    cj11array[0] = IKcos(j11array[0]);
    sj11array[1] = sj11array[0];
    j11array[1] = j11array[0] > 0 ? (IKPI-j11array[0]) : (-IKPI-j11array[0]);
    cj11array[1] = -cj11array[0];
}
else if( std::isnan(sj11array[0]) )
{
    // probably any value will work
    j11valid[0] = true;
    cj11array[0] = 1; sj11array[0] = 0; j11array[0] = 0;
}
for(int ij11 = 0; ij11 < 2; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 2; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[4];
IkReal x1121=IKcos(j11);
IkReal x1122=IKsin(j11);
IkReal x1123=((0.3215)*x1122);
IkReal x1124=((0.3215)*x1121);
evalcond[0]=x1124;
evalcond[1]=(r22*x1124);
evalcond[2]=((((-1.0)*cj12*r00*x1123))+((r01*sj12*x1123))+(((0.352)*cj7)));
evalcond[3]=((((-1.0)*cj12*r10*x1123))+((r11*sj12*x1123))+(((0.352)*sj7)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j11]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x1125=((44.0)*sj7);
IkReal x1126=(cj7*r02);
CheckValue<IkReal> x1127=IKPowWithIntegerCheck(((((40.1875)*r11*sj12))+(((-40.1875)*cj12*r10))),-1);
if(!x1127.valid){
continue;
}
if( IKabs(((x1127.value)*(((((-1.0)*x1125))+((x1125*(r12*r12)))+(((44.0)*r12*x1126)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.09486780715397)*x1126))+(((-1.09486780715397)*r12*sj7)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1127.value)*(((((-1.0)*x1125))+((x1125*(r12*r12)))+(((44.0)*r12*x1126))))))+IKsqr(((((-1.09486780715397)*x1126))+(((-1.09486780715397)*r12*sj7))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x1127.value)*(((((-1.0)*x1125))+((x1125*(r12*r12)))+(((44.0)*r12*x1126))))), ((((-1.09486780715397)*x1126))+(((-1.09486780715397)*r12*sj7))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[5];
IkReal x1128=IKcos(j11);
IkReal x1129=IKsin(j11);
IkReal x1130=(r01*sj12);
IkReal x1131=((0.352)*cj7);
IkReal x1132=(cj12*r10);
IkReal x1133=(r11*sj12);
IkReal x1134=(cj12*r00);
IkReal x1135=((0.352)*sj7);
IkReal x1136=((0.3215)*x1129);
IkReal x1137=((0.3215)*x1128);
evalcond[0]=(x1137+((r12*x1135))+((r02*x1131)));
evalcond[1]=(((r22*x1137))+((r21*sj12*x1136))+(((-1.0)*cj12*r20*x1136)));
evalcond[2]=(x1131+((x1130*x1136))+(((-1.0)*x1134*x1136))+((r02*x1137)));
evalcond[3]=(x1135+(((-1.0)*x1132*x1136))+((r12*x1137))+((x1133*x1136)));
evalcond[4]=(((x1131*x1134))+(((-1.0)*x1130*x1131))+(((-1.0)*x1136))+(((-1.0)*x1133*x1135))+((x1132*x1135)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x1138=(r12*sj7);
IkReal x1139=((44.0)*cj7);
CheckValue<IkReal> x1140=IKPowWithIntegerCheck(((((-40.1875)*cj12*r00))+(((40.1875)*r01*sj12))),-1);
if(!x1140.valid){
continue;
}
if( IKabs(((x1140.value)*((((x1139*(r02*r02)))+(((44.0)*r02*x1138))+(((-1.0)*x1139)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.09486780715397)*x1138))+(((-1.09486780715397)*cj7*r02)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1140.value)*((((x1139*(r02*r02)))+(((44.0)*r02*x1138))+(((-1.0)*x1139))))))+IKsqr(((((-1.09486780715397)*x1138))+(((-1.09486780715397)*cj7*r02))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x1140.value)*((((x1139*(r02*r02)))+(((44.0)*r02*x1138))+(((-1.0)*x1139))))), ((((-1.09486780715397)*x1138))+(((-1.09486780715397)*cj7*r02))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[5];
IkReal x1141=IKcos(j11);
IkReal x1142=IKsin(j11);
IkReal x1143=(r01*sj12);
IkReal x1144=((0.352)*cj7);
IkReal x1145=(cj12*r10);
IkReal x1146=(r11*sj12);
IkReal x1147=(cj12*r00);
IkReal x1148=((0.352)*sj7);
IkReal x1149=((0.3215)*x1142);
IkReal x1150=((0.3215)*x1141);
evalcond[0]=(x1150+((r02*x1144))+((r12*x1148)));
evalcond[1]=(((r22*x1150))+(((-1.0)*cj12*r20*x1149))+((r21*sj12*x1149)));
evalcond[2]=(x1144+((x1143*x1149))+((r02*x1150))+(((-1.0)*x1147*x1149)));
evalcond[3]=((((-1.0)*x1145*x1149))+x1148+((r12*x1150))+((x1146*x1149)));
evalcond[4]=(((x1145*x1148))+(((-1.0)*x1143*x1144))+(((-1.0)*x1149))+(((-1.0)*x1146*x1148))+((x1144*x1147)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x1151=((0.352)*r22);
IkReal x1152=(r12*sj7);
IkReal x1153=(cj7*r02);
CheckValue<IkReal> x1154=IKPowWithIntegerCheck(((((-0.3215)*cj12*r20))+(((0.3215)*r21*sj12))),-1);
if(!x1154.valid){
continue;
}
if( IKabs(((x1154.value)*((((x1151*x1152))+((x1151*x1153)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.09486780715397)*x1152))+(((-1.09486780715397)*x1153)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1154.value)*((((x1151*x1152))+((x1151*x1153))))))+IKsqr(((((-1.09486780715397)*x1152))+(((-1.09486780715397)*x1153))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x1154.value)*((((x1151*x1152))+((x1151*x1153))))), ((((-1.09486780715397)*x1152))+(((-1.09486780715397)*x1153))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[5];
IkReal x1155=IKcos(j11);
IkReal x1156=IKsin(j11);
IkReal x1157=(r01*sj12);
IkReal x1158=((0.352)*cj7);
IkReal x1159=(cj12*r10);
IkReal x1160=(r11*sj12);
IkReal x1161=(cj12*r00);
IkReal x1162=((0.352)*sj7);
IkReal x1163=((0.3215)*x1156);
IkReal x1164=((0.3215)*x1155);
evalcond[0]=(x1164+((r02*x1158))+((r12*x1162)));
evalcond[1]=(((r21*sj12*x1163))+((r22*x1164))+(((-1.0)*cj12*r20*x1163)));
evalcond[2]=(x1158+((r02*x1164))+((x1157*x1163))+(((-1.0)*x1161*x1163)));
evalcond[3]=(x1162+(((-1.0)*x1159*x1163))+((r12*x1164))+((x1160*x1163)));
evalcond[4]=(((x1159*x1162))+(((-1.0)*x1157*x1158))+((x1158*x1161))+(((-1.0)*x1160*x1162))+(((-1.0)*x1163)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}

} else
{
{
IkReal j11array[2], cj11array[2], sj11array[2];
bool j11valid[2]={false};
_nj11 = 2;
CheckValue<IkReal> x1166 = IKatan2WithCheck(IkReal(((0.3215)*r22)),IkReal(((((-0.3215)*cj12*r20))+(((0.3215)*r21*sj12)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1166.valid){
continue;
}
IkReal x1165=x1166.value;
j11array[0]=((-1.0)*x1165);
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
j11array[1]=((3.14159265358979)+(((-1.0)*x1165)));
sj11array[1]=IKsin(j11array[1]);
cj11array[1]=IKcos(j11array[1]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
if( j11array[1] > IKPI )
{
    j11array[1]-=IK2PI;
}
else if( j11array[1] < -IKPI )
{    j11array[1]+=IK2PI;
}
j11valid[1] = true;
for(int ij11 = 0; ij11 < 2; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 2; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];

{
IkReal j7eval[3];
px=0;
py=0;
pp=0;
npx=0;
npy=0;
npz=0;
rxp0_0=0;
rxp0_1=0;
rxp0_2=0;
rxp1_0=0;
rxp1_1=0;
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
pz=0;
IkReal x1167=(r21*sj12);
IkReal x1168=((1.0)*cj12);
IkReal x1169=(cj11*sj12);
j7eval[0]=((((-1.0)*r20*x1168))+x1167);
j7eval[1]=((IKabs((((r00*x1169))+((cj11*cj12*r01)))))+(IKabs(((((-1.0)*cj11*r11*x1168))+(((-1.0)*r10*x1169))))));
j7eval[2]=IKsign(((((247.808)*x1167))+(((-247.808)*cj12*r20))));
if( IKabs(j7eval[0]) < 0.0000010000000000  || IKabs(j7eval[1]) < 0.0000010000000000  || IKabs(j7eval[2]) < 0.0000010000000000  )
{
{
IkReal j7eval[3];
px=0;
py=0;
pp=0;
npx=0;
npy=0;
npz=0;
rxp0_0=0;
rxp0_1=0;
rxp0_2=0;
rxp1_0=0;
rxp1_1=0;
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
pz=0;
IkReal x1170=((28292.0)*cj11);
IkReal x1171=((28292.0)*sj11);
IkReal x1172=(cj12*r21);
IkReal x1173=(r20*sj12);
j7eval[0]=(x1173+x1172);
j7eval[1]=((IKabs(((((-1.0)*r12*x1171))+((r11*sj12*x1170))+(((-1.0)*cj12*r10*x1170)))))+(IKabs((((r02*x1171))+(((-1.0)*r01*sj12*x1170))+((cj12*r00*x1170))))));
j7eval[2]=IKsign(((((30976.0)*x1172))+(((30976.0)*x1173))));
if( IKabs(j7eval[0]) < 0.0000010000000000  || IKabs(j7eval[1]) < 0.0000010000000000  || IKabs(j7eval[2]) < 0.0000010000000000  )
{
{
IkReal j7eval[1];
px=0;
py=0;
pp=0;
npx=0;
npy=0;
npz=0;
rxp0_0=0;
rxp0_1=0;
rxp0_2=0;
rxp1_0=0;
rxp1_1=0;
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
pz=0;
j7eval[0]=r12;
if( IKabs(j7eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j11)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j7array[1], cj7array[1], sj7array[1];
bool j7valid[1]={false};
_nj7 = 1;
IkReal x1174=((0.913352272727273)*cj12);
IkReal x1175=((0.913352272727273)*sj12);
if( IKabs((((r10*x1174))+(((-1.0)*r11*x1175)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((r00*x1174))+(((-1.0)*r01*x1175)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((r10*x1174))+(((-1.0)*r11*x1175))))+IKsqr((((r00*x1174))+(((-1.0)*r01*x1175))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j7array[0]=IKatan2((((r10*x1174))+(((-1.0)*r11*x1175))), (((r00*x1174))+(((-1.0)*r01*x1175))));
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
for(int ij7 = 0; ij7 < 1; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 1; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];
{
IkReal evalcond[5];
IkReal x1176=IKcos(j7);
IkReal x1177=IKsin(j7);
IkReal x1178=(r01*sj12);
IkReal x1179=(cj12*r10);
IkReal x1180=(r11*sj12);
IkReal x1181=(cj12*r00);
IkReal x1182=((0.352)*x1177);
IkReal x1183=((0.352)*x1176);
evalcond[0]=(((r02*x1183))+((r12*x1182)));
evalcond[1]=(x1183+(((0.3215)*x1178))+(((-0.3215)*x1181)));
evalcond[2]=(x1182+(((-0.3215)*x1179))+(((0.3215)*x1180)));
evalcond[3]=(((r10*sj12*x1182))+((cj12*r01*x1183))+((cj12*r11*x1182))+((r00*sj12*x1183)));
evalcond[4]=((-0.3215)+((x1179*x1182))+(((-1.0)*x1178*x1183))+(((-1.0)*x1180*x1182))+((x1181*x1183)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j11)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j7array[1], cj7array[1], sj7array[1];
bool j7valid[1]={false};
_nj7 = 1;
IkReal x1184=((0.913352272727273)*cj12);
IkReal x1185=((0.913352272727273)*sj12);
if( IKabs(((((-1.0)*r10*x1184))+((r11*x1185)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((r01*x1185))+(((-1.0)*r00*x1184)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*r10*x1184))+((r11*x1185))))+IKsqr((((r01*x1185))+(((-1.0)*r00*x1184))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j7array[0]=IKatan2(((((-1.0)*r10*x1184))+((r11*x1185))), (((r01*x1185))+(((-1.0)*r00*x1184))));
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
for(int ij7 = 0; ij7 < 1; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 1; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];
{
IkReal evalcond[5];
IkReal x1186=IKcos(j7);
IkReal x1187=IKsin(j7);
IkReal x1188=((0.3215)*sj12);
IkReal x1189=(cj12*r10);
IkReal x1190=(cj12*r00);
IkReal x1191=((0.352)*x1187);
IkReal x1192=((0.352)*x1186);
evalcond[0]=(((r02*x1192))+((r12*x1191)));
evalcond[1]=((((-1.0)*r01*x1188))+x1192+(((0.3215)*x1190)));
evalcond[2]=((((-1.0)*r11*x1188))+x1191+(((0.3215)*x1189)));
evalcond[3]=(((r00*sj12*x1192))+((r10*sj12*x1191))+((cj12*r01*x1192))+((cj12*r11*x1191)));
evalcond[4]=((0.3215)+(((-1.0)*r11*sj12*x1191))+((x1189*x1191))+(((-1.0)*r01*sj12*x1192))+((x1190*x1192)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(r21))+(IKabs(r20)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j7array[1], cj7array[1], sj7array[1];
bool j7valid[1]={false};
_nj7 = 1;
IkReal x1193=((0.913352272727273)*cj12*sj11);
IkReal x1194=((0.913352272727273)*sj11*sj12);
if( IKabs((((r10*x1193))+(((-1.0)*r11*x1194)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((r00*x1193))+(((-1.0)*r01*x1194)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((r10*x1193))+(((-1.0)*r11*x1194))))+IKsqr((((r00*x1193))+(((-1.0)*r01*x1194))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j7array[0]=IKatan2((((r10*x1193))+(((-1.0)*r11*x1194))), (((r00*x1193))+(((-1.0)*r01*x1194))));
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
for(int ij7 = 0; ij7 < 1; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 1; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];
{
IkReal evalcond[4];
IkReal x1195=IKcos(j7);
IkReal x1196=IKsin(j7);
IkReal x1197=((0.3215)*sj11);
IkReal x1198=(r01*sj12);
IkReal x1199=(cj12*r10);
IkReal x1200=((0.352)*x1195);
IkReal x1201=((0.352)*x1196);
IkReal x1202=(r00*x1200);
IkReal x1203=(sj12*x1201);
evalcond[0]=(x1200+((x1197*x1198))+(((-1.0)*cj12*r00*x1197)));
evalcond[1]=(x1201+(((-1.0)*x1197*x1199))+((r11*sj12*x1197)));
evalcond[2]=(((r10*x1203))+((sj12*x1202))+((cj12*r11*x1201))+((cj12*r01*x1200)));
evalcond[3]=((((-1.0)*x1197))+((x1199*x1201))+(((-1.0)*r11*x1203))+((cj12*x1202))+(((-1.0)*x1198*x1200)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j7]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j7array[1], cj7array[1], sj7array[1];
bool j7valid[1]={false};
_nj7 = 1;
IkReal x1204=((643.0)*cj11);
IkReal x1205=((643.0)*r02);
IkReal x1206=(cj12*r00*sj11);
IkReal x1207=(r01*sj11*sj12);
CheckValue<IkReal> x1208=IKPowWithIntegerCheck(r12,-1);
if(!x1208.valid){
continue;
}
if( IKabs(((0.00142045454545455)*(x1208.value)*(((((-1.0)*x1205*x1206))+((x1205*x1207))+(((-1.0)*x1204))+((x1204*(r02*r02))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-0.913352272727273)*cj11*r02))+(((-0.913352272727273)*x1207))+(((0.913352272727273)*x1206)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((0.00142045454545455)*(x1208.value)*(((((-1.0)*x1205*x1206))+((x1205*x1207))+(((-1.0)*x1204))+((x1204*(r02*r02)))))))+IKsqr(((((-0.913352272727273)*cj11*r02))+(((-0.913352272727273)*x1207))+(((0.913352272727273)*x1206))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j7array[0]=IKatan2(((0.00142045454545455)*(x1208.value)*(((((-1.0)*x1205*x1206))+((x1205*x1207))+(((-1.0)*x1204))+((x1204*(r02*r02)))))), ((((-0.913352272727273)*cj11*r02))+(((-0.913352272727273)*x1207))+(((0.913352272727273)*x1206))));
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
for(int ij7 = 0; ij7 < 1; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 1; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];
{
IkReal evalcond[5];
IkReal x1209=IKcos(j7);
IkReal x1210=IKsin(j7);
IkReal x1211=(r01*sj12);
IkReal x1212=((0.3215)*cj11);
IkReal x1213=(r11*sj12);
IkReal x1214=((0.3215)*sj11);
IkReal x1215=(cj12*r10);
IkReal x1216=(cj12*r00);
IkReal x1217=((0.352)*x1210);
IkReal x1218=((0.352)*x1209);
evalcond[0]=(((r12*x1217))+x1212+((r02*x1218)));
evalcond[1]=(x1218+((r02*x1212))+(((-1.0)*x1214*x1216))+((x1211*x1214)));
evalcond[2]=(((r12*x1212))+x1217+((x1213*x1214))+(((-1.0)*x1214*x1215)));
evalcond[3]=(((r10*sj12*x1217))+((r00*sj12*x1218))+((cj12*r01*x1218))+((cj12*r11*x1217)));
evalcond[4]=((((-1.0)*x1213*x1217))+(((-1.0)*x1211*x1218))+((x1216*x1218))+(((-1.0)*x1214))+((x1215*x1217)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j7array[1], cj7array[1], sj7array[1];
bool j7valid[1]={false};
_nj7 = 1;
IkReal x1219=((28292.0)*cj11);
IkReal x1220=((28292.0)*sj11);
CheckValue<IkReal> x1221 = IKatan2WithCheck(IkReal((((r02*x1220))+((cj12*r00*x1219))+(((-1.0)*r01*sj12*x1219)))),IkReal((((r11*sj12*x1219))+(((-1.0)*r12*x1220))+(((-1.0)*cj12*r10*x1219)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1221.valid){
continue;
}
CheckValue<IkReal> x1222=IKPowWithIntegerCheck(IKsign(((((30976.0)*r20*sj12))+(((30976.0)*cj12*r21)))),-1);
if(!x1222.valid){
continue;
}
j7array[0]=((-1.5707963267949)+(x1221.value)+(((1.5707963267949)*(x1222.value))));
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
for(int ij7 = 0; ij7 < 1; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 1; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];
{
IkReal evalcond[5];
IkReal x1223=IKcos(j7);
IkReal x1224=IKsin(j7);
IkReal x1225=(r01*sj12);
IkReal x1226=((0.3215)*cj11);
IkReal x1227=(r11*sj12);
IkReal x1228=((0.3215)*sj11);
IkReal x1229=(cj12*r10);
IkReal x1230=(cj12*r00);
IkReal x1231=((0.352)*x1224);
IkReal x1232=((0.352)*x1223);
evalcond[0]=(x1226+((r02*x1232))+((r12*x1231)));
evalcond[1]=(x1232+((x1225*x1228))+((r02*x1226))+(((-1.0)*x1228*x1230)));
evalcond[2]=(x1231+(((-1.0)*x1228*x1229))+((x1227*x1228))+((r12*x1226)));
evalcond[3]=(((cj12*r11*x1231))+((r10*sj12*x1231))+((cj12*r01*x1232))+((r00*sj12*x1232)));
evalcond[4]=((((-1.0)*x1225*x1232))+(((-1.0)*x1228))+(((-1.0)*x1227*x1231))+((x1230*x1232))+((x1229*x1231)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j7array[1], cj7array[1], sj7array[1];
bool j7valid[1]={false};
_nj7 = 1;
IkReal x1233=((226.336)*cj11);
CheckValue<IkReal> x1234=IKPowWithIntegerCheck(IKsign(((((-247.808)*cj12*r20))+(((247.808)*r21*sj12)))),-1);
if(!x1234.valid){
continue;
}
CheckValue<IkReal> x1235 = IKatan2WithCheck(IkReal((((cj12*r01*x1233))+((r00*sj12*x1233)))),IkReal(((((-1.0)*cj12*r11*x1233))+(((-1.0)*r10*sj12*x1233)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1235.valid){
continue;
}
j7array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1234.value)))+(x1235.value));
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
for(int ij7 = 0; ij7 < 1; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 1; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];
{
IkReal evalcond[5];
IkReal x1236=IKcos(j7);
IkReal x1237=IKsin(j7);
IkReal x1238=(r01*sj12);
IkReal x1239=((0.3215)*cj11);
IkReal x1240=(r11*sj12);
IkReal x1241=((0.3215)*sj11);
IkReal x1242=(cj12*r10);
IkReal x1243=(cj12*r00);
IkReal x1244=((0.352)*x1237);
IkReal x1245=((0.352)*x1236);
evalcond[0]=(x1239+((r02*x1245))+((r12*x1244)));
evalcond[1]=(x1245+((r02*x1239))+((x1238*x1241))+(((-1.0)*x1241*x1243)));
evalcond[2]=(x1244+((x1240*x1241))+(((-1.0)*x1241*x1242))+((r12*x1239)));
evalcond[3]=(((cj12*r11*x1244))+((cj12*r01*x1245))+((r10*sj12*x1244))+((r00*sj12*x1245)));
evalcond[4]=((((-1.0)*x1241))+(((-1.0)*x1238*x1245))+(((-1.0)*x1240*x1244))+((x1242*x1244))+((x1243*x1245)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j7, j11]

}
} while(0);
if( bgotonextstatement )
{
}
}
}

} else
{
{
IkReal j7array[2], cj7array[2], sj7array[2];
bool j7valid[2]={false};
_nj7 = 2;
IkReal x1246=((0.352)*cj12);
IkReal x1247=((0.352)*sj12);
IkReal x1248=((1.0)*pz);
IkReal x1249=(((r01*x1246))+((r00*x1247)));
IkReal x1250=(((r11*x1246))+((r10*x1247)));
CheckValue<IkReal> x1253 = IKatan2WithCheck(IkReal(x1249),IkReal(x1250),IKFAST_ATAN2_MAGTHRESH);
if(!x1253.valid){
continue;
}
IkReal x1251=((1.0)*(x1253.value));
if((((x1249*x1249)+(x1250*x1250))) < -0.00001)
continue;
CheckValue<IkReal> x1254=IKPowWithIntegerCheck(IKabs(IKsqrt(((x1249*x1249)+(x1250*x1250)))),-1);
if(!x1254.valid){
continue;
}
if( (((-1.0)*(x1254.value)*(((((-1.0)*cj12*r21*x1248))+(((-1.0)*r20*sj12*x1248)))))) < -1-IKFAST_SINCOS_THRESH || (((-1.0)*(x1254.value)*(((((-1.0)*cj12*r21*x1248))+(((-1.0)*r20*sj12*x1248)))))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x1252=((-1.0)*(IKasin(((-1.0)*(x1254.value)*(((((-1.0)*cj12*r21*x1248))+(((-1.0)*r20*sj12*x1248))))))));
j7array[0]=((((-1.0)*x1252))+(((-1.0)*x1251)));
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
j7array[1]=((3.14159265358979)+(((-1.0)*x1251))+(((1.0)*x1252)));
sj7array[1]=IKsin(j7array[1]);
cj7array[1]=IKcos(j7array[1]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
if( j7array[1] > IKPI )
{
    j7array[1]-=IK2PI;
}
else if( j7array[1] < -IKPI )
{    j7array[1]+=IK2PI;
}
j7valid[1] = true;
for(int ij7 = 0; ij7 < 2; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 2; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];

{
IkReal j11eval[1];
IkReal x1255=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x1255);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x1255);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=(r02*x1255);
rxp2_2=0;
j11eval[0]=((((-1.0)*cj12*r20))+((r21*sj12)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal j11eval[1];
IkReal x1256=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x1256);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x1256);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=(r02*x1256);
rxp2_2=0;
j11eval[0]=((((-1.0)*cj12*r00))+((r01*sj12)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal j11eval[1];
IkReal x1257=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=(pz*r20);
npy=(pz*r21);
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x1257);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x1257);
rxp1_2=0;
rxp2_0=(pz*r12);
rxp2_1=(r02*x1257);
rxp2_2=0;
j11eval[0]=(((r11*sj12))+(((-1.0)*cj12*r10)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
IkReal x1259 = ((1.0)+(((-1.0)*(r12*r12))));
if(IKabs(x1259)==0){
continue;
}
IkReal x1258=pow(x1259,-0.5);
CheckValue<IkReal> x1260 = IKatan2WithCheck(IkReal(((-1.0)*r10)),IkReal(r11),IKFAST_ATAN2_MAGTHRESH);
if(!x1260.valid){
continue;
}
IkReal gconst64=((-1.0)*(x1260.value));
IkReal gconst65=(r10*x1258);
IkReal gconst66=(r11*x1258);
CheckValue<IkReal> x1261 = IKatan2WithCheck(IkReal(((-1.0)*r10)),IkReal(r11),IKFAST_ATAN2_MAGTHRESH);
if(!x1261.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs((j12+(x1261.value))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x1262=((0.352)*r22);
IkReal x1263=(r12*sj7);
IkReal x1264=(cj7*r02);
CheckValue<IkReal> x1265=IKPowWithIntegerCheck(((((0.3215)*gconst65*r21))+(((-0.3215)*gconst66*r20))),-1);
if(!x1265.valid){
continue;
}
if( IKabs(((x1265.value)*(((((-1.0)*pz*(r22*r22)))+((x1262*x1264))+((x1262*x1263))+pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.09486780715397)*x1264))+(((-1.09486780715397)*x1263))+(((3.1104199066874)*pz*r22)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1265.value)*(((((-1.0)*pz*(r22*r22)))+((x1262*x1264))+((x1262*x1263))+pz))))+IKsqr(((((-1.09486780715397)*x1264))+(((-1.09486780715397)*x1263))+(((3.1104199066874)*pz*r22))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x1265.value)*(((((-1.0)*pz*(r22*r22)))+((x1262*x1264))+((x1262*x1263))+pz))), ((((-1.09486780715397)*x1264))+(((-1.09486780715397)*x1263))+(((3.1104199066874)*pz*r22))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x1266=IKcos(j11);
IkReal x1267=IKsin(j11);
IkReal x1268=((0.352)*cj7);
IkReal x1269=(gconst65*r01);
IkReal x1270=((0.352)*sj7);
IkReal x1271=((0.643)*pz);
IkReal x1272=((1.0)*pz);
IkReal x1273=(gconst65*r21);
IkReal x1274=(gconst66*x1267);
IkReal x1275=((0.3215)*x1266);
IkReal x1276=((0.3215)*x1267);
IkReal x1277=(gconst65*x1276);
evalcond[0]=(x1275+((r12*x1270))+((r02*x1268))+(((-1.0)*r22*x1272)));
evalcond[1]=((((-1.0)*x1272))+((r22*x1275))+((x1273*x1276))+(((-0.3215)*r20*x1274)));
evalcond[2]=(((x1269*x1276))+x1268+((r02*x1275))+(((-0.3215)*r00*x1274)));
evalcond[3]=(x1270+((r12*x1275))+((r11*x1277))+(((-0.3215)*r10*x1274)));
evalcond[4]=((0.0410835)+((x1267*x1271*x1273))+((r22*x1266*x1271))+(((-1.0)*r20*x1271*x1274)));
evalcond[5]=(((pz*x1273))+((gconst66*r10*x1270))+(((-1.0)*gconst65*r11*x1270))+(((-1.0)*x1276))+((gconst66*r00*x1268))+(((-1.0)*x1268*x1269))+(((-1.0)*gconst66*r20*x1272)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x1280 = ((1.0)+(((-1.0)*(r12*r12))));
if(IKabs(x1280)==0){
continue;
}
IkReal x1278=pow(x1280,-0.5);
IkReal x1279=((-1.0)*x1278);
CheckValue<IkReal> x1281 = IKatan2WithCheck(IkReal(((-1.0)*r10)),IkReal(r11),IKFAST_ATAN2_MAGTHRESH);
if(!x1281.valid){
continue;
}
IkReal gconst67=((3.14159265358979)+(((-1.0)*(x1281.value))));
IkReal gconst68=(r10*x1279);
IkReal gconst69=(r11*x1279);
CheckValue<IkReal> x1282 = IKatan2WithCheck(IkReal(((-1.0)*r10)),IkReal(r11),IKFAST_ATAN2_MAGTHRESH);
if(!x1282.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j12+(x1282.value))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x1283=((0.352)*r22);
IkReal x1284=(r12*sj7);
IkReal x1285=(cj7*r02);
CheckValue<IkReal> x1286=IKPowWithIntegerCheck(((((0.3215)*gconst68*r21))+(((-0.3215)*gconst69*r20))),-1);
if(!x1286.valid){
continue;
}
if( IKabs(((x1286.value)*(((((-1.0)*pz*(r22*r22)))+((x1283*x1285))+((x1283*x1284))+pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.09486780715397)*x1285))+(((-1.09486780715397)*x1284))+(((3.1104199066874)*pz*r22)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1286.value)*(((((-1.0)*pz*(r22*r22)))+((x1283*x1285))+((x1283*x1284))+pz))))+IKsqr(((((-1.09486780715397)*x1285))+(((-1.09486780715397)*x1284))+(((3.1104199066874)*pz*r22))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x1286.value)*(((((-1.0)*pz*(r22*r22)))+((x1283*x1285))+((x1283*x1284))+pz))), ((((-1.09486780715397)*x1285))+(((-1.09486780715397)*x1284))+(((3.1104199066874)*pz*r22))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x1287=IKcos(j11);
IkReal x1288=IKsin(j11);
IkReal x1289=((0.352)*sj7);
IkReal x1290=(gconst68*r11);
IkReal x1291=((1.0)*pz);
IkReal x1292=(gconst69*r20);
IkReal x1293=(gconst68*r01);
IkReal x1294=((0.352)*cj7);
IkReal x1295=(gconst69*r10);
IkReal x1296=(gconst68*r21);
IkReal x1297=(gconst69*r00);
IkReal x1298=((0.3215)*x1288);
IkReal x1299=((0.3215)*x1287);
IkReal x1300=((0.643)*pz*x1288);
evalcond[0]=(x1299+((r02*x1294))+(((-1.0)*r22*x1291))+((r12*x1289)));
evalcond[1]=(((x1296*x1298))+(((-1.0)*x1291))+(((-1.0)*x1292*x1298))+((r22*x1299)));
evalcond[2]=(x1294+((x1293*x1298))+((r02*x1299))+(((-1.0)*x1297*x1298)));
evalcond[3]=(x1289+((x1290*x1298))+((r12*x1299))+(((-1.0)*x1295*x1298)));
evalcond[4]=((0.0410835)+(((-1.0)*x1292*x1300))+((x1296*x1300))+(((0.643)*pz*r22*x1287)));
evalcond[5]=((((-1.0)*x1298))+(((-1.0)*x1289*x1290))+((x1294*x1297))+((pz*x1296))+(((-1.0)*x1293*x1294))+(((-1.0)*x1291*x1292))+((x1289*x1295)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x1302 = ((1.0)+(((-1.0)*(r02*r02))));
if(IKabs(x1302)==0){
continue;
}
IkReal x1301=pow(x1302,-0.5);
CheckValue<IkReal> x1303 = IKatan2WithCheck(IkReal(((-1.0)*r00)),IkReal(r01),IKFAST_ATAN2_MAGTHRESH);
if(!x1303.valid){
continue;
}
IkReal gconst70=((-1.0)*(x1303.value));
IkReal gconst71=(r00*x1301);
IkReal gconst72=(r01*x1301);
CheckValue<IkReal> x1304 = IKatan2WithCheck(IkReal(((-1.0)*r00)),IkReal(r01),IKFAST_ATAN2_MAGTHRESH);
if(!x1304.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs((j12+(x1304.value))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x1305=((0.352)*r22);
IkReal x1306=(r12*sj7);
IkReal x1307=(cj7*r02);
CheckValue<IkReal> x1308=IKPowWithIntegerCheck(((((0.3215)*gconst71*r21))+(((-0.3215)*gconst72*r20))),-1);
if(!x1308.valid){
continue;
}
if( IKabs(((x1308.value)*((((x1305*x1307))+((x1305*x1306))+(((-1.0)*pz*(r22*r22)))+pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.09486780715397)*x1307))+(((-1.09486780715397)*x1306))+(((3.1104199066874)*pz*r22)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1308.value)*((((x1305*x1307))+((x1305*x1306))+(((-1.0)*pz*(r22*r22)))+pz))))+IKsqr(((((-1.09486780715397)*x1307))+(((-1.09486780715397)*x1306))+(((3.1104199066874)*pz*r22))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x1308.value)*((((x1305*x1307))+((x1305*x1306))+(((-1.0)*pz*(r22*r22)))+pz))), ((((-1.09486780715397)*x1307))+(((-1.09486780715397)*x1306))+(((3.1104199066874)*pz*r22))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x1309=IKcos(j11);
IkReal x1310=IKsin(j11);
IkReal x1311=((0.352)*sj7);
IkReal x1312=(gconst72*r10);
IkReal x1313=(gconst72*r20);
IkReal x1314=(gconst71*r11);
IkReal x1315=((1.0)*pz);
IkReal x1316=(gconst71*r01);
IkReal x1317=((0.352)*cj7);
IkReal x1318=(gconst72*r00);
IkReal x1319=((0.3215)*x1310);
IkReal x1320=((0.3215)*x1309);
IkReal x1321=(gconst71*pz*r21);
IkReal x1322=((0.643)*x1310);
evalcond[0]=(x1320+(((-1.0)*r22*x1315))+((r12*x1311))+((r02*x1317)));
evalcond[1]=((((-1.0)*x1313*x1319))+((gconst71*r21*x1319))+(((-1.0)*x1315))+((r22*x1320)));
evalcond[2]=(x1317+(((-1.0)*x1318*x1319))+((x1316*x1319))+((r02*x1320)));
evalcond[3]=(x1311+((x1314*x1319))+((r12*x1320))+(((-1.0)*x1312*x1319)));
evalcond[4]=((0.0410835)+(((-1.0)*pz*x1313*x1322))+((x1321*x1322))+(((0.643)*pz*r22*x1309)));
evalcond[5]=(x1321+(((-1.0)*x1311*x1314))+((x1317*x1318))+((x1311*x1312))+(((-1.0)*x1313*x1315))+(((-1.0)*x1319))+(((-1.0)*x1316*x1317)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x1323=((-1.0)*r00);
IkReal x1325 = ((1.0)+(((-1.0)*(r02*r02))));
if(IKabs(x1325)==0){
continue;
}
IkReal x1324=pow(x1325,-0.5);
CheckValue<IkReal> x1326 = IKatan2WithCheck(IkReal(x1323),IkReal(r01),IKFAST_ATAN2_MAGTHRESH);
if(!x1326.valid){
continue;
}
IkReal gconst73=((3.14159265358979)+(((-1.0)*(x1326.value))));
IkReal gconst74=(x1323*x1324);
IkReal gconst75=((-1.0)*r01*x1324);
CheckValue<IkReal> x1327 = IKatan2WithCheck(IkReal(((-1.0)*r00)),IkReal(r01),IKFAST_ATAN2_MAGTHRESH);
if(!x1327.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j12+(x1327.value))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x1328=((0.352)*r22);
IkReal x1329=(r12*sj7);
IkReal x1330=(cj7*r02);
CheckValue<IkReal> x1331=IKPowWithIntegerCheck(((((0.3215)*gconst74*r21))+(((-0.3215)*gconst75*r20))),-1);
if(!x1331.valid){
continue;
}
if( IKabs(((x1331.value)*(((((-1.0)*pz*(r22*r22)))+((x1328*x1329))+((x1328*x1330))+pz)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.09486780715397)*x1330))+(((-1.09486780715397)*x1329))+(((3.1104199066874)*pz*r22)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1331.value)*(((((-1.0)*pz*(r22*r22)))+((x1328*x1329))+((x1328*x1330))+pz))))+IKsqr(((((-1.09486780715397)*x1330))+(((-1.09486780715397)*x1329))+(((3.1104199066874)*pz*r22))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x1331.value)*(((((-1.0)*pz*(r22*r22)))+((x1328*x1329))+((x1328*x1330))+pz))), ((((-1.09486780715397)*x1330))+(((-1.09486780715397)*x1329))+(((3.1104199066874)*pz*r22))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x1332=IKcos(j11);
IkReal x1333=IKsin(j11);
IkReal x1334=(pz*r20);
IkReal x1335=((0.352)*sj7);
IkReal x1336=((0.352)*cj7);
IkReal x1337=((1.0)*pz);
IkReal x1338=(gconst74*r11);
IkReal x1339=(pz*r21);
IkReal x1340=(gconst75*x1333);
IkReal x1341=((0.3215)*x1332);
IkReal x1342=(gconst74*x1333);
IkReal x1343=((0.3215)*x1333);
evalcond[0]=(x1341+((r12*x1335))+(((-1.0)*r22*x1337))+((r02*x1336)));
evalcond[1]=(((r22*x1341))+(((0.3215)*r21*x1342))+(((-0.3215)*r20*x1340))+(((-1.0)*x1337)));
evalcond[2]=(x1336+(((-0.3215)*r00*x1340))+((r02*x1341))+(((0.3215)*r01*x1342)));
evalcond[3]=(x1335+((x1338*x1343))+((r12*x1341))+(((-0.3215)*r10*x1340)));
evalcond[4]=((0.0410835)+(((0.643)*pz*r22*x1332))+(((-0.643)*x1334*x1340))+(((0.643)*x1339*x1342)));
evalcond[5]=((((-1.0)*x1335*x1338))+(((-1.0)*x1343))+(((-1.0)*gconst75*x1334))+(((-1.0)*gconst74*r01*x1336))+((gconst75*r10*x1335))+((gconst74*x1339))+((gconst75*r00*x1336)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x1345 = ((1.0)+(((-1.0)*(r22*r22))));
if(IKabs(x1345)==0){
continue;
}
IkReal x1344=pow(x1345,-0.5);
CheckValue<IkReal> x1346 = IKatan2WithCheck(IkReal(((-1.0)*r20)),IkReal(r21),IKFAST_ATAN2_MAGTHRESH);
if(!x1346.valid){
continue;
}
IkReal gconst76=((-1.0)*(x1346.value));
IkReal gconst77=(r20*x1344);
IkReal gconst78=(r21*x1344);
CheckValue<IkReal> x1347 = IKatan2WithCheck(IkReal(((-1.0)*r20)),IkReal(r21),IKFAST_ATAN2_MAGTHRESH);
if(!x1347.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs((j12+(x1347.value))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x1348=(pz*r22);
IkReal x1349=(r12*sj7);
IkReal x1350=((44.0)*cj7);
CheckValue<IkReal> x1351=IKPowWithIntegerCheck(((((-40.1875)*gconst78*r00))+(((40.1875)*gconst77*r01))),-1);
if(!x1351.valid){
continue;
}
if( IKabs(((x1351.value)*(((((-1.0)*x1350))+((x1350*(r02*r02)))+(((-125.0)*r02*x1348))+(((44.0)*r02*x1349)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((3.1104199066874)*x1348))+(((-1.09486780715397)*cj7*r02))+(((-1.09486780715397)*x1349)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1351.value)*(((((-1.0)*x1350))+((x1350*(r02*r02)))+(((-125.0)*r02*x1348))+(((44.0)*r02*x1349))))))+IKsqr(((((3.1104199066874)*x1348))+(((-1.09486780715397)*cj7*r02))+(((-1.09486780715397)*x1349))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x1351.value)*(((((-1.0)*x1350))+((x1350*(r02*r02)))+(((-125.0)*r02*x1348))+(((44.0)*r02*x1349))))), ((((3.1104199066874)*x1348))+(((-1.09486780715397)*cj7*r02))+(((-1.09486780715397)*x1349))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x1352=IKcos(j11);
IkReal x1353=IKsin(j11);
IkReal x1354=(gconst77*r21);
IkReal x1355=(gconst78*r10);
IkReal x1356=((0.352)*sj7);
IkReal x1357=((1.0)*pz);
IkReal x1358=(gconst78*r20);
IkReal x1359=(gconst78*r00);
IkReal x1360=((0.352)*cj7);
IkReal x1361=(gconst77*r01);
IkReal x1362=(gconst77*r11);
IkReal x1363=((0.3215)*x1353);
IkReal x1364=((0.3215)*x1352);
IkReal x1365=((0.643)*pz*x1353);
evalcond[0]=(x1364+((r02*x1360))+(((-1.0)*r22*x1357))+((r12*x1356)));
evalcond[1]=((((-1.0)*x1357))+((r22*x1364))+((x1354*x1363))+(((-1.0)*x1358*x1363)));
evalcond[2]=(x1360+((x1361*x1363))+((r02*x1364))+(((-1.0)*x1359*x1363)));
evalcond[3]=(x1356+(((-1.0)*x1355*x1363))+((r12*x1364))+((x1362*x1363)));
evalcond[4]=((0.0410835)+((x1354*x1365))+(((0.643)*pz*r22*x1352))+(((-1.0)*x1358*x1365)));
evalcond[5]=(((x1355*x1356))+((x1359*x1360))+(((-1.0)*x1356*x1362))+((pz*x1354))+(((-1.0)*x1357*x1358))+(((-1.0)*x1360*x1361))+(((-1.0)*x1363)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
IkReal x1368 = ((1.0)+(((-1.0)*(r22*r22))));
if(IKabs(x1368)==0){
continue;
}
IkReal x1366=pow(x1368,-0.5);
IkReal x1367=((-1.0)*x1366);
CheckValue<IkReal> x1369 = IKatan2WithCheck(IkReal(((-1.0)*r20)),IkReal(r21),IKFAST_ATAN2_MAGTHRESH);
if(!x1369.valid){
continue;
}
IkReal gconst79=((3.14159265358979)+(((-1.0)*(x1369.value))));
IkReal gconst80=(r20*x1367);
IkReal gconst81=(r21*x1367);
CheckValue<IkReal> x1370 = IKatan2WithCheck(IkReal(((-1.0)*r20)),IkReal(r21),IKFAST_ATAN2_MAGTHRESH);
if(!x1370.valid){
continue;
}
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j12+(x1370.value))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x1371=(pz*r22);
IkReal x1372=(r12*sj7);
IkReal x1373=((44.0)*cj7);
CheckValue<IkReal> x1374=IKPowWithIntegerCheck(((((-40.1875)*gconst81*r00))+(((40.1875)*gconst80*r01))),-1);
if(!x1374.valid){
continue;
}
if( IKabs(((x1374.value)*(((((-125.0)*r02*x1371))+(((-1.0)*x1373))+(((44.0)*r02*x1372))+((x1373*(r02*r02))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((3.1104199066874)*x1371))+(((-1.09486780715397)*x1372))+(((-1.09486780715397)*cj7*r02)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1374.value)*(((((-125.0)*r02*x1371))+(((-1.0)*x1373))+(((44.0)*r02*x1372))+((x1373*(r02*r02)))))))+IKsqr(((((3.1104199066874)*x1371))+(((-1.09486780715397)*x1372))+(((-1.09486780715397)*cj7*r02))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x1374.value)*(((((-125.0)*r02*x1371))+(((-1.0)*x1373))+(((44.0)*r02*x1372))+((x1373*(r02*r02)))))), ((((3.1104199066874)*x1371))+(((-1.09486780715397)*x1372))+(((-1.09486780715397)*cj7*r02))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x1375=IKcos(j11);
IkReal x1376=IKsin(j11);
IkReal x1377=(gconst80*r11);
IkReal x1378=(gconst81*r00);
IkReal x1379=((0.352)*sj7);
IkReal x1380=(gconst81*r20);
IkReal x1381=(gconst80*r21);
IkReal x1382=((1.0)*pz);
IkReal x1383=(gconst80*r01);
IkReal x1384=((0.352)*cj7);
IkReal x1385=(gconst81*r10);
IkReal x1386=((0.3215)*x1376);
IkReal x1387=((0.3215)*x1375);
IkReal x1388=((0.643)*pz*x1376);
evalcond[0]=(x1387+((r12*x1379))+(((-1.0)*r22*x1382))+((r02*x1384)));
evalcond[1]=((((-1.0)*x1382))+((x1381*x1386))+(((-1.0)*x1380*x1386))+((r22*x1387)));
evalcond[2]=(x1384+(((-1.0)*x1378*x1386))+((r02*x1387))+((x1383*x1386)));
evalcond[3]=(x1379+((x1377*x1386))+((r12*x1387))+(((-1.0)*x1385*x1386)));
evalcond[4]=((0.0410835)+((x1381*x1388))+(((-1.0)*x1380*x1388))+(((0.643)*pz*r22*x1375)));
evalcond[5]=((((-1.0)*x1386))+(((-1.0)*x1383*x1384))+((pz*x1381))+(((-1.0)*x1380*x1382))+(((-1.0)*x1377*x1379))+((x1379*x1385))+((x1378*x1384)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(r21))+(IKabs(r20)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j11eval[1];
IkReal x1389=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=0;
npy=0;
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x1389);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x1389);
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
r20=0;
r21=0;
r02=0;
r12=0;
j11eval[0]=((((-1.0)*cj12*r00))+((r01*sj12)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal j11eval[1];
IkReal x1390=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=0;
npy=0;
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x1390);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x1390);
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
r20=0;
r21=0;
r02=0;
r12=0;
j11eval[0]=(((r11*sj12))+(((-1.0)*cj12*r10)));
if( IKabs(j11eval[0]) < 0.0000010000000000  )
{
{
IkReal j11eval[3];
IkReal x1391=((-1.0)*pz);
px=0;
py=0;
pp=pz*pz;
npx=0;
npy=0;
npz=(pz*r22);
rxp0_0=(pz*r10);
rxp0_1=(r00*x1391);
rxp0_2=0;
rxp1_0=(pz*r11);
rxp1_1=(r01*x1391);
rxp1_2=0;
rxp2_0=0;
rxp2_1=0;
rxp2_2=0;
r20=0;
r21=0;
r02=0;
r12=0;
j11eval[0]=((((-1.0)*cj12*r00))+((r01*sj12)));
j11eval[1]=pz;
j11eval[2]=r22;
if( IKabs(j11eval[0]) < 0.0000010000000000  || IKabs(j11eval[1]) < 0.0000010000000000  || IKabs(j11eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(pz);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j11array[2], cj11array[2], sj11array[2];
bool j11valid[2]={false};
_nj11 = 2;
IkReal x1392=((1.09486780715397)*cj12);
IkReal x1393=((1.09486780715397)*sj12);
sj11array[0]=((((-1.0)*cj7*r01*x1393))+(((-1.0)*r11*sj7*x1393))+((cj7*r00*x1392))+((r10*sj7*x1392)));
if( sj11array[0] >= -1-IKFAST_SINCOS_THRESH && sj11array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j11valid[0] = j11valid[1] = true;
    j11array[0] = IKasin(sj11array[0]);
    cj11array[0] = IKcos(j11array[0]);
    sj11array[1] = sj11array[0];
    j11array[1] = j11array[0] > 0 ? (IKPI-j11array[0]) : (-IKPI-j11array[0]);
    cj11array[1] = -cj11array[0];
}
else if( std::isnan(sj11array[0]) )
{
    // probably any value will work
    j11valid[0] = true;
    cj11array[0] = 1; sj11array[0] = 0; j11array[0] = 0;
}
for(int ij11 = 0; ij11 < 2; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 2; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[4];
IkReal x1394=IKcos(j11);
IkReal x1395=IKsin(j11);
IkReal x1396=((0.3215)*x1395);
IkReal x1397=((0.3215)*x1394);
evalcond[0]=x1397;
evalcond[1]=(r22*x1397);
evalcond[2]=(((r01*sj12*x1396))+(((-1.0)*cj12*r00*x1396))+(((0.352)*cj7)));
evalcond[3]=((((-1.0)*cj12*r10*x1396))+(((0.352)*sj7))+((r11*sj12*x1396)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j11]

}
} while(0);
if( bgotonextstatement )
{
}
}
}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
CheckValue<IkReal> x1398=IKPowWithIntegerCheck(((((-40.1875)*cj12*r00))+(((40.1875)*r01*sj12))),-1);
if(!x1398.valid){
continue;
}
CheckValue<IkReal> x1399=IKPowWithIntegerCheck(pz,-1);
if(!x1399.valid){
continue;
}
CheckValue<IkReal> x1400=IKPowWithIntegerCheck(r22,-1);
if(!x1400.valid){
continue;
}
if( IKabs(((-44.0)*cj7*(x1398.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-0.063893468118196)*(x1399.value)*(x1400.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-44.0)*cj7*(x1398.value)))+IKsqr(((-0.063893468118196)*(x1399.value)*(x1400.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((-44.0)*cj7*(x1398.value)), ((-0.063893468118196)*(x1399.value)*(x1400.value)));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x1401=IKcos(j11);
IkReal x1402=IKsin(j11);
IkReal x1403=((0.352)*sj7);
IkReal x1404=(cj12*r10);
IkReal x1405=(r01*sj12);
IkReal x1406=(r11*sj12);
IkReal x1407=((1.0)*pz);
IkReal x1408=((0.352)*cj7);
IkReal x1409=(cj12*r00);
IkReal x1410=((0.3215)*x1402);
IkReal x1411=(r22*x1401);
evalcond[0]=((0.0410835)+(((0.643)*pz*x1411)));
evalcond[1]=((((-1.0)*r22*x1407))+(((0.3215)*x1401)));
evalcond[2]=((((0.3215)*x1411))+(((-1.0)*x1407)));
evalcond[3]=(((x1405*x1410))+x1408+(((-1.0)*x1409*x1410)));
evalcond[4]=((((-1.0)*x1404*x1410))+((x1406*x1410))+x1403);
evalcond[5]=((((-1.0)*x1410))+(((-1.0)*x1405*x1408))+((x1403*x1404))+((x1408*x1409))+(((-1.0)*x1403*x1406)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
CheckValue<IkReal> x1412=IKPowWithIntegerCheck(((((40.1875)*r11*sj12))+(((-40.1875)*cj12*r10))),-1);
if(!x1412.valid){
continue;
}
if( IKabs(((-44.0)*sj7*(x1412.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((3.1104199066874)*pz*r22)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-44.0)*sj7*(x1412.value)))+IKsqr(((3.1104199066874)*pz*r22))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((-44.0)*sj7*(x1412.value)), ((3.1104199066874)*pz*r22));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x1413=IKcos(j11);
IkReal x1414=IKsin(j11);
IkReal x1415=((0.352)*sj7);
IkReal x1416=(cj12*r10);
IkReal x1417=(r01*sj12);
IkReal x1418=(r11*sj12);
IkReal x1419=((1.0)*pz);
IkReal x1420=((0.352)*cj7);
IkReal x1421=(cj12*r00);
IkReal x1422=((0.3215)*x1414);
IkReal x1423=(r22*x1413);
evalcond[0]=((0.0410835)+(((0.643)*pz*x1423)));
evalcond[1]=((((0.3215)*x1413))+(((-1.0)*r22*x1419)));
evalcond[2]=((((-1.0)*x1419))+(((0.3215)*x1423)));
evalcond[3]=((((-1.0)*x1421*x1422))+x1420+((x1417*x1422)));
evalcond[4]=((((-1.0)*x1416*x1422))+x1415+((x1418*x1422)));
evalcond[5]=((((-1.0)*x1415*x1418))+((x1415*x1416))+((x1420*x1421))+(((-1.0)*x1417*x1420))+(((-1.0)*x1422)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
CheckValue<IkReal> x1424=IKPowWithIntegerCheck(((((-40.1875)*cj12*r00))+(((40.1875)*r01*sj12))),-1);
if(!x1424.valid){
continue;
}
if( IKabs(((-44.0)*cj7*(x1424.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((3.1104199066874)*pz*r22)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-44.0)*cj7*(x1424.value)))+IKsqr(((3.1104199066874)*pz*r22))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((-44.0)*cj7*(x1424.value)), ((3.1104199066874)*pz*r22));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x1425=IKcos(j11);
IkReal x1426=IKsin(j11);
IkReal x1427=((0.352)*sj7);
IkReal x1428=(cj12*r10);
IkReal x1429=(r01*sj12);
IkReal x1430=(r11*sj12);
IkReal x1431=((1.0)*pz);
IkReal x1432=((0.352)*cj7);
IkReal x1433=(cj12*r00);
IkReal x1434=((0.3215)*x1426);
IkReal x1435=(r22*x1425);
evalcond[0]=((0.0410835)+(((0.643)*pz*x1435)));
evalcond[1]=((((0.3215)*x1425))+(((-1.0)*r22*x1431)));
evalcond[2]=((((-1.0)*x1431))+(((0.3215)*x1435)));
evalcond[3]=(((x1429*x1434))+x1432+(((-1.0)*x1433*x1434)));
evalcond[4]=(((x1430*x1434))+(((-1.0)*x1428*x1434))+x1427);
evalcond[5]=(((x1432*x1433))+(((-1.0)*x1429*x1432))+(((-1.0)*x1434))+(((-1.0)*x1427*x1430))+((x1427*x1428)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j11]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x1436=((44.0)*sj7);
IkReal x1437=(pz*r22);
IkReal x1438=(cj7*r02);
CheckValue<IkReal> x1439=IKPowWithIntegerCheck(((((40.1875)*r11*sj12))+(((-40.1875)*cj12*r10))),-1);
if(!x1439.valid){
continue;
}
if( IKabs(((x1439.value)*((((x1436*(r12*r12)))+(((-1.0)*x1436))+(((44.0)*r12*x1438))+(((-125.0)*r12*x1437)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.09486780715397)*x1438))+(((3.1104199066874)*x1437))+(((-1.09486780715397)*r12*sj7)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1439.value)*((((x1436*(r12*r12)))+(((-1.0)*x1436))+(((44.0)*r12*x1438))+(((-125.0)*r12*x1437))))))+IKsqr(((((-1.09486780715397)*x1438))+(((3.1104199066874)*x1437))+(((-1.09486780715397)*r12*sj7))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x1439.value)*((((x1436*(r12*r12)))+(((-1.0)*x1436))+(((44.0)*r12*x1438))+(((-125.0)*r12*x1437))))), ((((-1.09486780715397)*x1438))+(((3.1104199066874)*x1437))+(((-1.09486780715397)*r12*sj7))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x1440=IKcos(j11);
IkReal x1441=IKsin(j11);
IkReal x1442=((0.643)*pz);
IkReal x1443=((0.352)*sj7);
IkReal x1444=(cj12*r10);
IkReal x1445=((0.352)*cj7);
IkReal x1446=(cj12*r00);
IkReal x1447=((1.0)*pz);
IkReal x1448=(cj12*r20);
IkReal x1449=(sj12*x1441);
IkReal x1450=((0.3215)*x1440);
IkReal x1451=((0.3215)*x1441);
evalcond[0]=((((-1.0)*r22*x1447))+((r12*x1443))+((r02*x1445))+x1450);
evalcond[1]=((((-1.0)*x1448*x1451))+(((0.3215)*r21*x1449))+(((-1.0)*x1447))+((r22*x1450)));
evalcond[2]=((((0.3215)*r01*x1449))+(((-1.0)*x1446*x1451))+x1445+((r02*x1450)));
evalcond[3]=((((0.3215)*r11*x1449))+((r12*x1450))+x1443+(((-1.0)*x1444*x1451)));
evalcond[4]=((0.0410835)+((r21*x1442*x1449))+(((-1.0)*x1441*x1442*x1448))+((r22*x1440*x1442)));
evalcond[5]=(((x1445*x1446))+((pz*r21*sj12))+((x1443*x1444))+(((-1.0)*x1451))+(((-1.0)*x1447*x1448))+(((-1.0)*r01*sj12*x1445))+(((-1.0)*r11*sj12*x1443)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x1452=(pz*r22);
IkReal x1453=(r12*sj7);
IkReal x1454=((44.0)*cj7);
CheckValue<IkReal> x1455=IKPowWithIntegerCheck(((((-40.1875)*cj12*r00))+(((40.1875)*r01*sj12))),-1);
if(!x1455.valid){
continue;
}
if( IKabs(((x1455.value)*((((x1454*(r02*r02)))+(((-1.0)*x1454))+(((-125.0)*r02*x1452))+(((44.0)*r02*x1453)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.09486780715397)*x1453))+(((-1.09486780715397)*cj7*r02))+(((3.1104199066874)*x1452)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1455.value)*((((x1454*(r02*r02)))+(((-1.0)*x1454))+(((-125.0)*r02*x1452))+(((44.0)*r02*x1453))))))+IKsqr(((((-1.09486780715397)*x1453))+(((-1.09486780715397)*cj7*r02))+(((3.1104199066874)*x1452))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x1455.value)*((((x1454*(r02*r02)))+(((-1.0)*x1454))+(((-125.0)*r02*x1452))+(((44.0)*r02*x1453))))), ((((-1.09486780715397)*x1453))+(((-1.09486780715397)*cj7*r02))+(((3.1104199066874)*x1452))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x1456=IKcos(j11);
IkReal x1457=IKsin(j11);
IkReal x1458=((0.643)*pz);
IkReal x1459=((0.352)*sj7);
IkReal x1460=(cj12*r10);
IkReal x1461=((0.352)*cj7);
IkReal x1462=(cj12*r00);
IkReal x1463=((1.0)*pz);
IkReal x1464=(cj12*r20);
IkReal x1465=(sj12*x1457);
IkReal x1466=((0.3215)*x1456);
IkReal x1467=((0.3215)*x1457);
evalcond[0]=((((-1.0)*r22*x1463))+((r12*x1459))+x1466+((r02*x1461)));
evalcond[1]=((((-1.0)*x1463))+(((-1.0)*x1464*x1467))+((r22*x1466))+(((0.3215)*r21*x1465)));
evalcond[2]=((((-1.0)*x1462*x1467))+x1461+((r02*x1466))+(((0.3215)*r01*x1465)));
evalcond[3]=(((r12*x1466))+(((-1.0)*x1460*x1467))+x1459+(((0.3215)*r11*x1465)));
evalcond[4]=((0.0410835)+((r21*x1458*x1465))+((r22*x1456*x1458))+(((-1.0)*x1457*x1458*x1464)));
evalcond[5]=(((pz*r21*sj12))+(((-1.0)*r11*sj12*x1459))+(((-1.0)*r01*sj12*x1461))+(((-1.0)*x1467))+((x1459*x1460))+((x1461*x1462))+(((-1.0)*x1463*x1464)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j11array[1], cj11array[1], sj11array[1];
bool j11valid[1]={false};
_nj11 = 1;
IkReal x1468=((0.352)*r22);
IkReal x1469=(r12*sj7);
IkReal x1470=(cj7*r02);
CheckValue<IkReal> x1471=IKPowWithIntegerCheck(((((-0.3215)*cj12*r20))+(((0.3215)*r21*sj12))),-1);
if(!x1471.valid){
continue;
}
if( IKabs(((x1471.value)*(((((-1.0)*pz*(r22*r22)))+((x1468*x1469))+pz+((x1468*x1470)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.09486780715397)*x1469))+(((-1.09486780715397)*x1470))+(((3.1104199066874)*pz*r22)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x1471.value)*(((((-1.0)*pz*(r22*r22)))+((x1468*x1469))+pz+((x1468*x1470))))))+IKsqr(((((-1.09486780715397)*x1469))+(((-1.09486780715397)*x1470))+(((3.1104199066874)*pz*r22))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j11array[0]=IKatan2(((x1471.value)*(((((-1.0)*pz*(r22*r22)))+((x1468*x1469))+pz+((x1468*x1470))))), ((((-1.09486780715397)*x1469))+(((-1.09486780715397)*x1470))+(((3.1104199066874)*pz*r22))));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
for(int ij11 = 0; ij11 < 1; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 1; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[6];
IkReal x1472=IKcos(j11);
IkReal x1473=IKsin(j11);
IkReal x1474=((0.643)*pz);
IkReal x1475=((0.352)*sj7);
IkReal x1476=(cj12*r10);
IkReal x1477=((0.352)*cj7);
IkReal x1478=(cj12*r00);
IkReal x1479=((1.0)*pz);
IkReal x1480=(cj12*r20);
IkReal x1481=(sj12*x1473);
IkReal x1482=((0.3215)*x1472);
IkReal x1483=((0.3215)*x1473);
evalcond[0]=((((-1.0)*r22*x1479))+((r12*x1475))+((r02*x1477))+x1482);
evalcond[1]=((((-1.0)*x1480*x1483))+(((-1.0)*x1479))+((r22*x1482))+(((0.3215)*r21*x1481)));
evalcond[2]=((((0.3215)*r01*x1481))+x1477+((r02*x1482))+(((-1.0)*x1478*x1483)));
evalcond[3]=(((r12*x1482))+x1475+(((0.3215)*r11*x1481))+(((-1.0)*x1476*x1483)));
evalcond[4]=((0.0410835)+((r21*x1474*x1481))+((r22*x1472*x1474))+(((-1.0)*x1473*x1474*x1480)));
evalcond[5]=(((pz*r21*sj12))+(((-1.0)*x1479*x1480))+(((-1.0)*x1483))+(((-1.0)*r01*sj12*x1477))+(((-1.0)*r11*sj12*x1475))+((x1477*x1478))+((x1475*x1476)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}

} else
{
{
IkReal j11array[2], cj11array[2], sj11array[2];
bool j11valid[2]={false};
_nj11 = 2;
IkReal x1484=((0.643)*pz);
IkReal x1485=((((-1.0)*cj12*r20*x1484))+((r21*sj12*x1484)));
CheckValue<IkReal> x1488 = IKatan2WithCheck(IkReal((r22*x1484)),IkReal(x1485),IKFAST_ATAN2_MAGTHRESH);
if(!x1488.valid){
continue;
}
IkReal x1486=((1.0)*(x1488.value));
if((((((0.413449)*(pz*pz)*(r22*r22)))+(x1485*x1485))) < -0.00001)
continue;
CheckValue<IkReal> x1489=IKPowWithIntegerCheck(IKabs(IKsqrt(((((0.413449)*(pz*pz)*(r22*r22)))+(x1485*x1485)))),-1);
if(!x1489.valid){
continue;
}
if( (((0.0410835)*(x1489.value))) < -1-IKFAST_SINCOS_THRESH || (((0.0410835)*(x1489.value))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x1487=IKasin(((0.0410835)*(x1489.value)));
j11array[0]=((((-1.0)*x1486))+(((-1.0)*x1487)));
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
j11array[1]=((3.14159265358979)+(((-1.0)*x1486))+x1487);
sj11array[1]=IKsin(j11array[1]);
cj11array[1]=IKcos(j11array[1]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
if( j11array[1] > IKPI )
{
    j11array[1]-=IK2PI;
}
else if( j11array[1] < -IKPI )
{    j11array[1]+=IK2PI;
}
j11valid[1] = true;
for(int ij11 = 0; ij11 < 2; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 2; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[1];
IkReal x1490=IKsin(j11);
IkReal x1491=((0.3215)*x1490);
evalcond[0]=(((r21*sj12*x1491))+(((-1.0)*pz))+(((0.3215)*r22*(IKcos(j11))))+(((-1.0)*cj12*r20*x1491)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j7array[1], cj7array[1], sj7array[1];
bool j7valid[1]={false};
_nj7 = 1;
IkReal x1492=((0.913352272727273)*cj11);
IkReal x1493=((0.913352272727273)*cj12*sj11);
IkReal x1494=((0.913352272727273)*sj11*sj12);
if( IKabs((((r10*x1493))+(((-1.0)*r12*x1492))+(((-1.0)*r11*x1494)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((r00*x1493))+(((-1.0)*r01*x1494))+(((-1.0)*r02*x1492)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((r10*x1493))+(((-1.0)*r12*x1492))+(((-1.0)*r11*x1494))))+IKsqr((((r00*x1493))+(((-1.0)*r01*x1494))+(((-1.0)*r02*x1492))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j7array[0]=IKatan2((((r10*x1493))+(((-1.0)*r12*x1492))+(((-1.0)*r11*x1494))), (((r00*x1493))+(((-1.0)*r01*x1494))+(((-1.0)*r02*x1492))));
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
for(int ij7 = 0; ij7 < 1; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 1; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];
{
IkReal evalcond[5];
IkReal x1495=IKcos(j7);
IkReal x1496=IKsin(j7);
IkReal x1497=(cj12*r00);
IkReal x1498=(r11*sj12);
IkReal x1499=(r01*sj12);
IkReal x1500=(cj12*r10);
IkReal x1501=((0.3215)*sj11);
IkReal x1502=((0.3215)*cj11);
IkReal x1503=((1.0)*pz);
IkReal x1504=((0.352)*x1495);
IkReal x1505=((0.352)*x1496);
IkReal x1506=(cj12*x1503);
evalcond[0]=((((-1.0)*r22*x1503))+((r12*x1505))+x1502+((r02*x1504)));
evalcond[1]=(((x1499*x1501))+x1504+((r02*x1502))+(((-1.0)*x1497*x1501)));
evalcond[2]=(((x1498*x1501))+((r12*x1502))+x1505+(((-1.0)*x1500*x1501)));
evalcond[3]=(((cj12*r01*x1504))+((cj12*r11*x1505))+((r00*sj12*x1504))+((r10*sj12*x1505))+(((-1.0)*r20*sj12*x1503))+(((-1.0)*r21*x1506)));
evalcond[4]=((((-1.0)*r20*x1506))+(((-1.0)*x1501))+(((-1.0)*x1499*x1504))+((pz*r21*sj12))+(((-1.0)*x1498*x1505))+((x1497*x1504))+((x1500*x1505)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}
}
}

}

}

} else
{
{
IkReal j11array[2], cj11array[2], sj11array[2];
bool j11valid[2]={false};
_nj11 = 2;
IkReal x1507=((((-0.3215)*cj12*r20))+(((0.3215)*r21*sj12)));
CheckValue<IkReal> x1510 = IKatan2WithCheck(IkReal(((0.3215)*r22)),IkReal(x1507),IKFAST_ATAN2_MAGTHRESH);
if(!x1510.valid){
continue;
}
IkReal x1508=((1.0)*(x1510.value));
if((((((0.10336225)*(r22*r22)))+(x1507*x1507))) < -0.00001)
continue;
CheckValue<IkReal> x1511=IKPowWithIntegerCheck(IKabs(IKsqrt(((((0.10336225)*(r22*r22)))+(x1507*x1507)))),-1);
if(!x1511.valid){
continue;
}
if( ((pz*(x1511.value))) < -1-IKFAST_SINCOS_THRESH || ((pz*(x1511.value))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x1509=IKasin((pz*(x1511.value)));
j11array[0]=((((-1.0)*x1508))+x1509);
sj11array[0]=IKsin(j11array[0]);
cj11array[0]=IKcos(j11array[0]);
j11array[1]=((3.14159265358979)+(((-1.0)*x1508))+(((-1.0)*x1509)));
sj11array[1]=IKsin(j11array[1]);
cj11array[1]=IKcos(j11array[1]);
if( j11array[0] > IKPI )
{
    j11array[0]-=IK2PI;
}
else if( j11array[0] < -IKPI )
{    j11array[0]+=IK2PI;
}
j11valid[0] = true;
if( j11array[1] > IKPI )
{
    j11array[1]-=IK2PI;
}
else if( j11array[1] < -IKPI )
{    j11array[1]+=IK2PI;
}
j11valid[1] = true;
for(int ij11 = 0; ij11 < 2; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 2; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];
{
IkReal evalcond[1];
IkReal x1512=IKsin(j11);
IkReal x1513=((0.643)*pz);
evalcond[0]=((0.0410835)+(((-1.0)*cj12*r20*x1512*x1513))+((r21*sj12*x1512*x1513))+((r22*x1513*(IKcos(j11)))));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j7array[1], cj7array[1], sj7array[1];
bool j7valid[1]={false};
_nj7 = 1;
IkReal x1514=((0.913352272727273)*cj11);
IkReal x1515=((0.913352272727273)*cj12*sj11);
IkReal x1516=((0.913352272727273)*sj11*sj12);
if( IKabs((((r10*x1515))+(((-1.0)*r11*x1516))+(((-1.0)*r12*x1514)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*r01*x1516))+((r00*x1515))+(((-1.0)*r02*x1514)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((r10*x1515))+(((-1.0)*r11*x1516))+(((-1.0)*r12*x1514))))+IKsqr(((((-1.0)*r01*x1516))+((r00*x1515))+(((-1.0)*r02*x1514))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j7array[0]=IKatan2((((r10*x1515))+(((-1.0)*r11*x1516))+(((-1.0)*r12*x1514))), ((((-1.0)*r01*x1516))+((r00*x1515))+(((-1.0)*r02*x1514))));
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
for(int ij7 = 0; ij7 < 1; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 1; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];
{
IkReal evalcond[5];
IkReal x1517=IKcos(j7);
IkReal x1518=IKsin(j7);
IkReal x1519=(cj12*r00);
IkReal x1520=(r11*sj12);
IkReal x1521=(r01*sj12);
IkReal x1522=(cj12*r10);
IkReal x1523=((0.3215)*sj11);
IkReal x1524=((0.3215)*cj11);
IkReal x1525=((1.0)*pz);
IkReal x1526=((0.352)*x1517);
IkReal x1527=((0.352)*x1518);
IkReal x1528=(cj12*x1525);
evalcond[0]=(((r12*x1527))+(((-1.0)*r22*x1525))+x1524+((r02*x1526)));
evalcond[1]=((((-1.0)*x1519*x1523))+x1526+((x1521*x1523))+((r02*x1524)));
evalcond[2]=(((r12*x1524))+((x1520*x1523))+x1527+(((-1.0)*x1522*x1523)));
evalcond[3]=(((cj12*r11*x1527))+((r10*sj12*x1527))+((r00*sj12*x1526))+((cj12*r01*x1526))+(((-1.0)*r20*sj12*x1525))+(((-1.0)*r21*x1528)));
evalcond[4]=(((pz*r21*sj12))+((x1519*x1526))+((x1522*x1527))+(((-1.0)*x1523))+(((-1.0)*r20*x1528))+(((-1.0)*x1520*x1527))+(((-1.0)*x1521*x1526)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}
}
}

}

}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j7, j11, j12]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j7array[2], cj7array[2], sj7array[2];
bool j7valid[2]={false};
_nj7 = 2;
CheckValue<IkReal> x1531 = IKatan2WithCheck(IkReal(((-0.704)*px)),IkReal(((-0.704)*py)),IKFAST_ATAN2_MAGTHRESH);
if(!x1531.valid){
continue;
}
IkReal x1529=((1.0)*(x1531.value));
if((((((0.495616)*(py*py)))+(((0.495616)*(px*px))))) < -0.00001)
continue;
CheckValue<IkReal> x1532=IKPowWithIntegerCheck(IKabs(IKsqrt(((((0.495616)*(py*py)))+(((0.495616)*(px*px)))))),-1);
if(!x1532.valid){
continue;
}
if( (((x1532.value)*(((0.02054175)+pp)))) < -1-IKFAST_SINCOS_THRESH || (((x1532.value)*(((0.02054175)+pp)))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x1530=IKasin(((x1532.value)*(((0.02054175)+pp))));
j7array[0]=((((-1.0)*x1530))+(((-1.0)*x1529)));
sj7array[0]=IKsin(j7array[0]);
cj7array[0]=IKcos(j7array[0]);
j7array[1]=((3.14159265358979)+(((-1.0)*x1529))+x1530);
sj7array[1]=IKsin(j7array[1]);
cj7array[1]=IKcos(j7array[1]);
if( j7array[0] > IKPI )
{
    j7array[0]-=IK2PI;
}
else if( j7array[0] < -IKPI )
{    j7array[0]+=IK2PI;
}
j7valid[0] = true;
if( j7array[1] > IKPI )
{
    j7array[1]-=IK2PI;
}
else if( j7array[1] < -IKPI )
{    j7array[1]+=IK2PI;
}
j7valid[1] = true;
for(int ij7 = 0; ij7 < 2; ++ij7)
{
if( !j7valid[ij7] )
{
    continue;
}
_ij7[0] = ij7; _ij7[1] = -1;
for(int iij7 = ij7+1; iij7 < 2; ++iij7)
{
if( j7valid[iij7] && IKabs(cj7array[ij7]-cj7array[iij7]) < IKFAST_SOLUTION_THRESH && IKabs(sj7array[ij7]-sj7array[iij7]) < IKFAST_SOLUTION_THRESH )
{
    j7valid[iij7]=false; _ij7[1] = iij7; break; 
}
}
j7 = j7array[ij7]; cj7 = cj7array[ij7]; sj7 = sj7array[ij7];

{
IkReal j11array[2], cj11array[2], sj11array[2];
bool j11valid[2]={false};
_nj11 = 2;
cj11array[0]=((((3.1104199066874)*npz))+(((-1.09486780715397)*cj7*r02))+(((-1.09486780715397)*r12*sj7)));
if( cj11array[0] >= -1-IKFAST_SINCOS_THRESH && cj11array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j11valid[0] = j11valid[1] = true;
    j11array[0] = IKacos(cj11array[0]);
    sj11array[0] = IKsin(j11array[0]);
    cj11array[1] = cj11array[0];
    j11array[1] = -j11array[0];
    sj11array[1] = -sj11array[0];
}
else if( std::isnan(cj11array[0]) )
{
    // probably any value will work
    j11valid[0] = true;
    cj11array[0] = 1; sj11array[0] = 0; j11array[0] = 0;
}
for(int ij11 = 0; ij11 < 2; ++ij11)
{
if( !j11valid[ij11] )
{
    continue;
}
_ij11[0] = ij11; _ij11[1] = -1;
for(int iij11 = ij11+1; iij11 < 2; ++iij11)
{
if( j11valid[iij11] && IKabs(cj11array[ij11]-cj11array[iij11]) < IKFAST_SOLUTION_THRESH && IKabs(sj11array[ij11]-sj11array[iij11]) < IKFAST_SOLUTION_THRESH )
{
    j11valid[iij11]=false; _ij11[1] = iij11; break; 
}
}
j11 = j11array[ij11]; cj11 = cj11array[ij11]; sj11 = sj11array[ij11];

{
IkReal j12eval[3];
IkReal x1533=(r02*sj11);
IkReal x1534=((643.0)*cj11);
IkReal x1535=((704.0)*sj7);
j12eval[0]=x1533;
j12eval[1]=IKsign(x1533);
j12eval[2]=((IKabs(((((-1.0)*r00*x1534))+((r21*x1535))+(((2000.0)*rxp1_0)))))+(IKabs((((r01*x1534))+((r20*x1535))+(((2000.0)*rxp0_0))))));
if( IKabs(j12eval[0]) < 0.0000010000000000  || IKabs(j12eval[1]) < 0.0000010000000000  || IKabs(j12eval[2]) < 0.0000010000000000  )
{
{
IkReal j12eval[3];
IkReal x1536=(r12*sj11);
IkReal x1537=((643.0)*cj11);
IkReal x1538=((704.0)*cj7);
j12eval[0]=x1536;
j12eval[1]=((IKabs(((((-2000.0)*rxp1_1))+((r10*x1537))+((r21*x1538)))))+(IKabs(((((-1.0)*r11*x1537))+((r20*x1538))+(((-2000.0)*rxp0_1))))));
j12eval[2]=IKsign(x1536);
if( IKabs(j12eval[0]) < 0.0000010000000000  || IKabs(j12eval[1]) < 0.0000010000000000  || IKabs(j12eval[2]) < 0.0000010000000000  )
{
{
IkReal j12eval[3];
IkReal x1539=((643.0)*cj11);
IkReal x1540=((2000.0)*pz);
IkReal x1541=((1000.0)*pp);
IkReal x1542=(npx*r21*sj11);
IkReal x1543=(npy*r20*sj11);
j12eval[0]=((((-1.0)*x1542))+x1543);
j12eval[1]=IKsign(((((-643.0)*x1542))+(((643.0)*x1543))));
j12eval[2]=((IKabs(((((-20.54175)*r20))+(((-1.0)*npz*r20*x1539))+((npx*r22*x1539))+(((-1.0)*npx*x1540))+((r20*x1541)))))+(IKabs(((((-20.54175)*r21))+((npy*r22*x1539))+((r21*x1541))+(((-1.0)*npy*x1540))+(((-1.0)*npz*r21*x1539))))));
if( IKabs(j12eval[0]) < 0.0000010000000000  || IKabs(j12eval[1]) < 0.0000010000000000  || IKabs(j12eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j11))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j12eval[1];
sj11=0;
cj11=1.0;
j11=0;
IkReal x1544=((0.352)*sj7);
IkReal x1545=((0.352)*cj7);
j12eval[0]=((IKabs((npy+(((-1.0)*r01*x1545))+(((-1.0)*r11*x1544)))))+(IKabs(((((-1.0)*npx))+((r10*x1544))+((r00*x1545))))));
if( IKabs(j12eval[0]) < 0.0000010000000000  )
{
{
IkReal j12eval[1];
sj11=0;
cj11=1.0;
j11=0;
IkReal x1546=((0.352)*sj7);
IkReal x1547=((0.352)*cj7);
j12eval[0]=((IKabs(((((-1.0)*npx))+((r10*x1546))+((r00*x1547)))))+(IKabs(((((-1.0)*npy))+((r11*x1546))+((r01*x1547))))));
if( IKabs(j12eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j12]

} else
{
{
IkReal j12array[2], cj12array[2], sj12array[2];
bool j12valid[2]={false};
_nj12 = 2;
IkReal x1548=((0.352)*sj7);
IkReal x1549=((0.352)*cj7);
CheckValue<IkReal> x1551 = IKatan2WithCheck(IkReal(((((-1.0)*npy))+((r11*x1548))+((r01*x1549)))),IkReal(((((-1.0)*npx))+((r10*x1548))+((r00*x1549)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1551.valid){
continue;
}
IkReal x1550=x1551.value;
j12array[0]=((-1.0)*x1550);
sj12array[0]=IKsin(j12array[0]);
cj12array[0]=IKcos(j12array[0]);
j12array[1]=((3.14159265358979)+(((-1.0)*x1550)));
sj12array[1]=IKsin(j12array[1]);
cj12array[1]=IKcos(j12array[1]);
if( j12array[0] > IKPI )
{
    j12array[0]-=IK2PI;
}
else if( j12array[0] < -IKPI )
{    j12array[0]+=IK2PI;
}
j12valid[0] = true;
if( j12array[1] > IKPI )
{
    j12array[1]-=IK2PI;
}
else if( j12array[1] < -IKPI )
{    j12array[1]+=IK2PI;
}
j12valid[1] = true;
for(int ij12 = 0; ij12 < 2; ++ij12)
{
if( !j12valid[ij12] )
{
    continue;
}
_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < 2; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
{
IkReal evalcond[1];
IkReal x1552=IKcos(j12);
IkReal x1553=IKsin(j12);
IkReal x1554=((0.352)*x1553);
IkReal x1555=((0.352)*x1552);
evalcond[0]=(((r10*sj7*x1555))+(((-1.0)*r11*sj7*x1554))+(((-1.0)*npx*x1552))+((npy*x1553))+((cj7*r00*x1555))+(((-1.0)*cj7*r01*x1554)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j12array[2], cj12array[2], sj12array[2];
bool j12valid[2]={false};
_nj12 = 2;
IkReal x1556=((0.352)*sj7);
IkReal x1557=((0.352)*cj7);
CheckValue<IkReal> x1559 = IKatan2WithCheck(IkReal((((r00*x1557))+(((-1.0)*npx))+((r10*x1556)))),IkReal((npy+(((-1.0)*r11*x1556))+(((-1.0)*r01*x1557)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1559.valid){
continue;
}
IkReal x1558=x1559.value;
j12array[0]=((-1.0)*x1558);
sj12array[0]=IKsin(j12array[0]);
cj12array[0]=IKcos(j12array[0]);
j12array[1]=((3.14159265358979)+(((-1.0)*x1558)));
sj12array[1]=IKsin(j12array[1]);
cj12array[1]=IKcos(j12array[1]);
if( j12array[0] > IKPI )
{
    j12array[0]-=IK2PI;
}
else if( j12array[0] < -IKPI )
{    j12array[0]+=IK2PI;
}
j12valid[0] = true;
if( j12array[1] > IKPI )
{
    j12array[1]-=IK2PI;
}
else if( j12array[1] < -IKPI )
{    j12array[1]+=IK2PI;
}
j12valid[1] = true;
for(int ij12 = 0; ij12 < 2; ++ij12)
{
if( !j12valid[ij12] )
{
    continue;
}
_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < 2; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
{
IkReal evalcond[1];
IkReal x1560=IKsin(j12);
IkReal x1561=IKcos(j12);
IkReal x1562=((0.352)*cj7);
IkReal x1563=((0.352)*sj7);
evalcond[0]=(((r10*x1560*x1563))+((r00*x1560*x1562))+(((-1.0)*npx*x1560))+((r01*x1561*x1562))+((r11*x1561*x1563))+(((-1.0)*npy*x1561)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j11)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j12eval[1];
sj11=0;
cj11=-1.0;
j11=3.14159265358979;
IkReal x1564=((0.352)*sj7);
IkReal x1565=((0.352)*cj7);
j12eval[0]=((IKabs((npy+(((-1.0)*r01*x1565))+(((-1.0)*r11*x1564)))))+(IKabs(((((-1.0)*npx))+((r10*x1564))+((r00*x1565))))));
if( IKabs(j12eval[0]) < 0.0000010000000000  )
{
{
IkReal j12eval[1];
sj11=0;
cj11=-1.0;
j11=3.14159265358979;
IkReal x1566=((0.352)*sj7);
IkReal x1567=((0.352)*cj7);
j12eval[0]=((IKabs(((((-1.0)*npy))+((r11*x1566))+((r01*x1567)))))+(IKabs(((((-1.0)*npx))+((r10*x1566))+((r00*x1567))))));
if( IKabs(j12eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j12]

} else
{
{
IkReal j12array[2], cj12array[2], sj12array[2];
bool j12valid[2]={false};
_nj12 = 2;
IkReal x1568=((0.352)*sj7);
IkReal x1569=((0.352)*cj7);
CheckValue<IkReal> x1571 = IKatan2WithCheck(IkReal(((((-1.0)*npy))+((r11*x1568))+((r01*x1569)))),IkReal(((((-1.0)*npx))+((r10*x1568))+((r00*x1569)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1571.valid){
continue;
}
IkReal x1570=x1571.value;
j12array[0]=((-1.0)*x1570);
sj12array[0]=IKsin(j12array[0]);
cj12array[0]=IKcos(j12array[0]);
j12array[1]=((3.14159265358979)+(((-1.0)*x1570)));
sj12array[1]=IKsin(j12array[1]);
cj12array[1]=IKcos(j12array[1]);
if( j12array[0] > IKPI )
{
    j12array[0]-=IK2PI;
}
else if( j12array[0] < -IKPI )
{    j12array[0]+=IK2PI;
}
j12valid[0] = true;
if( j12array[1] > IKPI )
{
    j12array[1]-=IK2PI;
}
else if( j12array[1] < -IKPI )
{    j12array[1]+=IK2PI;
}
j12valid[1] = true;
for(int ij12 = 0; ij12 < 2; ++ij12)
{
if( !j12valid[ij12] )
{
    continue;
}
_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < 2; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
{
IkReal evalcond[1];
IkReal x1572=IKcos(j12);
IkReal x1573=IKsin(j12);
IkReal x1574=((0.352)*x1573);
IkReal x1575=((0.352)*x1572);
evalcond[0]=(((r10*sj7*x1575))+(((-1.0)*r11*sj7*x1574))+(((-1.0)*npx*x1572))+((npy*x1573))+(((-1.0)*cj7*r01*x1574))+((cj7*r00*x1575)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j12array[2], cj12array[2], sj12array[2];
bool j12valid[2]={false};
_nj12 = 2;
IkReal x1576=((0.352)*sj7);
IkReal x1577=((0.352)*cj7);
CheckValue<IkReal> x1579 = IKatan2WithCheck(IkReal(((((-1.0)*npx))+((r10*x1576))+((r00*x1577)))),IkReal((npy+(((-1.0)*r01*x1577))+(((-1.0)*r11*x1576)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1579.valid){
continue;
}
IkReal x1578=x1579.value;
j12array[0]=((-1.0)*x1578);
sj12array[0]=IKsin(j12array[0]);
cj12array[0]=IKcos(j12array[0]);
j12array[1]=((3.14159265358979)+(((-1.0)*x1578)));
sj12array[1]=IKsin(j12array[1]);
cj12array[1]=IKcos(j12array[1]);
if( j12array[0] > IKPI )
{
    j12array[0]-=IK2PI;
}
else if( j12array[0] < -IKPI )
{    j12array[0]+=IK2PI;
}
j12valid[0] = true;
if( j12array[1] > IKPI )
{
    j12array[1]-=IK2PI;
}
else if( j12array[1] < -IKPI )
{    j12array[1]+=IK2PI;
}
j12valid[1] = true;
for(int ij12 = 0; ij12 < 2; ++ij12)
{
if( !j12valid[ij12] )
{
    continue;
}
_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < 2; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
{
IkReal evalcond[1];
IkReal x1580=IKsin(j12);
IkReal x1581=IKcos(j12);
IkReal x1582=((0.352)*cj7);
IkReal x1583=((0.352)*sj7);
evalcond[0]=((((-1.0)*npy*x1581))+((r11*x1581*x1583))+((r10*x1580*x1583))+(((-1.0)*npx*x1580))+((r00*x1580*x1582))+((r01*x1581*x1582)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(r02);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j12eval[3];
r02=0;
npz=(((py*r12))+((pz*r22)));
rxp2_1=(px*r22);
rxp2_2=((-1.0)*px*r12);
IkReal x1584=(r12*sj11);
IkReal x1585=((704.0)*cj7);
IkReal x1586=((643.0)*cj11*r22);
j12eval[0]=x1584;
j12eval[1]=IKsign(x1584);
j12eval[2]=((IKabs(((((-2000.0)*rxp1_1))+(((-1.0)*r01*x1586))+((r21*x1585)))))+(IKabs((((r20*x1585))+(((-1.0)*r00*x1586))+(((-2000.0)*rxp0_1))))));
if( IKabs(j12eval[0]) < 0.0000010000000000  || IKabs(j12eval[1]) < 0.0000010000000000  || IKabs(j12eval[2]) < 0.0000010000000000  )
{
{
IkReal j12eval[3];
r02=0;
npz=(((py*r12))+((pz*r22)));
rxp2_1=(px*r22);
rxp2_2=((-1.0)*px*r12);
IkReal x1587=(r22*sj11);
IkReal x1588=((704.0)*cj7);
IkReal x1589=((704.0)*sj7);
IkReal x1590=((643.0)*cj11*r12);
j12eval[0]=x1587;
j12eval[1]=IKsign(x1587);
j12eval[2]=((IKabs(((((-1.0)*r00*x1590))+(((-1.0)*r00*x1589))+(((2000.0)*rxp0_2))+((r10*x1588)))))+(IKabs((((r11*x1588))+(((-1.0)*r01*x1590))+(((-1.0)*r01*x1589))+(((2000.0)*rxp1_2))))));
if( IKabs(j12eval[0]) < 0.0000010000000000  || IKabs(j12eval[1]) < 0.0000010000000000  || IKabs(j12eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j11))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j12eval[1];
r02=0;
npz=(((py*r12))+((pz*r22)));
rxp2_1=(px*r22);
rxp2_2=((-1.0)*px*r12);
sj11=0;
cj11=1.0;
j11=0;
IkReal x1591=((0.352)*sj7);
IkReal x1592=((0.352)*cj7);
j12eval[0]=((IKabs((((r00*x1592))+(((-1.0)*npx))+((r10*x1591)))))+(IKabs((npy+(((-1.0)*r01*x1592))+(((-1.0)*r11*x1591))))));
if( IKabs(j12eval[0]) < 0.0000010000000000  )
{
{
IkReal j12eval[1];
r02=0;
npz=(((py*r12))+((pz*r22)));
rxp2_1=(px*r22);
rxp2_2=((-1.0)*px*r12);
sj11=0;
cj11=1.0;
j11=0;
IkReal x1593=((0.352)*sj7);
IkReal x1594=((0.352)*cj7);
j12eval[0]=((IKabs((((r00*x1594))+(((-1.0)*npx))+((r10*x1593)))))+(IKabs((((r01*x1594))+((r11*x1593))+(((-1.0)*npy))))));
if( IKabs(j12eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j12]

} else
{
{
IkReal j12array[2], cj12array[2], sj12array[2];
bool j12valid[2]={false};
_nj12 = 2;
IkReal x1595=((0.352)*sj7);
IkReal x1596=((0.352)*cj7);
CheckValue<IkReal> x1598 = IKatan2WithCheck(IkReal((((r01*x1596))+((r11*x1595))+(((-1.0)*npy)))),IkReal((((r00*x1596))+(((-1.0)*npx))+((r10*x1595)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1598.valid){
continue;
}
IkReal x1597=x1598.value;
j12array[0]=((-1.0)*x1597);
sj12array[0]=IKsin(j12array[0]);
cj12array[0]=IKcos(j12array[0]);
j12array[1]=((3.14159265358979)+(((-1.0)*x1597)));
sj12array[1]=IKsin(j12array[1]);
cj12array[1]=IKcos(j12array[1]);
if( j12array[0] > IKPI )
{
    j12array[0]-=IK2PI;
}
else if( j12array[0] < -IKPI )
{    j12array[0]+=IK2PI;
}
j12valid[0] = true;
if( j12array[1] > IKPI )
{
    j12array[1]-=IK2PI;
}
else if( j12array[1] < -IKPI )
{    j12array[1]+=IK2PI;
}
j12valid[1] = true;
for(int ij12 = 0; ij12 < 2; ++ij12)
{
if( !j12valid[ij12] )
{
    continue;
}
_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < 2; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
{
IkReal evalcond[1];
IkReal x1599=IKcos(j12);
IkReal x1600=IKsin(j12);
IkReal x1601=((0.352)*x1600);
IkReal x1602=((0.352)*x1599);
evalcond[0]=(((npy*x1600))+(((-1.0)*r11*sj7*x1601))+((r10*sj7*x1602))+((cj7*r00*x1602))+(((-1.0)*cj7*r01*x1601))+(((-1.0)*npx*x1599)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j12array[2], cj12array[2], sj12array[2];
bool j12valid[2]={false};
_nj12 = 2;
IkReal x1603=((0.352)*sj7);
IkReal x1604=((0.352)*cj7);
CheckValue<IkReal> x1606 = IKatan2WithCheck(IkReal((((r00*x1604))+(((-1.0)*npx))+((r10*x1603)))),IkReal((npy+(((-1.0)*r01*x1604))+(((-1.0)*r11*x1603)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1606.valid){
continue;
}
IkReal x1605=x1606.value;
j12array[0]=((-1.0)*x1605);
sj12array[0]=IKsin(j12array[0]);
cj12array[0]=IKcos(j12array[0]);
j12array[1]=((3.14159265358979)+(((-1.0)*x1605)));
sj12array[1]=IKsin(j12array[1]);
cj12array[1]=IKcos(j12array[1]);
if( j12array[0] > IKPI )
{
    j12array[0]-=IK2PI;
}
else if( j12array[0] < -IKPI )
{    j12array[0]+=IK2PI;
}
j12valid[0] = true;
if( j12array[1] > IKPI )
{
    j12array[1]-=IK2PI;
}
else if( j12array[1] < -IKPI )
{    j12array[1]+=IK2PI;
}
j12valid[1] = true;
for(int ij12 = 0; ij12 < 2; ++ij12)
{
if( !j12valid[ij12] )
{
    continue;
}
_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < 2; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
{
IkReal evalcond[1];
IkReal x1607=IKsin(j12);
IkReal x1608=IKcos(j12);
IkReal x1609=((0.352)*cj7);
IkReal x1610=((0.352)*sj7);
evalcond[0]=(((r10*x1607*x1610))+(((-1.0)*npy*x1608))+((r01*x1608*x1609))+((r00*x1607*x1609))+((r11*x1608*x1610))+(((-1.0)*npx*x1607)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j11)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j12eval[1];
r02=0;
npz=(((py*r12))+((pz*r22)));
rxp2_1=(px*r22);
rxp2_2=((-1.0)*px*r12);
sj11=0;
cj11=-1.0;
j11=3.14159265358979;
IkReal x1611=((0.352)*sj7);
IkReal x1612=((0.352)*cj7);
j12eval[0]=((IKabs((((r00*x1612))+(((-1.0)*npx))+((r10*x1611)))))+(IKabs(((((-1.0)*r11*x1611))+(((-1.0)*r01*x1612))+npy))));
if( IKabs(j12eval[0]) < 0.0000010000000000  )
{
{
IkReal j12eval[1];
r02=0;
npz=(((py*r12))+((pz*r22)));
rxp2_1=(px*r22);
rxp2_2=((-1.0)*px*r12);
sj11=0;
cj11=-1.0;
j11=3.14159265358979;
IkReal x1613=((0.352)*sj7);
IkReal x1614=((0.352)*cj7);
j12eval[0]=((IKabs((((r00*x1614))+(((-1.0)*npx))+((r10*x1613)))))+(IKabs((((r01*x1614))+(((-1.0)*npy))+((r11*x1613))))));
if( IKabs(j12eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j12]

} else
{
{
IkReal j12array[2], cj12array[2], sj12array[2];
bool j12valid[2]={false};
_nj12 = 2;
IkReal x1615=((0.352)*sj7);
IkReal x1616=((0.352)*cj7);
CheckValue<IkReal> x1618 = IKatan2WithCheck(IkReal((((r01*x1616))+(((-1.0)*npy))+((r11*x1615)))),IkReal((((r00*x1616))+(((-1.0)*npx))+((r10*x1615)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1618.valid){
continue;
}
IkReal x1617=x1618.value;
j12array[0]=((-1.0)*x1617);
sj12array[0]=IKsin(j12array[0]);
cj12array[0]=IKcos(j12array[0]);
j12array[1]=((3.14159265358979)+(((-1.0)*x1617)));
sj12array[1]=IKsin(j12array[1]);
cj12array[1]=IKcos(j12array[1]);
if( j12array[0] > IKPI )
{
    j12array[0]-=IK2PI;
}
else if( j12array[0] < -IKPI )
{    j12array[0]+=IK2PI;
}
j12valid[0] = true;
if( j12array[1] > IKPI )
{
    j12array[1]-=IK2PI;
}
else if( j12array[1] < -IKPI )
{    j12array[1]+=IK2PI;
}
j12valid[1] = true;
for(int ij12 = 0; ij12 < 2; ++ij12)
{
if( !j12valid[ij12] )
{
    continue;
}
_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < 2; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
{
IkReal evalcond[1];
IkReal x1619=IKcos(j12);
IkReal x1620=IKsin(j12);
IkReal x1621=((0.352)*x1620);
IkReal x1622=((0.352)*x1619);
evalcond[0]=((((-1.0)*npx*x1619))+((npy*x1620))+((cj7*r00*x1622))+(((-1.0)*r11*sj7*x1621))+(((-1.0)*cj7*r01*x1621))+((r10*sj7*x1622)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j12array[2], cj12array[2], sj12array[2];
bool j12valid[2]={false};
_nj12 = 2;
IkReal x1623=((0.352)*sj7);
IkReal x1624=((0.352)*cj7);
CheckValue<IkReal> x1626 = IKatan2WithCheck(IkReal((((r00*x1624))+(((-1.0)*npx))+((r10*x1623)))),IkReal(((((-1.0)*r11*x1623))+npy+(((-1.0)*r01*x1624)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1626.valid){
continue;
}
IkReal x1625=x1626.value;
j12array[0]=((-1.0)*x1625);
sj12array[0]=IKsin(j12array[0]);
cj12array[0]=IKcos(j12array[0]);
j12array[1]=((3.14159265358979)+(((-1.0)*x1625)));
sj12array[1]=IKsin(j12array[1]);
cj12array[1]=IKcos(j12array[1]);
if( j12array[0] > IKPI )
{
    j12array[0]-=IK2PI;
}
else if( j12array[0] < -IKPI )
{    j12array[0]+=IK2PI;
}
j12valid[0] = true;
if( j12array[1] > IKPI )
{
    j12array[1]-=IK2PI;
}
else if( j12array[1] < -IKPI )
{    j12array[1]+=IK2PI;
}
j12valid[1] = true;
for(int ij12 = 0; ij12 < 2; ++ij12)
{
if( !j12valid[ij12] )
{
    continue;
}
_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < 2; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
{
IkReal evalcond[1];
IkReal x1627=IKsin(j12);
IkReal x1628=IKcos(j12);
IkReal x1629=((0.352)*cj7);
IkReal x1630=((0.352)*sj7);
evalcond[0]=((((-1.0)*npx*x1627))+((r11*x1628*x1630))+(((-1.0)*npy*x1628))+((r10*x1627*x1630))+((r01*x1628*x1629))+((r00*x1627*x1629)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=IKabs(r12);
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j12eval[3];
r02=0;
npz=(pz*r22);
rxp2_1=(px*r22);
rxp2_2=0;
r12=0;
rxp2_0=((-1.0)*py*r22);
IkReal x1631=(r22*sj11);
IkReal x1632=((704.0)*cj7);
IkReal x1633=((704.0)*sj7);
j12eval[0]=x1631;
j12eval[1]=((IKabs((((r10*x1632))+(((-1.0)*r00*x1633))+(((2000.0)*rxp0_2)))))+(IKabs(((((-1.0)*r01*x1633))+((r11*x1632))+(((2000.0)*rxp1_2))))));
j12eval[2]=IKsign(x1631);
if( IKabs(j12eval[0]) < 0.0000010000000000  || IKabs(j12eval[1]) < 0.0000010000000000  || IKabs(j12eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j11))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j12eval[1];
r02=0;
npz=(pz*r22);
rxp2_1=(px*r22);
rxp2_2=0;
r12=0;
rxp2_0=((-1.0)*py*r22);
sj11=0;
cj11=1.0;
j11=0;
j12eval[0]=((IKabs((pz*r20)))+(IKabs((pz*r21))));
if( IKabs(j12eval[0]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j12array[2], cj12array[2], sj12array[2];
bool j12valid[2]={false};
_nj12 = 2;
CheckValue<IkReal> x1635 = IKatan2WithCheck(IkReal((((px*r01))+(((-1.0)*npy))+((py*r11)))),IkReal((((px*r00))+(((-1.0)*npx))+((py*r10)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1635.valid){
continue;
}
IkReal x1634=x1635.value;
j12array[0]=((-1.0)*x1634);
sj12array[0]=IKsin(j12array[0]);
cj12array[0]=IKcos(j12array[0]);
j12array[1]=((3.14159265358979)+(((-1.0)*x1634)));
sj12array[1]=IKsin(j12array[1]);
cj12array[1]=IKcos(j12array[1]);
if( j12array[0] > IKPI )
{
    j12array[0]-=IK2PI;
}
else if( j12array[0] < -IKPI )
{    j12array[0]+=IK2PI;
}
j12valid[0] = true;
if( j12array[1] > IKPI )
{
    j12array[1]-=IK2PI;
}
else if( j12array[1] < -IKPI )
{    j12array[1]+=IK2PI;
}
j12valid[1] = true;
for(int ij12 = 0; ij12 < 2; ++ij12)
{
if( !j12valid[ij12] )
{
    continue;
}
_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < 2; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
{
IkReal evalcond[1];
IkReal x1636=IKcos(j12);
IkReal x1637=IKsin(j12);
IkReal x1638=((1.0)*x1637);
evalcond[0]=((((-1.0)*npx*x1636))+((py*r10*x1636))+((px*r00*x1636))+(((-1.0)*px*r01*x1638))+(((-1.0)*py*r11*x1638))+((npy*x1637)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j11)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j12eval[1];
r02=0;
npz=(pz*r22);
rxp2_1=(px*r22);
rxp2_2=0;
r12=0;
rxp2_0=((-1.0)*py*r22);
sj11=0;
cj11=-1.0;
j11=3.14159265358979;
j12eval[0]=((IKabs((pz*r20)))+(IKabs((pz*r21))));
if( IKabs(j12eval[0]) < 0.0000010000000000  )
{
continue; // 3 cases reached

} else
{
{
IkReal j12array[2], cj12array[2], sj12array[2];
bool j12valid[2]={false};
_nj12 = 2;
CheckValue<IkReal> x1640 = IKatan2WithCheck(IkReal((((px*r01))+(((-1.0)*npy))+((py*r11)))),IkReal((((px*r00))+(((-1.0)*npx))+((py*r10)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1640.valid){
continue;
}
IkReal x1639=x1640.value;
j12array[0]=((-1.0)*x1639);
sj12array[0]=IKsin(j12array[0]);
cj12array[0]=IKcos(j12array[0]);
j12array[1]=((3.14159265358979)+(((-1.0)*x1639)));
sj12array[1]=IKsin(j12array[1]);
cj12array[1]=IKcos(j12array[1]);
if( j12array[0] > IKPI )
{
    j12array[0]-=IK2PI;
}
else if( j12array[0] < -IKPI )
{    j12array[0]+=IK2PI;
}
j12valid[0] = true;
if( j12array[1] > IKPI )
{
    j12array[1]-=IK2PI;
}
else if( j12array[1] < -IKPI )
{    j12array[1]+=IK2PI;
}
j12valid[1] = true;
for(int ij12 = 0; ij12 < 2; ++ij12)
{
if( !j12valid[ij12] )
{
    continue;
}
_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < 2; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
{
IkReal evalcond[1];
IkReal x1641=IKcos(j12);
IkReal x1642=IKsin(j12);
IkReal x1643=((1.0)*x1642);
evalcond[0]=(((px*r00*x1641))+(((-1.0)*py*r11*x1643))+(((-1.0)*npx*x1641))+((py*r10*x1641))+(((-1.0)*px*r01*x1643))+((npy*x1642)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j12]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}

} else
{
{
IkReal j12array[1], cj12array[1], sj12array[1];
bool j12valid[1]={false};
_nj12 = 1;
IkReal x1644=((704.0)*cj7);
IkReal x1645=((704.0)*sj7);
CheckValue<IkReal> x1646 = IKatan2WithCheck(IkReal(((((-1.0)*r00*x1645))+((r10*x1644))+(((2000.0)*rxp0_2)))),IkReal((((r11*x1644))+(((-1.0)*r01*x1645))+(((2000.0)*rxp1_2)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1646.valid){
continue;
}
CheckValue<IkReal> x1647=IKPowWithIntegerCheck(IKsign((r22*sj11)),-1);
if(!x1647.valid){
continue;
}
j12array[0]=((-1.5707963267949)+(x1646.value)+(((1.5707963267949)*(x1647.value))));
sj12array[0]=IKsin(j12array[0]);
cj12array[0]=IKcos(j12array[0]);
if( j12array[0] > IKPI )
{
    j12array[0]-=IK2PI;
}
else if( j12array[0] < -IKPI )
{    j12array[0]+=IK2PI;
}
j12valid[0] = true;
for(int ij12 = 0; ij12 < 1; ++ij12)
{
if( !j12valid[ij12] )
{
    continue;
}
_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < 1; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
{
IkReal evalcond[6];
IkReal x1648=IKsin(j12);
IkReal x1649=IKcos(j12);
IkReal x1650=((0.3215)*sj11);
IkReal x1651=((1.0)*npx);
IkReal x1652=(cj7*r01);
IkReal x1653=((0.643)*sj11);
IkReal x1654=(cj11*r22);
IkReal x1655=((0.352)*sj7);
IkReal x1656=((0.352)*cj7*r00);
IkReal x1657=(npy*x1648);
IkReal x1658=((0.352)*x1649);
IkReal x1659=(r11*x1648);
evalcond[0]=((((-1.0)*px))+(((-1.0)*r00*x1649*x1650))+(((0.352)*cj7))+((r01*x1648*x1650)));
evalcond[1]=(((x1650*x1659))+x1655+(((-1.0)*r10*x1649*x1650))+(((-1.0)*py)));
evalcond[2]=(((r21*x1648*x1650))+(((-1.0)*pz))+(((-1.0)*r20*x1649*x1650))+(((0.3215)*x1654)));
evalcond[3]=((0.02054175)+(((-1.0)*pp))+(((-1.0)*npx*x1649*x1653))+(((0.643)*pz*x1654))+((x1653*x1657)));
evalcond[4]=((((-1.0)*npy*x1649))+((x1648*x1656))+((r10*x1648*x1655))+((r11*x1649*x1655))+(((-1.0)*x1648*x1651))+((x1652*x1658)));
evalcond[5]=(x1657+(((-1.0)*x1655*x1659))+((x1649*x1656))+(((-1.0)*x1650))+(((-0.352)*x1648*x1652))+((r10*x1649*x1655))+(((-1.0)*x1649*x1651)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j12]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j12array[1], cj12array[1], sj12array[1];
bool j12valid[1]={false};
_nj12 = 1;
IkReal x1660=((704.0)*cj7);
IkReal x1661=((704.0)*sj7);
IkReal x1662=((643.0)*cj11*r12);
CheckValue<IkReal> x1663 = IKatan2WithCheck(IkReal(((((-1.0)*r00*x1662))+(((-1.0)*r00*x1661))+((r10*x1660))+(((2000.0)*rxp0_2)))),IkReal(((((-1.0)*r01*x1662))+(((-1.0)*r01*x1661))+((r11*x1660))+(((2000.0)*rxp1_2)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1663.valid){
continue;
}
CheckValue<IkReal> x1664=IKPowWithIntegerCheck(IKsign((r22*sj11)),-1);
if(!x1664.valid){
continue;
}
j12array[0]=((-1.5707963267949)+(x1663.value)+(((1.5707963267949)*(x1664.value))));
sj12array[0]=IKsin(j12array[0]);
cj12array[0]=IKcos(j12array[0]);
if( j12array[0] > IKPI )
{
    j12array[0]-=IK2PI;
}
else if( j12array[0] < -IKPI )
{    j12array[0]+=IK2PI;
}
j12valid[0] = true;
for(int ij12 = 0; ij12 < 1; ++ij12)
{
if( !j12valid[ij12] )
{
    continue;
}
_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < 1; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
{
IkReal evalcond[6];
IkReal x1665=IKsin(j12);
IkReal x1666=IKcos(j12);
IkReal x1667=((0.3215)*sj11);
IkReal x1668=((0.352)*cj7);
IkReal x1669=((1.0)*npx);
IkReal x1670=((0.643)*sj11);
IkReal x1671=(cj11*r22);
IkReal x1672=(cj11*r12);
IkReal x1673=((0.352)*sj7);
IkReal x1674=(npy*x1665);
IkReal x1675=(r11*x1673);
IkReal x1676=(r10*x1666);
IkReal x1677=(r01*x1665);
IkReal x1678=(r00*x1666);
evalcond[0]=((((-1.0)*x1667*x1678))+x1668+((x1667*x1677))+(((-1.0)*px)));
evalcond[1]=(((r21*x1665*x1667))+(((-1.0)*pz))+(((0.3215)*x1671))+(((-1.0)*r20*x1666*x1667)));
evalcond[2]=((((-1.0)*x1667*x1676))+x1673+(((-1.0)*py))+(((0.3215)*x1672))+((r11*x1665*x1667)));
evalcond[3]=((0.02054175)+(((0.643)*py*x1672))+(((0.643)*pz*x1671))+(((-1.0)*pp))+(((-1.0)*npx*x1666*x1670))+((x1670*x1674)));
evalcond[4]=(((x1666*x1675))+((r00*x1665*x1668))+((r01*x1666*x1668))+((r10*x1665*x1673))+(((-1.0)*npy*x1666))+(((-1.0)*x1665*x1669)));
evalcond[5]=((((-1.0)*x1668*x1677))+x1674+((x1673*x1676))+((x1668*x1678))+(((-1.0)*x1667))+(((-1.0)*x1665*x1675))+(((-1.0)*x1666*x1669)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j12array[1], cj12array[1], sj12array[1];
bool j12valid[1]={false};
_nj12 = 1;
IkReal x1679=((704.0)*cj7);
IkReal x1680=((643.0)*cj11*r22);
CheckValue<IkReal> x1681=IKPowWithIntegerCheck(IKsign((r12*sj11)),-1);
if(!x1681.valid){
continue;
}
CheckValue<IkReal> x1682 = IKatan2WithCheck(IkReal((((r20*x1679))+(((-2000.0)*rxp0_1))+(((-1.0)*r00*x1680)))),IkReal((((r21*x1679))+(((-1.0)*r01*x1680))+(((-2000.0)*rxp1_1)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1682.valid){
continue;
}
j12array[0]=((-1.5707963267949)+(((-1.5707963267949)*(x1681.value)))+(x1682.value));
sj12array[0]=IKsin(j12array[0]);
cj12array[0]=IKcos(j12array[0]);
if( j12array[0] > IKPI )
{
    j12array[0]-=IK2PI;
}
else if( j12array[0] < -IKPI )
{    j12array[0]+=IK2PI;
}
j12valid[0] = true;
for(int ij12 = 0; ij12 < 1; ++ij12)
{
if( !j12valid[ij12] )
{
    continue;
}
_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < 1; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
{
IkReal evalcond[6];
IkReal x1683=IKsin(j12);
IkReal x1684=IKcos(j12);
IkReal x1685=((0.3215)*sj11);
IkReal x1686=((0.352)*cj7);
IkReal x1687=((1.0)*npx);
IkReal x1688=((0.643)*sj11);
IkReal x1689=(cj11*r22);
IkReal x1690=(cj11*r12);
IkReal x1691=((0.352)*sj7);
IkReal x1692=(npy*x1683);
IkReal x1693=(r11*x1691);
IkReal x1694=(r10*x1684);
IkReal x1695=(r01*x1683);
IkReal x1696=(r00*x1684);
evalcond[0]=(x1686+(((-1.0)*px))+((x1685*x1695))+(((-1.0)*x1685*x1696)));
evalcond[1]=((((-1.0)*r20*x1684*x1685))+((r21*x1683*x1685))+(((-1.0)*pz))+(((0.3215)*x1689)));
evalcond[2]=(x1691+(((-1.0)*py))+((r11*x1683*x1685))+(((0.3215)*x1690))+(((-1.0)*x1685*x1694)));
evalcond[3]=((0.02054175)+(((-1.0)*pp))+((x1688*x1692))+(((-1.0)*npx*x1684*x1688))+(((0.643)*pz*x1689))+(((0.643)*py*x1690)));
evalcond[4]=(((r10*x1683*x1691))+(((-1.0)*x1683*x1687))+(((-1.0)*npy*x1684))+((r01*x1684*x1686))+((r00*x1683*x1686))+((x1684*x1693)));
evalcond[5]=((((-1.0)*x1686*x1695))+(((-1.0)*x1685))+x1692+((x1691*x1694))+((x1686*x1696))+(((-1.0)*x1683*x1693))+(((-1.0)*x1684*x1687)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j12]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j12array[1], cj12array[1], sj12array[1];
bool j12valid[1]={false};
_nj12 = 1;
IkReal x1697=((643.0)*cj11);
IkReal x1698=((2000.0)*pz);
IkReal x1699=((643.0)*sj11);
IkReal x1700=((1000.0)*pp);
CheckValue<IkReal> x1701=IKPowWithIntegerCheck(IKsign((((npy*r20*x1699))+(((-1.0)*npx*r21*x1699)))),-1);
if(!x1701.valid){
continue;
}
CheckValue<IkReal> x1702 = IKatan2WithCheck(IkReal(((((-20.54175)*r20))+(((-1.0)*npz*r20*x1697))+(((-1.0)*npx*x1698))+((r20*x1700))+((npx*r22*x1697)))),IkReal(((((-20.54175)*r21))+(((-1.0)*npy*x1698))+((npy*r22*x1697))+((r21*x1700))+(((-1.0)*npz*r21*x1697)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1702.valid){
continue;
}
j12array[0]=((-1.5707963267949)+(((1.5707963267949)*(x1701.value)))+(x1702.value));
sj12array[0]=IKsin(j12array[0]);
cj12array[0]=IKcos(j12array[0]);
if( j12array[0] > IKPI )
{
    j12array[0]-=IK2PI;
}
else if( j12array[0] < -IKPI )
{    j12array[0]+=IK2PI;
}
j12valid[0] = true;
for(int ij12 = 0; ij12 < 1; ++ij12)
{
if( !j12valid[ij12] )
{
    continue;
}
_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < 1; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
{
IkReal evalcond[6];
IkReal x1703=IKsin(j12);
IkReal x1704=IKcos(j12);
IkReal x1705=((0.3215)*sj11);
IkReal x1706=((0.352)*cj7);
IkReal x1707=((1.0)*npx);
IkReal x1708=((0.3215)*cj11);
IkReal x1709=((0.643)*sj11);
IkReal x1710=((0.352)*sj7);
IkReal x1711=(npy*x1703);
IkReal x1712=(r11*x1710);
IkReal x1713=(r01*x1703);
IkReal x1714=(r10*x1704);
IkReal x1715=(r00*x1704);
evalcond[0]=(((r22*x1708))+(((-1.0)*r20*x1704*x1705))+(((-1.0)*pz))+((r21*x1703*x1705)));
evalcond[1]=((0.02054175)+(((0.643)*cj11*npz))+((x1709*x1711))+(((-1.0)*npx*x1704*x1709))+(((-1.0)*pp)));
evalcond[2]=(((r02*x1708))+x1706+(((-1.0)*px))+(((-1.0)*x1705*x1715))+((x1705*x1713)));
evalcond[3]=(((r11*x1703*x1705))+((r12*x1708))+x1710+(((-1.0)*py))+(((-1.0)*x1705*x1714)));
evalcond[4]=((((-1.0)*x1703*x1707))+((x1704*x1712))+((r10*x1703*x1710))+(((-1.0)*npy*x1704))+((r00*x1703*x1706))+((r01*x1704*x1706)));
evalcond[5]=(((x1710*x1714))+x1711+(((-1.0)*x1705))+(((-1.0)*x1704*x1707))+(((-1.0)*x1706*x1713))+((x1706*x1715))+(((-1.0)*x1703*x1712)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j12array[1], cj12array[1], sj12array[1];
bool j12valid[1]={false};
_nj12 = 1;
IkReal x1716=((643.0)*cj11);
IkReal x1717=((704.0)*cj7);
CheckValue<IkReal> x1718=IKPowWithIntegerCheck(IKsign((r12*sj11)),-1);
if(!x1718.valid){
continue;
}
CheckValue<IkReal> x1719 = IKatan2WithCheck(IkReal((((r20*x1717))+(((-1.0)*r11*x1716))+(((-2000.0)*rxp0_1)))),IkReal(((((-2000.0)*rxp1_1))+((r10*x1716))+((r21*x1717)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1719.valid){
continue;
}
j12array[0]=((-1.5707963267949)+(((-1.5707963267949)*(x1718.value)))+(x1719.value));
sj12array[0]=IKsin(j12array[0]);
cj12array[0]=IKcos(j12array[0]);
if( j12array[0] > IKPI )
{
    j12array[0]-=IK2PI;
}
else if( j12array[0] < -IKPI )
{    j12array[0]+=IK2PI;
}
j12valid[0] = true;
for(int ij12 = 0; ij12 < 1; ++ij12)
{
if( !j12valid[ij12] )
{
    continue;
}
_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < 1; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
{
IkReal evalcond[6];
IkReal x1720=IKsin(j12);
IkReal x1721=IKcos(j12);
IkReal x1722=((0.3215)*sj11);
IkReal x1723=((0.352)*cj7);
IkReal x1724=((1.0)*npx);
IkReal x1725=((0.3215)*cj11);
IkReal x1726=((0.643)*sj11);
IkReal x1727=((0.352)*sj7);
IkReal x1728=(npy*x1720);
IkReal x1729=(r11*x1727);
IkReal x1730=(r01*x1720);
IkReal x1731=(r10*x1721);
IkReal x1732=(r00*x1721);
evalcond[0]=(((r22*x1725))+(((-1.0)*pz))+((r21*x1720*x1722))+(((-1.0)*r20*x1721*x1722)));
evalcond[1]=((0.02054175)+(((0.643)*cj11*npz))+(((-1.0)*npx*x1721*x1726))+((x1726*x1728))+(((-1.0)*pp)));
evalcond[2]=(((x1722*x1730))+x1723+(((-1.0)*x1722*x1732))+((r02*x1725))+(((-1.0)*px)));
evalcond[3]=(x1727+((r11*x1720*x1722))+(((-1.0)*x1722*x1731))+(((-1.0)*py))+((r12*x1725)));
evalcond[4]=((((-1.0)*npy*x1721))+((r10*x1720*x1727))+((x1721*x1729))+(((-1.0)*x1720*x1724))+((r00*x1720*x1723))+((r01*x1721*x1723)));
evalcond[5]=(((x1723*x1732))+x1728+(((-1.0)*x1720*x1729))+(((-1.0)*x1723*x1730))+((x1727*x1731))+(((-1.0)*x1722))+(((-1.0)*x1721*x1724)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j12array[1], cj12array[1], sj12array[1];
bool j12valid[1]={false};
_nj12 = 1;
IkReal x1733=((643.0)*cj11);
IkReal x1734=((704.0)*sj7);
CheckValue<IkReal> x1735 = IKatan2WithCheck(IkReal((((r01*x1733))+(((2000.0)*rxp0_0))+((r20*x1734)))),IkReal((((r21*x1734))+(((-1.0)*r00*x1733))+(((2000.0)*rxp1_0)))),IKFAST_ATAN2_MAGTHRESH);
if(!x1735.valid){
continue;
}
CheckValue<IkReal> x1736=IKPowWithIntegerCheck(IKsign((r02*sj11)),-1);
if(!x1736.valid){
continue;
}
j12array[0]=((-1.5707963267949)+(x1735.value)+(((1.5707963267949)*(x1736.value))));
sj12array[0]=IKsin(j12array[0]);
cj12array[0]=IKcos(j12array[0]);
if( j12array[0] > IKPI )
{
    j12array[0]-=IK2PI;
}
else if( j12array[0] < -IKPI )
{    j12array[0]+=IK2PI;
}
j12valid[0] = true;
for(int ij12 = 0; ij12 < 1; ++ij12)
{
if( !j12valid[ij12] )
{
    continue;
}
_ij12[0] = ij12; _ij12[1] = -1;
for(int iij12 = ij12+1; iij12 < 1; ++iij12)
{
if( j12valid[iij12] && IKabs(cj12array[ij12]-cj12array[iij12]) < IKFAST_SOLUTION_THRESH && IKabs(sj12array[ij12]-sj12array[iij12]) < IKFAST_SOLUTION_THRESH )
{
    j12valid[iij12]=false; _ij12[1] = iij12; break; 
}
}
j12 = j12array[ij12]; cj12 = cj12array[ij12]; sj12 = sj12array[ij12];
{
IkReal evalcond[6];
IkReal x1737=IKsin(j12);
IkReal x1738=IKcos(j12);
IkReal x1739=((0.3215)*sj11);
IkReal x1740=((0.352)*cj7);
IkReal x1741=((1.0)*npx);
IkReal x1742=((0.3215)*cj11);
IkReal x1743=((0.643)*sj11);
IkReal x1744=((0.352)*sj7);
IkReal x1745=(npy*x1737);
IkReal x1746=(r11*x1744);
IkReal x1747=(r01*x1737);
IkReal x1748=(r10*x1738);
IkReal x1749=(r00*x1738);
evalcond[0]=((((-1.0)*r20*x1738*x1739))+((r22*x1742))+(((-1.0)*pz))+((r21*x1737*x1739)));
evalcond[1]=((0.02054175)+(((0.643)*cj11*npz))+(((-1.0)*pp))+(((-1.0)*npx*x1738*x1743))+((x1743*x1745)));
evalcond[2]=(((x1739*x1747))+x1740+((r02*x1742))+(((-1.0)*x1739*x1749))+(((-1.0)*px)));
evalcond[3]=(((r12*x1742))+x1744+(((-1.0)*x1739*x1748))+(((-1.0)*py))+((r11*x1737*x1739)));
evalcond[4]=(((r00*x1737*x1740))+((r10*x1737*x1744))+(((-1.0)*npy*x1738))+(((-1.0)*x1737*x1741))+((x1738*x1746))+((r01*x1738*x1740)));
evalcond[5]=(x1745+(((-1.0)*x1738*x1741))+(((-1.0)*x1740*x1747))+((x1744*x1748))+(((-1.0)*x1737*x1746))+((x1740*x1749))+(((-1.0)*x1739)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}
}
}

}

}
}
return solutions.GetNumSolutions()>0;
}
inline void rotationfunction0(IkSolutionListBase<IkReal>& solutions) {
for(int rotationiter = 0; rotationiter < 1; ++rotationiter) {
IkReal x191=((1.0)*sj11);
IkReal x192=((1.0)*sj7);
IkReal x193=((1.0)*sj12);
IkReal x194=((((-1.0)*r00*x192))+((cj7*r10)));
IkReal x195=((((-1.0)*r01*x192))+((cj7*r11)));
IkReal x196=((((-1.0)*r02*x192))+((cj7*r12)));
IkReal x197=(((cj12*r20))+(((-1.0)*r21*x193)));
IkReal x198=(((r10*sj7))+((cj7*r00)));
IkReal x199=(((r11*sj7))+((cj7*r01)));
IkReal x200=(((r12*sj7))+((cj7*r02)));
IkReal x201=(((cj12*x194))+(((-1.0)*x193*x195)));
IkReal x202=(((cj12*x198))+(((-1.0)*x193*x199)));
new_r00=(((sj11*x196))+((cj11*x201)));
new_r01=(((cj12*x195))+((sj12*x194)));
new_r02=((((-1.0)*x191*x201))+((cj11*x196)));
new_r10=(((cj11*x197))+((r22*sj11)));
new_r11=(((r20*sj12))+((cj12*r21)));
new_r12=((((-1.0)*x191*x197))+((cj11*r22)));
new_r20=(((sj11*x200))+((cj11*x202)));
new_r21=(((cj12*x199))+((sj12*x198)));
new_r22=((((-1.0)*x191*x202))+((cj11*x200)));
{
IkReal j9array[2], cj9array[2], sj9array[2];
bool j9valid[2]={false};
_nj9 = 2;
cj9array[0]=new_r22;
if( cj9array[0] >= -1-IKFAST_SINCOS_THRESH && cj9array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j9valid[0] = j9valid[1] = true;
    j9array[0] = IKacos(cj9array[0]);
    sj9array[0] = IKsin(j9array[0]);
    cj9array[1] = cj9array[0];
    j9array[1] = -j9array[0];
    sj9array[1] = -sj9array[0];
}
else if( std::isnan(cj9array[0]) )
{
    // probably any value will work
    j9valid[0] = true;
    cj9array[0] = 1; sj9array[0] = 0; j9array[0] = 0;
}
for(int ij9 = 0; ij9 < 2; ++ij9)
{
if( !j9valid[ij9] )
{
    continue;
}
_ij9[0] = ij9; _ij9[1] = -1;
for(int iij9 = ij9+1; iij9 < 2; ++iij9)
{
if( j9valid[iij9] && IKabs(cj9array[ij9]-cj9array[iij9]) < IKFAST_SOLUTION_THRESH && IKabs(sj9array[ij9]-sj9array[iij9]) < IKFAST_SOLUTION_THRESH )
{
    j9valid[iij9]=false; _ij9[1] = iij9; break; 
}
}
j9 = j9array[ij9]; cj9 = cj9array[ij9]; sj9 = sj9array[ij9];

{
IkReal j8eval[3];
j8eval[0]=sj9;
j8eval[1]=((IKabs(new_r12))+(IKabs(new_r02)));
j8eval[2]=IKsign(sj9);
if( IKabs(j8eval[0]) < 0.0000010000000000  || IKabs(j8eval[1]) < 0.0000010000000000  || IKabs(j8eval[2]) < 0.0000010000000000  )
{
{
IkReal j10eval[3];
j10eval[0]=sj9;
j10eval[1]=IKsign(sj9);
j10eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  || IKabs(j10eval[2]) < 0.0000010000000000  )
{
{
IkReal j8eval[2];
j8eval[0]=new_r12;
j8eval[1]=sj9;
if( IKabs(j8eval[0]) < 0.0000010000000000  || IKabs(j8eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j9))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
IkReal j10mul = 1;
j10=0;
j8mul=-1.0;
if( IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r01))+IKsqr(new_r00)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j8=IKatan2(((-1.0)*new_r01), new_r00);
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].fmul = j8mul;
vinfos[2].freeind = 0;
vinfos[2].maxsolutions = 0;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].fmul = j10mul;
vinfos[4].freeind = 0;
vinfos[4].maxsolutions = 0;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(1);
vfree[0] = 4;
solutions.AddSolution(vinfos,vfree);
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j9)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
IkReal j10mul = 1;
j10=0;
j8mul=1.0;
if( IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r01))+IKsqr(((-1.0)*new_r00))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j8=IKatan2(((-1.0)*new_r01), ((-1.0)*new_r00));
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].fmul = j8mul;
vinfos[2].freeind = 0;
vinfos[2].maxsolutions = 0;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].fmul = j10mul;
vinfos[4].freeind = 0;
vinfos[4].maxsolutions = 0;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(1);
vfree[0] = 4;
solutions.AddSolution(vinfos,vfree);
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r12))+(IKabs(new_r02)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j8eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
IkReal x203=new_r22*new_r22;
IkReal x204=((16.0)*new_r10);
IkReal x205=((16.0)*new_r01);
IkReal x206=((16.0)*new_r22);
IkReal x207=((8.0)*new_r11);
IkReal x208=((8.0)*new_r00);
IkReal x209=(x203*x204);
IkReal x210=(x203*x205);
j8eval[0]=((IKabs(((((-1.0)*x205))+x210)))+(IKabs(((((-1.0)*x204))+x209)))+(IKabs(((((-1.0)*new_r00*x206))+(((32.0)*new_r11))+(((-16.0)*new_r11*x203)))))+(IKabs((((new_r11*x206))+(((-32.0)*new_r00*x203))+(((16.0)*new_r00)))))+(IKabs(((((-1.0)*x208))+((new_r22*x207)))))+(IKabs(((((-1.0)*new_r22*x208))+((x203*x207)))))+(IKabs(((((-1.0)*x209))+x204)))+(IKabs((x205+(((-1.0)*x210))))));
if( IKabs(j8eval[0]) < 0.0000000010000000  )
{
continue; // no branches [j8, j10]

} else
{
IkReal op[4+1], zeror[4];
int numroots;
IkReal j8evalpoly[1];
IkReal x211=new_r22*new_r22;
IkReal x212=((16.0)*new_r10);
IkReal x213=(new_r11*new_r22);
IkReal x214=(x211*x212);
IkReal x215=((((8.0)*x213))+(((-8.0)*new_r00)));
op[0]=x215;
op[1]=(x212+(((-1.0)*x214)));
op[2]=((((-32.0)*new_r00*x211))+(((16.0)*x213))+(((16.0)*new_r00)));
op[3]=(x214+(((-1.0)*x212)));
op[4]=x215;
polyroots4(op,zeror,numroots);
IkReal j8array[4], cj8array[4], sj8array[4], tempj8array[1];
int numsolutions = 0;
for(int ij8 = 0; ij8 < numroots; ++ij8)
{
IkReal htj8 = zeror[ij8];
tempj8array[0]=((2.0)*(atan(htj8)));
for(int kj8 = 0; kj8 < 1; ++kj8)
{
j8array[numsolutions] = tempj8array[kj8];
if( j8array[numsolutions] > IKPI )
{
    j8array[numsolutions]-=IK2PI;
}
else if( j8array[numsolutions] < -IKPI )
{
    j8array[numsolutions]+=IK2PI;
}
sj8array[numsolutions] = IKsin(j8array[numsolutions]);
cj8array[numsolutions] = IKcos(j8array[numsolutions]);
numsolutions++;
}
}
bool j8valid[4]={true,true,true,true};
_nj8 = 4;
for(int ij8 = 0; ij8 < numsolutions; ++ij8)
    {
if( !j8valid[ij8] )
{
    continue;
}
    j8 = j8array[ij8]; cj8 = cj8array[ij8]; sj8 = sj8array[ij8];
htj8 = IKtan(j8/2);

IkReal x216=new_r22*new_r22;
IkReal x217=((16.0)*new_r01);
IkReal x218=(new_r00*new_r22);
IkReal x219=((8.0)*x218);
IkReal x220=(new_r11*x216);
IkReal x221=((8.0)*x220);
IkReal x222=(x216*x217);
j8evalpoly[0]=((((htj8*htj8*htj8*htj8)*((x221+(((-1.0)*x219))))))+((htj8*((x217+(((-1.0)*x222))))))+x221+(((htj8*htj8)*(((((32.0)*new_r11))+(((-16.0)*x218))+(((-16.0)*x220))))))+(((-1.0)*x219))+(((htj8*htj8*htj8)*((x222+(((-1.0)*x217)))))));
if( IKabs(j8evalpoly[0]) > 0.0000000010000000  )
{
    continue;
}
_ij8[0] = ij8; _ij8[1] = -1;
for(int iij8 = ij8+1; iij8 < numsolutions; ++iij8)
{
if( j8valid[iij8] && IKabs(cj8array[ij8]-cj8array[iij8]) < IKFAST_SOLUTION_THRESH && IKabs(sj8array[ij8]-sj8array[iij8]) < IKFAST_SOLUTION_THRESH )
{
    j8valid[iij8]=false; _ij8[1] = iij8; break; 
}
}
{
IkReal j10eval[3];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
IkReal x223=cj8*cj8;
IkReal x224=(cj8*new_r22);
IkReal x225=((-1.0)+(((-1.0)*x223*(new_r22*new_r22)))+x223);
j10eval[0]=x225;
j10eval[1]=IKsign(x225);
j10eval[2]=((IKabs((((new_r01*x224))+((new_r00*sj8)))))+(IKabs((((new_r01*sj8))+(((-1.0)*new_r00*x224))))));
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  || IKabs(j10eval[2]) < 0.0000010000000000  )
{
{
IkReal j10eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j10eval[0]=new_r22;
if( IKabs(j10eval[0]) < 0.0000010000000000  )
{
{
IkReal j10eval[2];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
IkReal x226=new_r22*new_r22;
j10eval[0]=(((cj8*x226))+(((-1.0)*cj8)));
j10eval[1]=((((-1.0)*sj8))+((sj8*x226)));
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[1];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j8)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(((-1.0)*new_r01))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r00), ((-1.0)*new_r01));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x227=IKsin(j10);
IkReal x228=IKcos(j10);
evalcond[0]=x227;
evalcond[1]=((-1.0)*x228);
evalcond[2]=((((-1.0)*new_r00))+(((-1.0)*x227)));
evalcond[3]=((((-1.0)*new_r01))+(((-1.0)*x228)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j8)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r00)+IKsqr(new_r01)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(new_r00, new_r01);
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x229=IKsin(j10);
IkReal x230=IKcos(j10);
evalcond[0]=x229;
evalcond[1]=((-1.0)*x230);
evalcond[2]=(new_r00+(((-1.0)*x229)));
evalcond[3]=(new_r01+(((-1.0)*x230)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j8))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r10)+IKsqr(new_r11)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(new_r10, new_r11);
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x231=IKsin(j10);
IkReal x232=IKcos(j10);
evalcond[0]=x231;
evalcond[1]=((-1.0)*x232);
evalcond[2]=(new_r10+(((-1.0)*x231)));
evalcond[3]=(new_r11+(((-1.0)*x232)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j8)))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r10), ((-1.0)*new_r11));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x233=IKsin(j10);
IkReal x234=IKcos(j10);
evalcond[0]=x233;
evalcond[1]=((-1.0)*x234);
evalcond[2]=((((-1.0)*new_r10))+(((-1.0)*x233)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x234)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
CheckValue<IkReal> x235=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x235.valid){
continue;
}
if((x235.value) < -0.00001)
continue;
IkReal gconst82=((-1.0)*(IKsqrt(x235.value)));
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.0)+(IKsign(sj8)))))+(IKabs((cj8+(((-1.0)*gconst82)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
if((((1.0)+(((-1.0)*(gconst82*gconst82))))) < -0.00001)
continue;
sj8=IKsqrt(((1.0)+(((-1.0)*(gconst82*gconst82)))));
cj8=gconst82;
if( (gconst82) < -1-IKFAST_SINCOS_THRESH || (gconst82) > 1+IKFAST_SINCOS_THRESH )
    continue;
j8=IKacos(gconst82);
CheckValue<IkReal> x236=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x236.valid){
continue;
}
if((x236.value) < -0.00001)
continue;
IkReal gconst82=((-1.0)*(IKsqrt(x236.value)));
j10eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j10eval[0]) < 0.0000010000000000  )
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if((((1.0)+(((-1.0)*(gconst82*gconst82))))) < -0.00001)
continue;
CheckValue<IkReal> x237=IKPowWithIntegerCheck(gconst82,-1);
if(!x237.valid){
continue;
}
if( IKabs(((((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst82*gconst82))))))))+((gconst82*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r11*(x237.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst82*gconst82))))))))+((gconst82*new_r10))))+IKsqr((new_r11*(x237.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst82*gconst82))))))))+((gconst82*new_r10))), (new_r11*(x237.value)));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x238=IKcos(j10);
IkReal x239=IKsin(j10);
IkReal x240=((1.0)*x238);
IkReal x241=((1.0)*x239);
if((((1.0)+(((-1.0)*(gconst82*gconst82))))) < -0.00001)
continue;
IkReal x242=IKsqrt(((1.0)+(((-1.0)*(gconst82*gconst82)))));
IkReal x243=((1.0)*x242);
evalcond[0]=x239;
evalcond[1]=((-1.0)*x238);
evalcond[2]=(new_r11+(((-1.0)*gconst82*x240)));
evalcond[3]=(new_r10+(((-1.0)*gconst82*x241)));
evalcond[4]=(((x238*x242))+new_r01);
evalcond[5]=(((x239*x242))+new_r00);
evalcond[6]=((((-1.0)*new_r00*x243))+((gconst82*new_r10))+(((-1.0)*x241)));
evalcond[7]=((((-1.0)*new_r01*x243))+((gconst82*new_r11))+(((-1.0)*x240)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x244 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x244.valid){
continue;
}
CheckValue<IkReal> x245=IKPowWithIntegerCheck(IKsign(gconst82),-1);
if(!x245.valid){
continue;
}
j10array[0]=((-1.5707963267949)+(x244.value)+(((1.5707963267949)*(x245.value))));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x246=IKcos(j10);
IkReal x247=IKsin(j10);
IkReal x248=((1.0)*x246);
IkReal x249=((1.0)*x247);
if((((1.0)+(((-1.0)*(gconst82*gconst82))))) < -0.00001)
continue;
IkReal x250=IKsqrt(((1.0)+(((-1.0)*(gconst82*gconst82)))));
IkReal x251=((1.0)*x250);
evalcond[0]=x247;
evalcond[1]=((-1.0)*x246);
evalcond[2]=(new_r11+(((-1.0)*gconst82*x248)));
evalcond[3]=(new_r10+(((-1.0)*gconst82*x249)));
evalcond[4]=(((x246*x250))+new_r01);
evalcond[5]=(new_r00+((x247*x250)));
evalcond[6]=(((gconst82*new_r10))+(((-1.0)*x249))+(((-1.0)*new_r00*x251)));
evalcond[7]=((((-1.0)*new_r01*x251))+((gconst82*new_r11))+(((-1.0)*x248)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
CheckValue<IkReal> x252=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x252.valid){
continue;
}
if((x252.value) < -0.00001)
continue;
IkReal gconst82=((-1.0)*(IKsqrt(x252.value)));
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.0)+(IKsign(sj8)))))+(IKabs((cj8+(((-1.0)*gconst82)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
if((((1.0)+(((-1.0)*(gconst82*gconst82))))) < -0.00001)
continue;
sj8=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst82*gconst82)))))));
cj8=gconst82;
if( (gconst82) < -1-IKFAST_SINCOS_THRESH || (gconst82) > 1+IKFAST_SINCOS_THRESH )
    continue;
j8=((-1.0)*(IKacos(gconst82)));
CheckValue<IkReal> x253=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x253.valid){
continue;
}
if((x253.value) < -0.00001)
continue;
IkReal gconst82=((-1.0)*(IKsqrt(x253.value)));
j10eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j10eval[0]) < 0.0000010000000000  )
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if((((1.0)+(((-1.0)*(gconst82*gconst82))))) < -0.00001)
continue;
CheckValue<IkReal> x254=IKPowWithIntegerCheck(gconst82,-1);
if(!x254.valid){
continue;
}
if( IKabs((((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst82*gconst82))))))))+((gconst82*new_r10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r11*(x254.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst82*gconst82))))))))+((gconst82*new_r10))))+IKsqr((new_r11*(x254.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2((((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst82*gconst82))))))))+((gconst82*new_r10))), (new_r11*(x254.value)));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x255=IKcos(j10);
IkReal x256=IKsin(j10);
IkReal x257=((1.0)*x255);
IkReal x258=((1.0)*x256);
if((((1.0)+(((-1.0)*(gconst82*gconst82))))) < -0.00001)
continue;
IkReal x259=IKsqrt(((1.0)+(((-1.0)*(gconst82*gconst82)))));
evalcond[0]=x256;
evalcond[1]=((-1.0)*x255);
evalcond[2]=((((-1.0)*gconst82*x257))+new_r11);
evalcond[3]=((((-1.0)*gconst82*x258))+new_r10);
evalcond[4]=((((-1.0)*x257*x259))+new_r01);
evalcond[5]=(new_r00+(((-1.0)*x258*x259)));
evalcond[6]=(((new_r00*x259))+((gconst82*new_r10))+(((-1.0)*x258)));
evalcond[7]=(((new_r01*x259))+((gconst82*new_r11))+(((-1.0)*x257)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x260 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x260.valid){
continue;
}
CheckValue<IkReal> x261=IKPowWithIntegerCheck(IKsign(gconst82),-1);
if(!x261.valid){
continue;
}
j10array[0]=((-1.5707963267949)+(x260.value)+(((1.5707963267949)*(x261.value))));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x262=IKcos(j10);
IkReal x263=IKsin(j10);
IkReal x264=((1.0)*x262);
IkReal x265=((1.0)*x263);
if((((1.0)+(((-1.0)*(gconst82*gconst82))))) < -0.00001)
continue;
IkReal x266=IKsqrt(((1.0)+(((-1.0)*(gconst82*gconst82)))));
evalcond[0]=x263;
evalcond[1]=((-1.0)*x262);
evalcond[2]=(new_r11+(((-1.0)*gconst82*x264)));
evalcond[3]=(new_r10+(((-1.0)*gconst82*x265)));
evalcond[4]=(new_r01+(((-1.0)*x264*x266)));
evalcond[5]=((((-1.0)*x265*x266))+new_r00);
evalcond[6]=(((gconst82*new_r10))+((new_r00*x266))+(((-1.0)*x265)));
evalcond[7]=(((new_r01*x266))+((gconst82*new_r11))+(((-1.0)*x264)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
CheckValue<IkReal> x267=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x267.valid){
continue;
}
if((x267.value) < -0.00001)
continue;
IkReal gconst83=IKsqrt(x267.value);
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs((cj8+(((-1.0)*gconst83)))))+(IKabs(((-1.0)+(IKsign(sj8)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
if((((1.0)+(((-1.0)*(gconst83*gconst83))))) < -0.00001)
continue;
sj8=IKsqrt(((1.0)+(((-1.0)*(gconst83*gconst83)))));
cj8=gconst83;
if( (gconst83) < -1-IKFAST_SINCOS_THRESH || (gconst83) > 1+IKFAST_SINCOS_THRESH )
    continue;
j8=IKacos(gconst83);
CheckValue<IkReal> x268=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x268.valid){
continue;
}
if((x268.value) < -0.00001)
continue;
IkReal gconst83=IKsqrt(x268.value);
j10eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j10eval[0]) < 0.0000010000000000  )
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if((((1.0)+(((-1.0)*(gconst83*gconst83))))) < -0.00001)
continue;
CheckValue<IkReal> x269=IKPowWithIntegerCheck(gconst83,-1);
if(!x269.valid){
continue;
}
if( IKabs((((gconst83*new_r10))+(((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst83*gconst83)))))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r11*(x269.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((gconst83*new_r10))+(((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst83*gconst83))))))))))+IKsqr((new_r11*(x269.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2((((gconst83*new_r10))+(((-1.0)*new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst83*gconst83))))))))), (new_r11*(x269.value)));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x270=IKcos(j10);
IkReal x271=IKsin(j10);
IkReal x272=((1.0)*x271);
IkReal x273=((1.0)*x270);
if((((1.0)+(((-1.0)*(gconst83*gconst83))))) < -0.00001)
continue;
IkReal x274=IKsqrt(((1.0)+(((-1.0)*(gconst83*gconst83)))));
IkReal x275=((1.0)*x274);
evalcond[0]=x271;
evalcond[1]=((-1.0)*x270);
evalcond[2]=((((-1.0)*gconst83*x273))+new_r11);
evalcond[3]=((((-1.0)*gconst83*x272))+new_r10);
evalcond[4]=(((x270*x274))+new_r01);
evalcond[5]=(((x271*x274))+new_r00);
evalcond[6]=((((-1.0)*new_r00*x275))+((gconst83*new_r10))+(((-1.0)*x272)));
evalcond[7]=((((-1.0)*new_r01*x275))+((gconst83*new_r11))+(((-1.0)*x273)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x276=IKPowWithIntegerCheck(IKsign(gconst83),-1);
if(!x276.valid){
continue;
}
CheckValue<IkReal> x277 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x277.valid){
continue;
}
j10array[0]=((-1.5707963267949)+(((1.5707963267949)*(x276.value)))+(x277.value));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x278=IKcos(j10);
IkReal x279=IKsin(j10);
IkReal x280=((1.0)*x279);
IkReal x281=((1.0)*x278);
if((((1.0)+(((-1.0)*(gconst83*gconst83))))) < -0.00001)
continue;
IkReal x282=IKsqrt(((1.0)+(((-1.0)*(gconst83*gconst83)))));
IkReal x283=((1.0)*x282);
evalcond[0]=x279;
evalcond[1]=((-1.0)*x278);
evalcond[2]=(new_r11+(((-1.0)*gconst83*x281)));
evalcond[3]=(new_r10+(((-1.0)*gconst83*x280)));
evalcond[4]=(((x278*x282))+new_r01);
evalcond[5]=(((x279*x282))+new_r00);
evalcond[6]=((((-1.0)*new_r00*x283))+((gconst83*new_r10))+(((-1.0)*x280)));
evalcond[7]=(((gconst83*new_r11))+(((-1.0)*new_r01*x283))+(((-1.0)*x281)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
CheckValue<IkReal> x284=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x284.valid){
continue;
}
if((x284.value) < -0.00001)
continue;
IkReal gconst83=IKsqrt(x284.value);
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs((cj8+(((-1.0)*gconst83)))))+(IKabs(((1.0)+(IKsign(sj8)))))), 6.28318530717959)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
if((((1.0)+(((-1.0)*(gconst83*gconst83))))) < -0.00001)
continue;
sj8=((-1.0)*(IKsqrt(((1.0)+(((-1.0)*(gconst83*gconst83)))))));
cj8=gconst83;
if( (gconst83) < -1-IKFAST_SINCOS_THRESH || (gconst83) > 1+IKFAST_SINCOS_THRESH )
    continue;
j8=((-1.0)*(IKacos(gconst83)));
CheckValue<IkReal> x285=IKPowWithIntegerCheck(((1.0)+(((-1.0)*(new_r22*new_r22)))),-1);
if(!x285.valid){
continue;
}
if((x285.value) < -0.00001)
continue;
IkReal gconst83=IKsqrt(x285.value);
j10eval[0]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j10eval[0]) < 0.0000010000000000  )
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if((((1.0)+(((-1.0)*(gconst83*gconst83))))) < -0.00001)
continue;
CheckValue<IkReal> x286=IKPowWithIntegerCheck(gconst83,-1);
if(!x286.valid){
continue;
}
if( IKabs((((gconst83*new_r10))+((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst83*gconst83)))))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r11*(x286.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((gconst83*new_r10))+((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst83*gconst83))))))))))+IKsqr((new_r11*(x286.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2((((gconst83*new_r10))+((new_r00*(IKsqrt(((1.0)+(((-1.0)*(gconst83*gconst83))))))))), (new_r11*(x286.value)));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x287=IKcos(j10);
IkReal x288=IKsin(j10);
IkReal x289=((1.0)*x287);
IkReal x290=((1.0)*x288);
if((((1.0)+(((-1.0)*(gconst83*gconst83))))) < -0.00001)
continue;
IkReal x291=IKsqrt(((1.0)+(((-1.0)*(gconst83*gconst83)))));
evalcond[0]=x288;
evalcond[1]=((-1.0)*x287);
evalcond[2]=(new_r11+(((-1.0)*gconst83*x289)));
evalcond[3]=((((-1.0)*gconst83*x290))+new_r10);
evalcond[4]=((((-1.0)*x289*x291))+new_r01);
evalcond[5]=((((-1.0)*x290*x291))+new_r00);
evalcond[6]=((((-1.0)*x290))+((new_r00*x291))+((gconst83*new_r10)));
evalcond[7]=(((new_r01*x291))+((gconst83*new_r11))+(((-1.0)*x289)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x292=IKPowWithIntegerCheck(IKsign(gconst83),-1);
if(!x292.valid){
continue;
}
CheckValue<IkReal> x293 = IKatan2WithCheck(IkReal(new_r10),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x293.valid){
continue;
}
j10array[0]=((-1.5707963267949)+(((1.5707963267949)*(x292.value)))+(x293.value));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x294=IKcos(j10);
IkReal x295=IKsin(j10);
IkReal x296=((1.0)*x294);
IkReal x297=((1.0)*x295);
if((((1.0)+(((-1.0)*(gconst83*gconst83))))) < -0.00001)
continue;
IkReal x298=IKsqrt(((1.0)+(((-1.0)*(gconst83*gconst83)))));
evalcond[0]=x295;
evalcond[1]=((-1.0)*x294);
evalcond[2]=((((-1.0)*gconst83*x296))+new_r11);
evalcond[3]=((((-1.0)*gconst83*x297))+new_r10);
evalcond[4]=((((-1.0)*x296*x298))+new_r01);
evalcond[5]=((((-1.0)*x297*x298))+new_r00);
evalcond[6]=((((-1.0)*x297))+((new_r00*x298))+((gconst83*new_r10)));
evalcond[7]=((((-1.0)*x296))+((new_r01*x298))+((gconst83*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j10]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
IkReal x299=new_r22*new_r22;
CheckValue<IkReal> x300=IKPowWithIntegerCheck((((cj8*x299))+(((-1.0)*cj8))),-1);
if(!x300.valid){
continue;
}
CheckValue<IkReal> x301=IKPowWithIntegerCheck(((((-1.0)*sj8))+((sj8*x299))),-1);
if(!x301.valid){
continue;
}
if( IKabs(((x300.value)*(((((-1.0)*new_r01*new_r22))+(((-1.0)*new_r10)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x301.value)*((((new_r10*new_r22))+new_r01)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x300.value)*(((((-1.0)*new_r01*new_r22))+(((-1.0)*new_r10))))))+IKsqr(((x301.value)*((((new_r10*new_r22))+new_r01))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((x300.value)*(((((-1.0)*new_r01*new_r22))+(((-1.0)*new_r10))))), ((x301.value)*((((new_r10*new_r22))+new_r01))));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[10];
IkReal x302=IKsin(j10);
IkReal x303=IKcos(j10);
IkReal x304=(new_r22*sj8);
IkReal x305=(cj8*new_r00);
IkReal x306=((1.0)*sj8);
IkReal x307=(cj8*new_r01);
IkReal x308=((1.0)*x303);
IkReal x309=(new_r22*x302);
IkReal x310=((1.0)*x302);
evalcond[0]=(((new_r11*sj8))+x309+x307);
evalcond[1]=(((new_r11*x304))+((new_r22*x307))+x302);
evalcond[2]=(((cj8*new_r10))+(((-1.0)*x310))+(((-1.0)*new_r00*x306)));
evalcond[3]=(((cj8*new_r11))+(((-1.0)*new_r01*x306))+(((-1.0)*x308)));
evalcond[4]=(((sj8*x303))+((cj8*x309))+new_r01);
evalcond[5]=(((new_r10*sj8))+(((-1.0)*new_r22*x308))+x305);
evalcond[6]=(((sj8*x302))+(((-1.0)*cj8*new_r22*x308))+new_r00);
evalcond[7]=(((x302*x304))+(((-1.0)*cj8*x308))+new_r11);
evalcond[8]=(((new_r10*x304))+((new_r22*x305))+(((-1.0)*x308)));
evalcond[9]=((((-1.0)*x304*x308))+new_r10+(((-1.0)*cj8*x310)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
IkReal x311=((1.0)*new_r01);
CheckValue<IkReal> x312=IKPowWithIntegerCheck(new_r22,-1);
if(!x312.valid){
continue;
}
if( IKabs(((x312.value)*(((((-1.0)*new_r11*sj8))+(((-1.0)*cj8*x311)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*sj8*x311))+((cj8*new_r11)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x312.value)*(((((-1.0)*new_r11*sj8))+(((-1.0)*cj8*x311))))))+IKsqr(((((-1.0)*sj8*x311))+((cj8*new_r11))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((x312.value)*(((((-1.0)*new_r11*sj8))+(((-1.0)*cj8*x311))))), ((((-1.0)*sj8*x311))+((cj8*new_r11))));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[10];
IkReal x313=IKsin(j10);
IkReal x314=IKcos(j10);
IkReal x315=(new_r22*sj8);
IkReal x316=(cj8*new_r00);
IkReal x317=((1.0)*sj8);
IkReal x318=(cj8*new_r01);
IkReal x319=((1.0)*x314);
IkReal x320=(new_r22*x313);
IkReal x321=((1.0)*x313);
evalcond[0]=(((new_r11*sj8))+x320+x318);
evalcond[1]=(x313+((new_r11*x315))+((new_r22*x318)));
evalcond[2]=((((-1.0)*new_r00*x317))+(((-1.0)*x321))+((cj8*new_r10)));
evalcond[3]=(((cj8*new_r11))+(((-1.0)*x319))+(((-1.0)*new_r01*x317)));
evalcond[4]=(((cj8*x320))+((sj8*x314))+new_r01);
evalcond[5]=(((new_r10*sj8))+(((-1.0)*new_r22*x319))+x316);
evalcond[6]=(((sj8*x313))+new_r00+(((-1.0)*cj8*new_r22*x319)));
evalcond[7]=(new_r11+(((-1.0)*cj8*x319))+((x313*x315)));
evalcond[8]=((((-1.0)*x319))+((new_r10*x315))+((new_r22*x316)));
evalcond[9]=((((-1.0)*cj8*x321))+(((-1.0)*x315*x319))+new_r10);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
IkReal x322=cj8*cj8;
IkReal x323=(cj8*new_r22);
CheckValue<IkReal> x324=IKPowWithIntegerCheck(IKsign(((-1.0)+(((-1.0)*x322*(new_r22*new_r22)))+x322)),-1);
if(!x324.valid){
continue;
}
CheckValue<IkReal> x325 = IKatan2WithCheck(IkReal((((new_r01*x323))+((new_r00*sj8)))),IkReal((((new_r01*sj8))+(((-1.0)*new_r00*x323)))),IKFAST_ATAN2_MAGTHRESH);
if(!x325.valid){
continue;
}
j10array[0]=((-1.5707963267949)+(((1.5707963267949)*(x324.value)))+(x325.value));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[10];
IkReal x326=IKsin(j10);
IkReal x327=IKcos(j10);
IkReal x328=(new_r22*sj8);
IkReal x329=(cj8*new_r00);
IkReal x330=((1.0)*sj8);
IkReal x331=(cj8*new_r01);
IkReal x332=((1.0)*x327);
IkReal x333=(new_r22*x326);
IkReal x334=((1.0)*x326);
evalcond[0]=(((new_r11*sj8))+x333+x331);
evalcond[1]=(((new_r22*x331))+x326+((new_r11*x328)));
evalcond[2]=(((cj8*new_r10))+(((-1.0)*new_r00*x330))+(((-1.0)*x334)));
evalcond[3]=(((cj8*new_r11))+(((-1.0)*x332))+(((-1.0)*new_r01*x330)));
evalcond[4]=(((cj8*x333))+((sj8*x327))+new_r01);
evalcond[5]=((((-1.0)*new_r22*x332))+((new_r10*sj8))+x329);
evalcond[6]=((((-1.0)*cj8*new_r22*x332))+((sj8*x326))+new_r00);
evalcond[7]=(((x326*x328))+(((-1.0)*cj8*x332))+new_r11);
evalcond[8]=(((new_r22*x329))+(((-1.0)*x332))+((new_r10*x328)));
evalcond[9]=((((-1.0)*x328*x332))+(((-1.0)*cj8*x334))+new_r10);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j8, j10]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}

} else
{
{
IkReal j8array[1], cj8array[1], sj8array[1];
bool j8valid[1]={false};
_nj8 = 1;
CheckValue<IkReal> x336=IKPowWithIntegerCheck(sj9,-1);
if(!x336.valid){
continue;
}
IkReal x335=x336.value;
CheckValue<IkReal> x337=IKPowWithIntegerCheck(new_r12,-1);
if(!x337.valid){
continue;
}
if( IKabs((x335*(x337.value)*(((1.0)+(((-1.0)*(cj9*cj9)))+(((-1.0)*(new_r02*new_r02))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r02*x335)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x335*(x337.value)*(((1.0)+(((-1.0)*(cj9*cj9)))+(((-1.0)*(new_r02*new_r02)))))))+IKsqr((new_r02*x335))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j8array[0]=IKatan2((x335*(x337.value)*(((1.0)+(((-1.0)*(cj9*cj9)))+(((-1.0)*(new_r02*new_r02)))))), (new_r02*x335));
sj8array[0]=IKsin(j8array[0]);
cj8array[0]=IKcos(j8array[0]);
if( j8array[0] > IKPI )
{
    j8array[0]-=IK2PI;
}
else if( j8array[0] < -IKPI )
{    j8array[0]+=IK2PI;
}
j8valid[0] = true;
for(int ij8 = 0; ij8 < 1; ++ij8)
{
if( !j8valid[ij8] )
{
    continue;
}
_ij8[0] = ij8; _ij8[1] = -1;
for(int iij8 = ij8+1; iij8 < 1; ++iij8)
{
if( j8valid[iij8] && IKabs(cj8array[ij8]-cj8array[iij8]) < IKFAST_SOLUTION_THRESH && IKabs(sj8array[ij8]-sj8array[iij8]) < IKFAST_SOLUTION_THRESH )
{
    j8valid[iij8]=false; _ij8[1] = iij8; break; 
}
}
j8 = j8array[ij8]; cj8 = cj8array[ij8]; sj8 = sj8array[ij8];
{
IkReal evalcond[8];
IkReal x338=IKcos(j8);
IkReal x339=IKsin(j8);
IkReal x340=((1.0)*sj9);
IkReal x341=((1.0)*x339);
IkReal x342=(sj9*x338);
IkReal x343=(new_r12*x339);
IkReal x344=(new_r02*x338);
IkReal x345=(sj9*x339);
evalcond[0]=(new_r02+(((-1.0)*x338*x340)));
evalcond[1]=(new_r12+(((-1.0)*x339*x340)));
evalcond[2]=((((-1.0)*new_r02*x341))+((new_r12*x338)));
evalcond[3]=(x343+x344+(((-1.0)*x340)));
evalcond[4]=(((cj9*new_r20))+((new_r00*x342))+((new_r10*x345)));
evalcond[5]=(((cj9*new_r21))+((new_r11*x345))+((new_r01*x342)));
evalcond[6]=((-1.0)+((new_r02*x342))+((sj9*x343))+((cj9*new_r22)));
evalcond[7]=(((cj9*x343))+((cj9*x344))+(((-1.0)*new_r22*x340)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j10eval[3];
j10eval[0]=sj9;
j10eval[1]=IKsign(sj9);
j10eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  || IKabs(j10eval[2]) < 0.0000010000000000  )
{
{
IkReal j10eval[2];
j10eval[0]=sj8;
j10eval[1]=sj9;
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  )
{
{
IkReal j10eval[3];
j10eval[0]=cj8;
j10eval[1]=cj9;
j10eval[2]=sj9;
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  || IKabs(j10eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j8)))), 6.28318530717959)));
evalcond[1]=new_r02;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10eval[3];
sj8=1.0;
cj8=0;
j8=1.5707963267949;
j10eval[0]=sj9;
j10eval[1]=IKsign(sj9);
j10eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  || IKabs(j10eval[2]) < 0.0000010000000000  )
{
{
IkReal j10eval[3];
sj8=1.0;
cj8=0;
j8=1.5707963267949;
j10eval[0]=cj9;
j10eval[1]=IKsign(cj9);
j10eval[2]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  || IKabs(j10eval[2]) < 0.0000010000000000  )
{
{
IkReal j10eval[1];
sj8=1.0;
cj8=0;
j8=1.5707963267949;
j10eval[0]=sj9;
if( IKabs(j10eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j9))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r12;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r11))+IKsqr(new_r10)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r11), new_r10);
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x346=IKsin(j10);
IkReal x347=((1.0)*(IKcos(j10)));
evalcond[0]=(x346+new_r11);
evalcond[1]=(new_r10+(((-1.0)*x347)));
evalcond[2]=((((-1.0)*new_r00))+(((-1.0)*x346)));
evalcond[3]=((((-1.0)*new_r01))+(((-1.0)*x347)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j9)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r12;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r11)+IKsqr(((-1.0)*new_r10))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(new_r11, ((-1.0)*new_r10));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x348=IKcos(j10);
IkReal x349=((1.0)*(IKsin(j10)));
evalcond[0]=(x348+new_r10);
evalcond[1]=(new_r11+(((-1.0)*x349)));
evalcond[2]=((((-1.0)*new_r00))+(((-1.0)*x349)));
evalcond[3]=((((-1.0)*new_r01))+(((-1.0)*x348)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j9)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r11;
evalcond[3]=new_r10;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x350=IKcos(j10);
IkReal x351=((1.0)*(IKsin(j10)));
evalcond[0]=(x350+new_r20);
evalcond[1]=((((-1.0)*x351))+new_r21);
evalcond[2]=((((-1.0)*x351))+(((-1.0)*new_r00)));
evalcond[3]=((((-1.0)*x350))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j9)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r11;
evalcond[3]=new_r10;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x352=IKsin(j10);
IkReal x353=((1.0)*(IKcos(j10)));
evalcond[0]=(x352+new_r21);
evalcond[1]=((((-1.0)*x353))+new_r20);
evalcond[2]=((((-1.0)*x352))+(((-1.0)*new_r00)));
evalcond[3]=((((-1.0)*x353))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(((-1.0)*new_r01))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r00), ((-1.0)*new_r01));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[6];
IkReal x354=IKsin(j10);
IkReal x355=IKcos(j10);
IkReal x356=((-1.0)*x355);
evalcond[0]=x354;
evalcond[1]=(new_r22*x354);
evalcond[2]=x356;
evalcond[3]=(new_r22*x356);
evalcond[4]=((((-1.0)*x354))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x355))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j10]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x357=IKPowWithIntegerCheck(sj9,-1);
if(!x357.valid){
continue;
}
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*(x357.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(((-1.0)*new_r20*(x357.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r00), ((-1.0)*new_r20*(x357.value)));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x358=IKsin(j10);
IkReal x359=IKcos(j10);
IkReal x360=((1.0)*sj9);
IkReal x361=((1.0)*x359);
evalcond[0]=(((sj9*x359))+new_r20);
evalcond[1]=(((cj9*x358))+new_r11);
evalcond[2]=((((-1.0)*x358*x360))+new_r21);
evalcond[3]=((((-1.0)*cj9*x361))+new_r10);
evalcond[4]=((((-1.0)*x358))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x361))+(((-1.0)*new_r01)));
evalcond[6]=(((cj9*new_r11))+x358+(((-1.0)*new_r21*x360)));
evalcond[7]=((((-1.0)*new_r20*x360))+(((-1.0)*x361))+((cj9*new_r10)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x362=IKPowWithIntegerCheck(IKsign(cj9),-1);
if(!x362.valid){
continue;
}
CheckValue<IkReal> x363 = IKatan2WithCheck(IkReal(((-1.0)*new_r11)),IkReal(new_r10),IKFAST_ATAN2_MAGTHRESH);
if(!x363.valid){
continue;
}
j10array[0]=((-1.5707963267949)+(((1.5707963267949)*(x362.value)))+(x363.value));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x364=IKsin(j10);
IkReal x365=IKcos(j10);
IkReal x366=((1.0)*sj9);
IkReal x367=((1.0)*x365);
evalcond[0]=(((sj9*x365))+new_r20);
evalcond[1]=(((cj9*x364))+new_r11);
evalcond[2]=((((-1.0)*x364*x366))+new_r21);
evalcond[3]=((((-1.0)*cj9*x367))+new_r10);
evalcond[4]=((((-1.0)*x364))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x367))+(((-1.0)*new_r01)));
evalcond[6]=(((cj9*new_r11))+x364+(((-1.0)*new_r21*x366)));
evalcond[7]=((((-1.0)*new_r20*x366))+(((-1.0)*x367))+((cj9*new_r10)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x368 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x368.valid){
continue;
}
CheckValue<IkReal> x369=IKPowWithIntegerCheck(IKsign(sj9),-1);
if(!x369.valid){
continue;
}
j10array[0]=((-1.5707963267949)+(x368.value)+(((1.5707963267949)*(x369.value))));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x370=IKsin(j10);
IkReal x371=IKcos(j10);
IkReal x372=((1.0)*sj9);
IkReal x373=((1.0)*x371);
evalcond[0]=(((sj9*x371))+new_r20);
evalcond[1]=(((cj9*x370))+new_r11);
evalcond[2]=((((-1.0)*x370*x372))+new_r21);
evalcond[3]=((((-1.0)*cj9*x373))+new_r10);
evalcond[4]=((((-1.0)*x370))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x373))+(((-1.0)*new_r01)));
evalcond[6]=((((-1.0)*new_r21*x372))+((cj9*new_r11))+x370);
evalcond[7]=((((-1.0)*new_r20*x372))+(((-1.0)*x373))+((cj9*new_r10)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j8)))), 6.28318530717959)));
evalcond[1]=new_r02;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r00)+IKsqr(new_r01)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(new_r00, new_r01);
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x374=IKcos(j10);
IkReal x375=IKsin(j10);
IkReal x376=((1.0)*sj9);
IkReal x377=((1.0)*new_r10);
IkReal x378=((1.0)*new_r11);
IkReal x379=((1.0)*x374);
evalcond[0]=(((sj9*x374))+new_r20);
evalcond[1]=((((-1.0)*x375))+new_r00);
evalcond[2]=((((-1.0)*x379))+new_r01);
evalcond[3]=(new_r21+(((-1.0)*x375*x376)));
evalcond[4]=((((-1.0)*x378))+((cj9*x375)));
evalcond[5]=((((-1.0)*x377))+(((-1.0)*cj9*x379)));
evalcond[6]=((((-1.0)*new_r21*x376))+(((-1.0)*cj9*x378))+x375);
evalcond[7]=((((-1.0)*new_r20*x376))+(((-1.0)*x379))+(((-1.0)*cj9*x377)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j9)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x380=IKcos(j10);
IkReal x381=IKsin(j10);
IkReal x382=((1.0)*sj8);
IkReal x383=((1.0)*x381);
IkReal x384=((1.0)*x380);
evalcond[0]=(x380+new_r20);
evalcond[1]=((((-1.0)*x383))+new_r21);
evalcond[2]=(((sj8*x380))+new_r01);
evalcond[3]=(((sj8*x381))+new_r00);
evalcond[4]=(new_r11+(((-1.0)*cj8*x384)));
evalcond[5]=(new_r10+(((-1.0)*cj8*x383)));
evalcond[6]=((((-1.0)*new_r00*x382))+((cj8*new_r10))+(((-1.0)*x383)));
evalcond[7]=((((-1.0)*new_r01*x382))+((cj8*new_r11))+(((-1.0)*x384)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j9)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x385=IKcos(j10);
IkReal x386=IKsin(j10);
IkReal x387=((1.0)*sj8);
IkReal x388=((1.0)*x385);
IkReal x389=((1.0)*x386);
evalcond[0]=(x386+new_r21);
evalcond[1]=((((-1.0)*x388))+new_r20);
evalcond[2]=(((sj8*x385))+new_r01);
evalcond[3]=(((sj8*x386))+new_r00);
evalcond[4]=(new_r11+(((-1.0)*cj8*x388)));
evalcond[5]=(new_r10+(((-1.0)*cj8*x389)));
evalcond[6]=((((-1.0)*new_r00*x387))+((cj8*new_r10))+(((-1.0)*x389)));
evalcond[7]=((((-1.0)*new_r01*x387))+((cj8*new_r11))+(((-1.0)*x388)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j9))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
IkReal x390=((1.0)*new_r01);
if( IKabs(((((-1.0)*cj8*x390))+(((-1.0)*new_r00*sj8)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj8*new_r00))+(((-1.0)*sj8*x390)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*cj8*x390))+(((-1.0)*new_r00*sj8))))+IKsqr((((cj8*new_r00))+(((-1.0)*sj8*x390))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((((-1.0)*cj8*x390))+(((-1.0)*new_r00*sj8))), (((cj8*new_r00))+(((-1.0)*sj8*x390))));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x391=IKsin(j10);
IkReal x392=IKcos(j10);
IkReal x393=((1.0)*sj8);
IkReal x394=((1.0)*x392);
IkReal x395=(sj8*x391);
IkReal x396=(cj8*x391);
IkReal x397=(cj8*x394);
evalcond[0]=(((new_r11*sj8))+x391+((cj8*new_r01)));
evalcond[1]=(((sj8*x392))+x396+new_r01);
evalcond[2]=((((-1.0)*x394))+((new_r10*sj8))+((cj8*new_r00)));
evalcond[3]=((((-1.0)*x391))+((cj8*new_r10))+(((-1.0)*new_r00*x393)));
evalcond[4]=((((-1.0)*new_r01*x393))+(((-1.0)*x394))+((cj8*new_r11)));
evalcond[5]=((((-1.0)*x397))+x395+new_r00);
evalcond[6]=((((-1.0)*x397))+x395+new_r11);
evalcond[7]=((((-1.0)*x396))+new_r10+(((-1.0)*x392*x393)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j9)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
IkReal x398=((1.0)*new_r00);
if( IKabs((((cj8*new_r01))+(((-1.0)*sj8*x398)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*new_r01*sj8))+(((-1.0)*cj8*x398)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((((cj8*new_r01))+(((-1.0)*sj8*x398))))+IKsqr(((((-1.0)*new_r01*sj8))+(((-1.0)*cj8*x398))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2((((cj8*new_r01))+(((-1.0)*sj8*x398))), ((((-1.0)*new_r01*sj8))+(((-1.0)*cj8*x398))));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x399=IKsin(j10);
IkReal x400=IKcos(j10);
IkReal x401=((1.0)*sj8);
IkReal x402=((1.0)*x399);
IkReal x403=(sj8*x400);
IkReal x404=((1.0)*x400);
IkReal x405=(cj8*x402);
evalcond[0]=(((new_r10*sj8))+((cj8*new_r00))+x400);
evalcond[1]=(((new_r11*sj8))+((cj8*new_r01))+(((-1.0)*x402)));
evalcond[2]=(((sj8*x399))+((cj8*x400))+new_r00);
evalcond[3]=(((cj8*new_r10))+(((-1.0)*new_r00*x401))+(((-1.0)*x402)));
evalcond[4]=(((cj8*new_r11))+(((-1.0)*new_r01*x401))+(((-1.0)*x404)));
evalcond[5]=(x403+new_r01+(((-1.0)*x405)));
evalcond[6]=(x403+new_r10+(((-1.0)*x405)));
evalcond[7]=((((-1.0)*cj8*x404))+(((-1.0)*x399*x401))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j8))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r10)+IKsqr(new_r11)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(new_r10, new_r11);
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x406=IKcos(j10);
IkReal x407=IKsin(j10);
IkReal x408=((1.0)*sj9);
IkReal x409=((1.0)*x406);
evalcond[0]=(new_r20+((sj9*x406)));
evalcond[1]=(new_r10+(((-1.0)*x407)));
evalcond[2]=(new_r11+(((-1.0)*x409)));
evalcond[3]=(new_r01+((cj9*x407)));
evalcond[4]=((((-1.0)*x407*x408))+new_r21);
evalcond[5]=((((-1.0)*cj9*x409))+new_r00);
evalcond[6]=(((cj9*new_r01))+x407+(((-1.0)*new_r21*x408)));
evalcond[7]=(((cj9*new_r00))+(((-1.0)*new_r20*x408))+(((-1.0)*x409)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j8)))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10eval[3];
sj8=0;
cj8=-1.0;
j8=3.14159265358979;
j10eval[0]=sj9;
j10eval[1]=IKsign(sj9);
j10eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  || IKabs(j10eval[2]) < 0.0000010000000000  )
{
{
IkReal j10eval[1];
sj8=0;
cj8=-1.0;
j8=3.14159265358979;
j10eval[0]=sj9;
if( IKabs(j10eval[0]) < 0.0000010000000000  )
{
{
IkReal j10eval[2];
sj8=0;
cj8=-1.0;
j8=3.14159265358979;
j10eval[0]=cj9;
j10eval[1]=sj9;
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j9)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x410=IKcos(j10);
IkReal x411=((1.0)*(IKsin(j10)));
evalcond[0]=(x410+new_r20);
evalcond[1]=(new_r21+(((-1.0)*x411)));
evalcond[2]=((((-1.0)*new_r10))+(((-1.0)*x411)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x410)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j9)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x412=IKsin(j10);
IkReal x413=((1.0)*(IKcos(j10)));
evalcond[0]=(x412+new_r21);
evalcond[1]=(new_r20+(((-1.0)*x413)));
evalcond[2]=((((-1.0)*new_r10))+(((-1.0)*x412)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x413)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j9))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r01)+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(new_r01, ((-1.0)*new_r11));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x414=IKsin(j10);
IkReal x415=((1.0)*(IKcos(j10)));
evalcond[0]=(x414+(((-1.0)*new_r01)));
evalcond[1]=((((-1.0)*new_r10))+(((-1.0)*x414)));
evalcond[2]=((((-1.0)*new_r11))+(((-1.0)*x415)));
evalcond[3]=((((-1.0)*new_r00))+(((-1.0)*x415)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j9)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(new_r00)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r10), new_r00);
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x416=IKcos(j10);
IkReal x417=((1.0)*(IKsin(j10)));
evalcond[0]=(x416+(((-1.0)*new_r00)));
evalcond[1]=((((-1.0)*new_r10))+(((-1.0)*x417)));
evalcond[2]=((((-1.0)*new_r11))+(((-1.0)*x416)));
evalcond[3]=((((-1.0)*new_r01))+(((-1.0)*x417)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r10), ((-1.0)*new_r11));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[6];
IkReal x418=IKsin(j10);
IkReal x419=IKcos(j10);
IkReal x420=((-1.0)*x419);
evalcond[0]=x418;
evalcond[1]=(new_r22*x418);
evalcond[2]=x420;
evalcond[3]=(new_r22*x420);
evalcond[4]=((((-1.0)*new_r10))+(((-1.0)*x418)));
evalcond[5]=((((-1.0)*new_r11))+(((-1.0)*x419)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j10]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x421=IKPowWithIntegerCheck(cj9,-1);
if(!x421.valid){
continue;
}
CheckValue<IkReal> x422=IKPowWithIntegerCheck(sj9,-1);
if(!x422.valid){
continue;
}
if( IKabs((new_r01*(x421.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*(x422.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r01*(x421.value)))+IKsqr(((-1.0)*new_r20*(x422.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2((new_r01*(x421.value)), ((-1.0)*new_r20*(x422.value)));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x423=IKsin(j10);
IkReal x424=IKcos(j10);
IkReal x425=((1.0)*sj9);
IkReal x426=((1.0)*new_r01);
IkReal x427=((1.0)*new_r00);
IkReal x428=((1.0)*x424);
evalcond[0]=(((sj9*x424))+new_r20);
evalcond[1]=(new_r21+(((-1.0)*x423*x425)));
evalcond[2]=((((-1.0)*x423))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x428))+(((-1.0)*new_r11)));
evalcond[4]=(((cj9*x423))+(((-1.0)*x426)));
evalcond[5]=((((-1.0)*cj9*x428))+(((-1.0)*x427)));
evalcond[6]=((((-1.0)*cj9*x426))+x423+(((-1.0)*new_r21*x425)));
evalcond[7]=((((-1.0)*cj9*x427))+(((-1.0)*x428))+(((-1.0)*new_r20*x425)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x429=IKPowWithIntegerCheck(sj9,-1);
if(!x429.valid){
continue;
}
if( IKabs((new_r21*(x429.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r21*(x429.value)))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2((new_r21*(x429.value)), ((-1.0)*new_r11));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x430=IKsin(j10);
IkReal x431=IKcos(j10);
IkReal x432=((1.0)*sj9);
IkReal x433=((1.0)*new_r01);
IkReal x434=((1.0)*new_r00);
IkReal x435=((1.0)*x431);
evalcond[0]=(((sj9*x431))+new_r20);
evalcond[1]=((((-1.0)*x430*x432))+new_r21);
evalcond[2]=((((-1.0)*x430))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x435))+(((-1.0)*new_r11)));
evalcond[4]=((((-1.0)*x433))+((cj9*x430)));
evalcond[5]=((((-1.0)*x434))+(((-1.0)*cj9*x435)));
evalcond[6]=((((-1.0)*cj9*x433))+x430+(((-1.0)*new_r21*x432)));
evalcond[7]=((((-1.0)*x435))+(((-1.0)*cj9*x434))+(((-1.0)*new_r20*x432)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x436 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x436.valid){
continue;
}
CheckValue<IkReal> x437=IKPowWithIntegerCheck(IKsign(sj9),-1);
if(!x437.valid){
continue;
}
j10array[0]=((-1.5707963267949)+(x436.value)+(((1.5707963267949)*(x437.value))));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x438=IKsin(j10);
IkReal x439=IKcos(j10);
IkReal x440=((1.0)*sj9);
IkReal x441=((1.0)*new_r01);
IkReal x442=((1.0)*new_r00);
IkReal x443=((1.0)*x439);
evalcond[0]=(((sj9*x439))+new_r20);
evalcond[1]=((((-1.0)*x438*x440))+new_r21);
evalcond[2]=((((-1.0)*x438))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x443))+(((-1.0)*new_r11)));
evalcond[4]=((((-1.0)*x441))+((cj9*x438)));
evalcond[5]=((((-1.0)*x442))+(((-1.0)*cj9*x443)));
evalcond[6]=((((-1.0)*cj9*x441))+x438+(((-1.0)*new_r21*x440)));
evalcond[7]=((((-1.0)*x443))+(((-1.0)*cj9*x442))+(((-1.0)*new_r20*x440)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10eval[1];
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
j10eval[0]=IKabs(new_r22);
if( IKabs(j10eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j10]

} else
{
IkReal op[2+1], zeror[2];
int numroots;
op[0]=new_r22;
op[1]=0;
op[2]=((-1.0)*new_r22);
polyroots2(op,zeror,numroots);
IkReal j10array[2], cj10array[2], sj10array[2], tempj10array[1];
int numsolutions = 0;
for(int ij10 = 0; ij10 < numroots; ++ij10)
{
IkReal htj10 = zeror[ij10];
tempj10array[0]=((2.0)*(atan(htj10)));
for(int kj10 = 0; kj10 < 1; ++kj10)
{
j10array[numsolutions] = tempj10array[kj10];
if( j10array[numsolutions] > IKPI )
{
    j10array[numsolutions]-=IK2PI;
}
else if( j10array[numsolutions] < -IKPI )
{
    j10array[numsolutions]+=IK2PI;
}
sj10array[numsolutions] = IKsin(j10array[numsolutions]);
cj10array[numsolutions] = IKcos(j10array[numsolutions]);
numsolutions++;
}
}
bool j10valid[2]={true,true};
_nj10 = 2;
for(int ij10 = 0; ij10 < numsolutions; ++ij10)
    {
if( !j10valid[ij10] )
{
    continue;
}
    j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
htj10 = IKtan(j10/2);

_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < numsolutions; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j10]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x445=IKPowWithIntegerCheck(sj9,-1);
if(!x445.valid){
continue;
}
IkReal x444=x445.value;
CheckValue<IkReal> x446=IKPowWithIntegerCheck(cj8,-1);
if(!x446.valid){
continue;
}
CheckValue<IkReal> x447=IKPowWithIntegerCheck(cj9,-1);
if(!x447.valid){
continue;
}
if( IKabs((x444*(x446.value)*(x447.value)*((((new_r20*sj8))+(((-1.0)*new_r01*sj9)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*x444)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x444*(x446.value)*(x447.value)*((((new_r20*sj8))+(((-1.0)*new_r01*sj9))))))+IKsqr(((-1.0)*new_r20*x444))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2((x444*(x446.value)*(x447.value)*((((new_r20*sj8))+(((-1.0)*new_r01*sj9))))), ((-1.0)*new_r20*x444));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[12];
IkReal x448=IKsin(j10);
IkReal x449=IKcos(j10);
IkReal x450=(cj9*sj8);
IkReal x451=((1.0)*sj9);
IkReal x452=((1.0)*sj8);
IkReal x453=((1.0)*cj8);
IkReal x454=(cj8*new_r00);
IkReal x455=(cj8*new_r01);
IkReal x456=((1.0)*x449);
IkReal x457=(cj9*x448);
IkReal x458=(cj9*x456);
evalcond[0]=(((sj9*x449))+new_r20);
evalcond[1]=(new_r21+(((-1.0)*x448*x451)));
evalcond[2]=(((new_r11*sj8))+x457+x455);
evalcond[3]=((((-1.0)*x448))+(((-1.0)*new_r00*x452))+((cj8*new_r10)));
evalcond[4]=((((-1.0)*new_r01*x452))+((cj8*new_r11))+(((-1.0)*x456)));
evalcond[5]=(((cj8*x457))+new_r01+((sj8*x449)));
evalcond[6]=(((new_r10*sj8))+(((-1.0)*x458))+x454);
evalcond[7]=((((-1.0)*cj9*x449*x453))+new_r00+((sj8*x448)));
evalcond[8]=(((x448*x450))+new_r11+(((-1.0)*x449*x453)));
evalcond[9]=((((-1.0)*x450*x456))+new_r10+(((-1.0)*x448*x453)));
evalcond[10]=((((-1.0)*new_r21*x451))+((new_r11*x450))+((cj9*x455))+x448);
evalcond[11]=(((new_r10*x450))+(((-1.0)*new_r20*x451))+((cj9*x454))+(((-1.0)*x456)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x460=IKPowWithIntegerCheck(sj9,-1);
if(!x460.valid){
continue;
}
IkReal x459=x460.value;
CheckValue<IkReal> x461=IKPowWithIntegerCheck(sj8,-1);
if(!x461.valid){
continue;
}
if( IKabs((x459*(x461.value)*(((((-1.0)*cj8*cj9*new_r20))+(((-1.0)*new_r00*sj9)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*x459)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x459*(x461.value)*(((((-1.0)*cj8*cj9*new_r20))+(((-1.0)*new_r00*sj9))))))+IKsqr(((-1.0)*new_r20*x459))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2((x459*(x461.value)*(((((-1.0)*cj8*cj9*new_r20))+(((-1.0)*new_r00*sj9))))), ((-1.0)*new_r20*x459));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[12];
IkReal x462=IKsin(j10);
IkReal x463=IKcos(j10);
IkReal x464=(cj9*sj8);
IkReal x465=((1.0)*sj9);
IkReal x466=((1.0)*sj8);
IkReal x467=((1.0)*cj8);
IkReal x468=(cj8*new_r00);
IkReal x469=(cj8*new_r01);
IkReal x470=((1.0)*x463);
IkReal x471=(cj9*x462);
IkReal x472=(cj9*x470);
evalcond[0]=(new_r20+((sj9*x463)));
evalcond[1]=((((-1.0)*x462*x465))+new_r21);
evalcond[2]=(((new_r11*sj8))+x469+x471);
evalcond[3]=((((-1.0)*x462))+((cj8*new_r10))+(((-1.0)*new_r00*x466)));
evalcond[4]=((((-1.0)*x470))+(((-1.0)*new_r01*x466))+((cj8*new_r11)));
evalcond[5]=(((cj8*x471))+new_r01+((sj8*x463)));
evalcond[6]=(((new_r10*sj8))+(((-1.0)*x472))+x468);
evalcond[7]=((((-1.0)*cj9*x463*x467))+new_r00+((sj8*x462)));
evalcond[8]=((((-1.0)*x463*x467))+new_r11+((x462*x464)));
evalcond[9]=((((-1.0)*x462*x467))+(((-1.0)*x464*x470))+new_r10);
evalcond[10]=((((-1.0)*new_r21*x465))+((new_r11*x464))+((cj9*x469))+x462);
evalcond[11]=(((new_r10*x464))+(((-1.0)*new_r20*x465))+((cj9*x468))+(((-1.0)*x470)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x473 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x473.valid){
continue;
}
CheckValue<IkReal> x474=IKPowWithIntegerCheck(IKsign(sj9),-1);
if(!x474.valid){
continue;
}
j10array[0]=((-1.5707963267949)+(x473.value)+(((1.5707963267949)*(x474.value))));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[12];
IkReal x475=IKsin(j10);
IkReal x476=IKcos(j10);
IkReal x477=(cj9*sj8);
IkReal x478=((1.0)*sj9);
IkReal x479=((1.0)*sj8);
IkReal x480=((1.0)*cj8);
IkReal x481=(cj8*new_r00);
IkReal x482=(cj8*new_r01);
IkReal x483=((1.0)*x476);
IkReal x484=(cj9*x475);
IkReal x485=(cj9*x483);
evalcond[0]=(((sj9*x476))+new_r20);
evalcond[1]=((((-1.0)*x475*x478))+new_r21);
evalcond[2]=(((new_r11*sj8))+x482+x484);
evalcond[3]=((((-1.0)*new_r00*x479))+((cj8*new_r10))+(((-1.0)*x475)));
evalcond[4]=((((-1.0)*x483))+(((-1.0)*new_r01*x479))+((cj8*new_r11)));
evalcond[5]=(((sj8*x476))+new_r01+((cj8*x484)));
evalcond[6]=(((new_r10*sj8))+(((-1.0)*x485))+x481);
evalcond[7]=((((-1.0)*cj9*x476*x480))+((sj8*x475))+new_r00);
evalcond[8]=((((-1.0)*x476*x480))+new_r11+((x475*x477)));
evalcond[9]=((((-1.0)*x475*x480))+(((-1.0)*x477*x483))+new_r10);
evalcond[10]=((((-1.0)*new_r21*x478))+((new_r11*x477))+x475+((cj9*x482)));
evalcond[11]=((((-1.0)*x483))+((new_r10*x477))+((cj9*x481))+(((-1.0)*new_r20*x478)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x486 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x486.valid){
continue;
}
CheckValue<IkReal> x487=IKPowWithIntegerCheck(IKsign(sj9),-1);
if(!x487.valid){
continue;
}
j10array[0]=((-1.5707963267949)+(x486.value)+(((1.5707963267949)*(x487.value))));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[2];
evalcond[0]=(((sj9*(IKcos(j10))))+new_r20);
evalcond[1]=((((-1.0)*sj9*(IKsin(j10))))+new_r21);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j8eval[3];
j8eval[0]=sj9;
j8eval[1]=((IKabs(new_r12))+(IKabs(new_r02)));
j8eval[2]=IKsign(sj9);
if( IKabs(j8eval[0]) < 0.0000010000000000  || IKabs(j8eval[1]) < 0.0000010000000000  || IKabs(j8eval[2]) < 0.0000010000000000  )
{
{
IkReal j8eval[2];
j8eval[0]=cj10;
j8eval[1]=sj9;
if( IKabs(j8eval[0]) < 0.0000010000000000  || IKabs(j8eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j10)))), 6.28318530717959)));
evalcond[1]=new_r20;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j8array[1], cj8array[1], sj8array[1];
bool j8valid[1]={false};
_nj8 = 1;
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(new_r10)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j8array[0]=IKatan2(((-1.0)*new_r00), new_r10);
sj8array[0]=IKsin(j8array[0]);
cj8array[0]=IKcos(j8array[0]);
if( j8array[0] > IKPI )
{
    j8array[0]-=IK2PI;
}
else if( j8array[0] < -IKPI )
{    j8array[0]+=IK2PI;
}
j8valid[0] = true;
for(int ij8 = 0; ij8 < 1; ++ij8)
{
if( !j8valid[ij8] )
{
    continue;
}
_ij8[0] = ij8; _ij8[1] = -1;
for(int iij8 = ij8+1; iij8 < 1; ++iij8)
{
if( j8valid[iij8] && IKabs(cj8array[ij8]-cj8array[iij8]) < IKFAST_SOLUTION_THRESH && IKabs(sj8array[ij8]-sj8array[iij8]) < IKFAST_SOLUTION_THRESH )
{
    j8valid[iij8]=false; _ij8[1] = iij8; break; 
}
}
j8 = j8array[ij8]; cj8 = cj8array[ij8]; sj8 = sj8array[ij8];
{
IkReal evalcond[18];
IkReal x488=IKsin(j8);
IkReal x489=IKcos(j8);
IkReal x490=((1.0)*sj9);
IkReal x491=((1.0)*x488);
IkReal x492=(cj9*x488);
IkReal x493=(new_r11*x488);
IkReal x494=(new_r10*x488);
IkReal x495=(new_r02*x489);
IkReal x496=(cj9*x489);
IkReal x497=(new_r12*x488);
IkReal x498=(new_r01*x489);
IkReal x499=(new_r00*x489);
evalcond[0]=(x488+new_r00);
evalcond[1]=(x496+new_r01);
evalcond[2]=(x492+new_r11);
evalcond[3]=((((-1.0)*x489))+new_r10);
evalcond[4]=((((-1.0)*x489*x490))+new_r02);
evalcond[5]=((((-1.0)*x488*x490))+new_r12);
evalcond[6]=(x499+x494);
evalcond[7]=((((-1.0)*new_r02*x491))+((new_r12*x489)));
evalcond[8]=((((-1.0)*new_r01*x491))+((new_r11*x489)));
evalcond[9]=(cj9+x498+x493);
evalcond[10]=((-1.0)+(((-1.0)*new_r00*x491))+((new_r10*x489)));
evalcond[11]=(((sj9*x499))+((sj9*x494)));
evalcond[12]=(((new_r10*x492))+((new_r00*x496)));
evalcond[13]=((((-1.0)*x490))+x497+x495);
evalcond[14]=(((cj9*new_r21))+((sj9*x498))+((sj9*x493)));
evalcond[15]=((-1.0)+((cj9*new_r22))+((sj9*x495))+((sj9*x497)));
evalcond[16]=(((new_r12*x492))+(((-1.0)*new_r22*x490))+((cj9*x495)));
evalcond[17]=((1.0)+(((-1.0)*new_r21*x490))+((new_r11*x492))+((new_r01*x496)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j10)))), 6.28318530717959)));
evalcond[1]=new_r20;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j8array[1], cj8array[1], sj8array[1];
bool j8valid[1]={false};
_nj8 = 1;
if( IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r00)+IKsqr(((-1.0)*new_r10))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j8array[0]=IKatan2(new_r00, ((-1.0)*new_r10));
sj8array[0]=IKsin(j8array[0]);
cj8array[0]=IKcos(j8array[0]);
if( j8array[0] > IKPI )
{
    j8array[0]-=IK2PI;
}
else if( j8array[0] < -IKPI )
{    j8array[0]+=IK2PI;
}
j8valid[0] = true;
for(int ij8 = 0; ij8 < 1; ++ij8)
{
if( !j8valid[ij8] )
{
    continue;
}
_ij8[0] = ij8; _ij8[1] = -1;
for(int iij8 = ij8+1; iij8 < 1; ++iij8)
{
if( j8valid[iij8] && IKabs(cj8array[ij8]-cj8array[iij8]) < IKFAST_SOLUTION_THRESH && IKabs(sj8array[ij8]-sj8array[iij8]) < IKFAST_SOLUTION_THRESH )
{
    j8valid[iij8]=false; _ij8[1] = iij8; break; 
}
}
j8 = j8array[ij8]; cj8 = cj8array[ij8]; sj8 = sj8array[ij8];
{
IkReal evalcond[18];
IkReal x500=IKcos(j8);
IkReal x501=IKsin(j8);
IkReal x502=((1.0)*cj9);
IkReal x503=((1.0)*sj9);
IkReal x504=((1.0)*x501);
IkReal x505=(new_r11*x501);
IkReal x506=(new_r10*x501);
IkReal x507=(new_r02*x500);
IkReal x508=(cj9*x500);
IkReal x509=(new_r12*x501);
IkReal x510=(new_r01*x500);
IkReal x511=(new_r00*x500);
evalcond[0]=(x500+new_r10);
evalcond[1]=((((-1.0)*x504))+new_r00);
evalcond[2]=(new_r02+(((-1.0)*x500*x503)));
evalcond[3]=((((-1.0)*x501*x503))+new_r12);
evalcond[4]=(new_r01+(((-1.0)*x500*x502)));
evalcond[5]=((((-1.0)*x501*x502))+new_r11);
evalcond[6]=(x506+x511);
evalcond[7]=((((-1.0)*new_r02*x504))+((new_r12*x500)));
evalcond[8]=((((-1.0)*new_r01*x504))+((new_r11*x500)));
evalcond[9]=((1.0)+(((-1.0)*new_r00*x504))+((new_r10*x500)));
evalcond[10]=(((sj9*x511))+((sj9*x506)));
evalcond[11]=(((cj9*x506))+((new_r00*x508)));
evalcond[12]=((((-1.0)*x503))+x509+x507);
evalcond[13]=((((-1.0)*x502))+x505+x510);
evalcond[14]=(((cj9*new_r21))+((sj9*x510))+((sj9*x505)));
evalcond[15]=((-1.0)+((cj9*new_r22))+((sj9*x509))+((sj9*x507)));
evalcond[16]=(((cj9*x509))+((cj9*x507))+(((-1.0)*new_r22*x503)));
evalcond[17]=((-1.0)+(sj9*sj9)+((cj9*x505))+((new_r01*x508)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j9))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j8array[1], cj8array[1], sj8array[1];
bool j8valid[1]={false};
_nj8 = 1;
IkReal x512=((1.0)*sj10);
if( IKabs(((((-1.0)*cj10*new_r01))+(((-1.0)*new_r00*x512)))) < IKFAST_ATAN2_MAGTHRESH && IKabs((((cj10*new_r00))+(((-1.0)*new_r01*x512)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*cj10*new_r01))+(((-1.0)*new_r00*x512))))+IKsqr((((cj10*new_r00))+(((-1.0)*new_r01*x512))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j8array[0]=IKatan2(((((-1.0)*cj10*new_r01))+(((-1.0)*new_r00*x512))), (((cj10*new_r00))+(((-1.0)*new_r01*x512))));
sj8array[0]=IKsin(j8array[0]);
cj8array[0]=IKcos(j8array[0]);
if( j8array[0] > IKPI )
{
    j8array[0]-=IK2PI;
}
else if( j8array[0] < -IKPI )
{    j8array[0]+=IK2PI;
}
j8valid[0] = true;
for(int ij8 = 0; ij8 < 1; ++ij8)
{
if( !j8valid[ij8] )
{
    continue;
}
_ij8[0] = ij8; _ij8[1] = -1;
for(int iij8 = ij8+1; iij8 < 1; ++iij8)
{
if( j8valid[iij8] && IKabs(cj8array[ij8]-cj8array[iij8]) < IKFAST_SOLUTION_THRESH && IKabs(sj8array[ij8]-sj8array[iij8]) < IKFAST_SOLUTION_THRESH )
{
    j8valid[iij8]=false; _ij8[1] = iij8; break; 
}
}
j8 = j8array[ij8]; cj8 = cj8array[ij8]; sj8 = sj8array[ij8];
{
IkReal evalcond[8];
IkReal x513=IKsin(j8);
IkReal x514=IKcos(j8);
IkReal x515=((1.0)*cj10);
IkReal x516=((1.0)*sj10);
IkReal x517=(sj10*x513);
IkReal x518=((1.0)*x513);
IkReal x519=(x514*x515);
evalcond[0]=(((new_r01*x514))+((new_r11*x513))+sj10);
evalcond[1]=(((sj10*x514))+((cj10*x513))+new_r01);
evalcond[2]=(x517+new_r00+(((-1.0)*x519)));
evalcond[3]=(x517+new_r11+(((-1.0)*x519)));
evalcond[4]=(((new_r00*x514))+((new_r10*x513))+(((-1.0)*x515)));
evalcond[5]=((((-1.0)*x514*x516))+(((-1.0)*x513*x515))+new_r10);
evalcond[6]=(((new_r10*x514))+(((-1.0)*new_r00*x518))+(((-1.0)*x516)));
evalcond[7]=(((new_r11*x514))+(((-1.0)*new_r01*x518))+(((-1.0)*x515)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j9)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j8array[1], cj8array[1], sj8array[1];
bool j8valid[1]={false};
_nj8 = 1;
IkReal x520=((1.0)*new_r00);
if( IKabs(((((-1.0)*cj10*new_r01))+(((-1.0)*sj10*x520)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*cj10*x520))+((new_r01*sj10)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*cj10*new_r01))+(((-1.0)*sj10*x520))))+IKsqr(((((-1.0)*cj10*x520))+((new_r01*sj10))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j8array[0]=IKatan2(((((-1.0)*cj10*new_r01))+(((-1.0)*sj10*x520))), ((((-1.0)*cj10*x520))+((new_r01*sj10))));
sj8array[0]=IKsin(j8array[0]);
cj8array[0]=IKcos(j8array[0]);
if( j8array[0] > IKPI )
{
    j8array[0]-=IK2PI;
}
else if( j8array[0] < -IKPI )
{    j8array[0]+=IK2PI;
}
j8valid[0] = true;
for(int ij8 = 0; ij8 < 1; ++ij8)
{
if( !j8valid[ij8] )
{
    continue;
}
_ij8[0] = ij8; _ij8[1] = -1;
for(int iij8 = ij8+1; iij8 < 1; ++iij8)
{
if( j8valid[iij8] && IKabs(cj8array[ij8]-cj8array[iij8]) < IKFAST_SOLUTION_THRESH && IKabs(sj8array[ij8]-sj8array[iij8]) < IKFAST_SOLUTION_THRESH )
{
    j8valid[iij8]=false; _ij8[1] = iij8; break; 
}
}
j8 = j8array[ij8]; cj8 = cj8array[ij8]; sj8 = sj8array[ij8];
{
IkReal evalcond[8];
IkReal x521=IKcos(j8);
IkReal x522=IKsin(j8);
IkReal x523=((1.0)*sj10);
IkReal x524=((1.0)*cj10);
IkReal x525=(cj10*x522);
IkReal x526=((1.0)*x522);
IkReal x527=(x521*x523);
evalcond[0]=(((new_r10*x522))+cj10+((new_r00*x521)));
evalcond[1]=(((sj10*x522))+((cj10*x521))+new_r00);
evalcond[2]=((((-1.0)*x527))+x525+new_r01);
evalcond[3]=((((-1.0)*x527))+x525+new_r10);
evalcond[4]=(((new_r01*x521))+((new_r11*x522))+(((-1.0)*x523)));
evalcond[5]=((((-1.0)*x521*x524))+(((-1.0)*x522*x523))+new_r11);
evalcond[6]=((((-1.0)*new_r00*x526))+(((-1.0)*x523))+((new_r10*x521)));
evalcond[7]=(((new_r11*x521))+(((-1.0)*x524))+(((-1.0)*new_r01*x526)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r12))+(IKabs(new_r02)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j8eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j8eval[0]=((IKabs(new_r11))+(IKabs(new_r01)));
if( IKabs(j8eval[0]) < 0.0000010000000000  )
{
{
IkReal j8eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j8eval[0]=((IKabs(new_r10))+(IKabs(new_r00)));
if( IKabs(j8eval[0]) < 0.0000010000000000  )
{
{
IkReal j8eval[1];
new_r02=0;
new_r12=0;
new_r20=0;
new_r21=0;
j8eval[0]=((IKabs((new_r11*new_r22)))+(IKabs((new_r01*new_r22))));
if( IKabs(j8eval[0]) < 0.0000010000000000  )
{
continue; // no branches [j8]

} else
{
{
IkReal j8array[2], cj8array[2], sj8array[2];
bool j8valid[2]={false};
_nj8 = 2;
CheckValue<IkReal> x529 = IKatan2WithCheck(IkReal((new_r01*new_r22)),IkReal((new_r11*new_r22)),IKFAST_ATAN2_MAGTHRESH);
if(!x529.valid){
continue;
}
IkReal x528=x529.value;
j8array[0]=((-1.0)*x528);
sj8array[0]=IKsin(j8array[0]);
cj8array[0]=IKcos(j8array[0]);
j8array[1]=((3.14159265358979)+(((-1.0)*x528)));
sj8array[1]=IKsin(j8array[1]);
cj8array[1]=IKcos(j8array[1]);
if( j8array[0] > IKPI )
{
    j8array[0]-=IK2PI;
}
else if( j8array[0] < -IKPI )
{    j8array[0]+=IK2PI;
}
j8valid[0] = true;
if( j8array[1] > IKPI )
{
    j8array[1]-=IK2PI;
}
else if( j8array[1] < -IKPI )
{    j8array[1]+=IK2PI;
}
j8valid[1] = true;
for(int ij8 = 0; ij8 < 2; ++ij8)
{
if( !j8valid[ij8] )
{
    continue;
}
_ij8[0] = ij8; _ij8[1] = -1;
for(int iij8 = ij8+1; iij8 < 2; ++iij8)
{
if( j8valid[iij8] && IKabs(cj8array[ij8]-cj8array[iij8]) < IKFAST_SOLUTION_THRESH && IKabs(sj8array[ij8]-sj8array[iij8]) < IKFAST_SOLUTION_THRESH )
{
    j8valid[iij8]=false; _ij8[1] = iij8; break; 
}
}
j8 = j8array[ij8]; cj8 = cj8array[ij8]; sj8 = sj8array[ij8];
{
IkReal evalcond[5];
IkReal x530=IKsin(j8);
IkReal x531=IKcos(j8);
IkReal x532=(new_r00*x531);
IkReal x533=((1.0)*x530);
IkReal x534=(new_r10*x530);
evalcond[0]=(((new_r01*x531))+((new_r11*x530)));
evalcond[1]=(x532+x534);
evalcond[2]=((((-1.0)*new_r00*x533))+((new_r10*x531)));
evalcond[3]=(((new_r11*x531))+(((-1.0)*new_r01*x533)));
evalcond[4]=(((new_r22*x532))+((new_r22*x534)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j8array[2], cj8array[2], sj8array[2];
bool j8valid[2]={false};
_nj8 = 2;
CheckValue<IkReal> x536 = IKatan2WithCheck(IkReal(new_r00),IkReal(new_r10),IKFAST_ATAN2_MAGTHRESH);
if(!x536.valid){
continue;
}
IkReal x535=x536.value;
j8array[0]=((-1.0)*x535);
sj8array[0]=IKsin(j8array[0]);
cj8array[0]=IKcos(j8array[0]);
j8array[1]=((3.14159265358979)+(((-1.0)*x535)));
sj8array[1]=IKsin(j8array[1]);
cj8array[1]=IKcos(j8array[1]);
if( j8array[0] > IKPI )
{
    j8array[0]-=IK2PI;
}
else if( j8array[0] < -IKPI )
{    j8array[0]+=IK2PI;
}
j8valid[0] = true;
if( j8array[1] > IKPI )
{
    j8array[1]-=IK2PI;
}
else if( j8array[1] < -IKPI )
{    j8array[1]+=IK2PI;
}
j8valid[1] = true;
for(int ij8 = 0; ij8 < 2; ++ij8)
{
if( !j8valid[ij8] )
{
    continue;
}
_ij8[0] = ij8; _ij8[1] = -1;
for(int iij8 = ij8+1; iij8 < 2; ++iij8)
{
if( j8valid[iij8] && IKabs(cj8array[ij8]-cj8array[iij8]) < IKFAST_SOLUTION_THRESH && IKabs(sj8array[ij8]-sj8array[iij8]) < IKFAST_SOLUTION_THRESH )
{
    j8valid[iij8]=false; _ij8[1] = iij8; break; 
}
}
j8 = j8array[ij8]; cj8 = cj8array[ij8]; sj8 = sj8array[ij8];
{
IkReal evalcond[5];
IkReal x537=IKcos(j8);
IkReal x538=IKsin(j8);
IkReal x539=(new_r01*x537);
IkReal x540=(new_r11*x538);
IkReal x541=((1.0)*x538);
evalcond[0]=(x540+x539);
evalcond[1]=((((-1.0)*new_r00*x541))+((new_r10*x537)));
evalcond[2]=(((new_r11*x537))+(((-1.0)*new_r01*x541)));
evalcond[3]=(((new_r22*x540))+((new_r22*x539)));
evalcond[4]=(((new_r00*new_r22*x537))+((new_r10*new_r22*x538)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j8array[2], cj8array[2], sj8array[2];
bool j8valid[2]={false};
_nj8 = 2;
CheckValue<IkReal> x543 = IKatan2WithCheck(IkReal(new_r01),IkReal(new_r11),IKFAST_ATAN2_MAGTHRESH);
if(!x543.valid){
continue;
}
IkReal x542=x543.value;
j8array[0]=((-1.0)*x542);
sj8array[0]=IKsin(j8array[0]);
cj8array[0]=IKcos(j8array[0]);
j8array[1]=((3.14159265358979)+(((-1.0)*x542)));
sj8array[1]=IKsin(j8array[1]);
cj8array[1]=IKcos(j8array[1]);
if( j8array[0] > IKPI )
{
    j8array[0]-=IK2PI;
}
else if( j8array[0] < -IKPI )
{    j8array[0]+=IK2PI;
}
j8valid[0] = true;
if( j8array[1] > IKPI )
{
    j8array[1]-=IK2PI;
}
else if( j8array[1] < -IKPI )
{    j8array[1]+=IK2PI;
}
j8valid[1] = true;
for(int ij8 = 0; ij8 < 2; ++ij8)
{
if( !j8valid[ij8] )
{
    continue;
}
_ij8[0] = ij8; _ij8[1] = -1;
for(int iij8 = ij8+1; iij8 < 2; ++iij8)
{
if( j8valid[iij8] && IKabs(cj8array[ij8]-cj8array[iij8]) < IKFAST_SOLUTION_THRESH && IKabs(sj8array[ij8]-sj8array[iij8]) < IKFAST_SOLUTION_THRESH )
{
    j8valid[iij8]=false; _ij8[1] = iij8; break; 
}
}
j8 = j8array[ij8]; cj8 = cj8array[ij8]; sj8 = sj8array[ij8];
{
IkReal evalcond[5];
IkReal x544=IKcos(j8);
IkReal x545=IKsin(j8);
IkReal x546=(new_r22*x544);
IkReal x547=(new_r22*x545);
IkReal x548=((1.0)*x545);
evalcond[0]=(((new_r00*x544))+((new_r10*x545)));
evalcond[1]=((((-1.0)*new_r00*x548))+((new_r10*x544)));
evalcond[2]=(((new_r11*x544))+(((-1.0)*new_r01*x548)));
evalcond[3]=(((new_r11*x547))+((new_r01*x546)));
evalcond[4]=(((new_r00*x546))+((new_r10*x547)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j8]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}

} else
{
{
IkReal j8array[1], cj8array[1], sj8array[1];
bool j8valid[1]={false};
_nj8 = 1;
CheckValue<IkReal> x550=IKPowWithIntegerCheck(sj9,-1);
if(!x550.valid){
continue;
}
IkReal x549=x550.value;
CheckValue<IkReal> x551=IKPowWithIntegerCheck(cj10,-1);
if(!x551.valid){
continue;
}
if( IKabs((x549*(x551.value)*(((((-1.0)*cj9*new_r02*sj10))+(((-1.0)*new_r01*sj9)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs((new_r02*x549)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x549*(x551.value)*(((((-1.0)*cj9*new_r02*sj10))+(((-1.0)*new_r01*sj9))))))+IKsqr((new_r02*x549))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j8array[0]=IKatan2((x549*(x551.value)*(((((-1.0)*cj9*new_r02*sj10))+(((-1.0)*new_r01*sj9))))), (new_r02*x549));
sj8array[0]=IKsin(j8array[0]);
cj8array[0]=IKcos(j8array[0]);
if( j8array[0] > IKPI )
{
    j8array[0]-=IK2PI;
}
else if( j8array[0] < -IKPI )
{    j8array[0]+=IK2PI;
}
j8valid[0] = true;
for(int ij8 = 0; ij8 < 1; ++ij8)
{
if( !j8valid[ij8] )
{
    continue;
}
_ij8[0] = ij8; _ij8[1] = -1;
for(int iij8 = ij8+1; iij8 < 1; ++iij8)
{
if( j8valid[iij8] && IKabs(cj8array[ij8]-cj8array[iij8]) < IKFAST_SOLUTION_THRESH && IKabs(sj8array[ij8]-sj8array[iij8]) < IKFAST_SOLUTION_THRESH )
{
    j8valid[iij8]=false; _ij8[1] = iij8; break; 
}
}
j8 = j8array[ij8]; cj8 = cj8array[ij8]; sj8 = sj8array[ij8];
{
IkReal evalcond[18];
IkReal x552=IKcos(j8);
IkReal x553=IKsin(j8);
IkReal x554=((1.0)*cj10);
IkReal x555=((1.0)*sj9);
IkReal x556=((1.0)*sj10);
IkReal x557=((1.0)*x553);
IkReal x558=(sj10*x553);
IkReal x559=(new_r11*x553);
IkReal x560=(new_r10*x553);
IkReal x561=(new_r02*x552);
IkReal x562=(cj9*x552);
IkReal x563=(new_r12*x553);
IkReal x564=(new_r01*x552);
IkReal x565=(new_r00*x552);
evalcond[0]=((((-1.0)*x552*x555))+new_r02);
evalcond[1]=((((-1.0)*x553*x555))+new_r12);
evalcond[2]=(((new_r12*x552))+(((-1.0)*new_r02*x557)));
evalcond[3]=(((cj10*x553))+((sj10*x562))+new_r01);
evalcond[4]=((((-1.0)*x555))+x563+x561);
evalcond[5]=(((cj9*sj10))+x559+x564);
evalcond[6]=(x558+(((-1.0)*x554*x562))+new_r00);
evalcond[7]=(((cj9*x558))+(((-1.0)*x552*x554))+new_r11);
evalcond[8]=(((new_r10*x552))+(((-1.0)*new_r00*x557))+(((-1.0)*x556)));
evalcond[9]=(((new_r11*x552))+(((-1.0)*new_r01*x557))+(((-1.0)*x554)));
evalcond[10]=((((-1.0)*cj9*x554))+x565+x560);
evalcond[11]=((((-1.0)*x552*x556))+new_r10+(((-1.0)*cj9*x553*x554)));
evalcond[12]=(((cj9*new_r20))+((sj9*x565))+((sj9*x560)));
evalcond[13]=(((cj9*new_r21))+((sj9*x559))+((sj9*x564)));
evalcond[14]=((-1.0)+((cj9*new_r22))+((sj9*x561))+((sj9*x563)));
evalcond[15]=((((-1.0)*new_r22*x555))+((cj9*x561))+((cj9*x563)));
evalcond[16]=((((-1.0)*new_r21*x555))+((new_r01*x562))+((cj9*x559))+sj10);
evalcond[17]=(((new_r00*x562))+(((-1.0)*x554))+(((-1.0)*new_r20*x555))+((cj9*x560)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j8array[1], cj8array[1], sj8array[1];
bool j8valid[1]={false};
_nj8 = 1;
CheckValue<IkReal> x566 = IKatan2WithCheck(IkReal(new_r12),IkReal(new_r02),IKFAST_ATAN2_MAGTHRESH);
if(!x566.valid){
continue;
}
CheckValue<IkReal> x567=IKPowWithIntegerCheck(IKsign(sj9),-1);
if(!x567.valid){
continue;
}
j8array[0]=((-1.5707963267949)+(x566.value)+(((1.5707963267949)*(x567.value))));
sj8array[0]=IKsin(j8array[0]);
cj8array[0]=IKcos(j8array[0]);
if( j8array[0] > IKPI )
{
    j8array[0]-=IK2PI;
}
else if( j8array[0] < -IKPI )
{    j8array[0]+=IK2PI;
}
j8valid[0] = true;
for(int ij8 = 0; ij8 < 1; ++ij8)
{
if( !j8valid[ij8] )
{
    continue;
}
_ij8[0] = ij8; _ij8[1] = -1;
for(int iij8 = ij8+1; iij8 < 1; ++iij8)
{
if( j8valid[iij8] && IKabs(cj8array[ij8]-cj8array[iij8]) < IKFAST_SOLUTION_THRESH && IKabs(sj8array[ij8]-sj8array[iij8]) < IKFAST_SOLUTION_THRESH )
{
    j8valid[iij8]=false; _ij8[1] = iij8; break; 
}
}
j8 = j8array[ij8]; cj8 = cj8array[ij8]; sj8 = sj8array[ij8];
{
IkReal evalcond[18];
IkReal x568=IKcos(j8);
IkReal x569=IKsin(j8);
IkReal x570=((1.0)*cj10);
IkReal x571=((1.0)*sj9);
IkReal x572=((1.0)*sj10);
IkReal x573=((1.0)*x569);
IkReal x574=(sj10*x569);
IkReal x575=(new_r11*x569);
IkReal x576=(new_r10*x569);
IkReal x577=(new_r02*x568);
IkReal x578=(cj9*x568);
IkReal x579=(new_r12*x569);
IkReal x580=(new_r01*x568);
IkReal x581=(new_r00*x568);
evalcond[0]=((((-1.0)*x568*x571))+new_r02);
evalcond[1]=((((-1.0)*x569*x571))+new_r12);
evalcond[2]=((((-1.0)*new_r02*x573))+((new_r12*x568)));
evalcond[3]=(((sj10*x578))+((cj10*x569))+new_r01);
evalcond[4]=((((-1.0)*x571))+x579+x577);
evalcond[5]=(((cj9*sj10))+x575+x580);
evalcond[6]=((((-1.0)*x570*x578))+x574+new_r00);
evalcond[7]=(((cj9*x574))+(((-1.0)*x568*x570))+new_r11);
evalcond[8]=((((-1.0)*x572))+(((-1.0)*new_r00*x573))+((new_r10*x568)));
evalcond[9]=((((-1.0)*x570))+((new_r11*x568))+(((-1.0)*new_r01*x573)));
evalcond[10]=((((-1.0)*cj9*x570))+x576+x581);
evalcond[11]=((((-1.0)*cj9*x569*x570))+(((-1.0)*x568*x572))+new_r10);
evalcond[12]=(((cj9*new_r20))+((sj9*x576))+((sj9*x581)));
evalcond[13]=(((cj9*new_r21))+((sj9*x575))+((sj9*x580)));
evalcond[14]=((-1.0)+((cj9*new_r22))+((sj9*x579))+((sj9*x577)));
evalcond[15]=((((-1.0)*new_r22*x571))+((cj9*x579))+((cj9*x577)));
evalcond[16]=(((new_r01*x578))+sj10+((cj9*x575))+(((-1.0)*new_r21*x571)));
evalcond[17]=(((new_r00*x578))+(((-1.0)*x570))+(((-1.0)*new_r20*x571))+((cj9*x576)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[12]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[13]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[14]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[15]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[16]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[17]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j8array[1], cj8array[1], sj8array[1];
bool j8valid[1]={false};
_nj8 = 1;
CheckValue<IkReal> x582 = IKatan2WithCheck(IkReal(new_r12),IkReal(new_r02),IKFAST_ATAN2_MAGTHRESH);
if(!x582.valid){
continue;
}
CheckValue<IkReal> x583=IKPowWithIntegerCheck(IKsign(sj9),-1);
if(!x583.valid){
continue;
}
j8array[0]=((-1.5707963267949)+(x582.value)+(((1.5707963267949)*(x583.value))));
sj8array[0]=IKsin(j8array[0]);
cj8array[0]=IKcos(j8array[0]);
if( j8array[0] > IKPI )
{
    j8array[0]-=IK2PI;
}
else if( j8array[0] < -IKPI )
{    j8array[0]+=IK2PI;
}
j8valid[0] = true;
for(int ij8 = 0; ij8 < 1; ++ij8)
{
if( !j8valid[ij8] )
{
    continue;
}
_ij8[0] = ij8; _ij8[1] = -1;
for(int iij8 = ij8+1; iij8 < 1; ++iij8)
{
if( j8valid[iij8] && IKabs(cj8array[ij8]-cj8array[iij8]) < IKFAST_SOLUTION_THRESH && IKabs(sj8array[ij8]-sj8array[iij8]) < IKFAST_SOLUTION_THRESH )
{
    j8valid[iij8]=false; _ij8[1] = iij8; break; 
}
}
j8 = j8array[ij8]; cj8 = cj8array[ij8]; sj8 = sj8array[ij8];
{
IkReal evalcond[8];
IkReal x584=IKcos(j8);
IkReal x585=IKsin(j8);
IkReal x586=((1.0)*sj9);
IkReal x587=((1.0)*x585);
IkReal x588=(sj9*x584);
IkReal x589=(new_r12*x585);
IkReal x590=(new_r02*x584);
IkReal x591=(sj9*x585);
evalcond[0]=((((-1.0)*x584*x586))+new_r02);
evalcond[1]=((((-1.0)*x585*x586))+new_r12);
evalcond[2]=(((new_r12*x584))+(((-1.0)*new_r02*x587)));
evalcond[3]=(x589+x590+(((-1.0)*x586)));
evalcond[4]=(((cj9*new_r20))+((new_r10*x591))+((new_r00*x588)));
evalcond[5]=(((cj9*new_r21))+((new_r11*x591))+((new_r01*x588)));
evalcond[6]=((-1.0)+((cj9*new_r22))+((sj9*x589))+((new_r02*x588)));
evalcond[7]=(((cj9*x590))+(((-1.0)*new_r22*x586))+((cj9*x589)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
IkReal j10eval[3];
j10eval[0]=sj9;
j10eval[1]=IKsign(sj9);
j10eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  || IKabs(j10eval[2]) < 0.0000010000000000  )
{
{
IkReal j10eval[2];
j10eval[0]=sj8;
j10eval[1]=sj9;
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  )
{
{
IkReal j10eval[3];
j10eval[0]=cj8;
j10eval[1]=cj9;
j10eval[2]=sj9;
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  || IKabs(j10eval[2]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j8)))), 6.28318530717959)));
evalcond[1]=new_r02;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10eval[3];
sj8=1.0;
cj8=0;
j8=1.5707963267949;
j10eval[0]=sj9;
j10eval[1]=IKsign(sj9);
j10eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  || IKabs(j10eval[2]) < 0.0000010000000000  )
{
{
IkReal j10eval[3];
sj8=1.0;
cj8=0;
j8=1.5707963267949;
j10eval[0]=cj9;
j10eval[1]=IKsign(cj9);
j10eval[2]=((IKabs(new_r11))+(IKabs(new_r10)));
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  || IKabs(j10eval[2]) < 0.0000010000000000  )
{
{
IkReal j10eval[1];
sj8=1.0;
cj8=0;
j8=1.5707963267949;
j10eval[0]=sj9;
if( IKabs(j10eval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j9))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r12;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r11))+IKsqr(new_r10)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r11), new_r10);
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x592=IKsin(j10);
IkReal x593=((1.0)*(IKcos(j10)));
evalcond[0]=(x592+new_r11);
evalcond[1]=((((-1.0)*x593))+new_r10);
evalcond[2]=((((-1.0)*x592))+(((-1.0)*new_r00)));
evalcond[3]=((((-1.0)*x593))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j9)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r12;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r11)+IKsqr(((-1.0)*new_r10))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(new_r11, ((-1.0)*new_r10));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x594=IKcos(j10);
IkReal x595=((1.0)*(IKsin(j10)));
evalcond[0]=(x594+new_r10);
evalcond[1]=((((-1.0)*x595))+new_r11);
evalcond[2]=((((-1.0)*x595))+(((-1.0)*new_r00)));
evalcond[3]=((((-1.0)*x594))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j9)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r11;
evalcond[3]=new_r10;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x596=IKcos(j10);
IkReal x597=((1.0)*(IKsin(j10)));
evalcond[0]=(x596+new_r20);
evalcond[1]=((((-1.0)*x597))+new_r21);
evalcond[2]=((((-1.0)*x597))+(((-1.0)*new_r00)));
evalcond[3]=((((-1.0)*x596))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j9)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r11;
evalcond[3]=new_r10;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x598=IKsin(j10);
IkReal x599=((1.0)*(IKcos(j10)));
evalcond[0]=(x598+new_r21);
evalcond[1]=((((-1.0)*x599))+new_r20);
evalcond[2]=((((-1.0)*x598))+(((-1.0)*new_r00)));
evalcond[3]=((((-1.0)*x599))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r01)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(((-1.0)*new_r01))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r00), ((-1.0)*new_r01));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[6];
IkReal x600=IKsin(j10);
IkReal x601=IKcos(j10);
IkReal x602=((-1.0)*x601);
evalcond[0]=x600;
evalcond[1]=(new_r22*x600);
evalcond[2]=x602;
evalcond[3]=(new_r22*x602);
evalcond[4]=((((-1.0)*x600))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x601))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j10]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x603=IKPowWithIntegerCheck(sj9,-1);
if(!x603.valid){
continue;
}
if( IKabs(((-1.0)*new_r00)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*(x603.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r00))+IKsqr(((-1.0)*new_r20*(x603.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r00), ((-1.0)*new_r20*(x603.value)));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x604=IKsin(j10);
IkReal x605=IKcos(j10);
IkReal x606=((1.0)*sj9);
IkReal x607=((1.0)*x605);
evalcond[0]=(((sj9*x605))+new_r20);
evalcond[1]=(((cj9*x604))+new_r11);
evalcond[2]=((((-1.0)*x604*x606))+new_r21);
evalcond[3]=((((-1.0)*cj9*x607))+new_r10);
evalcond[4]=((((-1.0)*x604))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x607))+(((-1.0)*new_r01)));
evalcond[6]=(((cj9*new_r11))+x604+(((-1.0)*new_r21*x606)));
evalcond[7]=((((-1.0)*new_r20*x606))+((cj9*new_r10))+(((-1.0)*x607)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x608=IKPowWithIntegerCheck(IKsign(cj9),-1);
if(!x608.valid){
continue;
}
CheckValue<IkReal> x609 = IKatan2WithCheck(IkReal(((-1.0)*new_r11)),IkReal(new_r10),IKFAST_ATAN2_MAGTHRESH);
if(!x609.valid){
continue;
}
j10array[0]=((-1.5707963267949)+(((1.5707963267949)*(x608.value)))+(x609.value));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x610=IKsin(j10);
IkReal x611=IKcos(j10);
IkReal x612=((1.0)*sj9);
IkReal x613=((1.0)*x611);
evalcond[0]=(((sj9*x611))+new_r20);
evalcond[1]=(((cj9*x610))+new_r11);
evalcond[2]=((((-1.0)*x610*x612))+new_r21);
evalcond[3]=((((-1.0)*cj9*x613))+new_r10);
evalcond[4]=((((-1.0)*x610))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x613))+(((-1.0)*new_r01)));
evalcond[6]=((((-1.0)*new_r21*x612))+((cj9*new_r11))+x610);
evalcond[7]=(((cj9*new_r10))+(((-1.0)*x613))+(((-1.0)*new_r20*x612)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x614 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x614.valid){
continue;
}
CheckValue<IkReal> x615=IKPowWithIntegerCheck(IKsign(sj9),-1);
if(!x615.valid){
continue;
}
j10array[0]=((-1.5707963267949)+(x614.value)+(((1.5707963267949)*(x615.value))));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x616=IKsin(j10);
IkReal x617=IKcos(j10);
IkReal x618=((1.0)*sj9);
IkReal x619=((1.0)*x617);
evalcond[0]=(((sj9*x617))+new_r20);
evalcond[1]=(((cj9*x616))+new_r11);
evalcond[2]=(new_r21+(((-1.0)*x616*x618)));
evalcond[3]=((((-1.0)*cj9*x619))+new_r10);
evalcond[4]=((((-1.0)*x616))+(((-1.0)*new_r00)));
evalcond[5]=((((-1.0)*x619))+(((-1.0)*new_r01)));
evalcond[6]=((((-1.0)*new_r21*x618))+((cj9*new_r11))+x616);
evalcond[7]=(((cj9*new_r10))+(((-1.0)*x619))+(((-1.0)*new_r20*x618)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j8)))), 6.28318530717959)));
evalcond[1]=new_r02;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r00)+IKsqr(new_r01)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(new_r00, new_r01);
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x620=IKcos(j10);
IkReal x621=IKsin(j10);
IkReal x622=((1.0)*sj9);
IkReal x623=((1.0)*new_r10);
IkReal x624=((1.0)*new_r11);
IkReal x625=((1.0)*x620);
evalcond[0]=(((sj9*x620))+new_r20);
evalcond[1]=((((-1.0)*x621))+new_r00);
evalcond[2]=((((-1.0)*x625))+new_r01);
evalcond[3]=((((-1.0)*x621*x622))+new_r21);
evalcond[4]=((((-1.0)*x624))+((cj9*x621)));
evalcond[5]=((((-1.0)*cj9*x625))+(((-1.0)*x623)));
evalcond[6]=((((-1.0)*cj9*x624))+(((-1.0)*new_r21*x622))+x621);
evalcond[7]=((((-1.0)*cj9*x623))+(((-1.0)*x625))+(((-1.0)*new_r20*x622)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j9)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x626=IKcos(j10);
IkReal x627=IKsin(j10);
IkReal x628=((1.0)*sj8);
IkReal x629=((1.0)*x627);
IkReal x630=((1.0)*x626);
evalcond[0]=(x626+new_r20);
evalcond[1]=((((-1.0)*x629))+new_r21);
evalcond[2]=(((sj8*x626))+new_r01);
evalcond[3]=(((sj8*x627))+new_r00);
evalcond[4]=((((-1.0)*cj8*x630))+new_r11);
evalcond[5]=((((-1.0)*cj8*x629))+new_r10);
evalcond[6]=((((-1.0)*new_r00*x628))+(((-1.0)*x629))+((cj8*new_r10)));
evalcond[7]=((((-1.0)*new_r01*x628))+(((-1.0)*x630))+((cj8*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j9)))), 6.28318530717959)));
evalcond[1]=new_r22;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x631=IKcos(j10);
IkReal x632=IKsin(j10);
IkReal x633=((1.0)*sj8);
IkReal x634=((1.0)*x631);
IkReal x635=((1.0)*x632);
evalcond[0]=(x632+new_r21);
evalcond[1]=((((-1.0)*x634))+new_r20);
evalcond[2]=(new_r01+((sj8*x631)));
evalcond[3]=(new_r00+((sj8*x632)));
evalcond[4]=((((-1.0)*cj8*x634))+new_r11);
evalcond[5]=((((-1.0)*cj8*x635))+new_r10);
evalcond[6]=((((-1.0)*new_r00*x633))+(((-1.0)*x635))+((cj8*new_r10)));
evalcond[7]=((((-1.0)*new_r01*x633))+(((-1.0)*x634))+((cj8*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j9))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
IkReal x636=((1.0)*new_r01);
if( IKabs(((((-1.0)*cj8*x636))+(((-1.0)*new_r00*sj8)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*sj8*x636))+((cj8*new_r00)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*cj8*x636))+(((-1.0)*new_r00*sj8))))+IKsqr(((((-1.0)*sj8*x636))+((cj8*new_r00))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((((-1.0)*cj8*x636))+(((-1.0)*new_r00*sj8))), ((((-1.0)*sj8*x636))+((cj8*new_r00))));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x637=IKsin(j10);
IkReal x638=IKcos(j10);
IkReal x639=((1.0)*sj8);
IkReal x640=((1.0)*x638);
IkReal x641=(sj8*x637);
IkReal x642=(cj8*x637);
IkReal x643=(cj8*x640);
evalcond[0]=(((new_r11*sj8))+((cj8*new_r01))+x637);
evalcond[1]=(x642+new_r01+((sj8*x638)));
evalcond[2]=(((new_r10*sj8))+(((-1.0)*x640))+((cj8*new_r00)));
evalcond[3]=((((-1.0)*new_r00*x639))+((cj8*new_r10))+(((-1.0)*x637)));
evalcond[4]=((((-1.0)*new_r01*x639))+((cj8*new_r11))+(((-1.0)*x640)));
evalcond[5]=((((-1.0)*x643))+x641+new_r00);
evalcond[6]=((((-1.0)*x643))+x641+new_r11);
evalcond[7]=((((-1.0)*x642))+(((-1.0)*x638*x639))+new_r10);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j9)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r12;
evalcond[4]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  && IKabs(evalcond[4]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
IkReal x644=((1.0)*new_r00);
if( IKabs(((((-1.0)*sj8*x644))+((cj8*new_r01)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((-1.0)*new_r01*sj8))+(((-1.0)*cj8*x644)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((-1.0)*sj8*x644))+((cj8*new_r01))))+IKsqr(((((-1.0)*new_r01*sj8))+(((-1.0)*cj8*x644))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((((-1.0)*sj8*x644))+((cj8*new_r01))), ((((-1.0)*new_r01*sj8))+(((-1.0)*cj8*x644))));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x645=IKsin(j10);
IkReal x646=IKcos(j10);
IkReal x647=((1.0)*sj8);
IkReal x648=((1.0)*x645);
IkReal x649=(sj8*x646);
IkReal x650=((1.0)*x646);
IkReal x651=(cj8*x648);
evalcond[0]=(((new_r10*sj8))+((cj8*new_r00))+x646);
evalcond[1]=(((new_r11*sj8))+(((-1.0)*x648))+((cj8*new_r01)));
evalcond[2]=(((sj8*x645))+((cj8*x646))+new_r00);
evalcond[3]=(((cj8*new_r10))+(((-1.0)*x648))+(((-1.0)*new_r00*x647)));
evalcond[4]=(((cj8*new_r11))+(((-1.0)*x650))+(((-1.0)*new_r01*x647)));
evalcond[5]=((((-1.0)*x651))+x649+new_r01);
evalcond[6]=((((-1.0)*x651))+x649+new_r10);
evalcond[7]=((((-1.0)*cj8*x650))+(((-1.0)*x645*x647))+new_r11);
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j8))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(new_r10) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r11) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r10)+IKsqr(new_r11)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(new_r10, new_r11);
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x652=IKcos(j10);
IkReal x653=IKsin(j10);
IkReal x654=((1.0)*sj9);
IkReal x655=((1.0)*x652);
evalcond[0]=(new_r20+((sj9*x652)));
evalcond[1]=((((-1.0)*x653))+new_r10);
evalcond[2]=((((-1.0)*x655))+new_r11);
evalcond[3]=(((cj9*x653))+new_r01);
evalcond[4]=(new_r21+(((-1.0)*x653*x654)));
evalcond[5]=((((-1.0)*cj9*x655))+new_r00);
evalcond[6]=(((cj9*new_r01))+x653+(((-1.0)*new_r21*x654)));
evalcond[7]=(((cj9*new_r00))+(((-1.0)*x655))+(((-1.0)*new_r20*x654)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j8)))), 6.28318530717959)));
evalcond[1]=new_r12;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10eval[3];
sj8=0;
cj8=-1.0;
j8=3.14159265358979;
j10eval[0]=sj9;
j10eval[1]=IKsign(sj9);
j10eval[2]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  || IKabs(j10eval[2]) < 0.0000010000000000  )
{
{
IkReal j10eval[1];
sj8=0;
cj8=-1.0;
j8=3.14159265358979;
j10eval[0]=sj9;
if( IKabs(j10eval[0]) < 0.0000010000000000  )
{
{
IkReal j10eval[2];
sj8=0;
cj8=-1.0;
j8=3.14159265358979;
j10eval[0]=cj9;
j10eval[1]=sj9;
if( IKabs(j10eval[0]) < 0.0000010000000000  || IKabs(j10eval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-1.5707963267949)+j9)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((-1.0)*new_r20))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(new_r21, ((-1.0)*new_r20));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x656=IKcos(j10);
IkReal x657=((1.0)*(IKsin(j10)));
evalcond[0]=(x656+new_r20);
evalcond[1]=((((-1.0)*x657))+new_r21);
evalcond[2]=((((-1.0)*x657))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x656))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((1.5707963267949)+j9)))), 6.28318530717959)));
evalcond[1]=new_r22;
evalcond[2]=new_r01;
evalcond[3]=new_r00;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(((-1.0)*new_r21)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r21))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r21), new_r20);
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x658=IKsin(j10);
IkReal x659=((1.0)*(IKcos(j10)));
evalcond[0]=(x658+new_r21);
evalcond[1]=((((-1.0)*x659))+new_r20);
evalcond[2]=((((-1.0)*x658))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x659))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(j9))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(new_r01) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r01)+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(new_r01, ((-1.0)*new_r11));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x660=IKsin(j10);
IkReal x661=((1.0)*(IKcos(j10)));
evalcond[0]=(x660+(((-1.0)*new_r01)));
evalcond[1]=((((-1.0)*x660))+(((-1.0)*new_r10)));
evalcond[2]=((((-1.0)*x661))+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x661))+(((-1.0)*new_r00)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((-3.14159265358979)+(IKfmod(((3.14159265358979)+(IKabs(((-3.14159265358979)+j9)))), 6.28318530717959)));
evalcond[1]=new_r20;
evalcond[2]=new_r02;
evalcond[3]=new_r21;
if( IKabs(evalcond[0]) < 0.0000050000000000  && IKabs(evalcond[1]) < 0.0000050000000000  && IKabs(evalcond[2]) < 0.0000050000000000  && IKabs(evalcond[3]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r00) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(new_r00)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r10), new_r00);
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[4];
IkReal x662=IKcos(j10);
IkReal x663=((1.0)*(IKsin(j10)));
evalcond[0]=(x662+(((-1.0)*new_r00)));
evalcond[1]=((((-1.0)*x663))+(((-1.0)*new_r10)));
evalcond[2]=((((-1.0)*x662))+(((-1.0)*new_r11)));
evalcond[3]=((((-1.0)*x663))+(((-1.0)*new_r01)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
if( IKabs(((-1.0)*new_r10)) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((-1.0)*new_r10))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2(((-1.0)*new_r10), ((-1.0)*new_r11));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[6];
IkReal x664=IKsin(j10);
IkReal x665=IKcos(j10);
IkReal x666=((-1.0)*x665);
evalcond[0]=x664;
evalcond[1]=(new_r22*x664);
evalcond[2]=x666;
evalcond[3]=(new_r22*x666);
evalcond[4]=((((-1.0)*x664))+(((-1.0)*new_r10)));
evalcond[5]=((((-1.0)*x665))+(((-1.0)*new_r11)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j10]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x667=IKPowWithIntegerCheck(cj9,-1);
if(!x667.valid){
continue;
}
CheckValue<IkReal> x668=IKPowWithIntegerCheck(sj9,-1);
if(!x668.valid){
continue;
}
if( IKabs((new_r01*(x667.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*(x668.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r01*(x667.value)))+IKsqr(((-1.0)*new_r20*(x668.value)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2((new_r01*(x667.value)), ((-1.0)*new_r20*(x668.value)));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x669=IKsin(j10);
IkReal x670=IKcos(j10);
IkReal x671=((1.0)*sj9);
IkReal x672=((1.0)*new_r01);
IkReal x673=((1.0)*new_r00);
IkReal x674=((1.0)*x670);
evalcond[0]=(((sj9*x670))+new_r20);
evalcond[1]=((((-1.0)*x669*x671))+new_r21);
evalcond[2]=((((-1.0)*x669))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*new_r11))+(((-1.0)*x674)));
evalcond[4]=(((cj9*x669))+(((-1.0)*x672)));
evalcond[5]=((((-1.0)*cj9*x674))+(((-1.0)*x673)));
evalcond[6]=((((-1.0)*new_r21*x671))+(((-1.0)*cj9*x672))+x669);
evalcond[7]=((((-1.0)*new_r20*x671))+(((-1.0)*cj9*x673))+(((-1.0)*x674)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x675=IKPowWithIntegerCheck(sj9,-1);
if(!x675.valid){
continue;
}
if( IKabs((new_r21*(x675.value))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r11)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((new_r21*(x675.value)))+IKsqr(((-1.0)*new_r11))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2((new_r21*(x675.value)), ((-1.0)*new_r11));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x676=IKsin(j10);
IkReal x677=IKcos(j10);
IkReal x678=((1.0)*sj9);
IkReal x679=((1.0)*new_r01);
IkReal x680=((1.0)*new_r00);
IkReal x681=((1.0)*x677);
evalcond[0]=(((sj9*x677))+new_r20);
evalcond[1]=((((-1.0)*x676*x678))+new_r21);
evalcond[2]=((((-1.0)*x676))+(((-1.0)*new_r10)));
evalcond[3]=((((-1.0)*x681))+(((-1.0)*new_r11)));
evalcond[4]=(((cj9*x676))+(((-1.0)*x679)));
evalcond[5]=((((-1.0)*cj9*x681))+(((-1.0)*x680)));
evalcond[6]=((((-1.0)*new_r21*x678))+(((-1.0)*cj9*x679))+x676);
evalcond[7]=((((-1.0)*cj9*x680))+(((-1.0)*x681))+(((-1.0)*new_r20*x678)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x682 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x682.valid){
continue;
}
CheckValue<IkReal> x683=IKPowWithIntegerCheck(IKsign(sj9),-1);
if(!x683.valid){
continue;
}
j10array[0]=((-1.5707963267949)+(x682.value)+(((1.5707963267949)*(x683.value))));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[8];
IkReal x684=IKsin(j10);
IkReal x685=IKcos(j10);
IkReal x686=((1.0)*sj9);
IkReal x687=((1.0)*new_r01);
IkReal x688=((1.0)*new_r00);
IkReal x689=((1.0)*x685);
evalcond[0]=(((sj9*x685))+new_r20);
evalcond[1]=((((-1.0)*x684*x686))+new_r21);
evalcond[2]=((((-1.0)*new_r10))+(((-1.0)*x684)));
evalcond[3]=((((-1.0)*x689))+(((-1.0)*new_r11)));
evalcond[4]=(((cj9*x684))+(((-1.0)*x687)));
evalcond[5]=((((-1.0)*cj9*x689))+(((-1.0)*x688)));
evalcond[6]=((((-1.0)*cj9*x687))+(((-1.0)*new_r21*x686))+x684);
evalcond[7]=((((-1.0)*cj9*x688))+(((-1.0)*x689))+(((-1.0)*new_r20*x686)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
evalcond[0]=((IKabs(new_r20))+(IKabs(new_r21)));
if( IKabs(evalcond[0]) < 0.0000050000000000  )
{
bgotonextstatement=false;
{
IkReal j10eval[1];
new_r21=0;
new_r20=0;
new_r02=0;
new_r12=0;
j10eval[0]=IKabs(new_r22);
if( IKabs(j10eval[0]) < 0.0000000100000000  )
{
continue; // no branches [j10]

} else
{
IkReal op[2+1], zeror[2];
int numroots;
op[0]=new_r22;
op[1]=0;
op[2]=((-1.0)*new_r22);
polyroots2(op,zeror,numroots);
IkReal j10array[2], cj10array[2], sj10array[2], tempj10array[1];
int numsolutions = 0;
for(int ij10 = 0; ij10 < numroots; ++ij10)
{
IkReal htj10 = zeror[ij10];
tempj10array[0]=((2.0)*(atan(htj10)));
for(int kj10 = 0; kj10 < 1; ++kj10)
{
j10array[numsolutions] = tempj10array[kj10];
if( j10array[numsolutions] > IKPI )
{
    j10array[numsolutions]-=IK2PI;
}
else if( j10array[numsolutions] < -IKPI )
{
    j10array[numsolutions]+=IK2PI;
}
sj10array[numsolutions] = IKsin(j10array[numsolutions]);
cj10array[numsolutions] = IKcos(j10array[numsolutions]);
numsolutions++;
}
}
bool j10valid[2]={true,true};
_nj10 = 2;
for(int ij10 = 0; ij10 < numsolutions; ++ij10)
    {
if( !j10valid[ij10] )
{
    continue;
}
    j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
htj10 = IKtan(j10/2);

_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < numsolutions; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
    }

}

}

}
} while(0);
if( bgotonextstatement )
{
bool bgotonextstatement = true;
do
{
if( 1 )
{
bgotonextstatement=false;
continue; // branch miss [j10]

}
} while(0);
if( bgotonextstatement )
{
}
}
}
}
}
}
}
}
}
}
}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x691=IKPowWithIntegerCheck(sj9,-1);
if(!x691.valid){
continue;
}
IkReal x690=x691.value;
CheckValue<IkReal> x692=IKPowWithIntegerCheck(cj8,-1);
if(!x692.valid){
continue;
}
CheckValue<IkReal> x693=IKPowWithIntegerCheck(cj9,-1);
if(!x693.valid){
continue;
}
if( IKabs((x690*(x692.value)*(x693.value)*((((new_r20*sj8))+(((-1.0)*new_r01*sj9)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*x690)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x690*(x692.value)*(x693.value)*((((new_r20*sj8))+(((-1.0)*new_r01*sj9))))))+IKsqr(((-1.0)*new_r20*x690))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2((x690*(x692.value)*(x693.value)*((((new_r20*sj8))+(((-1.0)*new_r01*sj9))))), ((-1.0)*new_r20*x690));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[12];
IkReal x694=IKsin(j10);
IkReal x695=IKcos(j10);
IkReal x696=(cj9*sj8);
IkReal x697=((1.0)*sj9);
IkReal x698=((1.0)*sj8);
IkReal x699=((1.0)*cj8);
IkReal x700=(cj8*new_r00);
IkReal x701=(cj8*new_r01);
IkReal x702=((1.0)*x695);
IkReal x703=(cj9*x694);
IkReal x704=(cj9*x702);
evalcond[0]=(new_r20+((sj9*x695)));
evalcond[1]=((((-1.0)*x694*x697))+new_r21);
evalcond[2]=(((new_r11*sj8))+x703+x701);
evalcond[3]=((((-1.0)*new_r00*x698))+((cj8*new_r10))+(((-1.0)*x694)));
evalcond[4]=((((-1.0)*new_r01*x698))+((cj8*new_r11))+(((-1.0)*x702)));
evalcond[5]=(((cj8*x703))+((sj8*x695))+new_r01);
evalcond[6]=(((new_r10*sj8))+(((-1.0)*x704))+x700);
evalcond[7]=((((-1.0)*cj9*x695*x699))+((sj8*x694))+new_r00);
evalcond[8]=(((x694*x696))+(((-1.0)*x695*x699))+new_r11);
evalcond[9]=((((-1.0)*x696*x702))+(((-1.0)*x694*x699))+new_r10);
evalcond[10]=(((new_r11*x696))+x694+((cj9*x701))+(((-1.0)*new_r21*x697)));
evalcond[11]=(((new_r10*x696))+(((-1.0)*x702))+((cj9*x700))+(((-1.0)*new_r20*x697)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x706=IKPowWithIntegerCheck(sj9,-1);
if(!x706.valid){
continue;
}
IkReal x705=x706.value;
CheckValue<IkReal> x707=IKPowWithIntegerCheck(sj8,-1);
if(!x707.valid){
continue;
}
if( IKabs((x705*(x707.value)*(((((-1.0)*cj8*cj9*new_r20))+(((-1.0)*new_r00*sj9)))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((-1.0)*new_r20*x705)) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr((x705*(x707.value)*(((((-1.0)*cj8*cj9*new_r20))+(((-1.0)*new_r00*sj9))))))+IKsqr(((-1.0)*new_r20*x705))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j10array[0]=IKatan2((x705*(x707.value)*(((((-1.0)*cj8*cj9*new_r20))+(((-1.0)*new_r00*sj9))))), ((-1.0)*new_r20*x705));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[12];
IkReal x708=IKsin(j10);
IkReal x709=IKcos(j10);
IkReal x710=(cj9*sj8);
IkReal x711=((1.0)*sj9);
IkReal x712=((1.0)*sj8);
IkReal x713=((1.0)*cj8);
IkReal x714=(cj8*new_r00);
IkReal x715=(cj8*new_r01);
IkReal x716=((1.0)*x709);
IkReal x717=(cj9*x708);
IkReal x718=(cj9*x716);
evalcond[0]=(((sj9*x709))+new_r20);
evalcond[1]=((((-1.0)*x708*x711))+new_r21);
evalcond[2]=(((new_r11*sj8))+x715+x717);
evalcond[3]=((((-1.0)*x708))+((cj8*new_r10))+(((-1.0)*new_r00*x712)));
evalcond[4]=(((cj8*new_r11))+(((-1.0)*x716))+(((-1.0)*new_r01*x712)));
evalcond[5]=(((cj8*x717))+new_r01+((sj8*x709)));
evalcond[6]=(((new_r10*sj8))+(((-1.0)*x718))+x714);
evalcond[7]=((((-1.0)*cj9*x709*x713))+new_r00+((sj8*x708)));
evalcond[8]=((((-1.0)*x709*x713))+new_r11+((x708*x710)));
evalcond[9]=((((-1.0)*x710*x716))+(((-1.0)*x708*x713))+new_r10);
evalcond[10]=((((-1.0)*new_r21*x711))+((new_r11*x710))+x708+((cj9*x715)));
evalcond[11]=((((-1.0)*new_r20*x711))+(((-1.0)*x716))+((new_r10*x710))+((cj9*x714)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j10array[1], cj10array[1], sj10array[1];
bool j10valid[1]={false};
_nj10 = 1;
CheckValue<IkReal> x719 = IKatan2WithCheck(IkReal(new_r21),IkReal(((-1.0)*new_r20)),IKFAST_ATAN2_MAGTHRESH);
if(!x719.valid){
continue;
}
CheckValue<IkReal> x720=IKPowWithIntegerCheck(IKsign(sj9),-1);
if(!x720.valid){
continue;
}
j10array[0]=((-1.5707963267949)+(x719.value)+(((1.5707963267949)*(x720.value))));
sj10array[0]=IKsin(j10array[0]);
cj10array[0]=IKcos(j10array[0]);
if( j10array[0] > IKPI )
{
    j10array[0]-=IK2PI;
}
else if( j10array[0] < -IKPI )
{    j10array[0]+=IK2PI;
}
j10valid[0] = true;
for(int ij10 = 0; ij10 < 1; ++ij10)
{
if( !j10valid[ij10] )
{
    continue;
}
_ij10[0] = ij10; _ij10[1] = -1;
for(int iij10 = ij10+1; iij10 < 1; ++iij10)
{
if( j10valid[iij10] && IKabs(cj10array[ij10]-cj10array[iij10]) < IKFAST_SOLUTION_THRESH && IKabs(sj10array[ij10]-sj10array[iij10]) < IKFAST_SOLUTION_THRESH )
{
    j10valid[iij10]=false; _ij10[1] = iij10; break; 
}
}
j10 = j10array[ij10]; cj10 = cj10array[ij10]; sj10 = sj10array[ij10];
{
IkReal evalcond[12];
IkReal x721=IKsin(j10);
IkReal x722=IKcos(j10);
IkReal x723=(cj9*sj8);
IkReal x724=((1.0)*sj9);
IkReal x725=((1.0)*sj8);
IkReal x726=((1.0)*cj8);
IkReal x727=(cj8*new_r00);
IkReal x728=(cj8*new_r01);
IkReal x729=((1.0)*x722);
IkReal x730=(cj9*x721);
IkReal x731=(cj9*x729);
evalcond[0]=(((sj9*x722))+new_r20);
evalcond[1]=((((-1.0)*x721*x724))+new_r21);
evalcond[2]=(((new_r11*sj8))+x730+x728);
evalcond[3]=(((cj8*new_r10))+(((-1.0)*x721))+(((-1.0)*new_r00*x725)));
evalcond[4]=(((cj8*new_r11))+(((-1.0)*x729))+(((-1.0)*new_r01*x725)));
evalcond[5]=(((sj8*x722))+((cj8*x730))+new_r01);
evalcond[6]=(((new_r10*sj8))+(((-1.0)*x731))+x727);
evalcond[7]=((((-1.0)*cj9*x722*x726))+((sj8*x721))+new_r00);
evalcond[8]=(((x721*x723))+(((-1.0)*x722*x726))+new_r11);
evalcond[9]=((((-1.0)*x723*x729))+(((-1.0)*x721*x726))+new_r10);
evalcond[10]=((((-1.0)*new_r21*x724))+x721+((new_r11*x723))+((cj9*x728)));
evalcond[11]=((((-1.0)*new_r20*x724))+(((-1.0)*x729))+((cj9*x727))+((new_r10*x723)));
if( IKabs(evalcond[0]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[1]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[2]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[3]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[4]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[5]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[6]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[7]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[8]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[9]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[10]) > IKFAST_EVALCOND_THRESH  || IKabs(evalcond[11]) > IKFAST_EVALCOND_THRESH  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j6;
vinfos[0].indices[0] = _ij6[0];
vinfos[0].indices[1] = _ij6[1];
vinfos[0].maxsolutions = _nj6;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j7;
vinfos[1].indices[0] = _ij7[0];
vinfos[1].indices[1] = _ij7[1];
vinfos[1].maxsolutions = _nj7;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j8;
vinfos[2].indices[0] = _ij8[0];
vinfos[2].indices[1] = _ij8[1];
vinfos[2].maxsolutions = _nj8;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j9;
vinfos[3].indices[0] = _ij9[0];
vinfos[3].indices[1] = _ij9[1];
vinfos[3].maxsolutions = _nj9;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j10;
vinfos[4].indices[0] = _ij10[0];
vinfos[4].indices[1] = _ij10[1];
vinfos[4].maxsolutions = _nj10;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j11;
vinfos[5].indices[0] = _ij11[0];
vinfos[5].indices[1] = _ij11[1];
vinfos[5].maxsolutions = _nj11;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j12;
vinfos[6].indices[0] = _ij12[0];
vinfos[6].indices[1] = _ij12[1];
vinfos[6].maxsolutions = _nj12;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}
}
}static inline void polyroots3(IkReal rawcoeffs[3+1], IkReal rawroots[3], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots2(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[3];
    const int maxsteps = 110;
    for(int i = 0; i < 3; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[3];
    IkReal err[3];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 3; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 3; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 3; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 3; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[3] = {false};
    for(int i = 0; i < 3; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 3; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots2(IkReal rawcoeffs[2+1], IkReal rawroots[2], int& numroots) {
    IkReal det = rawcoeffs[1]*rawcoeffs[1]-4*rawcoeffs[0]*rawcoeffs[2];
    if( det < 0 ) {
        numroots=0;
    }
    else if( det == 0 ) {
        rawroots[0] = -0.5*rawcoeffs[1]/rawcoeffs[0];
        numroots = 1;
    }
    else {
        det = IKsqrt(det);
        rawroots[0] = (-rawcoeffs[1]+det)/(2*rawcoeffs[0]);
        rawroots[1] = (-rawcoeffs[1]-det)/(2*rawcoeffs[0]);//rawcoeffs[2]/(rawcoeffs[0]*rawroots[0]);
        numroots = 2;
    }
}
static inline void polyroots5(IkReal rawcoeffs[5+1], IkReal rawroots[5], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots4(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[5];
    const int maxsteps = 110;
    for(int i = 0; i < 5; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[5];
    IkReal err[5];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 5; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 5; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 5; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 5; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[5] = {false};
    for(int i = 0; i < 5; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 5; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots4(IkReal rawcoeffs[4+1], IkReal rawroots[4], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots3(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[4];
    const int maxsteps = 110;
    for(int i = 0; i < 4; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[4];
    IkReal err[4];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 4; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 4; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 4; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 4; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[4] = {false};
    for(int i = 0; i < 4; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 4; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots7(IkReal rawcoeffs[7+1], IkReal rawroots[7], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots6(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[7];
    const int maxsteps = 110;
    for(int i = 0; i < 7; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[7];
    IkReal err[7];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 7; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 7; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 7; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 7; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[7] = {false};
    for(int i = 0; i < 7; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 7; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots6(IkReal rawcoeffs[6+1], IkReal rawroots[6], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots5(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[6];
    const int maxsteps = 110;
    for(int i = 0; i < 6; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[6];
    IkReal err[6];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 6; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 6; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 6; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 6; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[6] = {false};
    for(int i = 0; i < 6; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 6; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
static inline void polyroots8(IkReal rawcoeffs[8+1], IkReal rawroots[8], int& numroots)
{
    using std::complex;
    if( rawcoeffs[0] == 0 ) {
        // solve with one reduced degree
        polyroots7(&rawcoeffs[1], &rawroots[0], numroots);
        return;
    }
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[8];
    const int maxsteps = 110;
    for(int i = 0; i < 8; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[8];
    IkReal err[8];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 8; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 8; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 8; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 8; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[8] = {false};
    for(int i = 0; i < 8; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 8; ++j) {
                // care about error in real much more than imaginary
                if( abs(real(roots[i])-real(roots[j])) < tolsqrt && abs(imag(roots[i])-imag(roots[j])) < 0.002 ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
};


/// solves the inverse kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API bool ComputeIk2(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions, void* pOpenRAVEManip) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API const char* GetKinematicsHash() { return "<robot:GenericRobot - fetch (a5ffee371c921db78a56e98f69ac61f1)>"; }

IKFAST_API const char* GetIkFastVersion() { return "0x10000049"; }

#ifdef IKFAST_NAMESPACE
} // end namespace
#endif

#ifndef IKFAST_NO_MAIN
#include <stdio.h>
#include <stdlib.h>
#ifdef IKFAST_NAMESPACE
using namespace IKFAST_NAMESPACE;
#endif
int main(int argc, char** argv)
{
    if( argc != 12+GetNumFreeParameters()+1 ) {
        printf("\nUsage: ./ik r00 r01 r02 t0 r10 r11 r12 t1 r20 r21 r22 t2 free0 ...\n\n"
               "Returns the ik solutions given the transformation of the end effector specified by\n"
               "a 3x3 rotation R (rXX), and a 3x1 translation (tX).\n"
               "There are %d free parameters that have to be specified.\n\n",GetNumFreeParameters());
        return 1;
    }

    IkSolutionList<IkReal> solutions;
    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9],eetrans[3];
    eerot[0] = atof(argv[1]); eerot[1] = atof(argv[2]); eerot[2] = atof(argv[3]); eetrans[0] = atof(argv[4]);
    eerot[3] = atof(argv[5]); eerot[4] = atof(argv[6]); eerot[5] = atof(argv[7]); eetrans[1] = atof(argv[8]);
    eerot[6] = atof(argv[9]); eerot[7] = atof(argv[10]); eerot[8] = atof(argv[11]); eetrans[2] = atof(argv[12]);
    for(std::size_t i = 0; i < vfree.size(); ++i)
        vfree[i] = atof(argv[13+i]);
    bool bSuccess = ComputeIk(eetrans, eerot, vfree.size() > 0 ? &vfree[0] : NULL, solutions);

    if( !bSuccess ) {
        fprintf(stderr,"Failed to get ik solution\n");
        return -1;
    }

    printf("Found %d ik solutions:\n", (int)solutions.GetNumSolutions());
    std::vector<IkReal> solvalues(GetNumJoints());
    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i) {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        printf("sol%d (free=%d): ", (int)i, (int)sol.GetFree().size());
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);
        for( std::size_t j = 0; j < solvalues.size(); ++j)
            printf("%.15f, ", solvalues[j]);
        printf("\n");
    }
    return 0;
}

#endif
