// -*- mode: c++ -*-
/*********************************************************************
 * Software License Agreement (BSD License)
 *
 *  Copyright (c) 2015, JSK Lab
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials provided
 *     with the distribution.
 *   * Neither the name of the JSK Lab nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 *********************************************************************/

#ifndef JSK_PCL_ROS_OCTREE_VOXEL_GRID_H_
#define JSK_PCL_ROS_OCTREE_VOXEL_GRID_H_

// ros
#include <ros/ros.h>
#include <ros/names.h>
#include <dynamic_reconfigure/server.h>
#include <jsk_topic_tools/diagnostic_nodelet.h>
#include <sensor_msgs/PointCloud2.h>
#include <visualization_msgs/Marker.h>
#include <visualization_msgs/MarkerArray.h>

// pcl
#include <pcl_ros/pcl_nodelet.h>
#include <pcl/point_types.h>
#include <pcl/octree/octree_pointcloud.h>
#include "jsk_pcl_ros/OctreeVoxelGridConfig.h"

namespace jsk_pcl_ros
{
  class OctreeVoxelGrid : public jsk_topic_tools::DiagnosticNodelet
  {
  public:
    typedef jsk_pcl_ros::OctreeVoxelGridConfig Config;
    OctreeVoxelGrid(): DiagnosticNodelet("OctreeVoxelGrid") {}
  protected:
    virtual void onInit();
    virtual void subscribe();
    virtual void unsubscribe();
    virtual void configCallback(Config &config, uint32_t level);
    virtual void generateVoxelCloud(const sensor_msgs::PointCloud2ConstPtr& input);
    template <class PointT>
    void generateVoxelCloudImpl(const sensor_msgs::PointCloud2ConstPtr& input);

    ros::Subscriber sub_input_;
    ros::Publisher pub_cloud_;
    ros::Publisher pub_marker_;
    ros::Publisher pub_marker_array_;
    ros::Publisher pub_octree_resolution_;

    boost::shared_ptr<dynamic_reconfigure::Server<Config> > srv_;
    boost::mutex mutex_;

    double resolution_;
    double marker_color_alpha_;
    
    bool publish_marker_flag_;
    std::string marker_color_;
  };
}

#endif // JSK_PCL_ROS_OCTREE_VOXEL_GRID_H_
