// -*- mode: c++ -*-
/*********************************************************************
 * Software License Agreement (BSD License)
 *
 *  Copyright (c) 2014, JSK Lab
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials provided
 *     with the distribution.
 *   * Neither the name of the JSK Lab nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 *********************************************************************/


namespace jsk_rviz_plugins
{
  std::map<std::string, QString> entypo_character_map;
  std::map<std::string, QString> entypo_social_character_map;
  std::map<std::string, QString> fontawesome_character_map;
  void setupFont() {
    static bool font_initialized = false;
    if (!font_initialized) {
      font_initialized = true;
      addFont(Entypo_ttf, Entypo_ttf_len);
      addFont(Entypo_Social_ttf, Entypo_Social_ttf_len);
      addFont(fontawesome_webfont_ttf,
              font_awesome_4_2_0_fonts_fontawesome_webfont_ttf_len);

      entypo_character_map["phone"] = QString::fromWCharArray(L"\x1F4DE");
      entypo_character_map["mobile"] = QString::fromWCharArray(L"\x1F4F1");
      entypo_character_map["mouse"] = QString::fromWCharArray(L"\xE789");
      entypo_character_map["address"] = QString::fromWCharArray(L"\xE723");
      entypo_character_map["mail"] = QString::fromWCharArray(L"\x2709");
      entypo_character_map["paper-plane"] = QString::fromWCharArray(L"\x1F53F");
      entypo_character_map["pencil"] = QString::fromWCharArray(L"\x270E");
      entypo_character_map["feather"] = QString::fromWCharArray(L"\x2712");
      entypo_character_map["attach"] = QString::fromWCharArray(L"\x1F4CE");
      entypo_character_map["inbox"] = QString::fromWCharArray(L"\xE777");
      entypo_character_map["reply"] = QString::fromWCharArray(L"\xE712");
      entypo_character_map["reply-all"] = QString::fromWCharArray(L"\xE713");
      entypo_character_map["forward"] = QString::fromWCharArray(L"\x27A6");
      entypo_character_map["user"] = QString::fromWCharArray(L"\x1F464");
      entypo_character_map["users"] = QString::fromWCharArray(L"\x1F465");
      entypo_character_map["add-user"] = QString::fromWCharArray(L"\xE700");
      entypo_character_map["vcard"] = QString::fromWCharArray(L"\xE722");
      entypo_character_map["export"] = QString::fromWCharArray(L"\xE715");
      entypo_character_map["location"] = QString::fromWCharArray(L"\xE724");
      entypo_character_map["map"] = QString::fromWCharArray(L"\xE727");
      entypo_character_map["compass"] = QString::fromWCharArray(L"\xE728");
      entypo_character_map["direction"] = QString::fromWCharArray(L"\x27A2");
      entypo_character_map["hair-cross"] = QString::fromWCharArray(L"\x1F3AF");
      entypo_character_map["share"] = QString::fromWCharArray(L"\xE73C");
      entypo_character_map["shareable"] = QString::fromWCharArray(L"\xE73E");
      entypo_character_map["heart"] = QString::fromWCharArray(L"\x2665");
      entypo_character_map["heart-empty"] = QString::fromWCharArray(L"\x2661");
      entypo_character_map["star"] = QString::fromWCharArray(L"\x2605");
      entypo_character_map["star-empty"] = QString::fromWCharArray(L"\x2606");
      entypo_character_map["thumbs-up"] = QString::fromWCharArray(L"\x1F44D");
      entypo_character_map["thumbs-down"] = QString::fromWCharArray(L"\x1F44E");
      entypo_character_map["chat"] = QString::fromWCharArray(L"\xE720");
      entypo_character_map["comment"] = QString::fromWCharArray(L"\xE718");
      entypo_character_map["quote"] = QString::fromWCharArray(L"\x275E");
      entypo_character_map["home"] = QString::fromWCharArray(L"\x2302");
      entypo_character_map["popup"] = QString::fromWCharArray(L"\xE74C");
      entypo_character_map["search"] = QString::fromWCharArray(L"\x1F50D");
      entypo_character_map["flashlight"] = QString::fromWCharArray(L"\x1F526");
      entypo_character_map["print"] = QString::fromWCharArray(L"\xE716");
      entypo_character_map["bell"] = QString::fromWCharArray(L"\x1F514");
      entypo_character_map["link"] = QString::fromWCharArray(L"\x1F517");
      entypo_character_map["flag"] = QString::fromWCharArray(L"\x2691");
      entypo_character_map["cog"] = QString::fromWCharArray(L"\x2699");
      entypo_character_map["tools"] = QString::fromWCharArray(L"\x2692");
      entypo_character_map["trophy"] = QString::fromWCharArray(L"\x1F3C6");
      entypo_character_map["tag"] = QString::fromWCharArray(L"\xE70C");
      entypo_character_map["camera"] = QString::fromWCharArray(L"\x1F4F7");
      entypo_character_map["megaphone"] = QString::fromWCharArray(L"\x1F4E3");
      entypo_character_map["moon"] = QString::fromWCharArray(L"\x263D");
      entypo_character_map["palette"] = QString::fromWCharArray(L"\x1F3A8");
      entypo_character_map["leaf"] = QString::fromWCharArray(L"\x1F342");
      entypo_character_map["note"] = QString::fromWCharArray(L"\x266A");
      entypo_character_map["beamed-note"] = QString::fromWCharArray(L"\x266B");
      entypo_character_map["new"] = QString::fromWCharArray(L"\x1F4A5");
      entypo_character_map["graduation-cap"] = QString::fromWCharArray(L"\x1F393");
      entypo_character_map["book"] = QString::fromWCharArray(L"\x1F4D5");
      entypo_character_map["newspaper"] = QString::fromWCharArray(L"\x1F4F0");
      entypo_character_map["bag"] = QString::fromWCharArray(L"\x1F45C");
      entypo_character_map["airplane"] = QString::fromWCharArray(L"\x2708");
      entypo_character_map["lifebuoy"] = QString::fromWCharArray(L"\xE788");
      entypo_character_map["eye"] = QString::fromWCharArray(L"\xE70A");
      entypo_character_map["clock"] = QString::fromWCharArray(L"\x1F554");
      entypo_character_map["mic"] = QString::fromWCharArray(L"\x1F3A4");
      entypo_character_map["calendar"] = QString::fromWCharArray(L"\x1F4C5");
      entypo_character_map["flash"] = QString::fromWCharArray(L"\x26A1");
      entypo_character_map["thunder-cloud"] = QString::fromWCharArray(L"\x26C8");
      entypo_character_map["droplet"] = QString::fromWCharArray(L"\x1F4A7");
      entypo_character_map["cd"] = QString::fromWCharArray(L"\x1F4BF");
      entypo_character_map["briefcase"] = QString::fromWCharArray(L"\x1F4BC");
      entypo_character_map["air"] = QString::fromWCharArray(L"\x1F4A8");
      entypo_character_map["hourglass"] = QString::fromWCharArray(L"\x23F3");
      entypo_character_map["gauge"] = QString::fromWCharArray(L"\x1F6C7");
      entypo_character_map["language"] = QString::fromWCharArray(L"\x1F394");
      entypo_character_map["network"] = QString::fromWCharArray(L"\xE776");
      entypo_character_map["key"] = QString::fromWCharArray(L"\x1F511");
      entypo_character_map["battery"] = QString::fromWCharArray(L"\x1F50B");
      entypo_character_map["bucket"] = QString::fromWCharArray(L"\x1F4FE");
      entypo_character_map["magnet"] = QString::fromWCharArray(L"\xE7A1");
      entypo_character_map["drive"] = QString::fromWCharArray(L"\x1F4FD");
      entypo_character_map["cup"] = QString::fromWCharArray(L"\x2615");
      entypo_character_map["rocket"] = QString::fromWCharArray(L"\x1F680");
      entypo_character_map["brush"] = QString::fromWCharArray(L"\xE79A");
      entypo_character_map["suitcase"] = QString::fromWCharArray(L"\x1F6C6");
      entypo_character_map["traffic-cone"] = QString::fromWCharArray(L"\x1F6C8");
      entypo_character_map["globe"] = QString::fromWCharArray(L"\x1F30E");
      entypo_character_map["keyboard"] = QString::fromWCharArray(L"\x2328");
      entypo_character_map["browser"] = QString::fromWCharArray(L"\xE74E");
      entypo_character_map["publish"] = QString::fromWCharArray(L"\xE74D");
      entypo_character_map["progress-3"] = QString::fromWCharArray(L"\xE76B");
      entypo_character_map["progress-2"] = QString::fromWCharArray(L"\xE76A");
      entypo_character_map["progress-1"] = QString::fromWCharArray(L"\xE769");
      entypo_character_map["progress-0"] = QString::fromWCharArray(L"\xE768");
      entypo_character_map["light-down"] = QString::fromWCharArray(L"\x1F505");
      entypo_character_map["light-up"] = QString::fromWCharArray(L"\x1F506");
      entypo_character_map["adjust"] = QString::fromWCharArray(L"\x25D1");
      entypo_character_map["code"] = QString::fromWCharArray(L"\xE714");
      entypo_character_map["monitor"] = QString::fromWCharArray(L"\x1F4BB");
      entypo_character_map["infinity"] = QString::fromWCharArray(L"\x221E");
      entypo_character_map["light-bulb"] = QString::fromWCharArray(L"\x1F4A1");
      entypo_character_map["credit-card"] = QString::fromWCharArray(L"\x1F4B3");
      entypo_character_map["database"] = QString::fromWCharArray(L"\x1F4F8");
      entypo_character_map["voicemail"] = QString::fromWCharArray(L"\x2707");
      entypo_character_map["clipboard"] = QString::fromWCharArray(L"\x1F4CB");
      entypo_character_map["cart"] = QString::fromWCharArray(L"\xE73D");
      entypo_character_map["box"] = QString::fromWCharArray(L"\x1F4E6");
      entypo_character_map["ticket"] = QString::fromWCharArray(L"\x1F3AB");
      entypo_character_map["rss"] = QString::fromWCharArray(L"\xE73A");
      entypo_character_map["signal"] = QString::fromWCharArray(L"\x1F4F6");
      entypo_character_map["thermometer"] = QString::fromWCharArray(L"\x1F4FF");
      entypo_character_map["water"] = QString::fromWCharArray(L"\x1F4A6");
      entypo_character_map["sweden"] = QString::fromWCharArray(L"\xF601");
      entypo_character_map["line-graph"] = QString::fromWCharArray(L"\x1F4C8");
      entypo_character_map["pie-chart"] = QString::fromWCharArray(L"\x25F4");
      entypo_character_map["bar-graph"] = QString::fromWCharArray(L"\x1F4CA");
      entypo_character_map["area-graph"] = QString::fromWCharArray(L"\x1F53E");
      entypo_character_map["lock"] = QString::fromWCharArray(L"\x1F512");
      entypo_character_map["lock-open"] = QString::fromWCharArray(L"\x1F513");
      entypo_character_map["logout"] = QString::fromWCharArray(L"\xE741");
      entypo_character_map["login"] = QString::fromWCharArray(L"\xE740");
      entypo_character_map["check"] = QString::fromWCharArray(L"\x2713");
      entypo_character_map["cross"] = QString::fromWCharArray(L"\x274C");
      entypo_character_map["squared-minus"] = QString::fromWCharArray(L"\x229F");
      entypo_character_map["squared-plus"] = QString::fromWCharArray(L"\x229E");
      entypo_character_map["squared-cross"] = QString::fromWCharArray(L"\x274E");
      entypo_character_map["circled-minus"] = QString::fromWCharArray(L"\x2296");
      entypo_character_map["circled-plus"] = QString::fromWCharArray(L"\x2295");
      entypo_character_map["circled-cross"] = QString::fromWCharArray(L"\x2716");
      entypo_character_map["minus"] = QString::fromWCharArray(L"\x2796");
      entypo_character_map["plus"] = QString::fromWCharArray(L"\x2795");
      entypo_character_map["erase"] = QString::fromWCharArray(L"\x232B");
      entypo_character_map["block"] = QString::fromWCharArray(L"\x1F6AB");
      entypo_character_map["info"] = QString::fromWCharArray(L"\x2139");
      entypo_character_map["circled-info"] = QString::fromWCharArray(L"\xE705");
      entypo_character_map["help"] = QString::fromWCharArray(L"\x2753");
      entypo_character_map["circled-help"] = QString::fromWCharArray(L"\xE704");
      entypo_character_map["warning"] = QString::fromWCharArray(L"\x26A0");
      entypo_character_map["cycle"] = QString::fromWCharArray(L"\x1F504");
      entypo_character_map["cw"] = QString::fromWCharArray(L"\x27F3");
      entypo_character_map["ccw"] = QString::fromWCharArray(L"\x27F2");
      entypo_character_map["shuffle"] = QString::fromWCharArray(L"\x1F500");
      entypo_character_map["back"] = QString::fromWCharArray(L"\x1F519");
      entypo_character_map["level-down"] = QString::fromWCharArray(L"\x21B3");
      entypo_character_map["retweet"] = QString::fromWCharArray(L"\xE717");
      entypo_character_map["loop"] = QString::fromWCharArray(L"\x1F501");
      entypo_character_map["back-in-time"] = QString::fromWCharArray(L"\xE771");
      entypo_character_map["level-up"] = QString::fromWCharArray(L"\x21B0");
      entypo_character_map["switch"] = QString::fromWCharArray(L"\x21C6");
      entypo_character_map["numbered-list"] = QString::fromWCharArray(L"\xE005");
      entypo_character_map["add-to-list"] = QString::fromWCharArray(L"\xE003");
      entypo_character_map["layout"] = QString::fromWCharArray(L"\x268F");
      entypo_character_map["list"] = QString::fromWCharArray(L"\x2630");
      entypo_character_map["text-doc"] = QString::fromWCharArray(L"\x1F4C4");
      entypo_character_map["text-doc-inverted"] = QString::fromWCharArray(L"\xE731");
      entypo_character_map["doc"] = QString::fromWCharArray(L"\xE730");
      entypo_character_map["docs"] = QString::fromWCharArray(L"\xE736");
      entypo_character_map["landscape-doc"] = QString::fromWCharArray(L"\xE737");
      entypo_character_map["picture"] = QString::fromWCharArray(L"\x1F304");
      entypo_character_map["video"] = QString::fromWCharArray(L"\x1F3AC");
      entypo_character_map["music"] = QString::fromWCharArray(L"\x1F3B5");
      entypo_character_map["folder"] = QString::fromWCharArray(L"\x1F4C1");
      entypo_character_map["archive"] = QString::fromWCharArray(L"\xE800");
      entypo_character_map["trash"] = QString::fromWCharArray(L"\xE729");
      entypo_character_map["upload"] = QString::fromWCharArray(L"\x1F4E4");
      entypo_character_map["download"] = QString::fromWCharArray(L"\x1F4E5");
      entypo_character_map["save"] = QString::fromWCharArray(L"\x1F4BE");
      entypo_character_map["install"] = QString::fromWCharArray(L"\xE778");
      entypo_character_map["cloud"] = QString::fromWCharArray(L"\x2601");
      entypo_character_map["upload-cloud"] = QString::fromWCharArray(L"\xE711");
      entypo_character_map["bookmark"] = QString::fromWCharArray(L"\x1F516");
      entypo_character_map["bookmarks"] = QString::fromWCharArray(L"\x1F4D1");
      entypo_character_map["open-book"] = QString::fromWCharArray(L"\x1F4D6");
      entypo_character_map["play"] = QString::fromWCharArray(L"\x25B6");
      entypo_character_map["paus"] = QString::fromWCharArray(L"\x2016");
      entypo_character_map["record"] = QString::fromWCharArray(L"\x25CF");
      entypo_character_map["stop"] = QString::fromWCharArray(L"\x25A0");
      entypo_character_map["ff"] = QString::fromWCharArray(L"\x23E9");
      entypo_character_map["fb"] = QString::fromWCharArray(L"\x23EA");
      entypo_character_map["to-start"] = QString::fromWCharArray(L"\x23EE");
      entypo_character_map["to-end"] = QString::fromWCharArray(L"\x23ED");
      entypo_character_map["resize-full"] = QString::fromWCharArray(L"\xE744");
      entypo_character_map["resize-small"] = QString::fromWCharArray(L"\xE746");
      entypo_character_map["volume"] = QString::fromWCharArray(L"\x23F7");
      entypo_character_map["sound"] = QString::fromWCharArray(L"\x1F50A");
      entypo_character_map["mute"] = QString::fromWCharArray(L"\x1F507");
      entypo_character_map["flow-cascade"] = QString::fromWCharArray(L"\x1F568");
      entypo_character_map["flow-branch"] = QString::fromWCharArray(L"\x1F569");
      entypo_character_map["flow-tree"] = QString::fromWCharArray(L"\x1F56A");
      entypo_character_map["flow-line"] = QString::fromWCharArray(L"\x1F56B");
      entypo_character_map["flow-parallel"] = QString::fromWCharArray(L"\x1F56C");
      entypo_character_map["left-bold"] = QString::fromWCharArray(L"\xE4AD");
      entypo_character_map["down-bold"] = QString::fromWCharArray(L"\xE4B0");
      entypo_character_map["up-bold"] = QString::fromWCharArray(L"\xE4AF");
      entypo_character_map["right-bold"] = QString::fromWCharArray(L"\xE4AE");
      entypo_character_map["left"] = QString::fromWCharArray(L"\x2B05");
      entypo_character_map["down"] = QString::fromWCharArray(L"\x2B07");
      entypo_character_map["up"] = QString::fromWCharArray(L"\x2B06");
      entypo_character_map["right"] = QString::fromWCharArray(L"\x27A1");
      entypo_character_map["circled-left"] = QString::fromWCharArray(L"\xE759");
      entypo_character_map["circled-down"] = QString::fromWCharArray(L"\xE758");
      entypo_character_map["circled-up"] = QString::fromWCharArray(L"\xE75B");
      entypo_character_map["circled-right"] = QString::fromWCharArray(L"\xE75A");
      entypo_character_map["triangle-left"] = QString::fromWCharArray(L"\x25C2");
      entypo_character_map["triangle-down"] = QString::fromWCharArray(L"\x25BE");
      entypo_character_map["triangle-up"] = QString::fromWCharArray(L"\x25B4");
      entypo_character_map["triangle-right"] = QString::fromWCharArray(L"\x25B8");
      entypo_character_map["chevron-left"] = QString::fromWCharArray(L"\xE75D");
      entypo_character_map["chevron-down"] = QString::fromWCharArray(L"\xE75C");
      entypo_character_map["chevron-up"] = QString::fromWCharArray(L"\xE75F");
      entypo_character_map["chevron-right"] = QString::fromWCharArray(L"\xE75E");
      entypo_character_map["chevron-small-left"] = QString::fromWCharArray(L"\xE761");
      entypo_character_map["chevron-small-down"] = QString::fromWCharArray(L"\xE760");
      entypo_character_map["chevron-small-up"] = QString::fromWCharArray(L"\xE763");
      entypo_character_map["chevron-small-right"] = QString::fromWCharArray(L"\xE762");
      entypo_character_map["chevron-thin-left"] = QString::fromWCharArray(L"\xE765");
      entypo_character_map["chevron-thin-down"] = QString::fromWCharArray(L"\xE764");
      entypo_character_map["chevron-thin-up"] = QString::fromWCharArray(L"\xE767");
      entypo_character_map["chevron-thin-right"] = QString::fromWCharArray(L"\xE766");
      entypo_character_map["left-thin"] = QString::fromWCharArray(L"\x2190");
      entypo_character_map["down-thin"] = QString::fromWCharArray(L"\x2193");
      entypo_character_map["up-thin"] = QString::fromWCharArray(L"\x2191");
      entypo_character_map["right-thin"] = QString::fromWCharArray(L"\x2192");
      entypo_character_map["arrow-combo"] = QString::fromWCharArray(L"\xE74F");
      entypo_character_map["three-dots"] = QString::fromWCharArray(L"\x23F6");
      entypo_character_map["two-dots"] = QString::fromWCharArray(L"\x23F5");
      entypo_character_map["dot"] = QString::fromWCharArray(L"\x23F4");
      entypo_character_map["cc"] = QString::fromWCharArray(L"\x1F545");
      entypo_character_map["cc-by"] = QString::fromWCharArray(L"\x1F546");
      entypo_character_map["cc-nc"] = QString::fromWCharArray(L"\x1F547");
      entypo_character_map["cc-nc-eu"] = QString::fromWCharArray(L"\x1F548");
      entypo_character_map["cc-nc-jp"] = QString::fromWCharArray(L"\x1F549");
      entypo_character_map["cc-sa"] = QString::fromWCharArray(L"\x1F54A");
      entypo_character_map["cc-nd"] = QString::fromWCharArray(L"\x1F54B");
      entypo_character_map["cc-pd"] = QString::fromWCharArray(L"\x1F54C");
      entypo_character_map["cc-zero"] = QString::fromWCharArray(L"\x1F54D");
      entypo_character_map["cc-share"] = QString::fromWCharArray(L"\x1F54E");
      entypo_character_map["cc-remix"] = QString::fromWCharArray(L"\x1F54F");
      entypo_character_map["db-logo"] = QString::fromWCharArray(L"\x1F5F9");
      entypo_character_map["db-shape"] = QString::fromWCharArray(L"\x1F5FA");

      entypo_social_character_map["github"] = QString::fromWCharArray(L"\xF300");
      entypo_social_character_map["c-github"] = QString::fromWCharArray(L"\xF301");
      entypo_social_character_map["flickr"] = QString::fromWCharArray(L"\xF303");
      entypo_social_character_map["c-flickr"] = QString::fromWCharArray(L"\xF304");
      entypo_social_character_map["vimeo"] = QString::fromWCharArray(L"\xF306");
      entypo_social_character_map["c-vimeo"] = QString::fromWCharArray(L"\xF307");
      entypo_social_character_map["twitter"] = QString::fromWCharArray(L"\xF309");
      entypo_social_character_map["c-twitter"] = QString::fromWCharArray(L"\xF30A");
      entypo_social_character_map["facebook"] = QString::fromWCharArray(L"\xF30C");
      entypo_social_character_map["c-facebook"] = QString::fromWCharArray(L"\xF30D");
      entypo_social_character_map["s-facebook"] = QString::fromWCharArray(L"\xF30E");
      entypo_social_character_map["google+"] = QString::fromWCharArray(L"\xF30F");
      entypo_social_character_map["c-google+"] = QString::fromWCharArray(L"\xF310");
      entypo_social_character_map["pinterest"] = QString::fromWCharArray(L"\xF312");
      entypo_social_character_map["c-pinterest"] = QString::fromWCharArray(L"\xF313");
      entypo_social_character_map["tumblr"] = QString::fromWCharArray(L"\xF315");
      entypo_social_character_map["c-tumblr"] = QString::fromWCharArray(L"\xF316");
      entypo_social_character_map["linkedin"] = QString::fromWCharArray(L"\xF318");
      entypo_social_character_map["c-linkedin"] = QString::fromWCharArray(L"\xF319");
      entypo_social_character_map["dribbble"] = QString::fromWCharArray(L"\xF31B");
      entypo_social_character_map["c-dribbble"] = QString::fromWCharArray(L"\xF31C");
      entypo_social_character_map["stumbleupon"] = QString::fromWCharArray(L"\xF31E");
      entypo_social_character_map["c-stumbleupon"] = QString::fromWCharArray(L"\xF31F");
      entypo_social_character_map["lastfm"] = QString::fromWCharArray(L"\xF321");
      entypo_social_character_map["c-lastfm"] = QString::fromWCharArray(L"\xF322");
      entypo_social_character_map["rdio"] = QString::fromWCharArray(L"\xF324");
      entypo_social_character_map["c-rdio"] = QString::fromWCharArray(L"\xF325");
      entypo_social_character_map["spotify"] = QString::fromWCharArray(L"\xF327");
      entypo_social_character_map["c-spotify"] = QString::fromWCharArray(L"\xF328");
      entypo_social_character_map["qq"] = QString::fromWCharArray(L"\xF32A");
      entypo_social_character_map["instagram"] = QString::fromWCharArray(L"\xF32D");
      entypo_social_character_map["dropbox"] = QString::fromWCharArray(L"\xF330");
      entypo_social_character_map["evernote"] = QString::fromWCharArray(L"\xF333");
      entypo_social_character_map["flattr"] = QString::fromWCharArray(L"\xF336");
      entypo_social_character_map["skype"] = QString::fromWCharArray(L"\xF339");
      entypo_social_character_map["c-skype"] = QString::fromWCharArray(L"\xF33A");
      entypo_social_character_map["renren"] = QString::fromWCharArray(L"\xF33C");
      entypo_social_character_map["sina-weibo"] = QString::fromWCharArray(L"\xF33F");
      entypo_social_character_map["paypal"] = QString::fromWCharArray(L"\xF342");
      entypo_social_character_map["picasa"] = QString::fromWCharArray(L"\xF345");
      entypo_social_character_map["soundcloud"] = QString::fromWCharArray(L"\xF348");
      entypo_social_character_map["mixi"] = QString::fromWCharArray(L"\xF34B");
      entypo_social_character_map["behance"] = QString::fromWCharArray(L"\xF34E");
      entypo_social_character_map["google-circles"] = QString::fromWCharArray(L"\xF351");
      entypo_social_character_map["vk"] = QString::fromWCharArray(L"\xF354");
      entypo_social_character_map["smashing"] = QString::fromWCharArray(L"\xF357");
      fontawesome_character_map["fa-glass-martini"] = QString::fromWCharArray(L"\xF000");
      fontawesome_character_map["fa-music"] = QString::fromWCharArray(L"\xF001");
      fontawesome_character_map["fa-search"] = QString::fromWCharArray(L"\xF002");
      fontawesome_character_map["fa-heart"] = QString::fromWCharArray(L"\xF004");
      fontawesome_character_map["fa-star"] = QString::fromWCharArray(L"\xF005");
      fontawesome_character_map["fa-user"] = QString::fromWCharArray(L"\xF007");
      fontawesome_character_map["fa-film"] = QString::fromWCharArray(L"\xF008");
      fontawesome_character_map["fa-th-large"] = QString::fromWCharArray(L"\xF009");
      fontawesome_character_map["fa-th"] = QString::fromWCharArray(L"\xF00a");
      fontawesome_character_map["fa-th-list"] = QString::fromWCharArray(L"\xF00b");
      fontawesome_character_map["fa-check"] = QString::fromWCharArray(L"\xF00c");
      fontawesome_character_map["fa-times"] = QString::fromWCharArray(L"\xF00d");
      fontawesome_character_map["fa-search-plus"] = QString::fromWCharArray(L"\xF00e");
      fontawesome_character_map["fa-search-minus"] = QString::fromWCharArray(L"\xF010");
      fontawesome_character_map["fa-power-off"] = QString::fromWCharArray(L"\xF011");
      fontawesome_character_map["fa-signal"] = QString::fromWCharArray(L"\xF012");
      fontawesome_character_map["fa-cog"] = QString::fromWCharArray(L"\xF013");
      fontawesome_character_map["fa-home"] = QString::fromWCharArray(L"\xF015");
      fontawesome_character_map["fa-clock"] = QString::fromWCharArray(L"\xF017");
      fontawesome_character_map["fa-road"] = QString::fromWCharArray(L"\xF018");
      fontawesome_character_map["fa-download"] = QString::fromWCharArray(L"\xF019");
      fontawesome_character_map["fa-inbox"] = QString::fromWCharArray(L"\xF01c");
      fontawesome_character_map["fa-redo"] = QString::fromWCharArray(L"\xF01e");
      fontawesome_character_map["fa-sync"] = QString::fromWCharArray(L"\xF021");
      fontawesome_character_map["fa-list-alt"] = QString::fromWCharArray(L"\xF022");
      fontawesome_character_map["fa-lock"] = QString::fromWCharArray(L"\xF023");
      fontawesome_character_map["fa-flag"] = QString::fromWCharArray(L"\xF024");
      fontawesome_character_map["fa-headphones"] = QString::fromWCharArray(L"\xF025");
      fontawesome_character_map["fa-volume-off"] = QString::fromWCharArray(L"\xF026");
      fontawesome_character_map["fa-volume-down"] = QString::fromWCharArray(L"\xF027");
      fontawesome_character_map["fa-volume-up"] = QString::fromWCharArray(L"\xF028");
      fontawesome_character_map["fa-qrcode"] = QString::fromWCharArray(L"\xF029");
      fontawesome_character_map["fa-barcode"] = QString::fromWCharArray(L"\xF02a");
      fontawesome_character_map["fa-tag"] = QString::fromWCharArray(L"\xF02b");
      fontawesome_character_map["fa-tags"] = QString::fromWCharArray(L"\xF02c");
      fontawesome_character_map["fa-book"] = QString::fromWCharArray(L"\xF02d");
      fontawesome_character_map["fa-bookmark"] = QString::fromWCharArray(L"\xF02e");
      fontawesome_character_map["fa-print"] = QString::fromWCharArray(L"\xF02f");
      fontawesome_character_map["fa-camera"] = QString::fromWCharArray(L"\xF030");
      fontawesome_character_map["fa-font"] = QString::fromWCharArray(L"\xF031");
      fontawesome_character_map["fa-bold"] = QString::fromWCharArray(L"\xF032");
      fontawesome_character_map["fa-italic"] = QString::fromWCharArray(L"\xF033");
      fontawesome_character_map["fa-text-height"] = QString::fromWCharArray(L"\xF034");
      fontawesome_character_map["fa-text-width"] = QString::fromWCharArray(L"\xF035");
      fontawesome_character_map["fa-align-left"] = QString::fromWCharArray(L"\xF036");
      fontawesome_character_map["fa-align-center"] = QString::fromWCharArray(L"\xF037");
      fontawesome_character_map["fa-align-right"] = QString::fromWCharArray(L"\xF038");
      fontawesome_character_map["fa-align-justify"] = QString::fromWCharArray(L"\xF039");
      fontawesome_character_map["fa-list"] = QString::fromWCharArray(L"\xF03a");
      fontawesome_character_map["fa-outdent"] = QString::fromWCharArray(L"\xF03b");
      fontawesome_character_map["fa-indent"] = QString::fromWCharArray(L"\xF03c");
      fontawesome_character_map["fa-video"] = QString::fromWCharArray(L"\xF03d");
      fontawesome_character_map["fa-image"] = QString::fromWCharArray(L"\xF03e");
      fontawesome_character_map["fa-map-marker"] = QString::fromWCharArray(L"\xF041");
      fontawesome_character_map["fa-adjust"] = QString::fromWCharArray(L"\xF042");
      fontawesome_character_map["fa-tint"] = QString::fromWCharArray(L"\xF043");
      fontawesome_character_map["fa-edit"] = QString::fromWCharArray(L"\xF044");
      fontawesome_character_map["fa-step-backward"] = QString::fromWCharArray(L"\xF048");
      fontawesome_character_map["fa-fast-backward"] = QString::fromWCharArray(L"\xF049");
      fontawesome_character_map["fa-backward"] = QString::fromWCharArray(L"\xF04a");
      fontawesome_character_map["fa-play"] = QString::fromWCharArray(L"\xF04b");
      fontawesome_character_map["fa-pause"] = QString::fromWCharArray(L"\xF04c");
      fontawesome_character_map["fa-stop"] = QString::fromWCharArray(L"\xF04d");
      fontawesome_character_map["fa-forward"] = QString::fromWCharArray(L"\xF04e");
      fontawesome_character_map["fa-fast-forward"] = QString::fromWCharArray(L"\xF050");
      fontawesome_character_map["fa-step-forward"] = QString::fromWCharArray(L"\xF051");
      fontawesome_character_map["fa-eject"] = QString::fromWCharArray(L"\xF052");
      fontawesome_character_map["fa-chevron-left"] = QString::fromWCharArray(L"\xF053");
      fontawesome_character_map["fa-chevron-right"] = QString::fromWCharArray(L"\xF054");
      fontawesome_character_map["fa-plus-circle"] = QString::fromWCharArray(L"\xF055");
      fontawesome_character_map["fa-minus-circle"] = QString::fromWCharArray(L"\xF056");
      fontawesome_character_map["fa-times-circle"] = QString::fromWCharArray(L"\xF057");
      fontawesome_character_map["fa-check-circle"] = QString::fromWCharArray(L"\xF058");
      fontawesome_character_map["fa-question-circle"] = QString::fromWCharArray(L"\xF059");
      fontawesome_character_map["fa-info-circle"] = QString::fromWCharArray(L"\xF05a");
      fontawesome_character_map["fa-crosshairs"] = QString::fromWCharArray(L"\xF05b");
      fontawesome_character_map["fa-ban"] = QString::fromWCharArray(L"\xF05e");
      fontawesome_character_map["fa-arrow-left"] = QString::fromWCharArray(L"\xF060");
      fontawesome_character_map["fa-arrow-right"] = QString::fromWCharArray(L"\xF061");
      fontawesome_character_map["fa-arrow-up"] = QString::fromWCharArray(L"\xF062");
      fontawesome_character_map["fa-arrow-down"] = QString::fromWCharArray(L"\xF063");
      fontawesome_character_map["fa-share"] = QString::fromWCharArray(L"\xF064");
      fontawesome_character_map["fa-expand"] = QString::fromWCharArray(L"\xF065");
      fontawesome_character_map["fa-compress"] = QString::fromWCharArray(L"\xF066");
      fontawesome_character_map["fa-plus"] = QString::fromWCharArray(L"\xF067");
      fontawesome_character_map["fa-minus"] = QString::fromWCharArray(L"\xF068");
      fontawesome_character_map["fa-asterisk"] = QString::fromWCharArray(L"\xF069");
      fontawesome_character_map["fa-exclamation-circle"] = QString::fromWCharArray(L"\xF06a");
      fontawesome_character_map["fa-gift"] = QString::fromWCharArray(L"\xF06b");
      fontawesome_character_map["fa-leaf"] = QString::fromWCharArray(L"\xF06c");
      fontawesome_character_map["fa-fire"] = QString::fromWCharArray(L"\xF06d");
      fontawesome_character_map["fa-eye"] = QString::fromWCharArray(L"\xF06e");
      fontawesome_character_map["fa-eye-slash"] = QString::fromWCharArray(L"\xF070");
      fontawesome_character_map["fa-exclamation-triangle"] = QString::fromWCharArray(L"\xF071");
      fontawesome_character_map["fa-plane"] = QString::fromWCharArray(L"\xF072");
      fontawesome_character_map["fa-calendar-alt"] = QString::fromWCharArray(L"\xF073");
      fontawesome_character_map["fa-random"] = QString::fromWCharArray(L"\xF074");
      fontawesome_character_map["fa-comment"] = QString::fromWCharArray(L"\xF075");
      fontawesome_character_map["fa-magnet"] = QString::fromWCharArray(L"\xF076");
      fontawesome_character_map["fa-chevron-up"] = QString::fromWCharArray(L"\xF077");
      fontawesome_character_map["fa-chevron-down"] = QString::fromWCharArray(L"\xF078");
      fontawesome_character_map["fa-retweet"] = QString::fromWCharArray(L"\xF079");
      fontawesome_character_map["fa-shopping-cart"] = QString::fromWCharArray(L"\xF07a");
      fontawesome_character_map["fa-folder"] = QString::fromWCharArray(L"\xF07b");
      fontawesome_character_map["fa-folder-open"] = QString::fromWCharArray(L"\xF07c");
      fontawesome_character_map["fa-chart-bar"] = QString::fromWCharArray(L"\xF080");
      fontawesome_character_map["fa-twitter-square"] = QString::fromWCharArray(L"\xF081");
      fontawesome_character_map["fa-facebook-square"] = QString::fromWCharArray(L"\xF082");
      fontawesome_character_map["fa-camera-retro"] = QString::fromWCharArray(L"\xF083");
      fontawesome_character_map["fa-key"] = QString::fromWCharArray(L"\xF084");
      fontawesome_character_map["fa-cogs"] = QString::fromWCharArray(L"\xF085");
      fontawesome_character_map["fa-comments"] = QString::fromWCharArray(L"\xF086");
      fontawesome_character_map["fa-star-half"] = QString::fromWCharArray(L"\xF089");
      fontawesome_character_map["fa-linkedin"] = QString::fromWCharArray(L"\xF08c");
      fontawesome_character_map["fa-thumbtack"] = QString::fromWCharArray(L"\xF08d");
      fontawesome_character_map["fa-trophy"] = QString::fromWCharArray(L"\xF091");
      fontawesome_character_map["fa-github-square"] = QString::fromWCharArray(L"\xF092");
      fontawesome_character_map["fa-upload"] = QString::fromWCharArray(L"\xF093");
      fontawesome_character_map["fa-lemon"] = QString::fromWCharArray(L"\xF094");
      fontawesome_character_map["fa-phone"] = QString::fromWCharArray(L"\xF095");
      fontawesome_character_map["fa-phone-square"] = QString::fromWCharArray(L"\xF098");
      fontawesome_character_map["fa-twitter"] = QString::fromWCharArray(L"\xF099");
      fontawesome_character_map["fa-facebook"] = QString::fromWCharArray(L"\xF09a");
      fontawesome_character_map["fa-github"] = QString::fromWCharArray(L"\xF09b");
      fontawesome_character_map["fa-unlock"] = QString::fromWCharArray(L"\xF09c");
      fontawesome_character_map["fa-credit-card"] = QString::fromWCharArray(L"\xF09d");
      fontawesome_character_map["fa-rss"] = QString::fromWCharArray(L"\xF09e");
      fontawesome_character_map["fa-hdd"] = QString::fromWCharArray(L"\xF0a0");
      fontawesome_character_map["fa-bullhorn"] = QString::fromWCharArray(L"\xF0a1");
      fontawesome_character_map["fa-certificate"] = QString::fromWCharArray(L"\xF0a3");
      fontawesome_character_map["fa-hand-point-right"] = QString::fromWCharArray(L"\xF0a4");
      fontawesome_character_map["fa-hand-point-left"] = QString::fromWCharArray(L"\xF0a5");
      fontawesome_character_map["fa-hand-point-up"] = QString::fromWCharArray(L"\xF0a6");
      fontawesome_character_map["fa-hand-point-down"] = QString::fromWCharArray(L"\xF0a7");
      fontawesome_character_map["fa-arrow-circle-left"] = QString::fromWCharArray(L"\xF0a8");
      fontawesome_character_map["fa-arrow-circle-right"] = QString::fromWCharArray(L"\xF0a9");
      fontawesome_character_map["fa-arrow-circle-up"] = QString::fromWCharArray(L"\xF0aa");
      fontawesome_character_map["fa-arrow-circle-down"] = QString::fromWCharArray(L"\xF0ab");
      fontawesome_character_map["fa-globe"] = QString::fromWCharArray(L"\xF0ac");
      fontawesome_character_map["fa-wrench"] = QString::fromWCharArray(L"\xF0ad");
      fontawesome_character_map["fa-tasks"] = QString::fromWCharArray(L"\xF0ae");
      fontawesome_character_map["fa-filter"] = QString::fromWCharArray(L"\xF0b0");
      fontawesome_character_map["fa-briefcase"] = QString::fromWCharArray(L"\xF0b1");
      fontawesome_character_map["fa-arrows-alt"] = QString::fromWCharArray(L"\xF0b2");
      fontawesome_character_map["fa-users"] = QString::fromWCharArray(L"\xF0c0");
      fontawesome_character_map["fa-link"] = QString::fromWCharArray(L"\xF0c1");
      fontawesome_character_map["fa-cloud"] = QString::fromWCharArray(L"\xF0c2");
      fontawesome_character_map["fa-flask"] = QString::fromWCharArray(L"\xF0c3");
      fontawesome_character_map["fa-cut"] = QString::fromWCharArray(L"\xF0c4");
      fontawesome_character_map["fa-copy"] = QString::fromWCharArray(L"\xF0c5");
      fontawesome_character_map["fa-paperclip"] = QString::fromWCharArray(L"\xF0c6");
      fontawesome_character_map["fa-save"] = QString::fromWCharArray(L"\xF0c7");
      fontawesome_character_map["fa-square"] = QString::fromWCharArray(L"\xF0c8");
      fontawesome_character_map["fa-bars"] = QString::fromWCharArray(L"\xF0c9");
      fontawesome_character_map["fa-list-ul"] = QString::fromWCharArray(L"\xF0ca");
      fontawesome_character_map["fa-list-ol"] = QString::fromWCharArray(L"\xF0cb");
      fontawesome_character_map["fa-strikethrough"] = QString::fromWCharArray(L"\xF0cc");
      fontawesome_character_map["fa-underline"] = QString::fromWCharArray(L"\xF0cd");
      fontawesome_character_map["fa-table"] = QString::fromWCharArray(L"\xF0ce");
      fontawesome_character_map["fa-magic"] = QString::fromWCharArray(L"\xF0d0");
      fontawesome_character_map["fa-truck"] = QString::fromWCharArray(L"\xF0d1");
      fontawesome_character_map["fa-pinterest"] = QString::fromWCharArray(L"\xF0d2");
      fontawesome_character_map["fa-pinterest-square"] = QString::fromWCharArray(L"\xF0d3");
      fontawesome_character_map["fa-google-plus-square"] = QString::fromWCharArray(L"\xF0d4");
      fontawesome_character_map["fa-google-plus-g"] = QString::fromWCharArray(L"\xF0d5");
      fontawesome_character_map["fa-money-bill"] = QString::fromWCharArray(L"\xF0d6");
      fontawesome_character_map["fa-caret-down"] = QString::fromWCharArray(L"\xF0d7");
      fontawesome_character_map["fa-caret-up"] = QString::fromWCharArray(L"\xF0d8");
      fontawesome_character_map["fa-caret-left"] = QString::fromWCharArray(L"\xF0d9");
      fontawesome_character_map["fa-caret-right"] = QString::fromWCharArray(L"\xF0da");
      fontawesome_character_map["fa-columns"] = QString::fromWCharArray(L"\xF0db");
      fontawesome_character_map["fa-sort"] = QString::fromWCharArray(L"\xF0dc");
      fontawesome_character_map["fa-sort-down"] = QString::fromWCharArray(L"\xF0dd");
      fontawesome_character_map["fa-sort-up"] = QString::fromWCharArray(L"\xF0de");
      fontawesome_character_map["fa-envelope"] = QString::fromWCharArray(L"\xF0e0");
      fontawesome_character_map["fa-linkedin-in"] = QString::fromWCharArray(L"\xF0e1");
      fontawesome_character_map["fa-undo"] = QString::fromWCharArray(L"\xF0e2");
      fontawesome_character_map["fa-gavel"] = QString::fromWCharArray(L"\xF0e3");
      fontawesome_character_map["fa-bolt"] = QString::fromWCharArray(L"\xF0e7");
      fontawesome_character_map["fa-sitemap"] = QString::fromWCharArray(L"\xF0e8");
      fontawesome_character_map["fa-umbrella"] = QString::fromWCharArray(L"\xF0e9");
      fontawesome_character_map["fa-paste"] = QString::fromWCharArray(L"\xF0ea");
      fontawesome_character_map["fa-lightbulb"] = QString::fromWCharArray(L"\xF0eb");
      fontawesome_character_map["fa-user-md"] = QString::fromWCharArray(L"\xF0f0");
      fontawesome_character_map["fa-stethoscope"] = QString::fromWCharArray(L"\xF0f1");
      fontawesome_character_map["fa-suitcase"] = QString::fromWCharArray(L"\xF0f2");
      fontawesome_character_map["fa-bell"] = QString::fromWCharArray(L"\xF0f3");
      fontawesome_character_map["fa-coffee"] = QString::fromWCharArray(L"\xF0f4");
      fontawesome_character_map["fa-hospital"] = QString::fromWCharArray(L"\xF0f8");
      fontawesome_character_map["fa-ambulance"] = QString::fromWCharArray(L"\xF0f9");
      fontawesome_character_map["fa-medkit"] = QString::fromWCharArray(L"\xF0fa");
      fontawesome_character_map["fa-fighter-jet"] = QString::fromWCharArray(L"\xF0fb");
      fontawesome_character_map["fa-beer"] = QString::fromWCharArray(L"\xF0fc");
      fontawesome_character_map["fa-h-square"] = QString::fromWCharArray(L"\xF0fd");
      fontawesome_character_map["fa-plus-square"] = QString::fromWCharArray(L"\xF0fe");
      fontawesome_character_map["fa-angle-double-left"] = QString::fromWCharArray(L"\xF100");
      fontawesome_character_map["fa-angle-double-right"] = QString::fromWCharArray(L"\xF101");
      fontawesome_character_map["fa-angle-double-up"] = QString::fromWCharArray(L"\xF102");
      fontawesome_character_map["fa-angle-double-down"] = QString::fromWCharArray(L"\xF103");
      fontawesome_character_map["fa-angle-left"] = QString::fromWCharArray(L"\xF104");
      fontawesome_character_map["fa-angle-right"] = QString::fromWCharArray(L"\xF105");
      fontawesome_character_map["fa-angle-up"] = QString::fromWCharArray(L"\xF106");
      fontawesome_character_map["fa-angle-down"] = QString::fromWCharArray(L"\xF107");
      fontawesome_character_map["fa-desktop"] = QString::fromWCharArray(L"\xF108");
      fontawesome_character_map["fa-laptop"] = QString::fromWCharArray(L"\xF109");
      fontawesome_character_map["fa-tablet"] = QString::fromWCharArray(L"\xF10a");
      fontawesome_character_map["fa-mobile"] = QString::fromWCharArray(L"\xF10b");
      fontawesome_character_map["fa-quote-left"] = QString::fromWCharArray(L"\xF10d");
      fontawesome_character_map["fa-quote-right"] = QString::fromWCharArray(L"\xF10e");
      fontawesome_character_map["fa-spinner"] = QString::fromWCharArray(L"\xF110");
      fontawesome_character_map["fa-circle"] = QString::fromWCharArray(L"\xF111");
      fontawesome_character_map["fa-github-alt"] = QString::fromWCharArray(L"\xF113");
      fontawesome_character_map["fa-smile"] = QString::fromWCharArray(L"\xF118");
      fontawesome_character_map["fa-frown"] = QString::fromWCharArray(L"\xF119");
      fontawesome_character_map["fa-meh"] = QString::fromWCharArray(L"\xF11a");
      fontawesome_character_map["fa-gamepad"] = QString::fromWCharArray(L"\xF11b");
      fontawesome_character_map["fa-keyboard"] = QString::fromWCharArray(L"\xF11c");
      fontawesome_character_map["fa-flag-checkered"] = QString::fromWCharArray(L"\xF11e");
      fontawesome_character_map["fa-terminal"] = QString::fromWCharArray(L"\xF120");
      fontawesome_character_map["fa-code"] = QString::fromWCharArray(L"\xF121");
      fontawesome_character_map["fa-reply-all"] = QString::fromWCharArray(L"\xF122");
      fontawesome_character_map["fa-location-arrow"] = QString::fromWCharArray(L"\xF124");
      fontawesome_character_map["fa-crop"] = QString::fromWCharArray(L"\xF125");
      fontawesome_character_map["fa-code-branch"] = QString::fromWCharArray(L"\xF126");
      fontawesome_character_map["fa-unlink"] = QString::fromWCharArray(L"\xF127");
      fontawesome_character_map["fa-question"] = QString::fromWCharArray(L"\xF128");
      fontawesome_character_map["fa-info"] = QString::fromWCharArray(L"\xF129");
      fontawesome_character_map["fa-exclamation"] = QString::fromWCharArray(L"\xF12a");
      fontawesome_character_map["fa-superscript"] = QString::fromWCharArray(L"\xF12b");
      fontawesome_character_map["fa-subscript"] = QString::fromWCharArray(L"\xF12c");
      fontawesome_character_map["fa-eraser"] = QString::fromWCharArray(L"\xF12d");
      fontawesome_character_map["fa-puzzle-piece"] = QString::fromWCharArray(L"\xF12e");
      fontawesome_character_map["fa-microphone"] = QString::fromWCharArray(L"\xF130");
      fontawesome_character_map["fa-microphone-slash"] = QString::fromWCharArray(L"\xF131");
      fontawesome_character_map["fa-calendar"] = QString::fromWCharArray(L"\xF133");
      fontawesome_character_map["fa-fire-extinguisher"] = QString::fromWCharArray(L"\xF134");
      fontawesome_character_map["fa-rocket"] = QString::fromWCharArray(L"\xF135");
      fontawesome_character_map["fa-maxcdn"] = QString::fromWCharArray(L"\xF136");
      fontawesome_character_map["fa-chevron-circle-left"] = QString::fromWCharArray(L"\xF137");
      fontawesome_character_map["fa-chevron-circle-right"] = QString::fromWCharArray(L"\xF138");
      fontawesome_character_map["fa-chevron-circle-up"] = QString::fromWCharArray(L"\xF139");
      fontawesome_character_map["fa-chevron-circle-down"] = QString::fromWCharArray(L"\xF13a");
      fontawesome_character_map["fa-html5"] = QString::fromWCharArray(L"\xF13b");
      fontawesome_character_map["fa-css3"] = QString::fromWCharArray(L"\xF13c");
      fontawesome_character_map["fa-anchor"] = QString::fromWCharArray(L"\xF13d");
      fontawesome_character_map["fa-unlock-alt"] = QString::fromWCharArray(L"\xF13e");
      fontawesome_character_map["fa-bullseye"] = QString::fromWCharArray(L"\xF140");
      fontawesome_character_map["fa-ellipsis-h"] = QString::fromWCharArray(L"\xF141");
      fontawesome_character_map["fa-ellipsis-v"] = QString::fromWCharArray(L"\xF142");
      fontawesome_character_map["fa-rss-square"] = QString::fromWCharArray(L"\xF143");
      fontawesome_character_map["fa-play-circle"] = QString::fromWCharArray(L"\xF144");
      fontawesome_character_map["fa-minus-square"] = QString::fromWCharArray(L"\xF146");
      fontawesome_character_map["fa-check-square"] = QString::fromWCharArray(L"\xF14a");
      fontawesome_character_map["fa-pen-square"] = QString::fromWCharArray(L"\xF14b");
      fontawesome_character_map["fa-share-square"] = QString::fromWCharArray(L"\xF14d");
      fontawesome_character_map["fa-compass"] = QString::fromWCharArray(L"\xF14e");
      fontawesome_character_map["fa-caret-square-down"] = QString::fromWCharArray(L"\xF150");
      fontawesome_character_map["fa-caret-square-up"] = QString::fromWCharArray(L"\xF151");
      fontawesome_character_map["fa-caret-square-right"] = QString::fromWCharArray(L"\xF152");
      fontawesome_character_map["fa-euro-sign"] = QString::fromWCharArray(L"\xF153");
      fontawesome_character_map["fa-pound-sign"] = QString::fromWCharArray(L"\xF154");
      fontawesome_character_map["fa-dollar-sign"] = QString::fromWCharArray(L"\xF155");
      fontawesome_character_map["fa-rupee-sign"] = QString::fromWCharArray(L"\xF156");
      fontawesome_character_map["fa-yen-sign"] = QString::fromWCharArray(L"\xF157");
      fontawesome_character_map["fa-ruble-sign"] = QString::fromWCharArray(L"\xF158");
      fontawesome_character_map["fa-won-sign"] = QString::fromWCharArray(L"\xF159");
      fontawesome_character_map["fa-btc"] = QString::fromWCharArray(L"\xF15a");
      fontawesome_character_map["fa-file"] = QString::fromWCharArray(L"\xF15b");
      fontawesome_character_map["fa-file-alt"] = QString::fromWCharArray(L"\xF15c");
      fontawesome_character_map["fa-sort-alpha-down"] = QString::fromWCharArray(L"\xF15d");
      fontawesome_character_map["fa-sort-alpha-up"] = QString::fromWCharArray(L"\xF15e");
      fontawesome_character_map["fa-sort-amount-down"] = QString::fromWCharArray(L"\xF160");
      fontawesome_character_map["fa-sort-amount-up"] = QString::fromWCharArray(L"\xF161");
      fontawesome_character_map["fa-sort-numeric-down"] = QString::fromWCharArray(L"\xF162");
      fontawesome_character_map["fa-sort-numeric-up"] = QString::fromWCharArray(L"\xF163");
      fontawesome_character_map["fa-thumbs-up"] = QString::fromWCharArray(L"\xF164");
      fontawesome_character_map["fa-thumbs-down"] = QString::fromWCharArray(L"\xF165");
      fontawesome_character_map["fa-youtube"] = QString::fromWCharArray(L"\xF167");
      fontawesome_character_map["fa-xing"] = QString::fromWCharArray(L"\xF168");
      fontawesome_character_map["fa-xing-square"] = QString::fromWCharArray(L"\xF169");
      fontawesome_character_map["fa-dropbox"] = QString::fromWCharArray(L"\xF16b");
      fontawesome_character_map["fa-stack-overflow"] = QString::fromWCharArray(L"\xF16c");
      fontawesome_character_map["fa-instagram"] = QString::fromWCharArray(L"\xF16d");
      fontawesome_character_map["fa-flickr"] = QString::fromWCharArray(L"\xF16e");
      fontawesome_character_map["fa-adn"] = QString::fromWCharArray(L"\xF170");
      fontawesome_character_map["fa-bitbucket"] = QString::fromWCharArray(L"\xF171");
      fontawesome_character_map["fa-tumblr"] = QString::fromWCharArray(L"\xF173");
      fontawesome_character_map["fa-tumblr-square"] = QString::fromWCharArray(L"\xF174");
      fontawesome_character_map["fa-apple"] = QString::fromWCharArray(L"\xF179");
      fontawesome_character_map["fa-windows"] = QString::fromWCharArray(L"\xF17a");
      fontawesome_character_map["fa-android"] = QString::fromWCharArray(L"\xF17b");
      fontawesome_character_map["fa-linux"] = QString::fromWCharArray(L"\xF17c");
      fontawesome_character_map["fa-dribbble"] = QString::fromWCharArray(L"\xF17d");
      fontawesome_character_map["fa-skype"] = QString::fromWCharArray(L"\xF17e");
      fontawesome_character_map["fa-foursquare"] = QString::fromWCharArray(L"\xF180");
      fontawesome_character_map["fa-trello"] = QString::fromWCharArray(L"\xF181");
      fontawesome_character_map["fa-female"] = QString::fromWCharArray(L"\xF182");
      fontawesome_character_map["fa-male"] = QString::fromWCharArray(L"\xF183");
      fontawesome_character_map["fa-gratipay"] = QString::fromWCharArray(L"\xF184");
      fontawesome_character_map["fa-sun"] = QString::fromWCharArray(L"\xF185");
      fontawesome_character_map["fa-moon"] = QString::fromWCharArray(L"\xF186");
      fontawesome_character_map["fa-archive"] = QString::fromWCharArray(L"\xF187");
      fontawesome_character_map["fa-bug"] = QString::fromWCharArray(L"\xF188");
      fontawesome_character_map["fa-vk"] = QString::fromWCharArray(L"\xF189");
      fontawesome_character_map["fa-weibo"] = QString::fromWCharArray(L"\xF18a");
      fontawesome_character_map["fa-renren"] = QString::fromWCharArray(L"\xF18b");
      fontawesome_character_map["fa-pagelines"] = QString::fromWCharArray(L"\xF18c");
      fontawesome_character_map["fa-stack-exchange"] = QString::fromWCharArray(L"\xF18d");
      fontawesome_character_map["fa-caret-square-left"] = QString::fromWCharArray(L"\xF191");
      fontawesome_character_map["fa-dot-circle"] = QString::fromWCharArray(L"\xF192");
      fontawesome_character_map["fa-wheelchair"] = QString::fromWCharArray(L"\xF193");
      fontawesome_character_map["fa-vimeo-square"] = QString::fromWCharArray(L"\xF194");
      fontawesome_character_map["fa-lira-sign"] = QString::fromWCharArray(L"\xF195");
      fontawesome_character_map["fa-space-shuttle"] = QString::fromWCharArray(L"\xF197");
      fontawesome_character_map["fa-slack"] = QString::fromWCharArray(L"\xF198");
      fontawesome_character_map["fa-envelope-square"] = QString::fromWCharArray(L"\xF199");
      fontawesome_character_map["fa-wordpress"] = QString::fromWCharArray(L"\xF19a");
      fontawesome_character_map["fa-openid"] = QString::fromWCharArray(L"\xF19b");
      fontawesome_character_map["fa-university"] = QString::fromWCharArray(L"\xF19c");
      fontawesome_character_map["fa-graduation-cap"] = QString::fromWCharArray(L"\xF19d");
      fontawesome_character_map["fa-yahoo"] = QString::fromWCharArray(L"\xF19e");
      fontawesome_character_map["fa-google"] = QString::fromWCharArray(L"\xF1a0");
      fontawesome_character_map["fa-reddit"] = QString::fromWCharArray(L"\xF1a1");
      fontawesome_character_map["fa-reddit-square"] = QString::fromWCharArray(L"\xF1a2");
      fontawesome_character_map["fa-stumbleupon-circle"] = QString::fromWCharArray(L"\xF1a3");
      fontawesome_character_map["fa-stumbleupon"] = QString::fromWCharArray(L"\xF1a4");
      fontawesome_character_map["fa-delicious"] = QString::fromWCharArray(L"\xF1a5");
      fontawesome_character_map["fa-digg"] = QString::fromWCharArray(L"\xF1a6");
      fontawesome_character_map["fa-pied-piper-pp"] = QString::fromWCharArray(L"\xF1a7");
      fontawesome_character_map["fa-pied-piper-alt"] = QString::fromWCharArray(L"\xF1a8");
      fontawesome_character_map["fa-drupal"] = QString::fromWCharArray(L"\xF1a9");
      fontawesome_character_map["fa-joomla"] = QString::fromWCharArray(L"\xF1aa");
      fontawesome_character_map["fa-language"] = QString::fromWCharArray(L"\xF1ab");
      fontawesome_character_map["fa-fax"] = QString::fromWCharArray(L"\xF1ac");
      fontawesome_character_map["fa-building"] = QString::fromWCharArray(L"\xF1ad");
      fontawesome_character_map["fa-child"] = QString::fromWCharArray(L"\xF1ae");
      fontawesome_character_map["fa-paw"] = QString::fromWCharArray(L"\xF1b0");
      fontawesome_character_map["fa-cube"] = QString::fromWCharArray(L"\xF1b2");
      fontawesome_character_map["fa-cubes"] = QString::fromWCharArray(L"\xF1b3");
      fontawesome_character_map["fa-behance"] = QString::fromWCharArray(L"\xF1b4");
      fontawesome_character_map["fa-behance-square"] = QString::fromWCharArray(L"\xF1b5");
      fontawesome_character_map["fa-steam"] = QString::fromWCharArray(L"\xF1b6");
      fontawesome_character_map["fa-steam-square"] = QString::fromWCharArray(L"\xF1b7");
      fontawesome_character_map["fa-recycle"] = QString::fromWCharArray(L"\xF1b8");
      fontawesome_character_map["fa-car"] = QString::fromWCharArray(L"\xF1b9");
      fontawesome_character_map["fa-taxi"] = QString::fromWCharArray(L"\xF1ba");
      fontawesome_character_map["fa-tree"] = QString::fromWCharArray(L"\xF1bb");
      fontawesome_character_map["fa-spotify"] = QString::fromWCharArray(L"\xF1bc");
      fontawesome_character_map["fa-deviantart"] = QString::fromWCharArray(L"\xF1bd");
      fontawesome_character_map["fa-soundcloud"] = QString::fromWCharArray(L"\xF1be");
      fontawesome_character_map["fa-database"] = QString::fromWCharArray(L"\xF1c0");
      fontawesome_character_map["fa-file-pdf"] = QString::fromWCharArray(L"\xF1c1");
      fontawesome_character_map["fa-file-word"] = QString::fromWCharArray(L"\xF1c2");
      fontawesome_character_map["fa-file-excel"] = QString::fromWCharArray(L"\xF1c3");
      fontawesome_character_map["fa-file-powerpoint"] = QString::fromWCharArray(L"\xF1c4");
      fontawesome_character_map["fa-file-image"] = QString::fromWCharArray(L"\xF1c5");
      fontawesome_character_map["fa-file-archive"] = QString::fromWCharArray(L"\xF1c6");
      fontawesome_character_map["fa-file-audio"] = QString::fromWCharArray(L"\xF1c7");
      fontawesome_character_map["fa-file-video"] = QString::fromWCharArray(L"\xF1c8");
      fontawesome_character_map["fa-file-code"] = QString::fromWCharArray(L"\xF1c9");
      fontawesome_character_map["fa-vine"] = QString::fromWCharArray(L"\xF1ca");
      fontawesome_character_map["fa-codepen"] = QString::fromWCharArray(L"\xF1cb");
      fontawesome_character_map["fa-jsfiddle"] = QString::fromWCharArray(L"\xF1cc");
      fontawesome_character_map["fa-life-ring"] = QString::fromWCharArray(L"\xF1cd");
      fontawesome_character_map["fa-circle-notch"] = QString::fromWCharArray(L"\xF1ce");
      fontawesome_character_map["fa-rebel"] = QString::fromWCharArray(L"\xF1d0");
      fontawesome_character_map["fa-empire"] = QString::fromWCharArray(L"\xF1d1");
      fontawesome_character_map["fa-git-square"] = QString::fromWCharArray(L"\xF1d2");
      fontawesome_character_map["fa-git"] = QString::fromWCharArray(L"\xF1d3");
      fontawesome_character_map["fa-hacker-news"] = QString::fromWCharArray(L"\xF1d4");
      fontawesome_character_map["fa-tencent-weibo"] = QString::fromWCharArray(L"\xF1d5");
      fontawesome_character_map["fa-qq"] = QString::fromWCharArray(L"\xF1d6");
      fontawesome_character_map["fa-weixin"] = QString::fromWCharArray(L"\xF1d7");
      fontawesome_character_map["fa-paper-plane"] = QString::fromWCharArray(L"\xF1d8");
      fontawesome_character_map["fa-history"] = QString::fromWCharArray(L"\xF1da");
      fontawesome_character_map["fa-heading"] = QString::fromWCharArray(L"\xF1dc");
      fontawesome_character_map["fa-paragraph"] = QString::fromWCharArray(L"\xF1dd");
      fontawesome_character_map["fa-sliders-h"] = QString::fromWCharArray(L"\xF1de");
      fontawesome_character_map["fa-share-alt"] = QString::fromWCharArray(L"\xF1e0");
      fontawesome_character_map["fa-share-alt-square"] = QString::fromWCharArray(L"\xF1e1");
      fontawesome_character_map["fa-bomb"] = QString::fromWCharArray(L"\xF1e2");
      fontawesome_character_map["fa-futbol"] = QString::fromWCharArray(L"\xF1e3");
      fontawesome_character_map["fa-tty"] = QString::fromWCharArray(L"\xF1e4");
      fontawesome_character_map["fa-binoculars"] = QString::fromWCharArray(L"\xF1e5");
      fontawesome_character_map["fa-plug"] = QString::fromWCharArray(L"\xF1e6");
      fontawesome_character_map["fa-slideshare"] = QString::fromWCharArray(L"\xF1e7");
      fontawesome_character_map["fa-twitch"] = QString::fromWCharArray(L"\xF1e8");
      fontawesome_character_map["fa-yelp"] = QString::fromWCharArray(L"\xF1e9");
      fontawesome_character_map["fa-newspaper"] = QString::fromWCharArray(L"\xF1ea");
      fontawesome_character_map["fa-wifi"] = QString::fromWCharArray(L"\xF1eb");
      fontawesome_character_map["fa-calculator"] = QString::fromWCharArray(L"\xF1ec");
      fontawesome_character_map["fa-paypal"] = QString::fromWCharArray(L"\xF1ed");
      fontawesome_character_map["fa-google-wallet"] = QString::fromWCharArray(L"\xF1ee");
      fontawesome_character_map["fa-cc-visa"] = QString::fromWCharArray(L"\xF1f0");
      fontawesome_character_map["fa-cc-mastercard"] = QString::fromWCharArray(L"\xF1f1");
      fontawesome_character_map["fa-cc-discover"] = QString::fromWCharArray(L"\xF1f2");
      fontawesome_character_map["fa-cc-amex"] = QString::fromWCharArray(L"\xF1f3");
      fontawesome_character_map["fa-cc-paypal"] = QString::fromWCharArray(L"\xF1f4");
      fontawesome_character_map["fa-cc-stripe"] = QString::fromWCharArray(L"\xF1f5");
      fontawesome_character_map["fa-bell-slash"] = QString::fromWCharArray(L"\xF1f6");
      fontawesome_character_map["fa-trash"] = QString::fromWCharArray(L"\xF1f8");
      fontawesome_character_map["fa-copyright"] = QString::fromWCharArray(L"\xF1f9");
      fontawesome_character_map["fa-at"] = QString::fromWCharArray(L"\xF1fa");
      fontawesome_character_map["fa-eye-dropper"] = QString::fromWCharArray(L"\xF1fb");
      fontawesome_character_map["fa-paint-brush"] = QString::fromWCharArray(L"\xF1fc");
      fontawesome_character_map["fa-birthday-cake"] = QString::fromWCharArray(L"\xF1fd");
      fontawesome_character_map["fa-chart-area"] = QString::fromWCharArray(L"\xF1fe");
      fontawesome_character_map["fa-chart-pie"] = QString::fromWCharArray(L"\xF200");
      fontawesome_character_map["fa-chart-line"] = QString::fromWCharArray(L"\xF201");
      fontawesome_character_map["fa-lastfm"] = QString::fromWCharArray(L"\xF202");
      fontawesome_character_map["fa-lastfm-square"] = QString::fromWCharArray(L"\xF203");
      fontawesome_character_map["fa-toggle-off"] = QString::fromWCharArray(L"\xF204");
      fontawesome_character_map["fa-toggle-on"] = QString::fromWCharArray(L"\xF205");
      fontawesome_character_map["fa-bicycle"] = QString::fromWCharArray(L"\xF206");
      fontawesome_character_map["fa-bus"] = QString::fromWCharArray(L"\xF207");
      fontawesome_character_map["fa-ioxhost"] = QString::fromWCharArray(L"\xF208");
      fontawesome_character_map["fa-angellist"] = QString::fromWCharArray(L"\xF209");
      fontawesome_character_map["fa-closed-captioning"] = QString::fromWCharArray(L"\xF20a");
      fontawesome_character_map["fa-shekel-sign"] = QString::fromWCharArray(L"\xF20b");
      fontawesome_character_map["fa-buysellads"] = QString::fromWCharArray(L"\xF20d");
      fontawesome_character_map["fa-connectdevelop"] = QString::fromWCharArray(L"\xF20e");
      fontawesome_character_map["fa-dashcube"] = QString::fromWCharArray(L"\xF210");
      fontawesome_character_map["fa-forumbee"] = QString::fromWCharArray(L"\xF211");
      fontawesome_character_map["fa-leanpub"] = QString::fromWCharArray(L"\xF212");
      fontawesome_character_map["fa-sellsy"] = QString::fromWCharArray(L"\xF213");
      fontawesome_character_map["fa-shirtsinbulk"] = QString::fromWCharArray(L"\xF214");
      fontawesome_character_map["fa-simplybuilt"] = QString::fromWCharArray(L"\xF215");
      fontawesome_character_map["fa-skyatlas"] = QString::fromWCharArray(L"\xF216");
      fontawesome_character_map["fa-cart-plus"] = QString::fromWCharArray(L"\xF217");
      fontawesome_character_map["fa-cart-arrow-down"] = QString::fromWCharArray(L"\xF218");
      fontawesome_character_map["fa-ship"] = QString::fromWCharArray(L"\xF21a");
      fontawesome_character_map["fa-user-secret"] = QString::fromWCharArray(L"\xF21b");
      fontawesome_character_map["fa-motorcycle"] = QString::fromWCharArray(L"\xF21c");
      fontawesome_character_map["fa-street-view"] = QString::fromWCharArray(L"\xF21d");
      fontawesome_character_map["fa-heartbeat"] = QString::fromWCharArray(L"\xF21e");
      fontawesome_character_map["fa-venus"] = QString::fromWCharArray(L"\xF221");
      fontawesome_character_map["fa-mars"] = QString::fromWCharArray(L"\xF222");
      fontawesome_character_map["fa-mercury"] = QString::fromWCharArray(L"\xF223");
      fontawesome_character_map["fa-transgender"] = QString::fromWCharArray(L"\xF224");
      fontawesome_character_map["fa-transgender-alt"] = QString::fromWCharArray(L"\xF225");
      fontawesome_character_map["fa-venus-double"] = QString::fromWCharArray(L"\xF226");
      fontawesome_character_map["fa-mars-double"] = QString::fromWCharArray(L"\xF227");
      fontawesome_character_map["fa-venus-mars"] = QString::fromWCharArray(L"\xF228");
      fontawesome_character_map["fa-mars-stroke"] = QString::fromWCharArray(L"\xF229");
      fontawesome_character_map["fa-mars-stroke-v"] = QString::fromWCharArray(L"\xF22a");
      fontawesome_character_map["fa-mars-stroke-h"] = QString::fromWCharArray(L"\xF22b");
      fontawesome_character_map["fa-neuter"] = QString::fromWCharArray(L"\xF22c");
      fontawesome_character_map["fa-genderless"] = QString::fromWCharArray(L"\xF22d");
      fontawesome_character_map["fa-pinterest-p"] = QString::fromWCharArray(L"\xF231");
      fontawesome_character_map["fa-whatsapp"] = QString::fromWCharArray(L"\xF232");
      fontawesome_character_map["fa-server"] = QString::fromWCharArray(L"\xF233");
      fontawesome_character_map["fa-user-plus"] = QString::fromWCharArray(L"\xF234");
      fontawesome_character_map["fa-user-times"] = QString::fromWCharArray(L"\xF235");
      fontawesome_character_map["fa-bed"] = QString::fromWCharArray(L"\xF236");
      fontawesome_character_map["fa-viacoin"] = QString::fromWCharArray(L"\xF237");
      fontawesome_character_map["fa-train"] = QString::fromWCharArray(L"\xF238");
      fontawesome_character_map["fa-subway"] = QString::fromWCharArray(L"\xF239");
      fontawesome_character_map["fa-medium"] = QString::fromWCharArray(L"\xF23a");
      fontawesome_character_map["fa-y-combinator"] = QString::fromWCharArray(L"\xF23b");
      fontawesome_character_map["fa-optin-monster"] = QString::fromWCharArray(L"\xF23c");
      fontawesome_character_map["fa-opencart"] = QString::fromWCharArray(L"\xF23d");
      fontawesome_character_map["fa-expeditedssl"] = QString::fromWCharArray(L"\xF23e");
      fontawesome_character_map["fa-battery-full"] = QString::fromWCharArray(L"\xF240");
      fontawesome_character_map["fa-battery-three-quarters"] = QString::fromWCharArray(L"\xF241");
      fontawesome_character_map["fa-battery-half"] = QString::fromWCharArray(L"\xF242");
      fontawesome_character_map["fa-battery-quarter"] = QString::fromWCharArray(L"\xF243");
      fontawesome_character_map["fa-battery-empty"] = QString::fromWCharArray(L"\xF244");
      fontawesome_character_map["fa-mouse-pointer"] = QString::fromWCharArray(L"\xF245");
      fontawesome_character_map["fa-i-cursor"] = QString::fromWCharArray(L"\xF246");
      fontawesome_character_map["fa-object-group"] = QString::fromWCharArray(L"\xF247");
      fontawesome_character_map["fa-object-ungroup"] = QString::fromWCharArray(L"\xF248");
      fontawesome_character_map["fa-sticky-note"] = QString::fromWCharArray(L"\xF249");
      fontawesome_character_map["fa-cc-jcb"] = QString::fromWCharArray(L"\xF24b");
      fontawesome_character_map["fa-cc-diners-club"] = QString::fromWCharArray(L"\xF24c");
      fontawesome_character_map["fa-clone"] = QString::fromWCharArray(L"\xF24d");
      fontawesome_character_map["fa-balance-scale"] = QString::fromWCharArray(L"\xF24e");
      fontawesome_character_map["fa-hourglass-start"] = QString::fromWCharArray(L"\xF251");
      fontawesome_character_map["fa-hourglass-half"] = QString::fromWCharArray(L"\xF252");
      fontawesome_character_map["fa-hourglass-end"] = QString::fromWCharArray(L"\xF253");
      fontawesome_character_map["fa-hourglass"] = QString::fromWCharArray(L"\xF254");
      fontawesome_character_map["fa-hand-rock"] = QString::fromWCharArray(L"\xF255");
      fontawesome_character_map["fa-hand-paper"] = QString::fromWCharArray(L"\xF256");
      fontawesome_character_map["fa-hand-scissors"] = QString::fromWCharArray(L"\xF257");
      fontawesome_character_map["fa-hand-lizard"] = QString::fromWCharArray(L"\xF258");
      fontawesome_character_map["fa-hand-spock"] = QString::fromWCharArray(L"\xF259");
      fontawesome_character_map["fa-hand-pointer"] = QString::fromWCharArray(L"\xF25a");
      fontawesome_character_map["fa-hand-peace"] = QString::fromWCharArray(L"\xF25b");
      fontawesome_character_map["fa-trademark"] = QString::fromWCharArray(L"\xF25c");
      fontawesome_character_map["fa-registered"] = QString::fromWCharArray(L"\xF25d");
      fontawesome_character_map["fa-creative-commons"] = QString::fromWCharArray(L"\xF25e");
      fontawesome_character_map["fa-gg"] = QString::fromWCharArray(L"\xF260");
      fontawesome_character_map["fa-gg-circle"] = QString::fromWCharArray(L"\xF261");
      fontawesome_character_map["fa-tripadvisor"] = QString::fromWCharArray(L"\xF262");
      fontawesome_character_map["fa-odnoklassniki"] = QString::fromWCharArray(L"\xF263");
      fontawesome_character_map["fa-odnoklassniki-square"] = QString::fromWCharArray(L"\xF264");
      fontawesome_character_map["fa-get-pocket"] = QString::fromWCharArray(L"\xF265");
      fontawesome_character_map["fa-wikipedia-w"] = QString::fromWCharArray(L"\xF266");
      fontawesome_character_map["fa-safari"] = QString::fromWCharArray(L"\xF267");
      fontawesome_character_map["fa-chrome"] = QString::fromWCharArray(L"\xF268");
      fontawesome_character_map["fa-firefox"] = QString::fromWCharArray(L"\xF269");
      fontawesome_character_map["fa-opera"] = QString::fromWCharArray(L"\xF26a");
      fontawesome_character_map["fa-internet-explorer"] = QString::fromWCharArray(L"\xF26b");
      fontawesome_character_map["fa-tv"] = QString::fromWCharArray(L"\xF26c");
      fontawesome_character_map["fa-contao"] = QString::fromWCharArray(L"\xF26d");
      fontawesome_character_map["fa-500px"] = QString::fromWCharArray(L"\xF26e");
      fontawesome_character_map["fa-amazon"] = QString::fromWCharArray(L"\xF270");
      fontawesome_character_map["fa-calendar-plus"] = QString::fromWCharArray(L"\xF271");
      fontawesome_character_map["fa-calendar-minus"] = QString::fromWCharArray(L"\xF272");
      fontawesome_character_map["fa-calendar-times"] = QString::fromWCharArray(L"\xF273");
      fontawesome_character_map["fa-calendar-check"] = QString::fromWCharArray(L"\xF274");
      fontawesome_character_map["fa-industry"] = QString::fromWCharArray(L"\xF275");
      fontawesome_character_map["fa-map-pin"] = QString::fromWCharArray(L"\xF276");
      fontawesome_character_map["fa-map-signs"] = QString::fromWCharArray(L"\xF277");
      fontawesome_character_map["fa-map"] = QString::fromWCharArray(L"\xF279");
      fontawesome_character_map["fa-comment-alt"] = QString::fromWCharArray(L"\xF27a");
      fontawesome_character_map["fa-houzz"] = QString::fromWCharArray(L"\xF27c");
      fontawesome_character_map["fa-vimeo-v"] = QString::fromWCharArray(L"\xF27d");
      fontawesome_character_map["fa-black-tie"] = QString::fromWCharArray(L"\xF27e");
      fontawesome_character_map["fa-fonticons"] = QString::fromWCharArray(L"\xF280");
      fontawesome_character_map["fa-reddit-alien"] = QString::fromWCharArray(L"\xF281");
      fontawesome_character_map["fa-edge"] = QString::fromWCharArray(L"\xF282");
      fontawesome_character_map["fa-codiepie"] = QString::fromWCharArray(L"\xF284");
      fontawesome_character_map["fa-modx"] = QString::fromWCharArray(L"\xF285");
      fontawesome_character_map["fa-fort-awesome"] = QString::fromWCharArray(L"\xF286");
      fontawesome_character_map["fa-usb"] = QString::fromWCharArray(L"\xF287");
      fontawesome_character_map["fa-product-hunt"] = QString::fromWCharArray(L"\xF288");
      fontawesome_character_map["fa-mixcloud"] = QString::fromWCharArray(L"\xF289");
      fontawesome_character_map["fa-scribd"] = QString::fromWCharArray(L"\xF28a");
      fontawesome_character_map["fa-pause-circle"] = QString::fromWCharArray(L"\xF28b");
      fontawesome_character_map["fa-stop-circle"] = QString::fromWCharArray(L"\xF28d");
      fontawesome_character_map["fa-shopping-bag"] = QString::fromWCharArray(L"\xF290");
      fontawesome_character_map["fa-shopping-basket"] = QString::fromWCharArray(L"\xF291");
      fontawesome_character_map["fa-hashtag"] = QString::fromWCharArray(L"\xF292");
      fontawesome_character_map["fa-bluetooth"] = QString::fromWCharArray(L"\xF293");
      fontawesome_character_map["fa-bluetooth-b"] = QString::fromWCharArray(L"\xF294");
      fontawesome_character_map["fa-percent"] = QString::fromWCharArray(L"\xF295");
      fontawesome_character_map["fa-gitlab"] = QString::fromWCharArray(L"\xF296");
      fontawesome_character_map["fa-wpbeginner"] = QString::fromWCharArray(L"\xF297");
      fontawesome_character_map["fa-wpforms"] = QString::fromWCharArray(L"\xF298");
      fontawesome_character_map["fa-envira"] = QString::fromWCharArray(L"\xF299");
      fontawesome_character_map["fa-universal-access"] = QString::fromWCharArray(L"\xF29a");
      fontawesome_character_map["fa-blind"] = QString::fromWCharArray(L"\xF29d");
      fontawesome_character_map["fa-audio-description"] = QString::fromWCharArray(L"\xF29e");
      fontawesome_character_map["fa-phone-volume"] = QString::fromWCharArray(L"\xF2a0");
      fontawesome_character_map["fa-braille"] = QString::fromWCharArray(L"\xF2a1");
      fontawesome_character_map["fa-assistive-listening-systems"] = QString::fromWCharArray(L"\xF2a2");
      fontawesome_character_map["fa-american-sign-language-interpreting"] = QString::fromWCharArray(L"\xF2a3");
      fontawesome_character_map["fa-deaf"] = QString::fromWCharArray(L"\xF2a4");
      fontawesome_character_map["fa-glide"] = QString::fromWCharArray(L"\xF2a5");
      fontawesome_character_map["fa-glide-g"] = QString::fromWCharArray(L"\xF2a6");
      fontawesome_character_map["fa-sign-language"] = QString::fromWCharArray(L"\xF2a7");
      fontawesome_character_map["fa-low-vision"] = QString::fromWCharArray(L"\xF2a8");
      fontawesome_character_map["fa-viadeo"] = QString::fromWCharArray(L"\xF2a9");
      fontawesome_character_map["fa-viadeo-square"] = QString::fromWCharArray(L"\xF2aa");
      fontawesome_character_map["fa-snapchat"] = QString::fromWCharArray(L"\xF2ab");
      fontawesome_character_map["fa-snapchat-ghost"] = QString::fromWCharArray(L"\xF2ac");
      fontawesome_character_map["fa-snapchat-square"] = QString::fromWCharArray(L"\xF2ad");
      fontawesome_character_map["fa-pied-piper"] = QString::fromWCharArray(L"\xF2ae");
      fontawesome_character_map["fa-first-order"] = QString::fromWCharArray(L"\xF2b0");
      fontawesome_character_map["fa-yoast"] = QString::fromWCharArray(L"\xF2b1");
      fontawesome_character_map["fa-themeisle"] = QString::fromWCharArray(L"\xF2b2");
      fontawesome_character_map["fa-google-plus"] = QString::fromWCharArray(L"\xF2b3");
      fontawesome_character_map["fa-font-awesome"] = QString::fromWCharArray(L"\xF2b4");
      fontawesome_character_map["fa-handshake"] = QString::fromWCharArray(L"\xF2b5");
      fontawesome_character_map["fa-envelope-open"] = QString::fromWCharArray(L"\xF2b6");
      fontawesome_character_map["fa-linode"] = QString::fromWCharArray(L"\xF2b8");
      fontawesome_character_map["fa-address-book"] = QString::fromWCharArray(L"\xF2b9");
      fontawesome_character_map["fa-address-card"] = QString::fromWCharArray(L"\xF2bb");
      fontawesome_character_map["fa-user-circle"] = QString::fromWCharArray(L"\xF2bd");
      fontawesome_character_map["fa-id-badge"] = QString::fromWCharArray(L"\xF2c1");
      fontawesome_character_map["fa-id-card"] = QString::fromWCharArray(L"\xF2c2");
      fontawesome_character_map["fa-quora"] = QString::fromWCharArray(L"\xF2c4");
      fontawesome_character_map["fa-free-code-camp"] = QString::fromWCharArray(L"\xF2c5");
      fontawesome_character_map["fa-telegram"] = QString::fromWCharArray(L"\xF2c6");
      fontawesome_character_map["fa-thermometer-full"] = QString::fromWCharArray(L"\xF2c7");
      fontawesome_character_map["fa-thermometer-three-quarters"] = QString::fromWCharArray(L"\xF2c8");
      fontawesome_character_map["fa-thermometer-half"] = QString::fromWCharArray(L"\xF2c9");
      fontawesome_character_map["fa-thermometer-quarter"] = QString::fromWCharArray(L"\xF2ca");
      fontawesome_character_map["fa-thermometer-empty"] = QString::fromWCharArray(L"\xF2cb");
      fontawesome_character_map["fa-shower"] = QString::fromWCharArray(L"\xF2cc");
      fontawesome_character_map["fa-bath"] = QString::fromWCharArray(L"\xF2cd");
      fontawesome_character_map["fa-podcast"] = QString::fromWCharArray(L"\xF2ce");
      fontawesome_character_map["fa-window-maximize"] = QString::fromWCharArray(L"\xF2d0");
      fontawesome_character_map["fa-window-minimize"] = QString::fromWCharArray(L"\xF2d1");
      fontawesome_character_map["fa-window-restore"] = QString::fromWCharArray(L"\xF2d2");
      fontawesome_character_map["fa-bandcamp"] = QString::fromWCharArray(L"\xF2d5");
      fontawesome_character_map["fa-grav"] = QString::fromWCharArray(L"\xF2d6");
      fontawesome_character_map["fa-etsy"] = QString::fromWCharArray(L"\xF2d7");
      fontawesome_character_map["fa-imdb"] = QString::fromWCharArray(L"\xF2d8");
      fontawesome_character_map["fa-ravelry"] = QString::fromWCharArray(L"\xF2d9");
      fontawesome_character_map["fa-sellcast"] = QString::fromWCharArray(L"\xF2da");
      fontawesome_character_map["fa-microchip"] = QString::fromWCharArray(L"\xF2db");
      fontawesome_character_map["fa-snowflake"] = QString::fromWCharArray(L"\xF2dc");
      fontawesome_character_map["fa-superpowers"] = QString::fromWCharArray(L"\xF2dd");
      fontawesome_character_map["fa-wpexplorer"] = QString::fromWCharArray(L"\xF2de");
      fontawesome_character_map["fa-meetup"] = QString::fromWCharArray(L"\xF2e0");
      fontawesome_character_map["fa-utensil-spoon"] = QString::fromWCharArray(L"\xF2e5");
      fontawesome_character_map["fa-utensils"] = QString::fromWCharArray(L"\xF2e7");
      fontawesome_character_map["fa-undo-alt"] = QString::fromWCharArray(L"\xF2ea");
      fontawesome_character_map["fa-trash-alt"] = QString::fromWCharArray(L"\xF2ed");
      fontawesome_character_map["fa-sync-alt"] = QString::fromWCharArray(L"\xF2f1");
      fontawesome_character_map["fa-stopwatch"] = QString::fromWCharArray(L"\xF2f2");
      fontawesome_character_map["fa-sign-out-alt"] = QString::fromWCharArray(L"\xF2f5");
      fontawesome_character_map["fa-sign-in-alt"] = QString::fromWCharArray(L"\xF2f6");
      fontawesome_character_map["fa-redo-alt"] = QString::fromWCharArray(L"\xF2f9");
      fontawesome_character_map["fa-poo"] = QString::fromWCharArray(L"\xF2fe");
      fontawesome_character_map["fa-images"] = QString::fromWCharArray(L"\xF302");
      fontawesome_character_map["fa-pencil-alt"] = QString::fromWCharArray(L"\xF303");
      fontawesome_character_map["fa-pen"] = QString::fromWCharArray(L"\xF304");
      fontawesome_character_map["fa-pen-alt"] = QString::fromWCharArray(L"\xF305");
      fontawesome_character_map["fa-long-arrow-alt-down"] = QString::fromWCharArray(L"\xF309");
      fontawesome_character_map["fa-long-arrow-alt-left"] = QString::fromWCharArray(L"\xF30a");
      fontawesome_character_map["fa-long-arrow-alt-right"] = QString::fromWCharArray(L"\xF30b");
      fontawesome_character_map["fa-long-arrow-alt-up"] = QString::fromWCharArray(L"\xF30c");
      fontawesome_character_map["fa-expand-arrows-alt"] = QString::fromWCharArray(L"\xF31e");
      fontawesome_character_map["fa-clipboard"] = QString::fromWCharArray(L"\xF328");
      fontawesome_character_map["fa-arrows-alt-h"] = QString::fromWCharArray(L"\xF337");
      fontawesome_character_map["fa-arrows-alt-v"] = QString::fromWCharArray(L"\xF338");
      fontawesome_character_map["fa-arrow-alt-circle-down"] = QString::fromWCharArray(L"\xF358");
      fontawesome_character_map["fa-arrow-alt-circle-left"] = QString::fromWCharArray(L"\xF359");
      fontawesome_character_map["fa-arrow-alt-circle-right"] = QString::fromWCharArray(L"\xF35a");
      fontawesome_character_map["fa-arrow-alt-circle-up"] = QString::fromWCharArray(L"\xF35b");
      fontawesome_character_map["fa-font-awesome-alt"] = QString::fromWCharArray(L"\xF35c");
      fontawesome_character_map["fa-external-link-alt"] = QString::fromWCharArray(L"\xF35d");
      fontawesome_character_map["fa-external-link-square-alt"] = QString::fromWCharArray(L"\xF360");
      fontawesome_character_map["fa-exchange-alt"] = QString::fromWCharArray(L"\xF362");
      fontawesome_character_map["fa-accessible-icon"] = QString::fromWCharArray(L"\xF368");
      fontawesome_character_map["fa-accusoft"] = QString::fromWCharArray(L"\xF369");
      fontawesome_character_map["fa-adversal"] = QString::fromWCharArray(L"\xF36a");
      fontawesome_character_map["fa-affiliatetheme"] = QString::fromWCharArray(L"\xF36b");
      fontawesome_character_map["fa-algolia"] = QString::fromWCharArray(L"\xF36c");
      fontawesome_character_map["fa-amilia"] = QString::fromWCharArray(L"\xF36d");
      fontawesome_character_map["fa-angrycreative"] = QString::fromWCharArray(L"\xF36e");
      fontawesome_character_map["fa-app-store"] = QString::fromWCharArray(L"\xF36f");
      fontawesome_character_map["fa-app-store-ios"] = QString::fromWCharArray(L"\xF370");
      fontawesome_character_map["fa-apper"] = QString::fromWCharArray(L"\xF371");
      fontawesome_character_map["fa-asymmetrik"] = QString::fromWCharArray(L"\xF372");
      fontawesome_character_map["fa-audible"] = QString::fromWCharArray(L"\xF373");
      fontawesome_character_map["fa-avianex"] = QString::fromWCharArray(L"\xF374");
      fontawesome_character_map["fa-aws"] = QString::fromWCharArray(L"\xF375");
      fontawesome_character_map["fa-bimobject"] = QString::fromWCharArray(L"\xF378");
      fontawesome_character_map["fa-bitcoin"] = QString::fromWCharArray(L"\xF379");
      fontawesome_character_map["fa-bity"] = QString::fromWCharArray(L"\xF37a");
      fontawesome_character_map["fa-blackberry"] = QString::fromWCharArray(L"\xF37b");
      fontawesome_character_map["fa-blogger"] = QString::fromWCharArray(L"\xF37c");
      fontawesome_character_map["fa-blogger-b"] = QString::fromWCharArray(L"\xF37d");
      fontawesome_character_map["fa-buromobelexperte"] = QString::fromWCharArray(L"\xF37f");
      fontawesome_character_map["fa-centercode"] = QString::fromWCharArray(L"\xF380");
      fontawesome_character_map["fa-cloud-download-alt"] = QString::fromWCharArray(L"\xF381");
      fontawesome_character_map["fa-cloud-upload-alt"] = QString::fromWCharArray(L"\xF382");
      fontawesome_character_map["fa-cloudscale"] = QString::fromWCharArray(L"\xF383");
      fontawesome_character_map["fa-cloudsmith"] = QString::fromWCharArray(L"\xF384");
      fontawesome_character_map["fa-cloudversify"] = QString::fromWCharArray(L"\xF385");
      fontawesome_character_map["fa-cpanel"] = QString::fromWCharArray(L"\xF388");
      fontawesome_character_map["fa-css3-alt"] = QString::fromWCharArray(L"\xF38b");
      fontawesome_character_map["fa-cuttlefish"] = QString::fromWCharArray(L"\xF38c");
      fontawesome_character_map["fa-d-and-d"] = QString::fromWCharArray(L"\xF38d");
      fontawesome_character_map["fa-deploydog"] = QString::fromWCharArray(L"\xF38e");
      fontawesome_character_map["fa-deskpro"] = QString::fromWCharArray(L"\xF38f");
      fontawesome_character_map["fa-digital-ocean"] = QString::fromWCharArray(L"\xF391");
      fontawesome_character_map["fa-discord"] = QString::fromWCharArray(L"\xF392");
      fontawesome_character_map["fa-discourse"] = QString::fromWCharArray(L"\xF393");
      fontawesome_character_map["fa-dochub"] = QString::fromWCharArray(L"\xF394");
      fontawesome_character_map["fa-docker"] = QString::fromWCharArray(L"\xF395");
      fontawesome_character_map["fa-draft2digital"] = QString::fromWCharArray(L"\xF396");
      fontawesome_character_map["fa-dribbble-square"] = QString::fromWCharArray(L"\xF397");
      fontawesome_character_map["fa-dyalog"] = QString::fromWCharArray(L"\xF399");
      fontawesome_character_map["fa-earlybirds"] = QString::fromWCharArray(L"\xF39a");
      fontawesome_character_map["fa-erlang"] = QString::fromWCharArray(L"\xF39d");
      fontawesome_character_map["fa-facebook-f"] = QString::fromWCharArray(L"\xF39e");
      fontawesome_character_map["fa-facebook-messenger"] = QString::fromWCharArray(L"\xF39f");
      fontawesome_character_map["fa-firstdraft"] = QString::fromWCharArray(L"\xF3a1");
      fontawesome_character_map["fa-fonticons-fi"] = QString::fromWCharArray(L"\xF3a2");
      fontawesome_character_map["fa-fort-awesome-alt"] = QString::fromWCharArray(L"\xF3a3");
      fontawesome_character_map["fa-freebsd"] = QString::fromWCharArray(L"\xF3a4");
      fontawesome_character_map["fa-gem"] = QString::fromWCharArray(L"\xF3a5");
      fontawesome_character_map["fa-gitkraken"] = QString::fromWCharArray(L"\xF3a6");
      fontawesome_character_map["fa-gofore"] = QString::fromWCharArray(L"\xF3a7");
      fontawesome_character_map["fa-goodreads"] = QString::fromWCharArray(L"\xF3a8");
      fontawesome_character_map["fa-goodreads-g"] = QString::fromWCharArray(L"\xF3a9");
      fontawesome_character_map["fa-google-drive"] = QString::fromWCharArray(L"\xF3aa");
      fontawesome_character_map["fa-google-play"] = QString::fromWCharArray(L"\xF3ab");
      fontawesome_character_map["fa-gripfire"] = QString::fromWCharArray(L"\xF3ac");
      fontawesome_character_map["fa-grunt"] = QString::fromWCharArray(L"\xF3ad");
      fontawesome_character_map["fa-gulp"] = QString::fromWCharArray(L"\xF3ae");
      fontawesome_character_map["fa-hacker-news-square"] = QString::fromWCharArray(L"\xF3af");
      fontawesome_character_map["fa-hire-a-helper"] = QString::fromWCharArray(L"\xF3b0");
      fontawesome_character_map["fa-hotjar"] = QString::fromWCharArray(L"\xF3b1");
      fontawesome_character_map["fa-hubspot"] = QString::fromWCharArray(L"\xF3b2");
      fontawesome_character_map["fa-itunes"] = QString::fromWCharArray(L"\xF3b4");
      fontawesome_character_map["fa-itunes-note"] = QString::fromWCharArray(L"\xF3b5");
      fontawesome_character_map["fa-jenkins"] = QString::fromWCharArray(L"\xF3b6");
      fontawesome_character_map["fa-joget"] = QString::fromWCharArray(L"\xF3b7");
      fontawesome_character_map["fa-js"] = QString::fromWCharArray(L"\xF3b8");
      fontawesome_character_map["fa-js-square"] = QString::fromWCharArray(L"\xF3b9");
      fontawesome_character_map["fa-keycdn"] = QString::fromWCharArray(L"\xF3ba");
      fontawesome_character_map["fa-kickstarter"] = QString::fromWCharArray(L"\xF3bb");
      fontawesome_character_map["fa-kickstarter-k"] = QString::fromWCharArray(L"\xF3bc");
      fontawesome_character_map["fa-laravel"] = QString::fromWCharArray(L"\xF3bd");
      fontawesome_character_map["fa-level-down-alt"] = QString::fromWCharArray(L"\xF3be");
      fontawesome_character_map["fa-level-up-alt"] = QString::fromWCharArray(L"\xF3bf");
      fontawesome_character_map["fa-line"] = QString::fromWCharArray(L"\xF3c0");
      fontawesome_character_map["fa-lock-open"] = QString::fromWCharArray(L"\xF3c1");
      fontawesome_character_map["fa-lyft"] = QString::fromWCharArray(L"\xF3c3");
      fontawesome_character_map["fa-magento"] = QString::fromWCharArray(L"\xF3c4");
      fontawesome_character_map["fa-map-marker-alt"] = QString::fromWCharArray(L"\xF3c5");
      fontawesome_character_map["fa-medapps"] = QString::fromWCharArray(L"\xF3c6");
      fontawesome_character_map["fa-medium-m"] = QString::fromWCharArray(L"\xF3c7");
      fontawesome_character_map["fa-medrt"] = QString::fromWCharArray(L"\xF3c8");
      fontawesome_character_map["fa-microphone-alt"] = QString::fromWCharArray(L"\xF3c9");
      fontawesome_character_map["fa-microsoft"] = QString::fromWCharArray(L"\xF3ca");
      fontawesome_character_map["fa-mix"] = QString::fromWCharArray(L"\xF3cb");
      fontawesome_character_map["fa-mizuni"] = QString::fromWCharArray(L"\xF3cc");
      fontawesome_character_map["fa-mobile-alt"] = QString::fromWCharArray(L"\xF3cd");
      fontawesome_character_map["fa-monero"] = QString::fromWCharArray(L"\xF3d0");
      fontawesome_character_map["fa-money-bill-alt"] = QString::fromWCharArray(L"\xF3d1");
      fontawesome_character_map["fa-napster"] = QString::fromWCharArray(L"\xF3d2");
      fontawesome_character_map["fa-node-js"] = QString::fromWCharArray(L"\xF3d3");
      fontawesome_character_map["fa-npm"] = QString::fromWCharArray(L"\xF3d4");
      fontawesome_character_map["fa-ns8"] = QString::fromWCharArray(L"\xF3d5");
      fontawesome_character_map["fa-nutritionix"] = QString::fromWCharArray(L"\xF3d6");
      fontawesome_character_map["fa-page4"] = QString::fromWCharArray(L"\xF3d7");
      fontawesome_character_map["fa-palfed"] = QString::fromWCharArray(L"\xF3d8");
      fontawesome_character_map["fa-patreon"] = QString::fromWCharArray(L"\xF3d9");
      fontawesome_character_map["fa-periscope"] = QString::fromWCharArray(L"\xF3da");
      fontawesome_character_map["fa-phabricator"] = QString::fromWCharArray(L"\xF3db");
      fontawesome_character_map["fa-phoenix-framework"] = QString::fromWCharArray(L"\xF3dc");
      fontawesome_character_map["fa-phone-slash"] = QString::fromWCharArray(L"\xF3dd");
      fontawesome_character_map["fa-playstation"] = QString::fromWCharArray(L"\xF3df");
      fontawesome_character_map["fa-portrait"] = QString::fromWCharArray(L"\xF3e0");
      fontawesome_character_map["fa-pushed"] = QString::fromWCharArray(L"\xF3e1");
      fontawesome_character_map["fa-python"] = QString::fromWCharArray(L"\xF3e2");
      fontawesome_character_map["fa-red-river"] = QString::fromWCharArray(L"\xF3e3");
      fontawesome_character_map["fa-wpressr"] = QString::fromWCharArray(L"\xF3e4");
      fontawesome_character_map["fa-reply"] = QString::fromWCharArray(L"\xF3e5");
      fontawesome_character_map["fa-replyd"] = QString::fromWCharArray(L"\xF3e6");
      fontawesome_character_map["fa-resolving"] = QString::fromWCharArray(L"\xF3e7");
      fontawesome_character_map["fa-rocketchat"] = QString::fromWCharArray(L"\xF3e8");
      fontawesome_character_map["fa-rockrms"] = QString::fromWCharArray(L"\xF3e9");
      fontawesome_character_map["fa-schlix"] = QString::fromWCharArray(L"\xF3ea");
      fontawesome_character_map["fa-searchengin"] = QString::fromWCharArray(L"\xF3eb");
      fontawesome_character_map["fa-servicestack"] = QString::fromWCharArray(L"\xF3ec");
      fontawesome_character_map["fa-shield-alt"] = QString::fromWCharArray(L"\xF3ed");
      fontawesome_character_map["fa-sistrix"] = QString::fromWCharArray(L"\xF3ee");
      fontawesome_character_map["fa-slack-hash"] = QString::fromWCharArray(L"\xF3ef");
      fontawesome_character_map["fa-speakap"] = QString::fromWCharArray(L"\xF3f3");
      fontawesome_character_map["fa-staylinked"] = QString::fromWCharArray(L"\xF3f5");
      fontawesome_character_map["fa-steam-symbol"] = QString::fromWCharArray(L"\xF3f6");
      fontawesome_character_map["fa-sticker-mule"] = QString::fromWCharArray(L"\xF3f7");
      fontawesome_character_map["fa-studiovinari"] = QString::fromWCharArray(L"\xF3f8");
      fontawesome_character_map["fa-supple"] = QString::fromWCharArray(L"\xF3f9");
      fontawesome_character_map["fa-tablet-alt"] = QString::fromWCharArray(L"\xF3fa");
      fontawesome_character_map["fa-tachometer-alt"] = QString::fromWCharArray(L"\xF3fd");
      fontawesome_character_map["fa-telegram-plane"] = QString::fromWCharArray(L"\xF3fe");
      fontawesome_character_map["fa-ticket-alt"] = QString::fromWCharArray(L"\xF3ff");
      fontawesome_character_map["fa-uber"] = QString::fromWCharArray(L"\xF402");
      fontawesome_character_map["fa-uikit"] = QString::fromWCharArray(L"\xF403");
      fontawesome_character_map["fa-uniregistry"] = QString::fromWCharArray(L"\xF404");
      fontawesome_character_map["fa-untappd"] = QString::fromWCharArray(L"\xF405");
      fontawesome_character_map["fa-user-alt"] = QString::fromWCharArray(L"\xF406");
      fontawesome_character_map["fa-ussunnah"] = QString::fromWCharArray(L"\xF407");
      fontawesome_character_map["fa-vaadin"] = QString::fromWCharArray(L"\xF408");
      fontawesome_character_map["fa-viber"] = QString::fromWCharArray(L"\xF409");
      fontawesome_character_map["fa-vimeo"] = QString::fromWCharArray(L"\xF40a");
      fontawesome_character_map["fa-vnv"] = QString::fromWCharArray(L"\xF40b");
      fontawesome_character_map["fa-whatsapp-square"] = QString::fromWCharArray(L"\xF40c");
      fontawesome_character_map["fa-whmcs"] = QString::fromWCharArray(L"\xF40d");
      fontawesome_character_map["fa-window-close"] = QString::fromWCharArray(L"\xF410");
      fontawesome_character_map["fa-wordpress-simple"] = QString::fromWCharArray(L"\xF411");
      fontawesome_character_map["fa-xbox"] = QString::fromWCharArray(L"\xF412");
      fontawesome_character_map["fa-yandex"] = QString::fromWCharArray(L"\xF413");
      fontawesome_character_map["fa-yandex-international"] = QString::fromWCharArray(L"\xF414");
      fontawesome_character_map["fa-apple-pay"] = QString::fromWCharArray(L"\xF415");
      fontawesome_character_map["fa-cc-apple-pay"] = QString::fromWCharArray(L"\xF416");
      fontawesome_character_map["fa-fly"] = QString::fromWCharArray(L"\xF417");
      fontawesome_character_map["fa-node"] = QString::fromWCharArray(L"\xF419");
      fontawesome_character_map["fa-osi"] = QString::fromWCharArray(L"\xF41a");
      fontawesome_character_map["fa-react"] = QString::fromWCharArray(L"\xF41b");
      fontawesome_character_map["fa-autoprefixer"] = QString::fromWCharArray(L"\xF41c");
      fontawesome_character_map["fa-less"] = QString::fromWCharArray(L"\xF41d");
      fontawesome_character_map["fa-sass"] = QString::fromWCharArray(L"\xF41e");
      fontawesome_character_map["fa-vuejs"] = QString::fromWCharArray(L"\xF41f");
      fontawesome_character_map["fa-angular"] = QString::fromWCharArray(L"\xF420");
      fontawesome_character_map["fa-aviato"] = QString::fromWCharArray(L"\xF421");
      fontawesome_character_map["fa-compress-alt"] = QString::fromWCharArray(L"\xF422");
      fontawesome_character_map["fa-ember"] = QString::fromWCharArray(L"\xF423");
      fontawesome_character_map["fa-expand-alt"] = QString::fromWCharArray(L"\xF424");
      fontawesome_character_map["fa-font-awesome-flag"] = QString::fromWCharArray(L"\xF425");
      fontawesome_character_map["fa-gitter"] = QString::fromWCharArray(L"\xF426");
      fontawesome_character_map["fa-hooli"] = QString::fromWCharArray(L"\xF427");
      fontawesome_character_map["fa-strava"] = QString::fromWCharArray(L"\xF428");
      fontawesome_character_map["fa-stripe"] = QString::fromWCharArray(L"\xF429");
      fontawesome_character_map["fa-stripe-s"] = QString::fromWCharArray(L"\xF42a");
      fontawesome_character_map["fa-typo3"] = QString::fromWCharArray(L"\xF42b");
      fontawesome_character_map["fa-amazon-pay"] = QString::fromWCharArray(L"\xF42c");
      fontawesome_character_map["fa-cc-amazon-pay"] = QString::fromWCharArray(L"\xF42d");
      fontawesome_character_map["fa-ethereum"] = QString::fromWCharArray(L"\xF42e");
      fontawesome_character_map["fa-korvue"] = QString::fromWCharArray(L"\xF42f");
      fontawesome_character_map["fa-elementor"] = QString::fromWCharArray(L"\xF430");
      fontawesome_character_map["fa-youtube-square"] = QString::fromWCharArray(L"\xF431");
      fontawesome_character_map["fa-baseball-ball"] = QString::fromWCharArray(L"\xF433");
      fontawesome_character_map["fa-basketball-ball"] = QString::fromWCharArray(L"\xF434");
      fontawesome_character_map["fa-bowling-ball"] = QString::fromWCharArray(L"\xF436");
      fontawesome_character_map["fa-chess"] = QString::fromWCharArray(L"\xF439");
      fontawesome_character_map["fa-chess-bishop"] = QString::fromWCharArray(L"\xF43a");
      fontawesome_character_map["fa-chess-board"] = QString::fromWCharArray(L"\xF43c");
      fontawesome_character_map["fa-chess-king"] = QString::fromWCharArray(L"\xF43f");
      fontawesome_character_map["fa-chess-knight"] = QString::fromWCharArray(L"\xF441");
      fontawesome_character_map["fa-chess-pawn"] = QString::fromWCharArray(L"\xF443");
      fontawesome_character_map["fa-chess-queen"] = QString::fromWCharArray(L"\xF445");
      fontawesome_character_map["fa-chess-rook"] = QString::fromWCharArray(L"\xF447");
      fontawesome_character_map["fa-dumbbell"] = QString::fromWCharArray(L"\xF44b");
      fontawesome_character_map["fa-flipboard"] = QString::fromWCharArray(L"\xF44d");
      fontawesome_character_map["fa-football-ball"] = QString::fromWCharArray(L"\xF44e");
      fontawesome_character_map["fa-golf-ball"] = QString::fromWCharArray(L"\xF450");
      fontawesome_character_map["fa-hips"] = QString::fromWCharArray(L"\xF452");
      fontawesome_character_map["fa-hockey-puck"] = QString::fromWCharArray(L"\xF453");
      fontawesome_character_map["fa-php"] = QString::fromWCharArray(L"\xF457");
      fontawesome_character_map["fa-quidditch"] = QString::fromWCharArray(L"\xF458");
      fontawesome_character_map["fa-quinscape"] = QString::fromWCharArray(L"\xF459");
      fontawesome_character_map["fa-square-full"] = QString::fromWCharArray(L"\xF45c");
      fontawesome_character_map["fa-table-tennis"] = QString::fromWCharArray(L"\xF45d");
      fontawesome_character_map["fa-volleyball-ball"] = QString::fromWCharArray(L"\xF45f");
      fontawesome_character_map["fa-allergies"] = QString::fromWCharArray(L"\xF461");
      fontawesome_character_map["fa-band-aid"] = QString::fromWCharArray(L"\xF462");
      fontawesome_character_map["fa-box"] = QString::fromWCharArray(L"\xF466");
      fontawesome_character_map["fa-boxes"] = QString::fromWCharArray(L"\xF468");
      fontawesome_character_map["fa-briefcase-medical"] = QString::fromWCharArray(L"\xF469");
      fontawesome_character_map["fa-burn"] = QString::fromWCharArray(L"\xF46a");
      fontawesome_character_map["fa-capsules"] = QString::fromWCharArray(L"\xF46b");
      fontawesome_character_map["fa-clipboard-check"] = QString::fromWCharArray(L"\xF46c");
      fontawesome_character_map["fa-clipboard-list"] = QString::fromWCharArray(L"\xF46d");
      fontawesome_character_map["fa-diagnoses"] = QString::fromWCharArray(L"\xF470");
      fontawesome_character_map["fa-dna"] = QString::fromWCharArray(L"\xF471");
      fontawesome_character_map["fa-dolly"] = QString::fromWCharArray(L"\xF472");
      fontawesome_character_map["fa-dolly-flatbed"] = QString::fromWCharArray(L"\xF474");
      fontawesome_character_map["fa-file-medical"] = QString::fromWCharArray(L"\xF477");
      fontawesome_character_map["fa-file-medical-alt"] = QString::fromWCharArray(L"\xF478");
      fontawesome_character_map["fa-first-aid"] = QString::fromWCharArray(L"\xF479");
      fontawesome_character_map["fa-hospital-alt"] = QString::fromWCharArray(L"\xF47d");
      fontawesome_character_map["fa-hospital-symbol"] = QString::fromWCharArray(L"\xF47e");
      fontawesome_character_map["fa-id-card-alt"] = QString::fromWCharArray(L"\xF47f");
      fontawesome_character_map["fa-notes-medical"] = QString::fromWCharArray(L"\xF481");
      fontawesome_character_map["fa-pallet"] = QString::fromWCharArray(L"\xF482");
      fontawesome_character_map["fa-pills"] = QString::fromWCharArray(L"\xF484");
      fontawesome_character_map["fa-prescription-bottle"] = QString::fromWCharArray(L"\xF485");
      fontawesome_character_map["fa-prescription-bottle-alt"] = QString::fromWCharArray(L"\xF486");
      fontawesome_character_map["fa-procedures"] = QString::fromWCharArray(L"\xF487");
      fontawesome_character_map["fa-shipping-fast"] = QString::fromWCharArray(L"\xF48b");
      fontawesome_character_map["fa-smoking"] = QString::fromWCharArray(L"\xF48d");
      fontawesome_character_map["fa-syringe"] = QString::fromWCharArray(L"\xF48e");
      fontawesome_character_map["fa-tablets"] = QString::fromWCharArray(L"\xF490");
      fontawesome_character_map["fa-thermometer"] = QString::fromWCharArray(L"\xF491");
      fontawesome_character_map["fa-vial"] = QString::fromWCharArray(L"\xF492");
      fontawesome_character_map["fa-vials"] = QString::fromWCharArray(L"\xF493");
      fontawesome_character_map["fa-warehouse"] = QString::fromWCharArray(L"\xF494");
      fontawesome_character_map["fa-weight"] = QString::fromWCharArray(L"\xF496");
      fontawesome_character_map["fa-x-ray"] = QString::fromWCharArray(L"\xF497");
      fontawesome_character_map["fa-box-open"] = QString::fromWCharArray(L"\xF49e");
      fontawesome_character_map["fa-comment-dots"] = QString::fromWCharArray(L"\xF4ad");
      fontawesome_character_map["fa-comment-slash"] = QString::fromWCharArray(L"\xF4b3");
      fontawesome_character_map["fa-couch"] = QString::fromWCharArray(L"\xF4b8");
      fontawesome_character_map["fa-donate"] = QString::fromWCharArray(L"\xF4b9");
      fontawesome_character_map["fa-dove"] = QString::fromWCharArray(L"\xF4ba");
      fontawesome_character_map["fa-hand-holding"] = QString::fromWCharArray(L"\xF4bd");
      fontawesome_character_map["fa-hand-holding-heart"] = QString::fromWCharArray(L"\xF4be");
      fontawesome_character_map["fa-hand-holding-usd"] = QString::fromWCharArray(L"\xF4c0");
      fontawesome_character_map["fa-hands"] = QString::fromWCharArray(L"\xF4c2");
      fontawesome_character_map["fa-hands-helping"] = QString::fromWCharArray(L"\xF4c4");
      fontawesome_character_map["fa-parachute-box"] = QString::fromWCharArray(L"\xF4cd");
      fontawesome_character_map["fa-people-carry"] = QString::fromWCharArray(L"\xF4ce");
      fontawesome_character_map["fa-piggy-bank"] = QString::fromWCharArray(L"\xF4d3");
      fontawesome_character_map["fa-readme"] = QString::fromWCharArray(L"\xF4d5");
      fontawesome_character_map["fa-ribbon"] = QString::fromWCharArray(L"\xF4d6");
      fontawesome_character_map["fa-route"] = QString::fromWCharArray(L"\xF4d7");
      fontawesome_character_map["fa-seedling"] = QString::fromWCharArray(L"\xF4d8");
      fontawesome_character_map["fa-sign"] = QString::fromWCharArray(L"\xF4d9");
      fontawesome_character_map["fa-smile-wink"] = QString::fromWCharArray(L"\xF4da");
      fontawesome_character_map["fa-tape"] = QString::fromWCharArray(L"\xF4db");
      fontawesome_character_map["fa-truck-loading"] = QString::fromWCharArray(L"\xF4de");
      fontawesome_character_map["fa-truck-moving"] = QString::fromWCharArray(L"\xF4df");
      fontawesome_character_map["fa-video-slash"] = QString::fromWCharArray(L"\xF4e2");
      fontawesome_character_map["fa-wine-glass"] = QString::fromWCharArray(L"\xF4e3");
      fontawesome_character_map["fa-java"] = QString::fromWCharArray(L"\xF4e4");
      fontawesome_character_map["fa-pied-piper-hat"] = QString::fromWCharArray(L"\xF4e5");
      fontawesome_character_map["fa-font-awesome-logo-full"] = QString::fromWCharArray(L"\xF4e6");
      fontawesome_character_map["fa-creative-commons-by"] = QString::fromWCharArray(L"\xF4e7");
      fontawesome_character_map["fa-creative-commons-nc"] = QString::fromWCharArray(L"\xF4e8");
      fontawesome_character_map["fa-creative-commons-nc-eu"] = QString::fromWCharArray(L"\xF4e9");
      fontawesome_character_map["fa-creative-commons-nc-jp"] = QString::fromWCharArray(L"\xF4ea");
      fontawesome_character_map["fa-creative-commons-nd"] = QString::fromWCharArray(L"\xF4eb");
      fontawesome_character_map["fa-creative-commons-pd"] = QString::fromWCharArray(L"\xF4ec");
      fontawesome_character_map["fa-creative-commons-pd-alt"] = QString::fromWCharArray(L"\xF4ed");
      fontawesome_character_map["fa-creative-commons-remix"] = QString::fromWCharArray(L"\xF4ee");
      fontawesome_character_map["fa-creative-commons-sa"] = QString::fromWCharArray(L"\xF4ef");
      fontawesome_character_map["fa-creative-commons-sampling"] = QString::fromWCharArray(L"\xF4f0");
      fontawesome_character_map["fa-creative-commons-sampling-plus"] = QString::fromWCharArray(L"\xF4f1");
      fontawesome_character_map["fa-creative-commons-share"] = QString::fromWCharArray(L"\xF4f2");
      fontawesome_character_map["fa-creative-commons-zero"] = QString::fromWCharArray(L"\xF4f3");
      fontawesome_character_map["fa-ebay"] = QString::fromWCharArray(L"\xF4f4");
      fontawesome_character_map["fa-keybase"] = QString::fromWCharArray(L"\xF4f5");
      fontawesome_character_map["fa-mastodon"] = QString::fromWCharArray(L"\xF4f6");
      fontawesome_character_map["fa-r-project"] = QString::fromWCharArray(L"\xF4f7");
      fontawesome_character_map["fa-researchgate"] = QString::fromWCharArray(L"\xF4f8");
      fontawesome_character_map["fa-teamspeak"] = QString::fromWCharArray(L"\xF4f9");
      fontawesome_character_map["fa-user-alt-slash"] = QString::fromWCharArray(L"\xF4fa");
      fontawesome_character_map["fa-user-astronaut"] = QString::fromWCharArray(L"\xF4fb");
      fontawesome_character_map["fa-user-check"] = QString::fromWCharArray(L"\xF4fc");
      fontawesome_character_map["fa-user-clock"] = QString::fromWCharArray(L"\xF4fd");
      fontawesome_character_map["fa-user-cog"] = QString::fromWCharArray(L"\xF4fe");
      fontawesome_character_map["fa-user-edit"] = QString::fromWCharArray(L"\xF4ff");
      fontawesome_character_map["fa-user-friends"] = QString::fromWCharArray(L"\xF500");
      fontawesome_character_map["fa-user-graduate"] = QString::fromWCharArray(L"\xF501");
      fontawesome_character_map["fa-user-lock"] = QString::fromWCharArray(L"\xF502");
      fontawesome_character_map["fa-user-minus"] = QString::fromWCharArray(L"\xF503");
      fontawesome_character_map["fa-user-ninja"] = QString::fromWCharArray(L"\xF504");
      fontawesome_character_map["fa-user-shield"] = QString::fromWCharArray(L"\xF505");
      fontawesome_character_map["fa-user-slash"] = QString::fromWCharArray(L"\xF506");
      fontawesome_character_map["fa-user-tag"] = QString::fromWCharArray(L"\xF507");
      fontawesome_character_map["fa-user-tie"] = QString::fromWCharArray(L"\xF508");
      fontawesome_character_map["fa-users-cog"] = QString::fromWCharArray(L"\xF509");
      fontawesome_character_map["fa-first-order-alt"] = QString::fromWCharArray(L"\xF50a");
      fontawesome_character_map["fa-fulcrum"] = QString::fromWCharArray(L"\xF50b");
      fontawesome_character_map["fa-galactic-republic"] = QString::fromWCharArray(L"\xF50c");
      fontawesome_character_map["fa-galactic-senate"] = QString::fromWCharArray(L"\xF50d");
      fontawesome_character_map["fa-jedi-order"] = QString::fromWCharArray(L"\xF50e");
      fontawesome_character_map["fa-mandalorian"] = QString::fromWCharArray(L"\xF50f");
      fontawesome_character_map["fa-old-republic"] = QString::fromWCharArray(L"\xF510");
      fontawesome_character_map["fa-phoenix-squadron"] = QString::fromWCharArray(L"\xF511");
      fontawesome_character_map["fa-sith"] = QString::fromWCharArray(L"\xF512");
      fontawesome_character_map["fa-trade-federation"] = QString::fromWCharArray(L"\xF513");
      fontawesome_character_map["fa-wolf-pack-battalion"] = QString::fromWCharArray(L"\xF514");
      fontawesome_character_map["fa-balance-scale-left"] = QString::fromWCharArray(L"\xF515");
      fontawesome_character_map["fa-balance-scale-right"] = QString::fromWCharArray(L"\xF516");
      fontawesome_character_map["fa-blender"] = QString::fromWCharArray(L"\xF517");
      fontawesome_character_map["fa-book-open"] = QString::fromWCharArray(L"\xF518");
      fontawesome_character_map["fa-broadcast-tower"] = QString::fromWCharArray(L"\xF519");
      fontawesome_character_map["fa-broom"] = QString::fromWCharArray(L"\xF51a");
      fontawesome_character_map["fa-chalkboard"] = QString::fromWCharArray(L"\xF51b");
      fontawesome_character_map["fa-chalkboard-teacher"] = QString::fromWCharArray(L"\xF51c");
      fontawesome_character_map["fa-church"] = QString::fromWCharArray(L"\xF51d");
      fontawesome_character_map["fa-coins"] = QString::fromWCharArray(L"\xF51e");
      fontawesome_character_map["fa-compact-disc"] = QString::fromWCharArray(L"\xF51f");
      fontawesome_character_map["fa-crow"] = QString::fromWCharArray(L"\xF520");
      fontawesome_character_map["fa-crown"] = QString::fromWCharArray(L"\xF521");
      fontawesome_character_map["fa-dice"] = QString::fromWCharArray(L"\xF522");
      fontawesome_character_map["fa-dice-five"] = QString::fromWCharArray(L"\xF523");
      fontawesome_character_map["fa-dice-four"] = QString::fromWCharArray(L"\xF524");
      fontawesome_character_map["fa-dice-one"] = QString::fromWCharArray(L"\xF525");
      fontawesome_character_map["fa-dice-six"] = QString::fromWCharArray(L"\xF526");
      fontawesome_character_map["fa-dice-three"] = QString::fromWCharArray(L"\xF527");
      fontawesome_character_map["fa-dice-two"] = QString::fromWCharArray(L"\xF528");
      fontawesome_character_map["fa-divide"] = QString::fromWCharArray(L"\xF529");
      fontawesome_character_map["fa-door-closed"] = QString::fromWCharArray(L"\xF52a");
      fontawesome_character_map["fa-door-open"] = QString::fromWCharArray(L"\xF52b");
      fontawesome_character_map["fa-equals"] = QString::fromWCharArray(L"\xF52c");
      fontawesome_character_map["fa-feather"] = QString::fromWCharArray(L"\xF52d");
      fontawesome_character_map["fa-frog"] = QString::fromWCharArray(L"\xF52e");
      fontawesome_character_map["fa-gas-pump"] = QString::fromWCharArray(L"\xF52f");
      fontawesome_character_map["fa-glasses"] = QString::fromWCharArray(L"\xF530");
      fontawesome_character_map["fa-greater-than"] = QString::fromWCharArray(L"\xF531");
      fontawesome_character_map["fa-greater-than-equal"] = QString::fromWCharArray(L"\xF532");
      fontawesome_character_map["fa-helicopter"] = QString::fromWCharArray(L"\xF533");
      fontawesome_character_map["fa-infinity"] = QString::fromWCharArray(L"\xF534");
      fontawesome_character_map["fa-kiwi-bird"] = QString::fromWCharArray(L"\xF535");
      fontawesome_character_map["fa-less-than"] = QString::fromWCharArray(L"\xF536");
      fontawesome_character_map["fa-less-than-equal"] = QString::fromWCharArray(L"\xF537");
      fontawesome_character_map["fa-memory"] = QString::fromWCharArray(L"\xF538");
      fontawesome_character_map["fa-microphone-alt-slash"] = QString::fromWCharArray(L"\xF539");
      fontawesome_character_map["fa-money-bill-wave"] = QString::fromWCharArray(L"\xF53a");
      fontawesome_character_map["fa-money-bill-wave-alt"] = QString::fromWCharArray(L"\xF53b");
      fontawesome_character_map["fa-money-check"] = QString::fromWCharArray(L"\xF53c");
      fontawesome_character_map["fa-money-check-alt"] = QString::fromWCharArray(L"\xF53d");
      fontawesome_character_map["fa-not-equal"] = QString::fromWCharArray(L"\xF53e");
      fontawesome_character_map["fa-palette"] = QString::fromWCharArray(L"\xF53f");
      fontawesome_character_map["fa-parking"] = QString::fromWCharArray(L"\xF540");
      fontawesome_character_map["fa-percentage"] = QString::fromWCharArray(L"\xF541");
      fontawesome_character_map["fa-project-diagram"] = QString::fromWCharArray(L"\xF542");
      fontawesome_character_map["fa-receipt"] = QString::fromWCharArray(L"\xF543");
      fontawesome_character_map["fa-robot"] = QString::fromWCharArray(L"\xF544");
      fontawesome_character_map["fa-ruler"] = QString::fromWCharArray(L"\xF545");
      fontawesome_character_map["fa-ruler-combined"] = QString::fromWCharArray(L"\xF546");
      fontawesome_character_map["fa-ruler-horizontal"] = QString::fromWCharArray(L"\xF547");
      fontawesome_character_map["fa-ruler-vertical"] = QString::fromWCharArray(L"\xF548");
      fontawesome_character_map["fa-school"] = QString::fromWCharArray(L"\xF549");
      fontawesome_character_map["fa-screwdriver"] = QString::fromWCharArray(L"\xF54a");
      fontawesome_character_map["fa-shoe-prints"] = QString::fromWCharArray(L"\xF54b");
      fontawesome_character_map["fa-skull"] = QString::fromWCharArray(L"\xF54c");
      fontawesome_character_map["fa-smoking-ban"] = QString::fromWCharArray(L"\xF54d");
      fontawesome_character_map["fa-store"] = QString::fromWCharArray(L"\xF54e");
      fontawesome_character_map["fa-store-alt"] = QString::fromWCharArray(L"\xF54f");
      fontawesome_character_map["fa-stream"] = QString::fromWCharArray(L"\xF550");
      fontawesome_character_map["fa-stroopwafel"] = QString::fromWCharArray(L"\xF551");
      fontawesome_character_map["fa-toolbox"] = QString::fromWCharArray(L"\xF552");
      fontawesome_character_map["fa-tshirt"] = QString::fromWCharArray(L"\xF553");
      fontawesome_character_map["fa-walking"] = QString::fromWCharArray(L"\xF554");
      fontawesome_character_map["fa-wallet"] = QString::fromWCharArray(L"\xF555");
      fontawesome_character_map["fa-angry"] = QString::fromWCharArray(L"\xF556");
      fontawesome_character_map["fa-archway"] = QString::fromWCharArray(L"\xF557");
      fontawesome_character_map["fa-atlas"] = QString::fromWCharArray(L"\xF558");
      fontawesome_character_map["fa-award"] = QString::fromWCharArray(L"\xF559");
      fontawesome_character_map["fa-backspace"] = QString::fromWCharArray(L"\xF55a");
      fontawesome_character_map["fa-bezier-curve"] = QString::fromWCharArray(L"\xF55b");
      fontawesome_character_map["fa-bong"] = QString::fromWCharArray(L"\xF55c");
      fontawesome_character_map["fa-brush"] = QString::fromWCharArray(L"\xF55d");
      fontawesome_character_map["fa-bus-alt"] = QString::fromWCharArray(L"\xF55e");
      fontawesome_character_map["fa-cannabis"] = QString::fromWCharArray(L"\xF55f");
      fontawesome_character_map["fa-check-double"] = QString::fromWCharArray(L"\xF560");
      fontawesome_character_map["fa-cocktail"] = QString::fromWCharArray(L"\xF561");
      fontawesome_character_map["fa-concierge-bell"] = QString::fromWCharArray(L"\xF562");
      fontawesome_character_map["fa-cookie"] = QString::fromWCharArray(L"\xF563");
      fontawesome_character_map["fa-cookie-bite"] = QString::fromWCharArray(L"\xF564");
      fontawesome_character_map["fa-crop-alt"] = QString::fromWCharArray(L"\xF565");
      fontawesome_character_map["fa-digital-tachograph"] = QString::fromWCharArray(L"\xF566");
      fontawesome_character_map["fa-dizzy"] = QString::fromWCharArray(L"\xF567");
      fontawesome_character_map["fa-drafting-compass"] = QString::fromWCharArray(L"\xF568");
      fontawesome_character_map["fa-drum"] = QString::fromWCharArray(L"\xF569");
      fontawesome_character_map["fa-drum-steelpan"] = QString::fromWCharArray(L"\xF56a");
      fontawesome_character_map["fa-feather-alt"] = QString::fromWCharArray(L"\xF56b");
      fontawesome_character_map["fa-file-contract"] = QString::fromWCharArray(L"\xF56c");
      fontawesome_character_map["fa-file-download"] = QString::fromWCharArray(L"\xF56d");
      fontawesome_character_map["fa-file-export"] = QString::fromWCharArray(L"\xF56e");
      fontawesome_character_map["fa-file-import"] = QString::fromWCharArray(L"\xF56f");
      fontawesome_character_map["fa-file-invoice"] = QString::fromWCharArray(L"\xF570");
      fontawesome_character_map["fa-file-invoice-dollar"] = QString::fromWCharArray(L"\xF571");
      fontawesome_character_map["fa-file-prescription"] = QString::fromWCharArray(L"\xF572");
      fontawesome_character_map["fa-file-signature"] = QString::fromWCharArray(L"\xF573");
      fontawesome_character_map["fa-file-upload"] = QString::fromWCharArray(L"\xF574");
      fontawesome_character_map["fa-fill"] = QString::fromWCharArray(L"\xF575");
      fontawesome_character_map["fa-fill-drip"] = QString::fromWCharArray(L"\xF576");
      fontawesome_character_map["fa-fingerprint"] = QString::fromWCharArray(L"\xF577");
      fontawesome_character_map["fa-fish"] = QString::fromWCharArray(L"\xF578");
      fontawesome_character_map["fa-flushed"] = QString::fromWCharArray(L"\xF579");
      fontawesome_character_map["fa-frown-open"] = QString::fromWCharArray(L"\xF57a");
      fontawesome_character_map["fa-glass-martini-alt"] = QString::fromWCharArray(L"\xF57b");
      fontawesome_character_map["fa-globe-africa"] = QString::fromWCharArray(L"\xF57c");
      fontawesome_character_map["fa-globe-americas"] = QString::fromWCharArray(L"\xF57d");
      fontawesome_character_map["fa-globe-asia"] = QString::fromWCharArray(L"\xF57e");
      fontawesome_character_map["fa-grimace"] = QString::fromWCharArray(L"\xF57f");
      fontawesome_character_map["fa-grin"] = QString::fromWCharArray(L"\xF580");
      fontawesome_character_map["fa-grin-alt"] = QString::fromWCharArray(L"\xF581");
      fontawesome_character_map["fa-grin-beam"] = QString::fromWCharArray(L"\xF582");
      fontawesome_character_map["fa-grin-beam-sweat"] = QString::fromWCharArray(L"\xF583");
      fontawesome_character_map["fa-grin-hearts"] = QString::fromWCharArray(L"\xF584");
      fontawesome_character_map["fa-grin-squint"] = QString::fromWCharArray(L"\xF585");
      fontawesome_character_map["fa-grin-squint-tears"] = QString::fromWCharArray(L"\xF586");
      fontawesome_character_map["fa-grin-stars"] = QString::fromWCharArray(L"\xF587");
      fontawesome_character_map["fa-grin-tears"] = QString::fromWCharArray(L"\xF588");
      fontawesome_character_map["fa-grin-tongue"] = QString::fromWCharArray(L"\xF589");
      fontawesome_character_map["fa-grin-tongue-squint"] = QString::fromWCharArray(L"\xF58a");
      fontawesome_character_map["fa-grin-tongue-wink"] = QString::fromWCharArray(L"\xF58b");
      fontawesome_character_map["fa-grin-wink"] = QString::fromWCharArray(L"\xF58c");
      fontawesome_character_map["fa-grip-horizontal"] = QString::fromWCharArray(L"\xF58d");
      fontawesome_character_map["fa-grip-vertical"] = QString::fromWCharArray(L"\xF58e");
      fontawesome_character_map["fa-headphones-alt"] = QString::fromWCharArray(L"\xF58f");
      fontawesome_character_map["fa-headset"] = QString::fromWCharArray(L"\xF590");
      fontawesome_character_map["fa-highlighter"] = QString::fromWCharArray(L"\xF591");
      fontawesome_character_map["fa-hornbill"] = QString::fromWCharArray(L"\xF592");
      fontawesome_character_map["fa-hot-tub"] = QString::fromWCharArray(L"\xF593");
      fontawesome_character_map["fa-hotel"] = QString::fromWCharArray(L"\xF594");
      fontawesome_character_map["fa-joint"] = QString::fromWCharArray(L"\xF595");
      fontawesome_character_map["fa-kiss"] = QString::fromWCharArray(L"\xF596");
      fontawesome_character_map["fa-kiss-beam"] = QString::fromWCharArray(L"\xF597");
      fontawesome_character_map["fa-kiss-wink-heart"] = QString::fromWCharArray(L"\xF598");
      fontawesome_character_map["fa-laugh"] = QString::fromWCharArray(L"\xF599");
      fontawesome_character_map["fa-laugh-beam"] = QString::fromWCharArray(L"\xF59a");
      fontawesome_character_map["fa-laugh-squint"] = QString::fromWCharArray(L"\xF59b");
      fontawesome_character_map["fa-laugh-wink"] = QString::fromWCharArray(L"\xF59c");
      fontawesome_character_map["fa-luggage-cart"] = QString::fromWCharArray(L"\xF59d");
      fontawesome_character_map["fa-mailchimp"] = QString::fromWCharArray(L"\xF59e");
      fontawesome_character_map["fa-map-marked"] = QString::fromWCharArray(L"\xF59f");
      fontawesome_character_map["fa-map-marked-alt"] = QString::fromWCharArray(L"\xF5a0");
      fontawesome_character_map["fa-marker"] = QString::fromWCharArray(L"\xF5a1");
      fontawesome_character_map["fa-medal"] = QString::fromWCharArray(L"\xF5a2");
      fontawesome_character_map["fa-megaport"] = QString::fromWCharArray(L"\xF5a3");
      fontawesome_character_map["fa-meh-blank"] = QString::fromWCharArray(L"\xF5a4");
      fontawesome_character_map["fa-meh-rolling-eyes"] = QString::fromWCharArray(L"\xF5a5");
      fontawesome_character_map["fa-monument"] = QString::fromWCharArray(L"\xF5a6");
      fontawesome_character_map["fa-mortar-pestle"] = QString::fromWCharArray(L"\xF5a7");
      fontawesome_character_map["fa-nimblr"] = QString::fromWCharArray(L"\xF5a8");
      fontawesome_character_map["fa-paint-roller"] = QString::fromWCharArray(L"\xF5aa");
      fontawesome_character_map["fa-passport"] = QString::fromWCharArray(L"\xF5ab");
      fontawesome_character_map["fa-pen-fancy"] = QString::fromWCharArray(L"\xF5ac");
      fontawesome_character_map["fa-pen-nib"] = QString::fromWCharArray(L"\xF5ad");
      fontawesome_character_map["fa-pencil-ruler"] = QString::fromWCharArray(L"\xF5ae");
      fontawesome_character_map["fa-plane-arrival"] = QString::fromWCharArray(L"\xF5af");
      fontawesome_character_map["fa-plane-departure"] = QString::fromWCharArray(L"\xF5b0");
      fontawesome_character_map["fa-prescription"] = QString::fromWCharArray(L"\xF5b1");
      fontawesome_character_map["fa-rev"] = QString::fromWCharArray(L"\xF5b2");
      fontawesome_character_map["fa-sad-cry"] = QString::fromWCharArray(L"\xF5b3");
      fontawesome_character_map["fa-sad-tear"] = QString::fromWCharArray(L"\xF5b4");
      fontawesome_character_map["fa-shopware"] = QString::fromWCharArray(L"\xF5b5");
      fontawesome_character_map["fa-shuttle-van"] = QString::fromWCharArray(L"\xF5b6");
      fontawesome_character_map["fa-signature"] = QString::fromWCharArray(L"\xF5b7");
      fontawesome_character_map["fa-smile-beam"] = QString::fromWCharArray(L"\xF5b8");
      fontawesome_character_map["fa-solar-panel"] = QString::fromWCharArray(L"\xF5ba");
      fontawesome_character_map["fa-spa"] = QString::fromWCharArray(L"\xF5bb");
      fontawesome_character_map["fa-splotch"] = QString::fromWCharArray(L"\xF5bc");
      fontawesome_character_map["fa-spray-can"] = QString::fromWCharArray(L"\xF5bd");
      fontawesome_character_map["fa-squarespace"] = QString::fromWCharArray(L"\xF5be");
      fontawesome_character_map["fa-stamp"] = QString::fromWCharArray(L"\xF5bf");
      fontawesome_character_map["fa-star-half-alt"] = QString::fromWCharArray(L"\xF5c0");
      fontawesome_character_map["fa-suitcase-rolling"] = QString::fromWCharArray(L"\xF5c1");
      fontawesome_character_map["fa-surprise"] = QString::fromWCharArray(L"\xF5c2");
      fontawesome_character_map["fa-swatchbook"] = QString::fromWCharArray(L"\xF5c3");
      fontawesome_character_map["fa-swimmer"] = QString::fromWCharArray(L"\xF5c4");
      fontawesome_character_map["fa-swimming-pool"] = QString::fromWCharArray(L"\xF5c5");
      fontawesome_character_map["fa-themeco"] = QString::fromWCharArray(L"\xF5c6");
      fontawesome_character_map["fa-tint-slash"] = QString::fromWCharArray(L"\xF5c7");
      fontawesome_character_map["fa-tired"] = QString::fromWCharArray(L"\xF5c8");
      fontawesome_character_map["fa-tooth"] = QString::fromWCharArray(L"\xF5c9");
      fontawesome_character_map["fa-umbrella-beach"] = QString::fromWCharArray(L"\xF5ca");
      fontawesome_character_map["fa-vector-square"] = QString::fromWCharArray(L"\xF5cb");
      fontawesome_character_map["fa-weebly"] = QString::fromWCharArray(L"\xF5cc");
      fontawesome_character_map["fa-weight-hanging"] = QString::fromWCharArray(L"\xF5cd");
      fontawesome_character_map["fa-wine-glass-alt"] = QString::fromWCharArray(L"\xF5ce");
      fontawesome_character_map["fa-wix"] = QString::fromWCharArray(L"\xF5cf");
      fontawesome_character_map["fa-air-freshener"] = QString::fromWCharArray(L"\xF5d0");
      fontawesome_character_map["fa-apple-alt"] = QString::fromWCharArray(L"\xF5d1");
      fontawesome_character_map["fa-atom"] = QString::fromWCharArray(L"\xF5d2");
      fontawesome_character_map["fa-bone"] = QString::fromWCharArray(L"\xF5d7");
      fontawesome_character_map["fa-book-reader"] = QString::fromWCharArray(L"\xF5da");
      fontawesome_character_map["fa-brain"] = QString::fromWCharArray(L"\xF5dc");
      fontawesome_character_map["fa-car-alt"] = QString::fromWCharArray(L"\xF5de");
      fontawesome_character_map["fa-car-battery"] = QString::fromWCharArray(L"\xF5df");
      fontawesome_character_map["fa-car-crash"] = QString::fromWCharArray(L"\xF5e1");
      fontawesome_character_map["fa-car-side"] = QString::fromWCharArray(L"\xF5e4");
      fontawesome_character_map["fa-charging-station"] = QString::fromWCharArray(L"\xF5e7");
      fontawesome_character_map["fa-directions"] = QString::fromWCharArray(L"\xF5eb");
      fontawesome_character_map["fa-draw-polygon"] = QString::fromWCharArray(L"\xF5ee");
      fontawesome_character_map["fa-ello"] = QString::fromWCharArray(L"\xF5f1");
      fontawesome_character_map["fa-hackerrank"] = QString::fromWCharArray(L"\xF5f7");
      fontawesome_character_map["fa-kaggle"] = QString::fromWCharArray(L"\xF5fa");
      fontawesome_character_map["fa-laptop-code"] = QString::fromWCharArray(L"\xF5fc");
      fontawesome_character_map["fa-layer-group"] = QString::fromWCharArray(L"\xF5fd");
      fontawesome_character_map["fa-markdown"] = QString::fromWCharArray(L"\xF60f");
      fontawesome_character_map["fa-microscope"] = QString::fromWCharArray(L"\xF610");
      fontawesome_character_map["fa-neos"] = QString::fromWCharArray(L"\xF612");
      fontawesome_character_map["fa-oil-can"] = QString::fromWCharArray(L"\xF613");
      fontawesome_character_map["fa-poop"] = QString::fromWCharArray(L"\xF619");
      fontawesome_character_map["fa-shapes"] = QString::fromWCharArray(L"\xF61f");
      fontawesome_character_map["fa-star-of-life"] = QString::fromWCharArray(L"\xF621");
      fontawesome_character_map["fa-teeth"] = QString::fromWCharArray(L"\xF62e");
      fontawesome_character_map["fa-teeth-open"] = QString::fromWCharArray(L"\xF62f");
      fontawesome_character_map["fa-theater-masks"] = QString::fromWCharArray(L"\xF630");
      fontawesome_character_map["fa-traffic-light"] = QString::fromWCharArray(L"\xF637");
      fontawesome_character_map["fa-truck-monster"] = QString::fromWCharArray(L"\xF63b");
      fontawesome_character_map["fa-truck-pickup"] = QString::fromWCharArray(L"\xF63c");
      fontawesome_character_map["fa-zhihu"] = QString::fromWCharArray(L"\xF63f");
      fontawesome_character_map["fa-ad"] = QString::fromWCharArray(L"\xF641");
      fontawesome_character_map["fa-alipay"] = QString::fromWCharArray(L"\xF642");
      fontawesome_character_map["fa-ankh"] = QString::fromWCharArray(L"\xF644");
      fontawesome_character_map["fa-bible"] = QString::fromWCharArray(L"\xF647");
      fontawesome_character_map["fa-business-time"] = QString::fromWCharArray(L"\xF64a");
      fontawesome_character_map["fa-city"] = QString::fromWCharArray(L"\xF64f");
      fontawesome_character_map["fa-comment-dollar"] = QString::fromWCharArray(L"\xF651");
      fontawesome_character_map["fa-comments-dollar"] = QString::fromWCharArray(L"\xF653");
      fontawesome_character_map["fa-cross"] = QString::fromWCharArray(L"\xF654");
      fontawesome_character_map["fa-dharmachakra"] = QString::fromWCharArray(L"\xF655");
      fontawesome_character_map["fa-envelope-open-text"] = QString::fromWCharArray(L"\xF658");
      fontawesome_character_map["fa-folder-minus"] = QString::fromWCharArray(L"\xF65d");
      fontawesome_character_map["fa-folder-plus"] = QString::fromWCharArray(L"\xF65e");
      fontawesome_character_map["fa-funnel-dollar"] = QString::fromWCharArray(L"\xF662");
      fontawesome_character_map["fa-gopuram"] = QString::fromWCharArray(L"\xF664");
      fontawesome_character_map["fa-hamsa"] = QString::fromWCharArray(L"\xF665");
      fontawesome_character_map["fa-bahai"] = QString::fromWCharArray(L"\xF666");
      fontawesome_character_map["fa-jedi"] = QString::fromWCharArray(L"\xF669");
      fontawesome_character_map["fa-journal-whills"] = QString::fromWCharArray(L"\xF66a");
      fontawesome_character_map["fa-kaaba"] = QString::fromWCharArray(L"\xF66b");
      fontawesome_character_map["fa-khanda"] = QString::fromWCharArray(L"\xF66d");
      fontawesome_character_map["fa-landmark"] = QString::fromWCharArray(L"\xF66f");
      fontawesome_character_map["fa-mail-bulk"] = QString::fromWCharArray(L"\xF674");
      fontawesome_character_map["fa-menorah"] = QString::fromWCharArray(L"\xF676");
      fontawesome_character_map["fa-mosque"] = QString::fromWCharArray(L"\xF678");
      fontawesome_character_map["fa-om"] = QString::fromWCharArray(L"\xF679");
      fontawesome_character_map["fa-pastafarianism"] = QString::fromWCharArray(L"\xF67b");
      fontawesome_character_map["fa-peace"] = QString::fromWCharArray(L"\xF67c");
      fontawesome_character_map["fa-place-of-worship"] = QString::fromWCharArray(L"\xF67f");
      fontawesome_character_map["fa-poll"] = QString::fromWCharArray(L"\xF681");
      fontawesome_character_map["fa-poll-h"] = QString::fromWCharArray(L"\xF682");
      fontawesome_character_map["fa-pray"] = QString::fromWCharArray(L"\xF683");
      fontawesome_character_map["fa-praying-hands"] = QString::fromWCharArray(L"\xF684");
      fontawesome_character_map["fa-quran"] = QString::fromWCharArray(L"\xF687");
      fontawesome_character_map["fa-search-dollar"] = QString::fromWCharArray(L"\xF688");
      fontawesome_character_map["fa-search-location"] = QString::fromWCharArray(L"\xF689");
      fontawesome_character_map["fa-socks"] = QString::fromWCharArray(L"\xF696");
      fontawesome_character_map["fa-square-root-alt"] = QString::fromWCharArray(L"\xF698");
      fontawesome_character_map["fa-star-and-crescent"] = QString::fromWCharArray(L"\xF699");
      fontawesome_character_map["fa-star-of-david"] = QString::fromWCharArray(L"\xF69a");
      fontawesome_character_map["fa-synagogue"] = QString::fromWCharArray(L"\xF69b");
      fontawesome_character_map["fa-the-red-yeti"] = QString::fromWCharArray(L"\xF69d");
      fontawesome_character_map["fa-torah"] = QString::fromWCharArray(L"\xF6a0");
      fontawesome_character_map["fa-torii-gate"] = QString::fromWCharArray(L"\xF6a1");
      fontawesome_character_map["fa-vihara"] = QString::fromWCharArray(L"\xF6a7");
      fontawesome_character_map["fa-volume-mute"] = QString::fromWCharArray(L"\xF6a9");
      fontawesome_character_map["fa-yin-yang"] = QString::fromWCharArray(L"\xF6ad");
      fontawesome_character_map["fa-acquisitions-incorporated"] = QString::fromWCharArray(L"\xF6af");
      fontawesome_character_map["fa-blender-phone"] = QString::fromWCharArray(L"\xF6b6");
      fontawesome_character_map["fa-book-dead"] = QString::fromWCharArray(L"\xF6b7");
      fontawesome_character_map["fa-campground"] = QString::fromWCharArray(L"\xF6bb");
      fontawesome_character_map["fa-cat"] = QString::fromWCharArray(L"\xF6be");
      fontawesome_character_map["fa-chair"] = QString::fromWCharArray(L"\xF6c0");
      fontawesome_character_map["fa-cloud-moon"] = QString::fromWCharArray(L"\xF6c3");
      fontawesome_character_map["fa-cloud-sun"] = QString::fromWCharArray(L"\xF6c4");
      fontawesome_character_map["fa-critical-role"] = QString::fromWCharArray(L"\xF6c9");
      fontawesome_character_map["fa-d-and-d-beyond"] = QString::fromWCharArray(L"\xF6ca");
      fontawesome_character_map["fa-dev"] = QString::fromWCharArray(L"\xF6cc");
      fontawesome_character_map["fa-dice-d20"] = QString::fromWCharArray(L"\xF6cf");
      fontawesome_character_map["fa-dice-d6"] = QString::fromWCharArray(L"\xF6d1");
      fontawesome_character_map["fa-dog"] = QString::fromWCharArray(L"\xF6d3");
      fontawesome_character_map["fa-dragon"] = QString::fromWCharArray(L"\xF6d5");
      fontawesome_character_map["fa-drumstick-bite"] = QString::fromWCharArray(L"\xF6d7");
      fontawesome_character_map["fa-dungeon"] = QString::fromWCharArray(L"\xF6d9");
      fontawesome_character_map["fa-fantasy-flight-games"] = QString::fromWCharArray(L"\xF6dc");
      fontawesome_character_map["fa-file-csv"] = QString::fromWCharArray(L"\xF6dd");
      fontawesome_character_map["fa-fist-raised"] = QString::fromWCharArray(L"\xF6de");
      fontawesome_character_map["fa-ghost"] = QString::fromWCharArray(L"\xF6e2");
      fontawesome_character_map["fa-hammer"] = QString::fromWCharArray(L"\xF6e3");
      fontawesome_character_map["fa-hanukiah"] = QString::fromWCharArray(L"\xF6e6");
      fontawesome_character_map["fa-hat-wizard"] = QString::fromWCharArray(L"\xF6e8");
      fontawesome_character_map["fa-hiking"] = QString::fromWCharArray(L"\xF6ec");
      fontawesome_character_map["fa-hippo"] = QString::fromWCharArray(L"\xF6ed");
      fontawesome_character_map["fa-horse"] = QString::fromWCharArray(L"\xF6f0");
      fontawesome_character_map["fa-house-damage"] = QString::fromWCharArray(L"\xF6f1");
      fontawesome_character_map["fa-hryvnia"] = QString::fromWCharArray(L"\xF6f2");
      fontawesome_character_map["fa-mask"] = QString::fromWCharArray(L"\xF6fa");
      fontawesome_character_map["fa-mountain"] = QString::fromWCharArray(L"\xF6fc");
      fontawesome_character_map["fa-network-wired"] = QString::fromWCharArray(L"\xF6ff");
      fontawesome_character_map["fa-otter"] = QString::fromWCharArray(L"\xF700");
      fontawesome_character_map["fa-penny-arcade"] = QString::fromWCharArray(L"\xF704");
      fontawesome_character_map["fa-ring"] = QString::fromWCharArray(L"\xF70b");
      fontawesome_character_map["fa-running"] = QString::fromWCharArray(L"\xF70c");
      fontawesome_character_map["fa-scroll"] = QString::fromWCharArray(L"\xF70e");
      fontawesome_character_map["fa-skull-crossbones"] = QString::fromWCharArray(L"\xF714");
      fontawesome_character_map["fa-slash"] = QString::fromWCharArray(L"\xF715");
      fontawesome_character_map["fa-spider"] = QString::fromWCharArray(L"\xF717");
      fontawesome_character_map["fa-toilet-paper"] = QString::fromWCharArray(L"\xF71e");
      fontawesome_character_map["fa-tractor"] = QString::fromWCharArray(L"\xF722");
      fontawesome_character_map["fa-user-injured"] = QString::fromWCharArray(L"\xF728");
      fontawesome_character_map["fa-vr-cardboard"] = QString::fromWCharArray(L"\xF729");
      fontawesome_character_map["fa-wind"] = QString::fromWCharArray(L"\xF72e");
      fontawesome_character_map["fa-wine-bottle"] = QString::fromWCharArray(L"\xF72f");
      fontawesome_character_map["fa-wizards-of-the-coast"] = QString::fromWCharArray(L"\xF730");
      fontawesome_character_map["fa-think-peaks"] = QString::fromWCharArray(L"\xF731");
      fontawesome_character_map["fa-cloud-meatball"] = QString::fromWCharArray(L"\xF73b");
      fontawesome_character_map["fa-cloud-moon-rain"] = QString::fromWCharArray(L"\xF73c");
      fontawesome_character_map["fa-cloud-rain"] = QString::fromWCharArray(L"\xF73d");
      fontawesome_character_map["fa-cloud-showers-heavy"] = QString::fromWCharArray(L"\xF740");
      fontawesome_character_map["fa-cloud-sun-rain"] = QString::fromWCharArray(L"\xF743");
      fontawesome_character_map["fa-democrat"] = QString::fromWCharArray(L"\xF747");
      fontawesome_character_map["fa-flag-usa"] = QString::fromWCharArray(L"\xF74d");
      fontawesome_character_map["fa-meteor"] = QString::fromWCharArray(L"\xF753");
      fontawesome_character_map["fa-person-booth"] = QString::fromWCharArray(L"\xF756");
      fontawesome_character_map["fa-poo-storm"] = QString::fromWCharArray(L"\xF75a");
      fontawesome_character_map["fa-rainbow"] = QString::fromWCharArray(L"\xF75b");
      fontawesome_character_map["fa-reacteurope"] = QString::fromWCharArray(L"\xF75d");
      fontawesome_character_map["fa-republican"] = QString::fromWCharArray(L"\xF75e");
      fontawesome_character_map["fa-smog"] = QString::fromWCharArray(L"\xF75f");
      fontawesome_character_map["fa-temperature-high"] = QString::fromWCharArray(L"\xF769");
      fontawesome_character_map["fa-temperature-low"] = QString::fromWCharArray(L"\xF76b");
      fontawesome_character_map["fa-vote-yea"] = QString::fromWCharArray(L"\xF772");
      fontawesome_character_map["fa-water"] = QString::fromWCharArray(L"\xF773");
      fontawesome_character_map["fa-adobe"] = QString::fromWCharArray(L"\xF778");
      fontawesome_character_map["fa-artstation"] = QString::fromWCharArray(L"\xF77a");
      fontawesome_character_map["fa-atlassian"] = QString::fromWCharArray(L"\xF77b");
      fontawesome_character_map["fa-baby"] = QString::fromWCharArray(L"\xF77c");
      fontawesome_character_map["fa-baby-carriage"] = QString::fromWCharArray(L"\xF77d");
      fontawesome_character_map["fa-biohazard"] = QString::fromWCharArray(L"\xF780");
      fontawesome_character_map["fa-blog"] = QString::fromWCharArray(L"\xF781");
      fontawesome_character_map["fa-calendar-day"] = QString::fromWCharArray(L"\xF783");
      fontawesome_character_map["fa-calendar-week"] = QString::fromWCharArray(L"\xF784");
      fontawesome_character_map["fa-canadian-maple-leaf"] = QString::fromWCharArray(L"\xF785");
      fontawesome_character_map["fa-candy-cane"] = QString::fromWCharArray(L"\xF786");
      fontawesome_character_map["fa-carrot"] = QString::fromWCharArray(L"\xF787");
      fontawesome_character_map["fa-cash-register"] = QString::fromWCharArray(L"\xF788");
      fontawesome_character_map["fa-centos"] = QString::fromWCharArray(L"\xF789");
      fontawesome_character_map["fa-compress-arrows-alt"] = QString::fromWCharArray(L"\xF78c");
      fontawesome_character_map["fa-confluence"] = QString::fromWCharArray(L"\xF78d");
      fontawesome_character_map["fa-dhl"] = QString::fromWCharArray(L"\xF790");
      fontawesome_character_map["fa-diaspora"] = QString::fromWCharArray(L"\xF791");
      fontawesome_character_map["fa-dumpster"] = QString::fromWCharArray(L"\xF793");
      fontawesome_character_map["fa-dumpster-fire"] = QString::fromWCharArray(L"\xF794");
      fontawesome_character_map["fa-ethernet"] = QString::fromWCharArray(L"\xF796");
      fontawesome_character_map["fa-fedex"] = QString::fromWCharArray(L"\xF797");
      fontawesome_character_map["fa-fedora"] = QString::fromWCharArray(L"\xF798");
      fontawesome_character_map["fa-figma"] = QString::fromWCharArray(L"\xF799");
      fontawesome_character_map["fa-gifts"] = QString::fromWCharArray(L"\xF79c");
      fontawesome_character_map["fa-glass-cheers"] = QString::fromWCharArray(L"\xF79f");
      fontawesome_character_map["fa-glass-whiskey"] = QString::fromWCharArray(L"\xF7a0");
      fontawesome_character_map["fa-globe-europe"] = QString::fromWCharArray(L"\xF7a2");
      fontawesome_character_map["fa-grip-lines"] = QString::fromWCharArray(L"\xF7a4");
      fontawesome_character_map["fa-grip-lines-vertical"] = QString::fromWCharArray(L"\xF7a5");
      fontawesome_character_map["fa-guitar"] = QString::fromWCharArray(L"\xF7a6");
      fontawesome_character_map["fa-heart-broken"] = QString::fromWCharArray(L"\xF7a9");
      fontawesome_character_map["fa-holly-berry"] = QString::fromWCharArray(L"\xF7aa");
      fontawesome_character_map["fa-horse-head"] = QString::fromWCharArray(L"\xF7ab");
      fontawesome_character_map["fa-icicles"] = QString::fromWCharArray(L"\xF7ad");
      fontawesome_character_map["fa-igloo"] = QString::fromWCharArray(L"\xF7ae");
      fontawesome_character_map["fa-intercom"] = QString::fromWCharArray(L"\xF7af");
      fontawesome_character_map["fa-invision"] = QString::fromWCharArray(L"\xF7b0");
      fontawesome_character_map["fa-jira"] = QString::fromWCharArray(L"\xF7b1");
      fontawesome_character_map["fa-mendeley"] = QString::fromWCharArray(L"\xF7b3");
      fontawesome_character_map["fa-mitten"] = QString::fromWCharArray(L"\xF7b5");
      fontawesome_character_map["fa-mug-hot"] = QString::fromWCharArray(L"\xF7b6");
      fontawesome_character_map["fa-radiation"] = QString::fromWCharArray(L"\xF7b9");
      fontawesome_character_map["fa-radiation-alt"] = QString::fromWCharArray(L"\xF7ba");
      fontawesome_character_map["fa-raspberry-pi"] = QString::fromWCharArray(L"\xF7bb");
      fontawesome_character_map["fa-redhat"] = QString::fromWCharArray(L"\xF7bc");
      fontawesome_character_map["fa-restroom"] = QString::fromWCharArray(L"\xF7bd");
      fontawesome_character_map["fa-satellite"] = QString::fromWCharArray(L"\xF7bf");
      fontawesome_character_map["fa-satellite-dish"] = QString::fromWCharArray(L"\xF7c0");
      fontawesome_character_map["fa-sd-card"] = QString::fromWCharArray(L"\xF7c2");
      fontawesome_character_map["fa-sim-card"] = QString::fromWCharArray(L"\xF7c4");
      fontawesome_character_map["fa-skating"] = QString::fromWCharArray(L"\xF7c5");
      fontawesome_character_map["fa-sketch"] = QString::fromWCharArray(L"\xF7c6");
      fontawesome_character_map["fa-skiing"] = QString::fromWCharArray(L"\xF7c9");
      fontawesome_character_map["fa-skiing-nordic"] = QString::fromWCharArray(L"\xF7ca");
      fontawesome_character_map["fa-sleigh"] = QString::fromWCharArray(L"\xF7cc");
      fontawesome_character_map["fa-sms"] = QString::fromWCharArray(L"\xF7cd");
      fontawesome_character_map["fa-snowboarding"] = QString::fromWCharArray(L"\xF7ce");
      fontawesome_character_map["fa-snowman"] = QString::fromWCharArray(L"\xF7d0");
      fontawesome_character_map["fa-snowplow"] = QString::fromWCharArray(L"\xF7d2");
      fontawesome_character_map["fa-sourcetree"] = QString::fromWCharArray(L"\xF7d3");
      fontawesome_character_map["fa-suse"] = QString::fromWCharArray(L"\xF7d6");
      fontawesome_character_map["fa-tenge"] = QString::fromWCharArray(L"\xF7d7");
      fontawesome_character_map["fa-toilet"] = QString::fromWCharArray(L"\xF7d8");
      fontawesome_character_map["fa-tools"] = QString::fromWCharArray(L"\xF7d9");
      fontawesome_character_map["fa-tram"] = QString::fromWCharArray(L"\xF7da");
      fontawesome_character_map["fa-ubuntu"] = QString::fromWCharArray(L"\xF7df");
      fontawesome_character_map["fa-ups"] = QString::fromWCharArray(L"\xF7e0");
      fontawesome_character_map["fa-usps"] = QString::fromWCharArray(L"\xF7e1");
      fontawesome_character_map["fa-yarn"] = QString::fromWCharArray(L"\xF7e3");
      fontawesome_character_map["fa-fire-alt"] = QString::fromWCharArray(L"\xF7e4");
      fontawesome_character_map["fa-bacon"] = QString::fromWCharArray(L"\xF7e5");
      fontawesome_character_map["fa-book-medical"] = QString::fromWCharArray(L"\xF7e6");
      fontawesome_character_map["fa-bread-slice"] = QString::fromWCharArray(L"\xF7ec");
      fontawesome_character_map["fa-cheese"] = QString::fromWCharArray(L"\xF7ef");
      fontawesome_character_map["fa-clinic-medical"] = QString::fromWCharArray(L"\xF7f2");
      fontawesome_character_map["fa-comment-medical"] = QString::fromWCharArray(L"\xF7f5");
      fontawesome_character_map["fa-crutch"] = QString::fromWCharArray(L"\xF7f7");
      fontawesome_character_map["fa-egg"] = QString::fromWCharArray(L"\xF7fb");
      fontawesome_character_map["fa-hamburger"] = QString::fromWCharArray(L"\xF805");
      fontawesome_character_map["fa-hand-middle-finger"] = QString::fromWCharArray(L"\xF806");
      fontawesome_character_map["fa-hard-hat"] = QString::fromWCharArray(L"\xF807");
      fontawesome_character_map["fa-hotdog"] = QString::fromWCharArray(L"\xF80f");
      fontawesome_character_map["fa-ice-cream"] = QString::fromWCharArray(L"\xF810");
      fontawesome_character_map["fa-laptop-medical"] = QString::fromWCharArray(L"\xF812");
      fontawesome_character_map["fa-pager"] = QString::fromWCharArray(L"\xF815");
      fontawesome_character_map["fa-pepper-hot"] = QString::fromWCharArray(L"\xF816");
      fontawesome_character_map["fa-pizza-slice"] = QString::fromWCharArray(L"\xF818");
      fontawesome_character_map["fa-trash-restore"] = QString::fromWCharArray(L"\xF829");
      fontawesome_character_map["fa-trash-restore-alt"] = QString::fromWCharArray(L"\xF82a");
      fontawesome_character_map["fa-user-nurse"] = QString::fromWCharArray(L"\xF82f");
      fontawesome_character_map["fa-airbnb"] = QString::fromWCharArray(L"\xF834");
      fontawesome_character_map["fa-battle-net"] = QString::fromWCharArray(L"\xF835");
      fontawesome_character_map["fa-bootstrap"] = QString::fromWCharArray(L"\xF836");
      fontawesome_character_map["fa-buffer"] = QString::fromWCharArray(L"\xF837");
      fontawesome_character_map["fa-chromecast"] = QString::fromWCharArray(L"\xF838");
      fontawesome_character_map["fa-evernote"] = QString::fromWCharArray(L"\xF839");
      fontawesome_character_map["fa-itch-io"] = QString::fromWCharArray(L"\xF83a");
      fontawesome_character_map["fa-salesforce"] = QString::fromWCharArray(L"\xF83b");
      fontawesome_character_map["fa-speaker-deck"] = QString::fromWCharArray(L"\xF83c");
      fontawesome_character_map["fa-symfony"] = QString::fromWCharArray(L"\xF83d");
      fontawesome_character_map["fa-wave-square"] = QString::fromWCharArray(L"\xF83e");
      fontawesome_character_map["fa-waze"] = QString::fromWCharArray(L"\xF83f");
      fontawesome_character_map["fa-yammer"] = QString::fromWCharArray(L"\xF840");
      fontawesome_character_map["fa-git-alt"] = QString::fromWCharArray(L"\xF841");
      fontawesome_character_map["fa-stackpath"] = QString::fromWCharArray(L"\xF842");
      fontawesome_character_map["fa-biking"] = QString::fromWCharArray(L"\xF84a");
      fontawesome_character_map["fa-border-all"] = QString::fromWCharArray(L"\xF84c");
      fontawesome_character_map["fa-border-none"] = QString::fromWCharArray(L"\xF850");
      fontawesome_character_map["fa-border-style"] = QString::fromWCharArray(L"\xF853");
      fontawesome_character_map["fa-fan"] = QString::fromWCharArray(L"\xF863");
      fontawesome_character_map["fa-icons"] = QString::fromWCharArray(L"\xF86d");
      fontawesome_character_map["fa-phone-alt"] = QString::fromWCharArray(L"\xF879");
      fontawesome_character_map["fa-phone-square-alt"] = QString::fromWCharArray(L"\xF87b");
      fontawesome_character_map["fa-photo-video"] = QString::fromWCharArray(L"\xF87c");
      fontawesome_character_map["fa-remove-format"] = QString::fromWCharArray(L"\xF87d");
      fontawesome_character_map["fa-sort-alpha-down-alt"] = QString::fromWCharArray(L"\xF881");
      fontawesome_character_map["fa-sort-alpha-up-alt"] = QString::fromWCharArray(L"\xF882");
      fontawesome_character_map["fa-sort-amount-down-alt"] = QString::fromWCharArray(L"\xF884");
      fontawesome_character_map["fa-sort-amount-up-alt"] = QString::fromWCharArray(L"\xF885");
      fontawesome_character_map["fa-sort-numeric-down-alt"] = QString::fromWCharArray(L"\xF886");
      fontawesome_character_map["fa-sort-numeric-up-alt"] = QString::fromWCharArray(L"\xF887");
      fontawesome_character_map["fa-spell-check"] = QString::fromWCharArray(L"\xF891");
      fontawesome_character_map["fa-voicemail"] = QString::fromWCharArray(L"\xF897");
      fontawesome_character_map["fa-cotton-bureau"] = QString::fromWCharArray(L"\xF89e");
      fontawesome_character_map["fa-buy-n-large"] = QString::fromWCharArray(L"\xF8a6");
      fontawesome_character_map["fa-hat-cowboy"] = QString::fromWCharArray(L"\xF8c0");
      fontawesome_character_map["fa-hat-cowboy-side"] = QString::fromWCharArray(L"\xF8c1");
      fontawesome_character_map["fa-mdb"] = QString::fromWCharArray(L"\xF8ca");
      fontawesome_character_map["fa-mouse"] = QString::fromWCharArray(L"\xF8cc");
      fontawesome_character_map["fa-orcid"] = QString::fromWCharArray(L"\xF8d2");
      fontawesome_character_map["fa-record-vinyl"] = QString::fromWCharArray(L"\xF8d9");
      fontawesome_character_map["fa-swift"] = QString::fromWCharArray(L"\xF8e1");
      fontawesome_character_map["fa-umbraco"] = QString::fromWCharArray(L"\xF8e8");
      fontawesome_character_map["fa-caravan"] = QString::fromWCharArray(L"\xF8ff");
      fontawesome_character_map["fa-firefox-browser"] = QString::fromWCharArray(L"\xF907");
      fontawesome_character_map["fa-ideal"] = QString::fromWCharArray(L"\xF913");
      fontawesome_character_map["fa-microblog"] = QString::fromWCharArray(L"\xF91a");
      fontawesome_character_map["fa-pied-piper-square"] = QString::fromWCharArray(L"\xF91e");
      fontawesome_character_map["fa-trailer"] = QString::fromWCharArray(L"\xF941");
      fontawesome_character_map["fa-unity"] = QString::fromWCharArray(L"\xF949");

      /* For backwards compatibility */
      fontawesome_character_map["fa-glass"] = QString::fromWCharArray(L"\xF000");
      fontawesome_character_map["fa-remove"] = QString::fromWCharArray(L"\xF00d");
      fontawesome_character_map["fa-close"] = QString::fromWCharArray(L"\xF00d");
      fontawesome_character_map["fa-gear"] = QString::fromWCharArray(L"\xF013");
      fontawesome_character_map["fa-clock-o"] = QString::fromWCharArray(L"\xF017");
      fontawesome_character_map["fa-rotate-right"] = QString::fromWCharArray(L"\xF01e");
      fontawesome_character_map["fa-repeat"] = QString::fromWCharArray(L"\xF01e");
      fontawesome_character_map["fa-refresh"] = QString::fromWCharArray(L"\xF021");
      fontawesome_character_map["fa-dedent"] = QString::fromWCharArray(L"\xF03b");
      fontawesome_character_map["fa-video-camera"] = QString::fromWCharArray(L"\xF03d");
      fontawesome_character_map["fa-photo"] = QString::fromWCharArray(L"\xF03e");
      fontawesome_character_map["fa-picture-o"] = QString::fromWCharArray(L"\xF03e");
      fontawesome_character_map["fa-pencil-square-o"] = QString::fromWCharArray(L"\xF044");
      fontawesome_character_map["fa-mail-forward"] = QString::fromWCharArray(L"\xF064");
      fontawesome_character_map["fa-warning"] = QString::fromWCharArray(L"\xF071");
      fontawesome_character_map["fa-calendar"] = QString::fromWCharArray(L"\xF073");
      fontawesome_character_map["fa-bar-chart-o"] = QString::fromWCharArray(L"\xF080");
      fontawesome_character_map["fa-bar-chart"] = QString::fromWCharArray(L"\xF080");
      fontawesome_character_map["fa-gears"] = QString::fromWCharArray(L"\xF085");
      fontawesome_character_map["fa-linkedin-square"] = QString::fromWCharArray(L"\xF08c");
      fontawesome_character_map["fa-thumb-tack"] = QString::fromWCharArray(L"\xF08d");
      fontawesome_character_map["fa-lemon-o"] = QString::fromWCharArray(L"\xF094");
      fontawesome_character_map["fa-hdd-o"] = QString::fromWCharArray(L"\xF0a0");
      fontawesome_character_map["fa-bell"] = QString::fromWCharArray(L"\xF0f3");
      fontawesome_character_map["fa-hand-o-right"] = QString::fromWCharArray(L"\xF0a4");
      fontawesome_character_map["fa-hand-o-left"] = QString::fromWCharArray(L"\xF0a5");
      fontawesome_character_map["fa-hand-o-up"] = QString::fromWCharArray(L"\xF0a6");
      fontawesome_character_map["fa-hand-o-down"] = QString::fromWCharArray(L"\xF0a7");
      fontawesome_character_map["fa-group"] = QString::fromWCharArray(L"\xF0c0");
      fontawesome_character_map["fa-chain"] = QString::fromWCharArray(L"\xF0c1");
      fontawesome_character_map["fa-scissors"] = QString::fromWCharArray(L"\xF0c4");
      fontawesome_character_map["fa-files-o"] = QString::fromWCharArray(L"\xF0c5");
      fontawesome_character_map["fa-floppy-o"] = QString::fromWCharArray(L"\xF0c7");
      fontawesome_character_map["fa-navicon"] = QString::fromWCharArray(L"\xF0c9");
      fontawesome_character_map["fa-reorder"] = QString::fromWCharArray(L"\xF0c9");
      fontawesome_character_map["fa-google-plus"] = QString::fromWCharArray(L"\xF0d5");
      fontawesome_character_map["fa-money"] = QString::fromWCharArray(L"\xF0d6");
      fontawesome_character_map["fa-unsorted"] = QString::fromWCharArray(L"\xF0dc");
      fontawesome_character_map["fa-sort-desc"] = QString::fromWCharArray(L"\xF0dd");
      fontawesome_character_map["fa-sort-asc"] = QString::fromWCharArray(L"\xF0de");
      fontawesome_character_map["fa-linkedin"] = QString::fromWCharArray(L"\xF0e1");
      fontawesome_character_map["fa-rotate-left"] = QString::fromWCharArray(L"\xF0e2");
      fontawesome_character_map["fa-legal"] = QString::fromWCharArray(L"\xF0e3");
      fontawesome_character_map["fa-flash"] = QString::fromWCharArray(L"\xF0e7");
      fontawesome_character_map["fa-clipboard"] = QString::fromWCharArray(L"\xF0ea");
      fontawesome_character_map["fa-lightbulb-o"] = QString::fromWCharArray(L"\xF0eb");
      fontawesome_character_map["fa-hospital-o"] = QString::fromWCharArray(L"\xF0f8");
      fontawesome_character_map["fa-mobile-phone"] = QString::fromWCharArray(L"\xF10b");
      fontawesome_character_map["fa-smile-o"] = QString::fromWCharArray(L"\xF118");
      fontawesome_character_map["fa-frown-o"] = QString::fromWCharArray(L"\xF119");
      fontawesome_character_map["fa-meh-o"] = QString::fromWCharArray(L"\xF11a");
      fontawesome_character_map["fa-keyboard-o"] = QString::fromWCharArray(L"\xF11c");
      fontawesome_character_map["fa-mail-reply-all"] = QString::fromWCharArray(L"\xF122");
      fontawesome_character_map["fa-code-fork"] = QString::fromWCharArray(L"\xF126");
      fontawesome_character_map["fa-chain-broken"] = QString::fromWCharArray(L"\xF127");
      fontawesome_character_map["fa-calendar-o"] = QString::fromWCharArray(L"\xF133");
      fontawesome_character_map["fa-pencil-square"] = QString::fromWCharArray(L"\xF14b");
      fontawesome_character_map["fa-toggle-down"] = QString::fromWCharArray(L"\xF150");
      fontawesome_character_map["fa-caret-square-o-down"] = QString::fromWCharArray(L"\xF150");
      fontawesome_character_map["fa-toggle-up"] = QString::fromWCharArray(L"\xF151");
      fontawesome_character_map["fa-caret-square-o-up"] = QString::fromWCharArray(L"\xF151");
      fontawesome_character_map["fa-toggle-right"] = QString::fromWCharArray(L"\xF152");
      fontawesome_character_map["fa-caret-square-o-right"] = QString::fromWCharArray(L"\xF152");
      fontawesome_character_map["fa-euro"] = QString::fromWCharArray(L"\xF153");
      fontawesome_character_map["fa-eur"] = QString::fromWCharArray(L"\xF153");
      fontawesome_character_map["fa-gbp"] = QString::fromWCharArray(L"\xF154");
      fontawesome_character_map["fa-dollar"] = QString::fromWCharArray(L"\xF155");
      fontawesome_character_map["fa-usd"] = QString::fromWCharArray(L"\xF155");
      fontawesome_character_map["fa-rupee"] = QString::fromWCharArray(L"\xF156");
      fontawesome_character_map["fa-inr"] = QString::fromWCharArray(L"\xF156");
      fontawesome_character_map["fa-cny"] = QString::fromWCharArray(L"\xF157");
      fontawesome_character_map["fa-rmb"] = QString::fromWCharArray(L"\xF157");
      fontawesome_character_map["fa-yen"] = QString::fromWCharArray(L"\xF157");
      fontawesome_character_map["fa-jpy"] = QString::fromWCharArray(L"\xF157");
      fontawesome_character_map["fa-ruble"] = QString::fromWCharArray(L"\xF158");
      fontawesome_character_map["fa-rouble"] = QString::fromWCharArray(L"\xF158");
      fontawesome_character_map["fa-rub"] = QString::fromWCharArray(L"\xF158");
      fontawesome_character_map["fa-won"] = QString::fromWCharArray(L"\xF159");
      fontawesome_character_map["fa-krw"] = QString::fromWCharArray(L"\xF159");
      fontawesome_character_map["fa-bitcoin"] = QString::fromWCharArray(L"\xF15a");
      fontawesome_character_map["fa-file-text"] = QString::fromWCharArray(L"\xF15c");
      fontawesome_character_map["fa-sort-alpha-asc"] = QString::fromWCharArray(L"\xF15d");
      fontawesome_character_map["fa-sort-alpha-desc"] = QString::fromWCharArray(L"\xF15e");
      fontawesome_character_map["fa-sort-amount-asc"] = QString::fromWCharArray(L"\xF160");
      fontawesome_character_map["fa-sort-amount-desc"] = QString::fromWCharArray(L"\xF161");
      fontawesome_character_map["fa-sort-numeric-asc"] = QString::fromWCharArray(L"\xF162");
      fontawesome_character_map["fa-sort-numeric-desc"] = QString::fromWCharArray(L"\xF163");
      fontawesome_character_map["fa-gittip"] = QString::fromWCharArray(L"\xF184");
      fontawesome_character_map["fa-sun-o"] = QString::fromWCharArray(L"\xF185");
      fontawesome_character_map["fa-moon-o"] = QString::fromWCharArray(L"\xF186");
      fontawesome_character_map["fa-toggle-left"] = QString::fromWCharArray(L"\xF191");
      fontawesome_character_map["fa-caret-square-o-left"] = QString::fromWCharArray(L"\xF191");
      fontawesome_character_map["fa-dot-circle-o"] = QString::fromWCharArray(L"\xF192");
      fontawesome_character_map["fa-turkish-lira"] = QString::fromWCharArray(L"\xF195");
      fontawesome_character_map["fa-try"] = QString::fromWCharArray(L"\xF195");
      fontawesome_character_map["fa-institution"] = QString::fromWCharArray(L"\xF19c");
      fontawesome_character_map["fa-bank"] = QString::fromWCharArray(L"\xF19c");
      fontawesome_character_map["fa-mortar-board"] = QString::fromWCharArray(L"\xF19d");
      fontawesome_character_map["fa-pied-piper"] = QString::fromWCharArray(L"\xF1a7");
      fontawesome_character_map["fa-automobile"] = QString::fromWCharArray(L"\xF1b9");
      fontawesome_character_map["fa-cab"] = QString::fromWCharArray(L"\xF1ba");
      fontawesome_character_map["fa-file-pdf-o"] = QString::fromWCharArray(L"\xF1c1");
      fontawesome_character_map["fa-file-word-o"] = QString::fromWCharArray(L"\xF1c2");
      fontawesome_character_map["fa-file-excel-o"] = QString::fromWCharArray(L"\xF1c3");
      fontawesome_character_map["fa-file-powerpoint-o"] = QString::fromWCharArray(L"\xF1c4");
      fontawesome_character_map["fa-file-photo-o"] = QString::fromWCharArray(L"\xF1c5");
      fontawesome_character_map["fa-file-picture-o"] = QString::fromWCharArray(L"\xF1c5");
      fontawesome_character_map["fa-file-image-o"] = QString::fromWCharArray(L"\xF1c5");
      fontawesome_character_map["fa-file-zip-o"] = QString::fromWCharArray(L"\xF1c6");
      fontawesome_character_map["fa-file-archive-o"] = QString::fromWCharArray(L"\xF1c6");
      fontawesome_character_map["fa-file-sound-o"] = QString::fromWCharArray(L"\xF1c7");
      fontawesome_character_map["fa-file-audio-o"] = QString::fromWCharArray(L"\xF1c7");
      fontawesome_character_map["fa-file-movie-o"] = QString::fromWCharArray(L"\xF1c8");
      fontawesome_character_map["fa-file-video-o"] = QString::fromWCharArray(L"\xF1c8");
      fontawesome_character_map["fa-file-code-o"] = QString::fromWCharArray(L"\xF1c9");
      fontawesome_character_map["fa-life-bouy"] = QString::fromWCharArray(L"\xF1cd");
      fontawesome_character_map["fa-life-buoy"] = QString::fromWCharArray(L"\xF1cd");
      fontawesome_character_map["fa-life-saver"] = QString::fromWCharArray(L"\xF1cd");
      fontawesome_character_map["fa-support"] = QString::fromWCharArray(L"\xF1cd");
      fontawesome_character_map["fa-circle-o-notch"] = QString::fromWCharArray(L"\xF1ce");
      fontawesome_character_map["fa-ra"] = QString::fromWCharArray(L"\xF1d0");
      fontawesome_character_map["fa-ge"] = QString::fromWCharArray(L"\xF1d1");
      fontawesome_character_map["fa-wechat"] = QString::fromWCharArray(L"\xF1d7");
      fontawesome_character_map["fa-send"] = QString::fromWCharArray(L"\xF1d8");
      fontawesome_character_map["fa-header"] = QString::fromWCharArray(L"\xF1dc");
      fontawesome_character_map["fa-sliders"] = QString::fromWCharArray(L"\xF1de");
      fontawesome_character_map["fa-soccer-ball-o"] = QString::fromWCharArray(L"\xF1e3");
      fontawesome_character_map["fa-futbol-o"] = QString::fromWCharArray(L"\xF1e3");
      fontawesome_character_map["fa-newspaper-o"] = QString::fromWCharArray(L"\xF1ea");
      fontawesome_character_map["fa-eyedropper"] = QString::fromWCharArray(L"\xF1fb");
      fontawesome_character_map["fa-area-chart"] = QString::fromWCharArray(L"\xF1fe");
      fontawesome_character_map["fa-pie-chart"] = QString::fromWCharArray(L"\xF200");
      fontawesome_character_map["fa-line-chart"] = QString::fromWCharArray(L"\xF201");
      fontawesome_character_map["fa-cc"] = QString::fromWCharArray(L"\xF20a");
      fontawesome_character_map["fa-shekel"] = QString::fromWCharArray(L"\xF20b");
      fontawesome_character_map["fa-sheqel"] = QString::fromWCharArray(L"\xF20b");
      fontawesome_character_map["fa-ils"] = QString::fromWCharArray(L"\xF20b");

      /* For backwards compatibility, but not present in new font data */
      fontawesome_character_map["fa-envelope-o"] = QString::fromWCharArray(L"\xF003");
      fontawesome_character_map["fa-star-o"] = QString::fromWCharArray(L"\xF006");
      fontawesome_character_map["fa-trash-o"] = QString::fromWCharArray(L"\xF014");
      fontawesome_character_map["fa-file-o"] = QString::fromWCharArray(L"\xF016");
      fontawesome_character_map["fa-arrow-circle-o-down"] = QString::fromWCharArray(L"\xF01a");
      fontawesome_character_map["fa-arrow-circle-o-up"] = QString::fromWCharArray(L"\xF01b");
      fontawesome_character_map["fa-play-circle-o"] = QString::fromWCharArray(L"\xF01d");
      fontawesome_character_map["fa-pencil"] = QString::fromWCharArray(L"\xF040");
      fontawesome_character_map["fa-share-square-o"] = QString::fromWCharArray(L"\xF045");
      fontawesome_character_map["fa-check-square-o"] = QString::fromWCharArray(L"\xF046");
      fontawesome_character_map["fa-arrows"] = QString::fromWCharArray(L"\xF047");
      fontawesome_character_map["fa-times-circle-o"] = QString::fromWCharArray(L"\xF05c");
      fontawesome_character_map["fa-check-circle-o"] = QString::fromWCharArray(L"\xF05d");
      fontawesome_character_map["fa-arrows-v"] = QString::fromWCharArray(L"\xF07d");
      fontawesome_character_map["fa-arrows-h"] = QString::fromWCharArray(L"\xF07e");
      fontawesome_character_map["fa-thumbs-o-up"] = QString::fromWCharArray(L"\xF087");
      fontawesome_character_map["fa-thumbs-o-down"] = QString::fromWCharArray(L"\xF088");
      fontawesome_character_map["fa-heart-o"] = QString::fromWCharArray(L"\xF08a");
      fontawesome_character_map["fa-sign-out"] = QString::fromWCharArray(L"\xF08b");
      fontawesome_character_map["fa-external-link"] = QString::fromWCharArray(L"\xF08e");
      fontawesome_character_map["fa-sign-in"] = QString::fromWCharArray(L"\xF090");
      fontawesome_character_map["fa-square-o"] = QString::fromWCharArray(L"\xF096");
      fontawesome_character_map["fa-bookmark-o"] = QString::fromWCharArray(L"\xF097");
      fontawesome_character_map["fa-dashboard"] = QString::fromWCharArray(L"\xF0e4");
      fontawesome_character_map["fa-tachometer"] = QString::fromWCharArray(L"\xF0e4");
      fontawesome_character_map["fa-comment-o"] = QString::fromWCharArray(L"\xF0e5");
      fontawesome_character_map["fa-comments-o"] = QString::fromWCharArray(L"\xF0e6");
      fontawesome_character_map["fa-exchange"] = QString::fromWCharArray(L"\xF0ec");
      fontawesome_character_map["fa-cloud-download"] = QString::fromWCharArray(L"\xF0ed");
      fontawesome_character_map["fa-cloud-upload"] = QString::fromWCharArray(L"\xF0ee");
      fontawesome_character_map["fa-bell-o"] = QString::fromWCharArray(L"\xF0a2");
      fontawesome_character_map["fa-cutlery"] = QString::fromWCharArray(L"\xF0f5");
      fontawesome_character_map["fa-file-text-o"] = QString::fromWCharArray(L"\xF0f6");
      fontawesome_character_map["fa-building-o"] = QString::fromWCharArray(L"\xF0f7");
      fontawesome_character_map["fa-circle-o"] = QString::fromWCharArray(L"\xF10c");
      fontawesome_character_map["fa-mail-reply"] = QString::fromWCharArray(L"\xF112");
      fontawesome_character_map["fa-reply"] = QString::fromWCharArray(L"\xF112");
      fontawesome_character_map["fa-folder-o"] = QString::fromWCharArray(L"\xF114");
      fontawesome_character_map["fa-folder-open-o"] = QString::fromWCharArray(L"\xF115");
      fontawesome_character_map["fa-flag-o"] = QString::fromWCharArray(L"\xF11d");
      fontawesome_character_map["fa-star-half-empty"] = QString::fromWCharArray(L"\xF123");
      fontawesome_character_map["fa-star-half-full"] = QString::fromWCharArray(L"\xF123");
      fontawesome_character_map["fa-star-half-o"] = QString::fromWCharArray(L"\xF123");
      fontawesome_character_map["fa-shield"] = QString::fromWCharArray(L"\xF132");
      fontawesome_character_map["fa-ticket"] = QString::fromWCharArray(L"\xF145");
      fontawesome_character_map["fa-minus-square-o"] = QString::fromWCharArray(L"\xF147");
      fontawesome_character_map["fa-level-up"] = QString::fromWCharArray(L"\xF148");
      fontawesome_character_map["fa-level-down"] = QString::fromWCharArray(L"\xF149");
      fontawesome_character_map["fa-external-link-square"] = QString::fromWCharArray(L"\xF14c");
      fontawesome_character_map["fa-youtube-square"] = QString::fromWCharArray(L"\xF166");
      fontawesome_character_map["fa-youtube-play"] = QString::fromWCharArray(L"\xF16a");
      fontawesome_character_map["fa-bitbucket-square"] = QString::fromWCharArray(L"\xF172");
      fontawesome_character_map["fa-long-arrow-down"] = QString::fromWCharArray(L"\xF175");
      fontawesome_character_map["fa-long-arrow-up"] = QString::fromWCharArray(L"\xF176");
      fontawesome_character_map["fa-long-arrow-left"] = QString::fromWCharArray(L"\xF177");
      fontawesome_character_map["fa-long-arrow-right"] = QString::fromWCharArray(L"\xF178");
      fontawesome_character_map["fa-arrow-circle-o-right"] = QString::fromWCharArray(L"\xF18e");
      fontawesome_character_map["fa-arrow-circle-o-left"] = QString::fromWCharArray(L"\xF190");
      fontawesome_character_map["fa-plus-square-o"] = QString::fromWCharArray(L"\xF196");
      fontawesome_character_map["fa-spoon"] = QString::fromWCharArray(L"\xF1b1");
      fontawesome_character_map["fa-send-o"] = QString::fromWCharArray(L"\xF1d9");
      fontawesome_character_map["fa-paper-plane-o"] = QString::fromWCharArray(L"\xF1d9");
      fontawesome_character_map["fa-circle-thin"] = QString::fromWCharArray(L"\xF1db");
      fontawesome_character_map["fa-bell-slash-o"] = QString::fromWCharArray(L"\xF1f7");
      fontawesome_character_map["fa-meanpath"] = QString::fromWCharArray(L"\xF20c");
    }
  }
}
