//
// Copyright (c) 2022 INRIA
//

#ifndef __pinocchio_algorithm_centroidal_txx__
#define __pinocchio_algorithm_centroidal_txx__

namespace pinocchio
{

  extern template PINOCCHIO_EXPLICIT_INSTANTIATION_DECLARATION_DLLAPI const
    ForceTpl<context::Scalar, context::Options> &
    computeCentroidalMomentum<context::Scalar, context::Options, JointCollectionDefaultTpl>(
      const context::Model &, context::Data &);
  namespace impl
  {
    extern template PINOCCHIO_EXPLICIT_INSTANTIATION_DECLARATION_DLLAPI const
      ForceTpl<context::Scalar, context::Options> &
      computeCentroidalMomentum<
        context::Scalar,
        context::Options,
        JointCollectionDefaultTpl,
        Eigen::Ref<const context::VectorXs>,
        Eigen::Ref<const context::VectorXs>>(
        const context::Model &,
        context::Data &,
        const Eigen::MatrixBase<Eigen::Ref<const context::VectorXs>> &,
        const Eigen::MatrixBase<Eigen::Ref<const context::VectorXs>> &);
  } // namespace impl
  extern template PINOCCHIO_EXPLICIT_INSTANTIATION_DECLARATION_DLLAPI const
    ForceTpl<context::Scalar, context::Options> &
    computeCentroidalMomentumTimeVariation<
      context::Scalar,
      context::Options,
      JointCollectionDefaultTpl>(const context::Model &, context::Data &);
  namespace impl
  {
    extern template PINOCCHIO_EXPLICIT_INSTANTIATION_DECLARATION_DLLAPI const
      ForceTpl<context::Scalar, context::Options> &
      computeCentroidalMomentumTimeVariation<
        context::Scalar,
        context::Options,
        JointCollectionDefaultTpl,
        Eigen::Ref<const context::VectorXs>,
        Eigen::Ref<const context::VectorXs>,
        Eigen::Ref<const context::VectorXs>>(
        const context::Model &,
        context::Data &,
        const Eigen::MatrixBase<Eigen::Ref<const context::VectorXs>> &,
        const Eigen::MatrixBase<Eigen::Ref<const context::VectorXs>> &,
        const Eigen::MatrixBase<Eigen::Ref<const context::VectorXs>> &);

    extern template PINOCCHIO_EXPLICIT_INSTANTIATION_DECLARATION_DLLAPI const context::Matrix6xs &
    ccrba<
      context::Scalar,
      context::Options,
      JointCollectionDefaultTpl,
      Eigen::Ref<const context::VectorXs>,
      Eigen::Ref<const context::VectorXs>>(
      const context::Model &,
      context::Data &,
      const Eigen::MatrixBase<Eigen::Ref<const context::VectorXs>> &,
      const Eigen::MatrixBase<Eigen::Ref<const context::VectorXs>> &);

    extern template PINOCCHIO_EXPLICIT_INSTANTIATION_DECLARATION_DLLAPI const context::Matrix6xs &
    computeCentroidalMap<
      context::Scalar,
      context::Options,
      JointCollectionDefaultTpl,
      Eigen::Ref<const context::VectorXs>>(
      const context::Model &,
      context::Data &,
      const Eigen::MatrixBase<Eigen::Ref<const context::VectorXs>> &);

    extern template PINOCCHIO_EXPLICIT_INSTANTIATION_DECLARATION_DLLAPI const context::Matrix6xs &
    dccrba<
      context::Scalar,
      context::Options,
      JointCollectionDefaultTpl,
      Eigen::Ref<const context::VectorXs>,
      Eigen::Ref<const context::VectorXs>>(
      const context::Model &,
      context::Data &,
      const Eigen::MatrixBase<Eigen::Ref<const context::VectorXs>> &,
      const Eigen::MatrixBase<Eigen::Ref<const context::VectorXs>> &);

    extern template PINOCCHIO_EXPLICIT_INSTANTIATION_DECLARATION_DLLAPI const context::Matrix6xs &
    computeCentroidalMapTimeVariation<
      context::Scalar,
      context::Options,
      JointCollectionDefaultTpl,
      Eigen::Ref<const context::VectorXs>,
      Eigen::Ref<const context::VectorXs>>(
      const context::Model &,
      context::Data &,
      const Eigen::MatrixBase<Eigen::Ref<const context::VectorXs>> &,
      const Eigen::MatrixBase<Eigen::Ref<const context::VectorXs>> &);
  } // namespace impl
} // namespace pinocchio

#endif // ifndef __pinocchio_algorithm_centroidal_txx__
