/*
 * Copyright (c) 2011, Willow Garage, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the Willow Garage, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived from
 *       this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <QApplication>
#include <QProcessEnvironment>

#include <rviz/visualizer_app.h>

int main(int argc, char** argv)
{
#if !OGRE_USE_WAYLAND
  // If Ogre does not support wayland, but we are running on wayland,
  // explicitly enforce the xcb platform for Qt unless the user set the platform
  std::vector<char*> args;
  for (int i = 0; i < argc; ++i)
  {
    args.push_back(argv[i]);
  }

  auto env = QProcessEnvironment::systemEnvironment();
  if (env.value("XDG_SESSION_TYPE") == "wayland" &&
      std::find(args.begin(), args.end(), "-platform") == args.end() && // no -platform arg
      !env.contains("QT_QPA_PLATFORM"))                                 // no env setting of platform
  {
    std::cout << "Enforcing xcb platform instead of wayland." << std::endl;
    static const char* xcb_platform_args[] = {"-platform", "xcb"};
    args.push_back(const_cast<char*>(xcb_platform_args[0]));
    args.push_back(const_cast<char*>(xcb_platform_args[1]));
    argc = static_cast<int>(args.size());
    argv = args.data();
  }
#endif

  QApplication qapp(argc, argv);

  rviz::VisualizerApp vapp;
  if (vapp.init(argc, argv))
  {
    return qapp.exec();
  }
  else
  {
    return 1;
  }
}
